/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class QuestHudOverlay {
    private static final int MAX_TRACKED_QUESTS = 3;
    private static List<String> trackedQuests = new ArrayList<String>();

    public static void render(GuiGraphics graphics, float partialTick) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.showProgressPercentage && !config.useColoredMessages) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_) {
            return;
        }
        ClientQuestManager manager = ClientQuestManager.getInstance();
        QuestProgress progress = manager.getProgress();
        if (progress == null) {
            return;
        }
        if (trackedQuests.isEmpty()) {
            List<Quest> completable = manager.getCompletableQuests();
            for (int i = 0; i < Math.min(3, completable.size()); ++i) {
                trackedQuests.add(completable.get(i).getId());
            }
        }
        int y = 10;
        int x = 10;
        for (String questId : new ArrayList<String>(trackedQuests)) {
            Quest quest = manager.getQuest(questId);
            if (quest == null || progress.isQuestCompleted(questId)) {
                trackedQuests.remove(questId);
                continue;
            }
            QuestHudOverlay.renderTrackedQuest(graphics, quest, progress, x, y);
            y += QuestHudOverlay.getQuestHeight(quest, progress) + 5;
        }
    }

    private static void renderTrackedQuest(GuiGraphics graphics, Quest quest, QuestProgress progress, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        int width = 200;
        int height = QuestHudOverlay.getQuestHeight(quest, progress);
        graphics.m_280509_(x, y, x + width, y + height, Integer.MIN_VALUE);
        graphics.m_280488_(mc.f_91062_, quest.getTitle(), x + 3, y + 3, 0xFFFFFF);
        int contentY = y + 15;
        for (Requirement req : quest.getRequirements()) {
            if (req.isMet(progress, quest.getId())) {
                text = "\u2713 " + req.getProgressDisplay(progress, quest.getId());
                graphics.m_280488_(mc.f_91062_, (String)text, x + 5, contentY, 0x55FF55);
            } else {
                text = req.getProgressDisplay(progress, quest.getId());
                graphics.m_280488_(mc.f_91062_, (String)text, x + 5, contentY, 0xFFFFFF);
            }
            contentY += 10;
        }
    }

    private static int getQuestHeight(Quest quest, QuestProgress progress) {
        return 15 + quest.getRequirements().size() * 10 + 5;
    }

    public static void trackQuest(String questId) {
        if (!trackedQuests.contains(questId)) {
            if (trackedQuests.size() >= 3) {
                trackedQuests.remove(0);
            }
            trackedQuests.add(questId);
        }
    }

    public static void untrackQuest(String questId) {
        trackedQuests.remove(questId);
    }

    public static void clearTracked() {
        trackedQuests.clear();
    }

    public static List<String> getTrackedQuests() {
        return new ArrayList<String>(trackedQuests);
    }
}

