/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class ObservationRequirement
extends Requirement {
    private String targetId;
    private String observeType;
    private int timer;

    public ObservationRequirement(String targetId, String observeType, int timer) {
        super("observation");
        this.targetId = targetId;
        this.observeType = observeType;
        this.timer = timer;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getObserveType() {
        return this.observeType;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setObserveType(String observeType) {
        this.observeType = observeType;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.timer;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        return "Observe " + this.observeType + ": " + this.targetId + " - " + current + "/" + this.timer + " ticks";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "observation");
        json.addProperty("target", this.targetId);
        json.addProperty("observe_type", this.observeType);
        json.addProperty("timer", (Number)this.timer);
        return json;
    }

    public static ObservationRequirement fromJson(JsonObject json) {
        String targetId = json.get("target").getAsString();
        String observeType = json.has("observe_type") ? json.get("observe_type").getAsString() : "entity";
        int timer = json.has("timer") ? json.get("timer").getAsInt() : 100;
        return new ObservationRequirement(targetId, observeType, timer);
    }
}

