/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.texboobcat.questory.api.TeamAPI;
import org.texboobcat.questory.config.ConfigManager;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.integration.FTBTeamsIntegration;
import org.texboobcat.questory.integration.FTBTeamsProvider;
import org.texboobcat.questory.integration.ScriptIntegration;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.TeamManager;

public final class Questory {
    public static final String MOD_ID = "questory";
    public static final int API_VERSION = 1;
    public static final Logger LOGGER = LogManager.getLogger((String)"Questify");
    private static Path dataPath;
    private static Path configPath;
    private static ConfigManager configManager;

    public static void init() {
        LOGGER.info("Questify mod initializing...");
        NetworkManager.init();
    }

    public static void initQuestSystem(Path gamePath) {
        block12: {
            QuestoryConfig cfg;
            block11: {
                dataPath = gamePath.resolve("data").resolve(MOD_ID);
                configPath = gamePath.resolve("config");
                configManager = new ConfigManager(configPath);
                configManager.loadConfig();
                QuestManager.initialize(dataPath);
                try {
                    cfg = QuestoryConfig.getInstance();
                    if (!cfg.teamSystemEnabled) break block11;
                    TeamManager.initialize(dataPath, cfg.teamUseExternalProvider);
                    try {
                        if (Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI") != null) {
                            TeamAPI.registerTeamProvider(new FTBTeamsProvider());
                            FTBTeamsIntegration.init();
                            LOGGER.info("FTB Teams integration active");
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    PendingRewardManager.initialize(dataPath);
                    LOGGER.info("Team system initialized");
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to init TeamManager: {}", (Object)t.getMessage());
                }
            }
            try {
                DailyQuestManager.getInstance().init(dataPath, QuestManager.getInstance());
            }
            catch (Throwable t) {
                LOGGER.error("Failed to init DailyQuestManager: {}", (Object)t.getMessage());
            }
            try {
                cfg = QuestoryConfig.getInstance();
                if (!cfg.scriptIntegrationEnabled) break block12;
                boolean kubePresent = false;
                try {
                    kubePresent = Platform.isModLoaded((String)"kubejs");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LOGGER.info("ScriptIntegration enabled{}", (Object)(kubePresent ? " (KubeJS detected)" : ""));
                ScriptIntegration.init();
            }
            catch (Throwable t) {
                LOGGER.error("Failed to init ScriptIntegration: {}", (Object)t.getMessage());
            }
        }
        LOGGER.info("Questify quest system initialized");
        LOGGER.info("  Data path: {}", (Object)dataPath);
        LOGGER.info("  Config path: {}", (Object)configPath);
    }

    public static Path getDataPath() {
        return dataPath;
    }

    public static Path getConfigPath() {
        return configPath;
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }
}

