/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.api.RequirementFactory;
import org.texboobcat.questory.api.exceptions.DuplicateRegistrationException;
import org.texboobcat.questory.api.serialization.RequirementCodec;
import org.texboobcat.questory.api.serialization.SerializationContext;
import org.texboobcat.questory.quest.Requirement;

public class RequirementRegistry {
    private static final ConcurrentMap<String, RequirementFactory> REGISTRY = new ConcurrentHashMap<String, RequirementFactory>();
    private static final ConcurrentMap<String, RequirementCodec<?>> CODECS = new ConcurrentHashMap();

    private static String normalize(String id) {
        if (id == null) {
            return "";
        }
        Object s = id.trim().toLowerCase(Locale.ROOT);
        if (((String)s).isEmpty()) {
            return s;
        }
        if (!((String)s).contains(":")) {
            s = "questory:" + (String)s;
        }
        return s;
    }

    public static void register(String type, RequirementFactory factory) {
        String key = RequirementRegistry.normalize(type);
        if (REGISTRY.containsKey(key)) {
            Questory.LOGGER.warn("[API] Overwriting requirement type: {}", (Object)key);
        }
        REGISTRY.put(key, factory);
        Questory.LOGGER.info("[API] Registered custom requirement type: {}", (Object)key);
    }

    public static void register(ResourceLocation id, RequirementFactory factory) {
        RequirementRegistry.register(id == null ? null : id.toString(), factory);
    }

    public static void registerOrReplace(ResourceLocation id, RequirementFactory factory) {
        String key = RequirementRegistry.normalize(id == null ? null : id.toString());
        REGISTRY.put(key, factory);
        Questory.LOGGER.info("[API] Registered (replace) requirement type: {}", (Object)key);
    }

    public static void registerStrict(ResourceLocation id, RequirementFactory factory) {
        String key = RequirementRegistry.normalize(id == null ? null : id.toString());
        if (REGISTRY.containsKey(key)) {
            throw new DuplicateRegistrationException("Requirement factory already registered: " + key);
        }
        REGISTRY.put(key, factory);
        Questory.LOGGER.info("[API] Registered requirement type: {}", (Object)key);
    }

    public static void register(ResourceLocation id, RequirementCodec<?> codec) {
        String key = RequirementRegistry.normalize(id == null ? null : id.toString());
        if (CODECS.containsKey(key)) {
            Questory.LOGGER.warn("[API] Overwriting requirement codec: {}", (Object)key);
        }
        CODECS.put(key, codec);
        Questory.LOGGER.info("[API] Registered requirement codec: {}", (Object)key);
    }

    public static void registerOrReplace(ResourceLocation id, RequirementCodec<?> codec) {
        String key = RequirementRegistry.normalize(id == null ? null : id.toString());
        CODECS.put(key, codec);
        Questory.LOGGER.info("[API] Registered (replace) requirement codec: {}", (Object)key);
    }

    public static void registerStrict(ResourceLocation id, RequirementCodec<?> codec) {
        String key = RequirementRegistry.normalize(id == null ? null : id.toString());
        if (CODECS.containsKey(key)) {
            throw new DuplicateRegistrationException("Requirement codec already registered: " + key);
        }
        CODECS.put(key, codec);
        Questory.LOGGER.info("[API] Registered requirement codec: {}", (Object)key);
    }

    public static Requirement create(String type, JsonObject json) {
        String key = RequirementRegistry.normalize(type);
        RequirementCodec codec = (RequirementCodec)CODECS.get(key);
        if (codec != null) {
            try {
                RequirementCodec c = codec;
                SerializationContext ctx = new SerializationContext(Questory.getDataPath(), 1, Questory.LOGGER);
                return c.fromJson(json, ctx);
            }
            catch (Exception e) {
                Questory.LOGGER.error("[API] Requirement codec decode failed for {}: {}", (Object)key, (Object)e.getMessage());
                return null;
            }
        }
        RequirementFactory factory = (RequirementFactory)REGISTRY.get(key);
        if (factory == null) {
            return null;
        }
        return factory.create(json);
    }

    public static Requirement create(ResourceLocation id, JsonObject json) {
        return RequirementRegistry.create(id == null ? null : id.toString(), json);
    }

    public static boolean isRegistered(String type) {
        String key = RequirementRegistry.normalize(type);
        return REGISTRY.containsKey(key) || CODECS.containsKey(key);
    }

    public static boolean isRegistered(ResourceLocation id) {
        return RequirementRegistry.isRegistered(id == null ? null : id.toString());
    }

    public static Set<String> getRegisteredTypes() {
        HashSet<String> types = new HashSet<String>();
        types.addAll(REGISTRY.keySet());
        types.addAll(CODECS.keySet());
        return types;
    }
}

