/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api.serialization;

import java.nio.file.Path;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.Logger;

public class SerializationContext {
    private final Path dataPath;
    private final int apiVersion;
    private final Logger logger;

    public SerializationContext(Path dataPath, int apiVersion, Logger logger) {
        this.dataPath = dataPath;
        this.apiVersion = apiVersion;
        this.logger = logger;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ResourceLocation id(String raw) {
        if (raw == null) {
            return null;
        }
        Object s = raw.trim();
        if (((String)s).isEmpty()) {
            return null;
        }
        if (!((String)s).contains(":")) {
            s = "minecraft:" + (String)s;
        }
        try {
            return new ResourceLocation((String)s);
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Invalid id '{}': {}", (Object)raw, (Object)e.getMessage());
            }
            return null;
        }
    }

    public Item resolveItem(String itemId) {
        ResourceLocation rl = this.id(itemId);
        return this.resolveItem(rl);
    }

    public Item resolveItem(ResourceLocation id) {
        if (id == null) {
            return null;
        }
        Item it = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
        if (it == null && this.logger != null) {
            this.logger.warn("Unknown item id: {}", (Object)id);
        }
        return it;
    }

    public TagKey<Item> resolveItemTag(String tagId) {
        ResourceLocation rl = this.id(tagId);
        if (rl == null) {
            return null;
        }
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)rl);
    }
}

