/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.ChapterArtEditorScreen;
import org.texboobcat.questory.client.gui.ChapterTabPanel;
import org.texboobcat.questory.quest.ChapterData;

public class ChapterGeneralTabPanel
extends ChapterTabPanel {
    private EditBox idField;
    private EditBox titleField;
    private Button alwaysInvisibleBtn;
    private boolean alwaysInvisible = false;

    public ChapterGeneralTabPanel(ChapterArtEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int fieldX = this.x + 140;
        int fieldY = this.y + 20;
        int fieldW = Math.min(400, this.w - 160);
        this.idField = this.createField(fieldX, fieldY, fieldW, "chapter_id");
        this.idField.m_94199_(200);
        this.titleField = this.createField(fieldX, fieldY += 26, fieldW, "Chapter Title");
        this.titleField.m_94199_(500);
        this.alwaysInvisibleBtn = Button.m_253074_((Component)Component.m_237113_((String)"Always Invisible: No"), b -> this.toggleAlwaysInvisible()).m_252987_(fieldX, fieldY += 30, 160, 20).m_253136_();
    }

    private void toggleAlwaysInvisible() {
        this.alwaysInvisible = !this.alwaysInvisible;
        this.alwaysInvisibleBtn.m_93666_((Component)Component.m_237113_((String)("Always Invisible: " + (this.alwaysInvisible ? "Yes" : "No"))));
    }

    @Override
    public void loadFromChapter(ChapterData chapter) {
        this.idField.m_94144_(chapter.getId());
        this.titleField.m_94144_(chapter.getTitle());
        this.alwaysInvisible = chapter.isAlwaysInvisible();
        this.alwaysInvisibleBtn.m_93666_((Component)Component.m_237113_((String)("Always Invisible: " + (this.alwaysInvisible ? "Yes" : "No"))));
    }

    @Override
    public void saveToChapter(ChapterData chapter) {
        chapter.setTitle(this.titleField.m_94155_().trim().isEmpty() ? chapter.getId() : this.titleField.m_94155_().trim());
        chapter.setAlwaysInvisible(this.alwaysInvisible);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int fieldX = this.x + 12;
        int fieldY = this.y + 20;
        int labelW = 120;
        g.m_280588_(this.x, this.y, this.x + this.w, this.y + this.h);
        g.m_280488_(this.getFont(), "\u00a7lChapter Information", fieldX, fieldY - 8, -86);
        g.m_280488_(this.getFont(), "ID:", fieldX, fieldY, -1);
        this.idField.m_253211_(fieldY);
        this.idField.m_252865_(fieldX + labelW);
        this.idField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Title:", fieldX, fieldY += 26, -1);
        this.titleField.m_253211_(fieldY);
        this.titleField.m_252865_(fieldX + labelW);
        this.titleField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Visibility:", fieldX, fieldY += 30, -1);
        this.alwaysInvisibleBtn.m_253211_(fieldY);
        this.alwaysInvisibleBtn.m_252865_(fieldX + labelW);
        this.alwaysInvisibleBtn.m_88315_(g, mouseX, mouseY, partialTick);
        fieldY += 26;
        g.m_280488_(this.getFont(), "\u00a77ID: Stable identifier used for data storage", fieldX, fieldY += 10, -5592406);
        g.m_280488_(this.getFont(), "\u00a77Title: Display name shown in quest book", fieldX, fieldY += 10, -5592406);
        g.m_280488_(this.getFont(), "\u00a77Always Invisible: Hide this chapter from players", fieldX, fieldY += 10, -5592406);
        g.m_280618_();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.alwaysInvisibleBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

