/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.ChapterArtEditorScreen;
import org.texboobcat.questory.client.gui.ChapterTabPanel;
import org.texboobcat.questory.client.gui.QuestLinkEditorScreen;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.QuestLink;

public class ChapterLinksTabPanel
extends ChapterTabPanel {
    private List<QuestLink> questLinks = new ArrayList<QuestLink>();
    private int selectedIndex = -1;
    private int listScroll = 0;
    private Button addBtn;
    private Button editBtn;
    private Button removeBtn;
    private Button moveUpBtn;
    private Button moveDownBtn;

    public ChapterLinksTabPanel(ChapterArtEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int btnY = this.y + this.h - 32;
        this.addBtn = Button.m_253074_((Component)Component.m_237113_((String)"+ Add Link"), b -> this.openAddDialog()).m_252987_(this.x + 12, btnY, 80, 20).m_253136_();
        this.editBtn = Button.m_253074_((Component)Component.m_237113_((String)"Edit"), b -> this.openEditDialog()).m_252987_(this.x + 96, btnY, 60, 20).m_253136_();
        this.removeBtn = Button.m_253074_((Component)Component.m_237113_((String)"Remove"), b -> this.removeSelected()).m_252987_(this.x + 160, btnY, 70, 20).m_253136_();
        this.moveUpBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2191"), b -> this.moveUp()).m_252987_(this.x + 234, btnY, 30, 20).m_253136_();
        this.moveDownBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2193"), b -> this.moveDown()).m_252987_(this.x + 268, btnY, 30, 20).m_253136_();
    }

    private void openAddDialog() {
        QuestLink newLink = new QuestLink("quest_id", 0, 0);
        this.getMinecraft().m_91152_((Screen)new QuestLinkEditorScreen(this.editor, newLink, updated -> {
            this.questLinks.add((QuestLink)updated);
            this.getMinecraft().m_91152_((Screen)this.editor);
        }));
    }

    private void openEditDialog() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.questLinks.size()) {
            QuestLink link = this.questLinks.get(this.selectedIndex);
            this.getMinecraft().m_91152_((Screen)new QuestLinkEditorScreen(this.editor, link, updated -> {
                this.questLinks.set(this.selectedIndex, (QuestLink)updated);
                this.getMinecraft().m_91152_((Screen)this.editor);
            }));
        }
    }

    private void removeSelected() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.questLinks.size()) {
            this.questLinks.remove(this.selectedIndex);
            this.selectedIndex = -1;
        }
    }

    private void moveUp() {
        if (this.selectedIndex > 0) {
            QuestLink temp = this.questLinks.get(this.selectedIndex);
            this.questLinks.set(this.selectedIndex, this.questLinks.get(this.selectedIndex - 1));
            this.questLinks.set(this.selectedIndex - 1, temp);
            --this.selectedIndex;
        }
    }

    private void moveDown() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.questLinks.size() - 1) {
            QuestLink temp = this.questLinks.get(this.selectedIndex);
            this.questLinks.set(this.selectedIndex, this.questLinks.get(this.selectedIndex + 1));
            this.questLinks.set(this.selectedIndex + 1, temp);
            ++this.selectedIndex;
        }
    }

    @Override
    public void loadFromChapter(ChapterData chapter) {
        this.questLinks.clear();
        this.questLinks.addAll(chapter.getQuestLinks());
        this.selectedIndex = -1;
        this.listScroll = 0;
    }

    @Override
    public void saveToChapter(ChapterData chapter) {
        chapter.getQuestLinks().clear();
        chapter.getQuestLinks().addAll(this.questLinks);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int listX = this.x + 12;
        int listY = this.y + 12;
        int listW = this.w - 24;
        int listH = this.h - 60;
        g.m_280488_(this.getFont(), "\u00a7lQuest Links (" + this.questLinks.size() + ")", listX, listY, -86);
        g.m_280509_(listX, listY += 20, listX + listW, listY + (listH -= 20), -803200992);
        g.m_280588_(listX, listY, listX + listW, listY + listH);
        int lineH = 36;
        int maxVisible = Math.max(1, listH / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.questLinks.size() - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, this.questLinks.size() - this.listScroll); ++i) {
            boolean hover;
            int index = this.listScroll + i;
            QuestLink link = this.questLinks.get(index);
            int itemY = listY + 4 + i * lineH;
            boolean selected = index == this.selectedIndex;
            boolean bl = hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= itemY && mouseY < itemY + lineH;
            if (selected) {
                g.m_280509_(listX + 2, itemY, listX + listW - 2, itemY + lineH - 2, -12952966);
            } else if (hover) {
                g.m_280509_(listX + 2, itemY, listX + listW - 2, itemY + lineH - 2, -14013910);
            }
            String summary = index + 1 + ". [LINK] \u2192 " + link.getLinkedQuestId();
            if (this.getFont().m_92895_(summary) > listW - 20) {
                summary = this.getFont().m_92834_(summary, listW - 30) + "...";
            }
            g.m_280488_(this.getFont(), summary, listX + 8, itemY + 4, -1);
            String shape = link.getShape().isEmpty() ? "default" : link.getShape();
            String details = String.format("  \u2514\u2500 Pos: (%d, %d) | Shape: %s | Size: %.1f", link.getX(), link.getY(), shape, link.getSize());
            g.m_280488_(this.getFont(), details, listX + 12, itemY + 18, -3355444);
        }
        g.m_280618_();
        this.addBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.editBtn.f_93623_ = this.selectedIndex >= 0;
        this.editBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.removeBtn.f_93623_ = this.selectedIndex >= 0;
        this.removeBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.moveUpBtn.f_93623_ = this.selectedIndex > 0;
        this.moveUpBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.moveDownBtn.f_93623_ = this.selectedIndex >= 0 && this.selectedIndex < this.questLinks.size() - 1;
        this.moveDownBtn.m_88315_(g, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.addBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.editBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.removeBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveUpBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveDownBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int lineH = 36;
            int index = this.listScroll + ((int)mouseY - listY - 4) / lineH;
            if (index >= 0 && index < this.questLinks.size()) {
                this.selectedIndex = index;
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta));
            return true;
        }
        return false;
    }
}

