/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.ChapterArtEditorScreen;
import org.texboobcat.questory.quest.ChapterData;

public abstract class ChapterTabPanel {
    protected final ChapterArtEditorScreen editor;
    protected final int x;
    protected final int y;
    protected final int w;
    protected final int h;
    protected final List<EditBox> fields = new ArrayList<EditBox>();
    protected int scrollOffset = 0;

    public ChapterTabPanel(ChapterArtEditorScreen editor, int x, int y, int w, int h) {
        this.editor = editor;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public abstract void loadFromChapter(ChapterData var1);

    public abstract void saveToChapter(ChapterData var1);

    public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (EditBox field : this.fields) {
            field.m_93692_(false);
        }
        for (EditBox field : this.fields) {
            if (!field.m_6375_(mouseX, mouseY, button)) continue;
            field.m_93692_(true);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.w) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.h)) {
            this.scrollOffset = (int)Math.max(0.0, (double)this.scrollOffset - Math.signum(delta) * 20.0);
            return true;
        }
        return false;
    }

    protected EditBox createField(int fx, int fy, int fw, String hint) {
        EditBox box = new EditBox(this.editor.getFont(), fx, fy, fw, 18, (Component)Component.m_237113_((String)hint));
        box.m_257771_((Component)Component.m_237113_((String)hint));
        box.m_94186_(true);
        this.fields.add(box);
        return box;
    }

    protected Font getFont() {
        return this.editor.getFont();
    }

    protected Minecraft getMinecraft() {
        return this.editor.getMinecraft();
    }

    public List<EditBox> getFields() {
        return this.fields;
    }
}

