/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ColorPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<Integer> onSelect;
    private float hue;
    private float sat;
    private float val;
    private float alpha;
    private EditBox hexField;
    private Button saveBtn;
    private Button cancelBtn;
    private Button copyBtn;
    private Button eyedropperBtn;
    private int panelX;
    private int panelY;
    private int panelW;
    private int panelH;
    private int svX;
    private int svY;
    private int svW;
    private int svH;
    private int hueX;
    private int hueY;
    private int hueW;
    private int hueH;
    private int aX;
    private int aY;
    private int aW;
    private int aH;
    private boolean dragSV = false;
    private boolean dragHue = false;
    private boolean dragA = false;
    private double scrollOffset = 0.0;
    private double maxScrollOffset = 0.0;
    private boolean isDraggingScroll = false;
    private int sliderX;
    private int sliderW;
    private int sliderY0;
    private int sliderRowH;
    private boolean dragR = false;
    private boolean dragG = false;
    private boolean dragB = false;
    private boolean dragAH = false;
    private boolean dragHH = false;
    private boolean dragSH = false;
    private boolean dragVH = false;
    private static final int[] recentColors = new int[8];
    private static int recentCount = 0;
    private static final int[] PRESETS = new int[]{-1, -65536, -16711936, -16776961, -256, -65281, -16711681, -16777216, -8355712, -4144960, -8388608, -16744448, -16777088, -8355840, -8388480, -16744320, -23296, -60269, -7114533, -14634326, -40121, -12490271, -13447886, -10496};
    private boolean eyedropperMode = false;

    public ColorPickerScreen(Screen parent, int currentColor, Consumer<Integer> onSelect) {
        super((Component)Component.m_237113_((String)"Pick Color"));
        this.parent = parent;
        this.onSelect = onSelect;
        this.setFromARGB(currentColor);
    }

    private void setFromARGB(int argb) {
        this.alpha = (float)(argb >>> 24 & 0xFF) / 255.0f;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        float[] hsv = ColorPickerScreen.rgbToHsv(r, g, b);
        this.hue = hsv[0];
        this.sat = hsv[1];
        this.val = hsv[2];
    }

    private int toARGB() {
        int[] rgb = ColorPickerScreen.hsvToRgb(this.hue, this.sat, this.val);
        int a = Math.round(this.alpha * 255.0f) & 0xFF;
        return a << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    protected void m_7856_() {
        super.m_7856_();
        this.panelW = 380;
        int svSize = 200;
        int sliderAreaH = 162;
        int presetsH = 80;
        int totalContentH = 60 + svSize + 12 + sliderAreaH + presetsH + 40;
        int maxPanelH = this.f_96544_ - 80;
        this.panelH = Math.min(maxPanelH, totalContentH);
        this.panelX = (this.f_96543_ - this.panelW) / 2;
        this.panelY = (this.f_96544_ - this.panelH) / 2;
        this.maxScrollOffset = totalContentH > this.panelH ? (double)(totalContentH - this.panelH + 20) : 0.0;
        this.svW = svSize;
        this.svH = svSize;
        this.svX = this.panelX + 12;
        this.svY = this.panelY + 60;
        this.hueW = 18;
        this.hueH = this.svH;
        this.hueX = this.svX + this.svW + 12;
        this.hueY = this.svY;
        this.aW = 18;
        this.aH = this.svH;
        this.aX = this.hueX + this.hueW + 12;
        this.aY = this.svY;
        this.hexField = new EditBox(this.f_96547_, this.panelX + 12, this.panelY + 28, 110, 20, (Component)Component.m_237113_((String)"#AARRGGBB"));
        this.hexField.m_94199_(16);
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
        this.hexField.m_257771_((Component)Component.m_237113_((String)"#AARRGGBB"));
        this.m_142416_((GuiEventListener)this.hexField);
        this.copyBtn = Button.m_253074_((Component)Component.m_237113_((String)"Copy"), b -> this.copyToClipboard()).m_252987_(this.panelX + 126, this.panelY + 28, 40, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.copyBtn);
        this.eyedropperBtn = Button.m_253074_((Component)Component.m_237113_((String)"\ud83c\udfa8"), b -> this.toggleEyedropper()).m_252987_(this.panelX + 170, this.panelY + 28, 28, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.eyedropperBtn);
        this.sliderX = this.panelX + 12;
        this.sliderW = this.panelW - 24;
        this.sliderRowH = 16;
        this.sliderY0 = this.svY + this.svH + 14;
        this.saveBtn = Button.m_253074_((Component)Component.m_237113_((String)"Select"), b -> this.save()).m_252987_(this.panelX + this.panelW - 135, this.panelY + this.panelH - 28, 62, 22).m_253136_();
        this.m_142416_((GuiEventListener)this.saveBtn);
        this.cancelBtn = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.panelX + this.panelW - 68, this.panelY + this.panelH - 28, 62, 22).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelBtn);
    }

    private void save() {
        this.parseHexField();
        int color = this.toARGB();
        this.addToRecent(color);
        this.onSelect.accept(color);
    }

    private void copyToClipboard() {
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90911_(this.hexField.m_94155_());
        }
    }

    private void toggleEyedropper() {
        this.eyedropperMode = !this.eyedropperMode;
    }

    private void addToRecent(int color) {
        for (int i = 0; i < recentCount; ++i) {
            if (recentColors[i] != color) continue;
            System.arraycopy(recentColors, 0, recentColors, 1, i);
            ColorPickerScreen.recentColors[0] = color;
            return;
        }
        if (recentCount < recentColors.length) {
            System.arraycopy(recentColors, 0, recentColors, 1, recentCount);
            ++recentCount;
        } else {
            System.arraycopy(recentColors, 0, recentColors, 1, recentColors.length - 1);
        }
        ColorPickerScreen.recentColors[0] = color;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int aCY;
        int hueCY;
        this.m_280273_(g);
        g.m_280509_(this.panelX - 5, this.panelY - 5, this.panelX + this.panelW + 5, this.panelY + this.panelH + 5, -534765536);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.panelY + 6, -1);
        if (this.hexField != null && this.hexField.m_93696_() && !this.dragSV && !this.dragHue && !this.dragA) {
            this.parseHexField();
        }
        int contentTop = this.panelY + 54;
        int contentBottom = this.panelY + this.panelH - 34;
        g.m_280588_(this.panelX, contentTop, this.panelX + this.panelW, contentBottom);
        int scrollY = (int)this.scrollOffset;
        int ySV = this.svY - scrollY;
        int yHue = this.hueY - scrollY;
        int yAlpha = this.aY - scrollY;
        this.drawSVSquareAt(g, this.svX, ySV);
        this.drawHueSliderAt(g, this.hueX, yHue);
        this.drawAlphaSliderAt(g, this.aX, yAlpha);
        int svCX = (int)((float)this.svX + this.sat * (float)this.svW);
        int svCY = (int)((float)ySV + (1.0f - this.val) * (float)this.svH);
        if (svCY >= contentTop && svCY <= contentBottom) {
            g.m_280509_(svCX - 4, svCY - 4, svCX + 5, svCY + 5, -16777216);
            g.m_280509_(svCX - 3, svCY - 3, svCX + 4, svCY + 4, -1);
            g.m_280509_(svCX - 1, svCY - 1, svCX + 2, svCY + 2, -16777216);
        }
        if ((hueCY = (int)((float)yHue + this.hue * (float)this.hueH)) >= contentTop && hueCY <= contentBottom) {
            g.m_280509_(this.hueX - 3, hueCY - 2, this.hueX + this.hueW + 3, hueCY + 3, -16777216);
            g.m_280509_(this.hueX - 2, hueCY - 1, this.hueX + this.hueW + 2, hueCY + 2, -1);
        }
        if ((aCY = (int)((float)yAlpha + (1.0f - this.alpha) * (float)this.aH)) >= contentTop && aCY <= contentBottom) {
            g.m_280509_(this.aX - 3, aCY - 2, this.aX + this.aW + 3, aCY + 3, -16777216);
            g.m_280509_(this.aX - 2, aCY - 1, this.aX + this.aW + 2, aCY + 2, -1);
        }
        int previewX = this.aX + this.aW + 16;
        int previewY = ySV;
        int previewSize = 50;
        int argb = this.toARGB();
        if (previewY >= contentTop - previewSize && previewY <= contentBottom) {
            g.m_280509_(previewX + 2, previewY + 2, previewX + previewSize + 2, previewY + previewSize + 2, Integer.MIN_VALUE);
            this.drawChecker(g, previewX, previewY, previewSize, previewSize);
            g.m_280509_(previewX, previewY, previewX + previewSize, previewY + previewSize, argb);
            this.drawBorder(g, previewX, previewY, previewSize, previewSize);
            int[] rgb = ColorPickerScreen.hsvToRgb(this.hue, this.sat, this.val);
            g.m_280488_(this.f_96547_, String.format("RGB: %d,%d,%d", rgb[0], rgb[1], rgb[2]), previewX, previewY + previewSize + 6, -3355444);
            g.m_280488_(this.f_96547_, String.format("HSV: %.0f\u00b0,%.0f%%,%.0f%%", Float.valueOf(this.hue * 360.0f), Float.valueOf(this.sat * 100.0f), Float.valueOf(this.val * 100.0f)), previewX, previewY + previewSize + 18, -3355444);
        }
        g.m_280488_(this.f_96547_, "Hex:", this.panelX + 12, this.panelY + 16, -1);
        this.drawSlidersAt(g, scrollY);
        this.drawColorPalettesAt(g, mouseX, mouseY, scrollY);
        g.m_280618_();
        if (this.maxScrollOffset > 0.0) {
            this.drawScrollbar(g);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void drawScrollbar(GuiGraphics g) {
        int scrollbarX = this.panelX + this.panelW + 2;
        int scrollbarY = this.panelY + 54;
        int scrollbarH = this.panelH - 88;
        int scrollbarW = 6;
        g.m_280509_(scrollbarX, scrollbarY, scrollbarX + scrollbarW, scrollbarY + scrollbarH, Integer.MIN_VALUE);
        double scrollRatio = this.scrollOffset / this.maxScrollOffset;
        int thumbH = Math.max(20, (int)((double)scrollbarH * ((double)this.panelH / ((double)this.panelH + this.maxScrollOffset))));
        int thumbY = scrollbarY + (int)((double)(scrollbarH - thumbH) * scrollRatio);
        g.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarW, thumbY + thumbH, -5592406);
    }

    private void drawSlidersAt(GuiGraphics g, int scrollY) {
        int[] rgbNow = ColorPickerScreen.hsvToRgb(this.hue, this.sat, this.val);
        int r = rgbNow[0];
        int gg = rgbNow[1];
        int bb = rgbNow[2];
        int a = Math.round(this.alpha * 255.0f);
        int y = this.sliderY0 - scrollY;
        y = this.drawHSlider(g, this.sliderX, y, this.sliderW, (float)r / 255.0f, -65536, "R:", String.valueOf(r), false, true);
        y = this.drawHSlider(g, this.sliderX, y, this.sliderW, (float)gg / 255.0f, -16711936, "G:", String.valueOf(gg), false, true);
        y = this.drawHSlider(g, this.sliderX, y, this.sliderW, (float)bb / 255.0f, -16776961, "B:", String.valueOf(bb), false, true);
        y = this.drawHSlider(g, this.sliderX, y, this.sliderW, (float)a / 255.0f, -1, "A:", String.valueOf(a), false, true);
        g.m_280488_(this.f_96547_, String.format("H: %.0f\u00b0", Float.valueOf(this.hue * 360.0f)), this.sliderX, y += 6, -1);
        y += 12;
        y = this.drawHSlider(g, this.sliderX, y, this.sliderW, this.hue, -1, null, null, true, false);
        g.m_280488_(this.f_96547_, String.format("S: %.0f%%", Float.valueOf(this.sat * 100.0f)), this.sliderX, y += 2, -1);
        y += 12;
        y = this.drawHSlider(g, this.sliderX, y, this.sliderW, this.sat, -1, null, null, false, false, this.hue, -1.0f);
        g.m_280488_(this.f_96547_, String.format("V: %.0f%%", Float.valueOf(this.val * 100.0f)), this.sliderX, y += 2, -1);
        this.drawHSlider(g, this.sliderX, y += 12, this.sliderW, this.val, -1, null, null, false, false, this.hue, this.sat);
    }

    private void drawColorPalettesAt(GuiGraphics g, int mouseX, int mouseY, int scrollY) {
        int presetsLabelX = this.panelX + 12;
        int presetsLabelY = this.presetsTopY() - scrollY;
        g.m_280488_(this.f_96547_, "Presets:", presetsLabelX, presetsLabelY, -1);
        int px = presetsLabelX + 60;
        int py = presetsLabelY - 2;
        int cellSize = 20;
        for (int i = 0; i < PRESETS.length; ++i) {
            int c = PRESETS[i];
            int cx = px + i % 8 * (cellSize + 2);
            int cy = py + i / 8 * (cellSize + 2);
            this.drawChecker(g, cx, cy, cellSize, cellSize);
            g.m_280509_(cx + 1, cy + 1, cx + cellSize - 1, cy + cellSize - 1, c);
            g.m_280509_(cx, cy, cx + cellSize, cy + 1, -10066330);
            g.m_280509_(cx, cy + cellSize - 1, cx + cellSize, cy + cellSize, -10066330);
            g.m_280509_(cx, cy, cx + 1, cy + cellSize, -10066330);
            g.m_280509_(cx + cellSize - 1, cy, cx + cellSize, cy + cellSize, -10066330);
            if (mouseX < cx || mouseX >= cx + cellSize || mouseY < cy || mouseY >= cy + cellSize) continue;
            g.m_280509_(cx, cy, cx + cellSize, cy + cellSize, 0x60FFFFFF);
        }
        if (recentCount > 0) {
            int recentY = py + (PRESETS.length + 7) / 8 * (cellSize + 2) + 10;
            g.m_280488_(this.f_96547_, "Recent:", presetsLabelX, recentY, -1);
            int rx = presetsLabelX + 60;
            for (int i = 0; i < recentCount; ++i) {
                int c = recentColors[i];
                int cx = rx + i * (cellSize + 2);
                this.drawChecker(g, cx, recentY - 2, cellSize, cellSize);
                g.m_280509_(cx + 1, recentY - 1, cx + cellSize - 1, recentY + cellSize - 3, c);
                g.m_280509_(cx, recentY - 2, cx + cellSize, recentY - 1, -10066330);
                g.m_280509_(cx, recentY + cellSize - 3, cx + cellSize, recentY + cellSize - 2, -10066330);
                g.m_280509_(cx, recentY - 2, cx + 1, recentY + cellSize - 2, -10066330);
                g.m_280509_(cx + cellSize - 1, recentY - 2, cx + cellSize, recentY + cellSize - 2, -10066330);
                if (mouseX < cx || mouseX >= cx + cellSize || mouseY < recentY - 2 || mouseY >= recentY + cellSize - 2) continue;
                g.m_280509_(cx, recentY - 2, cx + cellSize, recentY + cellSize - 2, 0x60FFFFFF);
            }
        }
    }

    private void drawSVSquareAt(GuiGraphics g, int x, int y) {
        int stepsX = this.svW / 2;
        for (int i = 0; i < stepsX; ++i) {
            float s = (float)i / (float)(stepsX - 1);
            int[] top = ColorPickerScreen.hsvToRgb(this.hue, s, 1.0f);
            int[] bottom = ColorPickerScreen.hsvToRgb(this.hue, s, 0.0f);
            int colTop = 0xFF000000 | top[0] << 16 | top[1] << 8 | top[2];
            int colBottom = 0xFF000000 | bottom[0] << 16 | bottom[1] << 8 | bottom[2];
            int x1 = x + i * this.svW / stepsX;
            int x2 = x + (i + 1) * this.svW / stepsX;
            for (int j = 0; j < this.svH; ++j) {
                float t = 1.0f - (float)j / (float)(this.svH - 1);
                int r = (int)((float)(colTop >> 16 & 0xFF) * t + (float)(colBottom >> 16 & 0xFF) * (1.0f - t));
                int gg = (int)((float)(colTop >> 8 & 0xFF) * t + (float)(colBottom >> 8 & 0xFF) * (1.0f - t));
                int b = (int)((float)(colTop & 0xFF) * t + (float)(colBottom & 0xFF) * (1.0f - t));
                g.m_280509_(x1, y + j, x2, y + j + 1, 0xFF000000 | r << 16 | gg << 8 | b);
            }
        }
        this.drawBorder(g, x, y, this.svW, this.svH);
    }

    private void drawHueSliderAt(GuiGraphics g, int x, int y) {
        for (int j = 0; j < this.hueH; ++j) {
            float h = (float)j / (float)(this.hueH - 1);
            int[] rgb = ColorPickerScreen.hsvToRgb(h, 1.0f, 1.0f);
            int col = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
            g.m_280509_(x, y + j, x + this.hueW, y + j + 1, col);
        }
        this.drawBorder(g, x, y, this.hueW, this.hueH);
    }

    private void drawAlphaSliderAt(GuiGraphics g, int x, int y) {
        this.drawChecker(g, x, y, this.aW, this.aH);
        int[] rgb = ColorPickerScreen.hsvToRgb(this.hue, this.sat, this.val);
        for (int j = 0; j < this.aH; ++j) {
            float a = 1.0f - (float)j / (float)(this.aH - 1);
            int col = (int)(a * 255.0f) << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
            g.m_280509_(x, y + j, x + this.aW, y + j + 1, col);
        }
        this.drawBorder(g, x, y, this.aW, this.aH);
    }

    private void drawBorder(GuiGraphics g, int x, int y, int w, int h) {
        g.m_280509_(x - 2, y - 2, x + w + 2, y - 1, -7829368);
        g.m_280509_(x - 2, y + h + 1, x + w + 2, y + h + 2, -7829368);
        g.m_280509_(x - 2, y - 1, x - 1, y + h + 1, -7829368);
        g.m_280509_(x + w + 1, y - 1, x + w + 2, y + h + 1, -7829368);
    }

    private void drawChecker(GuiGraphics g, int x, int y, int w, int h) {
        int s = 4;
        for (int yy = 0; yy < h; yy += s) {
            for (int xx = 0; xx < w; xx += s) {
                boolean dark = (xx / s + yy / s) % 2 == 0;
                g.m_280509_(x + xx, y + yy, x + Math.min(xx + s, w), y + Math.min(yy + s, h), dark ? -5592406 : -2236963);
            }
        }
    }

    private void parseHexField() {
        try {
            String hex = this.hexField.m_94155_().trim();
            if (hex.isEmpty()) {
                return;
            }
            if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            if (hex.startsWith("0x") || hex.startsWith("0X")) {
                hex = hex.substring(2);
            }
            long v = Long.parseUnsignedLong(hex, 16);
            int argb = hex.length() <= 6 ? (int)(0xFF000000L | v) : (int)v;
            this.setFromARGB(argb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int y;
            if (this.maxScrollOffset > 0.0) {
                int scrollbarX = this.panelX + this.panelW + 2;
                int scrollbarY = this.panelY + 54;
                int scrollbarH = this.panelH - 88;
                int scrollbarW = 6;
                if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + scrollbarW) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + scrollbarH)) {
                    this.isDraggingScroll = true;
                    this.updateScrollFromMouse(mouseY);
                    return true;
                }
            }
            int scrollY = (int)this.scrollOffset;
            int ySV = this.svY - scrollY;
            int yHue = this.hueY - scrollY;
            int yAlpha = this.aY - scrollY;
            if (mouseX >= (double)this.svX && mouseX < (double)(this.svX + this.svW) && mouseY >= (double)ySV && mouseY < (double)(ySV + this.svH)) {
                this.dragSV = true;
                this.updateSV(mouseX, mouseY, scrollY);
                return true;
            }
            if (mouseX >= (double)this.hueX && mouseX < (double)(this.hueX + this.hueW) && mouseY >= (double)yHue && mouseY < (double)(yHue + this.hueH)) {
                this.dragHue = true;
                this.updateHue(mouseY, scrollY);
                return true;
            }
            if (mouseX >= (double)this.aX && mouseX < (double)(this.aX + this.aW) && mouseY >= (double)yAlpha && mouseY < (double)(yAlpha + this.aH)) {
                this.dragA = true;
                this.updateAlpha(mouseY, scrollY);
                return true;
            }
            int presetsLabelX = this.panelX + 12;
            int presetsLabelY = this.presetsTopY() - scrollY;
            int px = presetsLabelX + 60;
            int py = presetsLabelY - 2;
            int cellSize = 20;
            for (int i = 0; i < PRESETS.length; ++i) {
                int cx = px + i % 8 * (cellSize + 2);
                int cy = py + i / 8 * (cellSize + 2);
                if (!(mouseX >= (double)cx) || !(mouseX < (double)(cx + cellSize)) || !(mouseY >= (double)cy) || !(mouseY < (double)(cy + cellSize))) continue;
                this.setFromARGB(PRESETS[i]);
                this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
                return true;
            }
            if (recentCount > 0) {
                int recentY = py + (PRESETS.length + 7) / 8 * (cellSize + 2) + 10;
                int rx = presetsLabelX + 60;
                for (int i = 0; i < recentCount; ++i) {
                    int cx = rx + i * (cellSize + 2);
                    if (!(mouseX >= (double)cx) || !(mouseX < (double)(cx + cellSize)) || !(mouseY >= (double)(recentY - 2)) || !(mouseY < (double)(recentY + cellSize - 2))) continue;
                    this.setFromARGB(recentColors[i]);
                    this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
                    return true;
                }
            }
            if (this.insideSlider(mouseX, mouseY, this.sliderX, y = this.sliderY0 - scrollY, this.sliderW)) {
                this.dragR = true;
                this.setRFromMouse(mouseX);
                return true;
            }
            if (this.insideSlider(mouseX, mouseY, this.sliderX, y += this.sliderRowH, this.sliderW)) {
                this.dragG = true;
                this.setGFromMouse(mouseX);
                return true;
            }
            if (this.insideSlider(mouseX, mouseY, this.sliderX, y += this.sliderRowH, this.sliderW)) {
                this.dragB = true;
                this.setBFromMouse(mouseX);
                return true;
            }
            if (this.insideSlider(mouseX, mouseY, this.sliderX, y += this.sliderRowH, this.sliderW)) {
                this.dragAH = true;
                this.setAFromMouse(mouseX);
                return true;
            }
            y = this.sliderY0 - scrollY + this.sliderRowH * 4 + 18;
            if (this.insideSlider(mouseX, mouseY, this.sliderX, y, this.sliderW)) {
                this.dragHH = true;
                this.setHFromMouse(mouseX);
                return true;
            }
            if (this.insideSlider(mouseX, mouseY, this.sliderX, y += this.sliderRowH + 14, this.sliderW)) {
                this.dragSH = true;
                this.setSFromMouse(mouseX);
                return true;
            }
            if (this.insideSlider(mouseX, mouseY, this.sliderX, y += this.sliderRowH + 14, this.sliderW)) {
                this.dragVH = true;
                this.setVFromMouse(mouseX);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.isDraggingScroll) {
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        int scrollY = (int)this.scrollOffset;
        if (this.dragSV) {
            this.updateSV(mouseX, mouseY, scrollY);
            return true;
        }
        if (this.dragHue) {
            this.updateHue(mouseY, scrollY);
            return true;
        }
        if (this.dragA) {
            this.updateAlpha(mouseY, scrollY);
            return true;
        }
        if (this.dragR) {
            this.setRFromMouse(mouseX);
            return true;
        }
        if (this.dragG) {
            this.setGFromMouse(mouseX);
            return true;
        }
        if (this.dragB) {
            this.setBFromMouse(mouseX);
            return true;
        }
        if (this.dragAH) {
            this.setAFromMouse(mouseX);
            return true;
        }
        if (this.dragHH) {
            this.setHFromMouse(mouseX);
            return true;
        }
        if (this.dragSH) {
            this.setSFromMouse(mouseX);
            return true;
        }
        if (this.dragVH) {
            this.setVFromMouse(mouseX);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragVH = false;
            this.dragSH = false;
            this.dragHH = false;
            this.dragAH = false;
            this.dragB = false;
            this.dragG = false;
            this.dragR = false;
            this.dragA = false;
            this.dragHue = false;
            this.dragSV = false;
            this.isDraggingScroll = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.maxScrollOffset > 0.0) {
            this.scrollOffset = Math.max(0.0, Math.min(this.maxScrollOffset, this.scrollOffset - delta * 20.0));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void updateScrollFromMouse(double mouseY) {
        int scrollbarY = this.panelY + 54;
        int scrollbarH = this.panelH - 88;
        double ratio = Math.max(0.0, Math.min(1.0, (mouseY - (double)scrollbarY) / (double)scrollbarH));
        this.scrollOffset = ratio * this.maxScrollOffset;
    }

    private void updateSV(double mx, double my, int scrollY) {
        int ySV = this.svY - scrollY;
        this.sat = (float)Math.max(0.0, Math.min(1.0, (mx - (double)this.svX) / (double)this.svW));
        this.val = 1.0f - (float)Math.max(0.0, Math.min(1.0, (my - (double)ySV) / (double)this.svH));
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
    }

    private void updateHue(double my, int scrollY) {
        int yHue = this.hueY - scrollY;
        this.hue = (float)Math.max(0.0, Math.min(1.0, (my - (double)yHue) / (double)this.hueH));
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
    }

    private void updateAlpha(double my, int scrollY) {
        int yAlpha = this.aY - scrollY;
        this.alpha = 1.0f - (float)Math.max(0.0, Math.min(1.0, (my - (double)yAlpha) / (double)this.aH));
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
    }

    private int presetsTopY() {
        int gaps = 38;
        int margin = 24;
        return this.sliderY0 + this.sliderRowH * 7 + gaps + margin;
    }

    private boolean insideSlider(double mx, double my, int x, int y, int w) {
        return mx >= (double)x && mx <= (double)(x + w) && my >= (double)(y - 2) && my <= (double)(y + this.sliderRowH);
    }

    private int drawHSlider(GuiGraphics g, int x, int y, int w, float t, int col, String label, String valText, boolean hsvBar, boolean rgbaMode) {
        return this.drawHSlider(g, x, y, w, t, col, label, valText, hsvBar, rgbaMode, -1.0f, -1.0f);
    }

    private int drawHSlider(GuiGraphics g, int x, int y, int w, float t, int col, String label, String valText, boolean hsvBar, boolean rgbaMode, float hueRef, float satRef) {
        int trackY = y;
        int trackH = this.sliderRowH - 6;
        if (hsvBar) {
            for (i = 0; i < w; ++i) {
                float h = (float)i / (float)(w - 1);
                int[] rgb = ColorPickerScreen.hsvToRgb(h, 1.0f, 1.0f);
                int c = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
                g.m_280509_(x + i, trackY, x + i + 1, trackY + trackH, c);
            }
        } else if (hueRef >= 0.0f && satRef < 0.0f) {
            for (i = 0; i < w; ++i) {
                float s = (float)i / (float)(w - 1);
                int[] rgb = ColorPickerScreen.hsvToRgb(hueRef, s, 1.0f);
                int c = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
                g.m_280509_(x + i, trackY, x + i + 1, trackY + trackH, c);
            }
        } else if (hueRef >= 0.0f && satRef >= 0.0f) {
            for (i = 0; i < w; ++i) {
                float v = (float)i / (float)(w - 1);
                int[] rgb = ColorPickerScreen.hsvToRgb(hueRef, satRef, v);
                int c = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
                g.m_280509_(x + i, trackY, x + i + 1, trackY + trackH, c);
            }
        } else if (rgbaMode) {
            int baseCol = col & 0xFFFFFF;
            for (int i = 0; i < w; ++i) {
                float ratio = (float)i / (float)(w - 1);
                int r = (int)((float)(baseCol >> 16 & 0xFF) * ratio);
                int gg = (int)((float)(baseCol >> 8 & 0xFF) * ratio);
                int b = (int)((float)(baseCol & 0xFF) * ratio);
                int c = 0xFF000000 | r << 16 | gg << 8 | b;
                g.m_280509_(x + i, trackY, x + i + 1, trackY + trackH, c);
            }
        } else {
            g.m_280509_(x, trackY, x + w, trackY + trackH, -12566464);
            g.m_280509_(x, trackY, x + (int)((float)w * t), trackY + trackH, col);
        }
        g.m_280509_(x - 1, trackY - 1, x + w + 1, trackY, -10066330);
        g.m_280509_(x - 1, trackY + trackH, x + w + 1, trackY + trackH + 1, -10066330);
        g.m_280509_(x - 1, trackY, x, trackY + trackH, -10066330);
        g.m_280509_(x + w, trackY, x + w + 1, trackY + trackH, -10066330);
        int kx = x + (int)(t * (float)w);
        g.m_280509_(kx - 3, trackY - 2, kx + 3, trackY + trackH + 1, -16777216);
        g.m_280509_(kx - 2, trackY - 1, kx + 2, trackY + trackH, -1);
        if (label != null) {
            g.m_280488_(this.f_96547_, label, x, trackY - 12, -1);
        }
        if (valText != null) {
            g.m_280488_(this.f_96547_, valText, x + w - this.f_96547_.m_92895_(valText), trackY - 12, -3355444);
        }
        return trackY + this.sliderRowH;
    }

    private void setRFromMouse(double mx) {
        this.setRGBFromMouse(mx, 0);
    }

    private void setGFromMouse(double mx) {
        this.setRGBFromMouse(mx, 1);
    }

    private void setBFromMouse(double mx) {
        this.setRGBFromMouse(mx, 2);
    }

    private void setAFromMouse(double mx) {
        float t;
        this.alpha = t = (float)Math.max(0.0, Math.min(1.0, (mx - (double)this.sliderX) / (double)this.sliderW));
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
    }

    private void setHFromMouse(double mx) {
        float t;
        this.hue = t = (float)Math.max(0.0, Math.min(1.0, (mx - (double)this.sliderX) / (double)this.sliderW));
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
    }

    private void setSFromMouse(double mx) {
        float t;
        this.sat = t = (float)Math.max(0.0, Math.min(1.0, (mx - (double)this.sliderX) / (double)this.sliderW));
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
    }

    private void setVFromMouse(double mx) {
        float t;
        this.val = t = (float)Math.max(0.0, Math.min(1.0, (mx - (double)this.sliderX) / (double)this.sliderW));
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
    }

    private void setRGBFromMouse(double mx, int channel) {
        float t = (float)Math.max(0.0, Math.min(1.0, (mx - (double)this.sliderX) / (double)this.sliderW));
        int[] rgb = ColorPickerScreen.hsvToRgb(this.hue, this.sat, this.val);
        int v = Math.round(t * 255.0f);
        if (channel == 0) {
            rgb[0] = v;
        } else if (channel == 1) {
            rgb[1] = v;
        } else {
            rgb[2] = v;
        }
        float[] hsv = ColorPickerScreen.rgbToHsv(rgb[0], rgb[1], rgb[2]);
        this.hue = hsv[0];
        this.sat = hsv[1];
        this.val = hsv[2];
        this.hexField.m_94144_(String.format("#%08X", this.toARGB()));
    }

    private static int[] hsvToRgb(float h, float s, float v) {
        h = (h % 1.0f + 1.0f) % 1.0f;
        int i = (int)(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (i % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new int[]{(int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f)};
    }

    private static float[] rgbToHsv(int r, int g, int b) {
        float h;
        float s;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float v = max;
        float d = max - min;
        float f = s = max == 0.0f ? 0.0f : d / max;
        if (max == min) {
            h = 0.0f;
        } else {
            h = max == rf ? (gf - bf) / d + (float)(gf < bf ? 6 : 0) : (max == gf ? (bf - rf) / d + 2.0f : (rf - gf) / d + 4.0f);
            h /= 6.0f;
        }
        return new float[]{h, s, v};
    }

    public boolean m_7043_() {
        return false;
    }
}

