/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.questory.client.gui.QuestIconRenderer;

public class EntityPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> onOk;
    private final String initial;
    private final int suggestedIconPx;
    private EditBox searchBox;
    private EditBox fitBox;
    private EditBox minBox;
    private EditBox maxBox;
    private EditBox spinBox;
    private EditBox bobBox;
    private EditBox bobSpeedBox;
    private EditBox iconSizeBox;
    private boolean seqMode = false;
    private Button seqToggleBtn;
    private EditBox intervalBox;
    private EditBox manualFrameBox;
    private Button addCurrentBtn;
    private Button addManualBtn;
    private Button removeFrameBtn;
    private Button upFrameBtn;
    private Button downFrameBtn;
    private Button clearFramesBtn;
    private List<String> frames = new ArrayList<String>();
    private int framesScroll = 0;
    private int framesSel = -1;
    private List<ResourceLocation> all = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> filtered = new ArrayList<ResourceLocation>();
    private ResourceLocation selected = null;
    private int listScroll = 0;
    private String lastQuery = null;
    private static final int PAD = 12;
    private int listX;
    private int listY;
    private int listW;
    private int listH;
    private int rightX;
    private int rightY;
    private int rightW;
    private int rightH;

    public EntityPickerScreen(Screen parent, String seed, Consumer<String> onOk) {
        this(parent, seed, onOk, 42);
    }

    public EntityPickerScreen(Screen parent, String seed, Consumer<String> onOk, int suggestedIconPx) {
        super((Component)Component.m_237113_((String)"Entity Browser"));
        this.parent = parent;
        this.onOk = onOk;
        this.initial = seed == null ? "" : seed;
        this.suggestedIconPx = Math.max(8, Math.min(128, suggestedIconPx));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.listX = 12;
        this.listY = 48;
        this.listW = (int)((double)(this.f_96543_ - 36) * 0.55);
        this.listH = this.f_96544_ - this.listY - 12 - 30;
        this.rightX = this.listX + this.listW + 12;
        this.rightY = 36;
        this.rightW = this.f_96543_ - this.rightX - 12;
        this.rightH = this.f_96544_ - this.rightY - 12 - 30;
        this.searchBox = new EditBox(this.f_96547_, this.listX, 18, this.listW, 18, (Component)Component.m_237113_((String)"Search entities..."));
        this.searchBox.m_94199_(200);
        this.searchBox.m_94144_("");
        this.m_142416_((GuiEventListener)this.searchBox);
        int by = this.f_96544_ - 26;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"OK"), b -> this.applySelection()).m_252987_(this.f_96543_ / 2 - 60, by, 56, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 4, by, 56, 20).m_253136_());
        int fy = this.rightY + 100;
        this.iconSizeBox = new EditBox(this.f_96547_, this.rightX, fy, 60, 18, (Component)Component.m_237113_((String)"icon px"));
        this.iconSizeBox.m_94144_(Integer.toString(this.suggestedIconPx));
        try {
            this.iconSizeBox.m_257771_((Component)Component.m_237113_((String)"icon px"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_142416_((GuiEventListener)this.iconSizeBox);
        int presetX = this.rightX + 66;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"32"), b -> this.iconSizeBox.m_94144_("32")).m_252987_(presetX, fy, 28, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"42"), b -> this.iconSizeBox.m_94144_("42")).m_252987_(presetX += 30, fy, 28, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"64"), b -> this.iconSizeBox.m_94144_("64")).m_252987_(presetX += 30, fy, 28, 18).m_253136_());
        int colW = Math.max(60, this.rightW / 3 - 8);
        this.fitBox = new EditBox(this.f_96547_, this.rightX, fy += 22, colW, 18, (Component)Component.m_237113_((String)"fit"));
        this.minBox = new EditBox(this.f_96547_, this.rightX + colW + 6, fy, colW, 18, (Component)Component.m_237113_((String)"min"));
        this.maxBox = new EditBox(this.f_96547_, this.rightX + (colW + 6) * 2, fy, colW, 18, (Component)Component.m_237113_((String)"max"));
        try {
            this.fitBox.m_257771_((Component)Component.m_237113_((String)"0.1 - 2.0"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.minBox.m_257771_((Component)Component.m_237113_((String)"min scale"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.maxBox.m_257771_((Component)Component.m_237113_((String)"max scale"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.spinBox = new EditBox(this.f_96547_, this.rightX, fy += 22, colW, 18, (Component)Component.m_237113_((String)"spin"));
        this.bobBox = new EditBox(this.f_96547_, this.rightX + colW + 6, fy, colW, 18, (Component)Component.m_237113_((String)"bob"));
        this.bobSpeedBox = new EditBox(this.f_96547_, this.rightX + (colW + 6) * 2, fy, colW, 18, (Component)Component.m_237113_((String)"bob_speed"));
        try {
            this.spinBox.m_257771_((Component)Component.m_237113_((String)"deg/tick"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.bobBox.m_257771_((Component)Component.m_237113_((String)"px"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.bobSpeedBox.m_257771_((Component)Component.m_237113_((String)"speed"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_142416_((GuiEventListener)this.fitBox);
        this.m_142416_((GuiEventListener)this.minBox);
        this.m_142416_((GuiEventListener)this.maxBox);
        this.m_142416_((GuiEventListener)this.spinBox);
        this.m_142416_((GuiEventListener)this.bobBox);
        this.m_142416_((GuiEventListener)this.bobSpeedBox);
        int seqY = fy + 22 + 22 + 72;
        this.seqToggleBtn = Button.m_253074_((Component)Component.m_237113_((String)"Sequence: Off"), b -> {
            this.seqMode = !this.seqMode;
            this.seqToggleBtn.m_93666_((Component)Component.m_237113_((String)(this.seqMode ? "Sequence: On" : "Sequence: Off")));
        }).m_252987_(this.rightX, seqY, 120, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.seqToggleBtn);
        this.intervalBox = new EditBox(this.f_96547_, this.rightX + 126, seqY, 40, 18, (Component)Component.m_237113_((String)"ticks"));
        this.intervalBox.m_94144_("20");
        try {
            this.intervalBox.m_257771_((Component)Component.m_237113_((String)"ticks"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_142416_((GuiEventListener)this.intervalBox);
        this.manualFrameBox = new EditBox(this.f_96547_, this.rightX + 170, seqY, Math.max(60, this.rightW - 170 - 4), 18, (Component)Component.m_237113_((String)"manual frame"));
        this.manualFrameBox.m_94144_("");
        this.m_142416_((GuiEventListener)this.manualFrameBox);
        int btnY = seqY + 22;
        this.addCurrentBtn = Button.m_253074_((Component)Component.m_237113_((String)"+Current"), b -> {
            if (this.selected != null) {
                this.frames.add("entity:" + this.selected.toString());
            }
        }).m_252987_(this.rightX, btnY, 68, 18).m_253136_();
        this.addManualBtn = Button.m_253074_((Component)Component.m_237113_((String)"+Add"), b -> {
            String v = this.manualFrameBox.m_94155_().trim();
            if (!v.isEmpty()) {
                this.frames.add(v);
            }
        }).m_252987_(this.rightX + 72, btnY, 48, 18).m_253136_();
        this.removeFrameBtn = Button.m_253074_((Component)Component.m_237113_((String)"-Del"), b -> {
            if (this.framesSel >= 0 && this.framesSel < this.frames.size()) {
                this.frames.remove(this.framesSel);
                this.framesSel = -1;
            }
        }).m_252987_(this.rightX + 124, btnY, 44, 18).m_253136_();
        this.upFrameBtn = Button.m_253074_((Component)Component.m_237113_((String)"Up"), b -> {
            if (this.framesSel > 0) {
                String s = this.frames.remove(this.framesSel);
                --this.framesSel;
                this.frames.add(this.framesSel, s);
            }
        }).m_252987_(this.rightX + 172, btnY, 36, 18).m_253136_();
        this.downFrameBtn = Button.m_253074_((Component)Component.m_237113_((String)"Down"), b -> {
            if (this.framesSel >= 0 && this.framesSel < this.frames.size() - 1) {
                String s = this.frames.remove(this.framesSel);
                ++this.framesSel;
                this.frames.add(this.framesSel, s);
            }
        }).m_252987_(this.rightX + 212, btnY, 44, 18).m_253136_();
        this.clearFramesBtn = Button.m_253074_((Component)Component.m_237113_((String)"Clear"), b -> {
            this.frames.clear();
            this.framesSel = -1;
        }).m_252987_(this.rightX + 260, btnY, 48, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.addCurrentBtn);
        this.m_142416_((GuiEventListener)this.addManualBtn);
        this.m_142416_((GuiEventListener)this.removeFrameBtn);
        this.m_142416_((GuiEventListener)this.upFrameBtn);
        this.m_142416_((GuiEventListener)this.downFrameBtn);
        this.m_142416_((GuiEventListener)this.clearFramesBtn);
        this.all = new ArrayList<ResourceLocation>();
        for (ResourceLocation id : BuiltInRegistries.f_256780_.m_6566_()) {
            this.all.add(id);
        }
        this.all.sort(Comparator.comparing(ResourceLocation::toString));
        if (this.initial.startsWith("entity:")) {
            try {
                String raw = this.initial.substring("entity:".length()).trim();
                int semi = raw.indexOf(59);
                String idStr = semi >= 0 ? raw.substring(0, semi).trim() : raw;
                ResourceLocation sel = new ResourceLocation(idStr);
                if (BuiltInRegistries.f_256780_.m_7804_(sel)) {
                    this.selected = sel;
                }
                if (semi >= 0) {
                    String rest = raw.substring(semi + 1);
                    HashMap<String, String> mods = new HashMap<String, String>();
                    for (String p : rest.split(";")) {
                        int eq;
                        String s = p.trim();
                        if (s.isEmpty() || (eq = s.indexOf(61)) <= 0) continue;
                        mods.put(s.substring(0, eq).trim().toLowerCase(Locale.ROOT), s.substring(eq + 1).trim());
                    }
                    this.fitBox.m_94144_(mods.getOrDefault("fit", ""));
                    this.minBox.m_94144_(mods.getOrDefault("min", ""));
                    this.maxBox.m_94144_(mods.getOrDefault("max", ""));
                    this.spinBox.m_94144_(mods.getOrDefault("spin", ""));
                    this.bobBox.m_94144_(mods.getOrDefault("bob", ""));
                    this.bobSpeedBox.m_94144_(mods.getOrDefault("bob_speed", ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateFiltered();
    }

    private void updateFiltered() {
        String q = this.searchBox == null ? "" : this.searchBox.m_94155_().trim().toLowerCase(Locale.ROOT);
        this.filtered = new ArrayList<ResourceLocation>();
        for (ResourceLocation id : this.all) {
            if (!q.isEmpty() && !id.toString().toLowerCase(Locale.ROOT).contains(q)) continue;
            this.filtered.add(id);
        }
        if (this.selected == null || !this.filtered.contains(this.selected)) {
            // empty if block
        }
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - this.visibleRows())));
    }

    private int visibleRows() {
        return Math.max(1, this.listH / 18);
    }

    private void applySelection() {
        String result;
        if (this.seqMode && !this.frames.isEmpty()) {
            int interval;
            try {
                interval = Math.max(1, Integer.parseInt(this.intervalBox.m_94155_().trim()));
            }
            catch (Exception e) {
                interval = 20;
            }
            StringBuilder sb = new StringBuilder("rotate:").append(interval).append('|');
            for (int i = 0; i < this.frames.size(); ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                sb.append(this.frames.get(i));
            }
            result = sb.toString();
        } else {
            result = this.selected != null ? this.buildIconString(this.selected) : this.initial;
        }
        this.onOk.accept(result);
        this.f_96541_.m_91152_(this.parent);
    }

    private String buildIconString(ResourceLocation id) {
        String bobSp;
        String bob;
        String spin;
        String max;
        String min;
        ArrayList<CallSite> mods = new ArrayList<CallSite>();
        String fit = this.fitBox.m_94155_().trim();
        if (!fit.isEmpty()) {
            mods.add((CallSite)((Object)("fit=" + fit)));
        }
        if (!(min = this.minBox.m_94155_().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("min=" + min)));
        }
        if (!(max = this.maxBox.m_94155_().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("max=" + max)));
        }
        if (!(spin = this.spinBox.m_94155_().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("spin=" + spin)));
        }
        if (!(bob = this.bobBox.m_94155_().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("bob=" + bob)));
        }
        if (!(bobSp = this.bobSpeedBox.m_94155_().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("bob_speed=" + bobSp)));
        }
        if (mods.isEmpty()) {
            return "entity:" + id.toString();
        }
        StringBuilder sb = new StringBuilder("entity:").append(id.toString()).append("; ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append("; ");
            }
            sb.append((String)mods.get(i));
        }
        return sb.toString();
    }

    public boolean m_6375_(double mx, double my, int button) {
        int row;
        int idx;
        if (super.m_6375_(mx, my, button)) {
            return true;
        }
        if (mx >= (double)this.listX && mx <= (double)(this.listX + this.listW) && my >= (double)this.listY && my <= (double)(this.listY + this.listH) && (idx = this.listScroll + (row = (int)((my - (double)this.listY) / 18.0))) >= 0 && idx < this.filtered.size()) {
            this.selected = this.filtered.get(idx);
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mx, double my, double delta) {
        if (mx >= (double)this.listX && mx <= (double)(this.listX + this.listW) && my >= (double)this.listY && my <= (double)(this.listY + this.listH)) {
            this.listScroll = Math.max(0, Math.min(this.listScroll - (int)Math.signum(delta), Math.max(0, this.filtered.size() - this.visibleRows())));
            return true;
        }
        return super.m_6050_(mx, my, delta);
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float p) {
        String q;
        this.m_280273_(g);
        g.m_280430_(this.f_96547_, this.f_96539_, 12, 12, -1);
        if (this.searchBox != null && (q = this.searchBox.m_94155_()) != null && !q.equals(this.lastQuery)) {
            this.lastQuery = q;
            this.updateFiltered();
        }
        g.m_280509_(this.listX, this.listY, this.listX + this.listW, this.listY + this.listH, -535818224);
        g.m_280588_(this.listX, this.listY, this.listX + this.listW, this.listY + this.listH);
        int vis = this.visibleRows();
        for (int i = 0; i < vis && this.listScroll + i < this.filtered.size(); ++i) {
            ResourceLocation id = this.filtered.get(this.listScroll + i);
            int y = this.listY + i * 18;
            boolean hover = mx >= this.listX && mx <= this.listX + this.listW && my >= y && my < y + 18;
            boolean sel = id.equals((Object)this.selected);
            if (sel) {
                g.m_280509_(this.listX, y, this.listX + this.listW, y + 18, -12952966);
            } else if (hover) {
                g.m_280509_(this.listX, y, this.listX + this.listW, y + 18, -14013910);
            }
            g.m_280488_(this.f_96547_, id.toString(), this.listX + 6, y + 5, -1);
        }
        g.m_280618_();
        g.m_280488_(this.f_96547_, "Preview:", this.rightX, this.rightY, -5592321);
        int pv = Math.min(96, Math.min(this.rightW, this.rightH) - 20);
        int px = this.rightX + (this.rightW - pv) / 2;
        int py = this.rightY + 20;
        g.m_280509_(px - 2, py - 2, px + pv + 2, py + pv + 2, -12566464);
        if (this.seqMode && !this.frames.isEmpty()) {
            int interval;
            try {
                iconSize = Math.max(8, Math.min(128, Integer.parseInt(this.iconSizeBox.m_94155_().trim())));
            }
            catch (Exception e) {
                iconSize = 42;
            }
            ix = px + (pv - iconSize) / 2;
            iy = py + (pv - iconSize) / 2;
            try {
                interval = Math.max(1, Integer.parseInt(this.intervalBox.m_94155_().trim()));
            }
            catch (Exception e) {
                interval = 20;
            }
            StringBuilder sb = new StringBuilder("rotate:").append(interval).append('|');
            for (int i = 0; i < this.frames.size(); ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                sb.append(this.frames.get(i));
            }
            try {
                QuestIconRenderer.render(g, sb.toString(), ix, iy, iconSize, false, false);
            }
            catch (Throwable throwable) {}
        } else if (this.selected != null) {
            try {
                try {
                    iconSize = Math.max(8, Math.min(128, Integer.parseInt(this.iconSizeBox.m_94155_().trim())));
                }
                catch (Exception e) {
                    iconSize = 42;
                }
                ix = px + (pv - iconSize) / 2;
                iy = py + (pv - iconSize) / 2;
                QuestIconRenderer.render(g, this.buildIconString(this.selected), ix, iy, iconSize, false, false);
            }
            catch (Throwable iconSize) {
                // empty catch block
            }
        }
        int colW = Math.max(60, this.rightW / 3 - 8);
        int row1Y = this.rightY + 84;
        g.m_280488_(this.f_96547_, "Fit  Min  Max", this.rightX, row1Y, -3355444);
        int row2Y = row1Y + 22 + 22;
        g.m_280488_(this.f_96547_, "Spin  Bob  Bob Speed", this.rightX, row2Y, -3355444);
        int helpY = row2Y + 26;
        g.m_280488_(this.f_96547_, "Help:", this.rightX, helpY, -5592321);
        g.m_280488_(this.f_96547_, "- Icon px: matches graph icon size (node*0.65)", this.rightX, helpY + 12, -7829368);
        super.m_88315_(g, mx, my, p);
    }
}

