/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.api.RewardRegistry;

public class RewardTypePickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> onSelect;
    private final String[] types;
    private final String[] typeLabels;
    private static final String[] BUILTIN_TYPES = new String[]{"item", "xp", "command", "script", "loot", "choice", "random", "currency", "advancement", "stage", "title", "toast", "xp_levels"};
    private static final String[] BUILTIN_LABELS = new String[]{"Item Reward", "Experience", "Command Execution", "KubeJS Script", "Loot Table", "Choice Reward", "Random Reward", "Currency", "Advancement", "GameStage", "Title Message", "Toast Notification", "XP Levels"};
    private static final Map<String, String> KEYWORDS = new HashMap<String, String>();
    private EditBox searchBox;
    private List<String> filteredTypes = new ArrayList<String>();
    private int scroll = 0;
    private boolean draggingScrollbar = false;

    public RewardTypePickerScreen(Screen parent, Consumer<String> onSelect) {
        super((Component)Component.m_237113_((String)"Select Reward Type"));
        int i;
        this.parent = parent;
        this.onSelect = onSelect;
        LinkedHashSet<String> allTypes = new LinkedHashSet<String>();
        for (String type : BUILTIN_TYPES) {
            allTypes.add(type);
        }
        try {
            allTypes.addAll(RewardRegistry.getRegisteredTypes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.types = allTypes.toArray(new String[0]);
        this.typeLabels = new String[this.types.length];
        HashMap<String, String> labelMap = new HashMap<String, String>();
        for (i = 0; i < BUILTIN_TYPES.length; ++i) {
            labelMap.put(BUILTIN_TYPES[i], BUILTIN_LABELS[i]);
        }
        for (i = 0; i < this.types.length; ++i) {
            String type = this.types[i];
            this.typeLabels[i] = labelMap.getOrDefault(type, RewardTypePickerScreen.generateLabel(type));
        }
        this.updateFilter();
    }

    protected void m_7856_() {
        super.m_7856_();
        int panelW = 300;
        int panelH = 350;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        this.searchBox = new EditBox(this.f_96547_, panelX + 12, panelY + 32, panelW - 24, 16, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94151_(s -> {
            this.scroll = 0;
            this.updateFilter();
        });
        this.m_142416_((GuiEventListener)this.searchBox);
    }

    private void updateFilter() {
        String query = this.searchBox != null ? this.searchBox.m_94155_().toLowerCase().trim() : "";
        this.filteredTypes.clear();
        if (query.isEmpty()) {
            for (String type : this.types) {
                this.filteredTypes.add(type);
            }
        } else {
            for (int i = 0; i < this.types.length; ++i) {
                String type = this.types[i];
                String label = this.typeLabels[i].toLowerCase();
                String keywords = KEYWORDS.getOrDefault(type, "").toLowerCase();
                if (!type.toLowerCase().contains(query) && !label.contains(query) && !keywords.contains(query)) continue;
                this.filteredTypes.add(type);
            }
        }
    }

    private static String generateLabel(String typeId) {
        if (typeId == null || typeId.isEmpty()) {
            return "Unknown";
        }
        String[] parts = typeId.split(":");
        String name = parts.length > 1 ? parts[1] : parts[0];
        String namespace = parts.length > 1 ? parts[0] : null;
        String[] words = name.split("_");
        StringBuilder label = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            label.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() > 1) {
                label.append(word.substring(1).toLowerCase(Locale.ROOT));
            }
            label.append(" ");
        }
        if (namespace != null && !namespace.equals("questory") && !namespace.equals("minecraft")) {
            label.append("(");
            label.append(Character.toUpperCase(namespace.charAt(0)));
            if (namespace.length() > 1) {
                label.append(namespace.substring(1));
            }
            label.append(")");
        } else if (label.length() > 0 && label.charAt(label.length() - 1) == ' ') {
            label.setLength(label.length() - 1);
        }
        return label.toString();
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int index;
        this.m_280273_(g);
        int panelW = 300;
        int panelH = 350;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        g.m_280509_(panelX, panelY, panelX + panelW, panelY + panelH, -535818224);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, panelY + 12, -1);
        int listY = panelY + 56;
        int listH = panelH - 88;
        int lineH = 20;
        g.m_280588_(panelX, listY, panelX + panelW, listY + listH);
        int total = this.filteredTypes.size();
        int maxVisible = listH / lineH;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, total - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, total - this.scroll) && (index = this.scroll + i) < total; ++i) {
            boolean hover;
            String typeId = this.filteredTypes.get(index);
            int originalIndex = -1;
            for (int k = 0; k < this.types.length; ++k) {
                if (!this.types[k].equals(typeId)) continue;
                originalIndex = k;
                break;
            }
            String label = originalIndex >= 0 ? this.typeLabels[originalIndex] : typeId;
            int itemY = listY + i * lineH;
            boolean bl = hover = mouseX >= panelX + 8 && mouseX <= panelX + panelW - 8 && mouseY >= itemY && mouseY < itemY + lineH;
            if (hover) {
                g.m_280509_(panelX + 8, itemY, panelX + panelW - 8, itemY + lineH, -12952966);
            }
            g.m_280488_(this.f_96547_, label, panelX + 12, itemY + 6, -1);
        }
        g.m_280618_();
        if (total > maxVisible) {
            int barW = 6;
            int trackX = panelX + panelW - 8 - barW;
            int trackY = listY;
            int trackH = listH;
            g.m_280509_(trackX, trackY, trackX + barW, trackY + trackH, 0x40222222);
            int thumbH = Math.max(12, (int)((float)trackH * (float)maxVisible / (float)total));
            int maxScroll = total - maxVisible;
            int thumbMax = trackH - thumbH;
            int thumbY = trackY + (maxScroll == 0 ? 0 : (int)((float)this.scroll / (float)maxScroll * (float)thumbMax));
            g.m_280509_(trackX + 1, thumbY, trackX + barW - 1, thumbY + thumbH, this.draggingScrollbar ? -9787695 : -7829368);
        }
        int btnW = 80;
        int btnX = this.f_96543_ / 2 - btnW / 2;
        int btnY = panelY + panelH - 28;
        g.m_280509_(btnX, btnY, btnX + btnW, btnY + 20, -12303292);
        g.m_280137_(this.f_96547_, "Cancel", this.f_96543_ / 2, btnY + 6, -1);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int total;
        int index;
        int panelW = 300;
        int panelH = 350;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        int listY = panelY + 56;
        int listH = panelH - 88;
        int lineH = 20;
        int maxVisible = listH / lineH;
        if (mouseX >= (double)(panelX + 8) && mouseX <= (double)(panelX + panelW - 8) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (index = this.scroll + ((int)mouseY - listY) / lineH) >= 0 && index < this.filteredTypes.size()) {
            this.onSelect.accept(this.filteredTypes.get(index));
            return true;
        }
        int barW = 6;
        int trackX = panelX + panelW - 8 - barW;
        if (mouseX >= (double)trackX && mouseX <= (double)(trackX + barW) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (total = this.filteredTypes.size()) > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            this.draggingScrollbar = true;
            return true;
        }
        int btnW = 80;
        int btnX = this.f_96543_ / 2 - btnW / 2;
        int btnY = panelY + panelH - 28;
        if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnW) && mouseY >= (double)btnY && mouseY < (double)(btnY + 20)) {
            this.f_96541_.m_91152_(this.parent);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int panelW = 300;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW)) {
            this.scroll = (int)Math.max(0.0, (double)this.scroll - Math.signum(delta));
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScrollbar) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        int panelW = 300;
        int panelH = 350;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        int listY = panelY + 56;
        int listH = panelH - 88;
        int lineH = 20;
        int maxVisible = Math.max(1, listH / lineH);
        int total = this.filteredTypes.size();
        if (total > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    static {
        KEYWORDS.put("item", "give grant reward loot");
        KEYWORDS.put("xp", "experience level levels");
        KEYWORDS.put("command", "run execute console");
        KEYWORDS.put("script", "kubejs js code javascript");
        KEYWORDS.put("loot", "table chest drop");
        KEYWORDS.put("choice", "select pick option");
        KEYWORDS.put("random", "chance luck rng");
        KEYWORDS.put("currency", "money coins cash economy");
        KEYWORDS.put("advancement", "unlock grant achievement");
        KEYWORDS.put("stage", "gamestage unlock");
        KEYWORDS.put("title", "message screen display");
        KEYWORDS.put("toast", "notification popup");
        KEYWORDS.put("xp_levels", "levels experience");
    }
}

