/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class CloseConfirmationDialog
extends Screen {
    private static final int DIALOG_WIDTH = 400;
    private static final int DIALOG_HEIGHT = 300;
    private static final int PADDING = 12;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 90;
    private final Screen parent;
    private final Screen returnScreen;
    private final List<UnsavedEntity> unsavedEntities;
    private final Runnable onSaveAll;
    private final Runnable onDiscard;
    private final Runnable onCancel;
    private int dialogX;
    private int dialogY;
    private int listScroll = 0;
    private boolean discardConfirmPending = false;

    public CloseConfirmationDialog(Screen parent, Screen returnScreen, List<UnsavedEntity> unsavedEntities, Runnable onSaveAll, Runnable onDiscard, Runnable onCancel) {
        super((Component)Component.m_237113_((String)"Unsaved Changes"));
        this.parent = parent;
        this.returnScreen = returnScreen;
        this.unsavedEntities = new ArrayList<UnsavedEntity>(unsavedEntities);
        this.onSaveAll = onSaveAll;
        this.onDiscard = onDiscard;
        this.onCancel = onCancel;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.dialogX = (this.f_96543_ - 400) / 2;
        this.dialogY = (this.f_96544_ - 300) / 2;
        int buttonY = this.dialogY + 300 - 12 - 20;
        int centerX = this.dialogX + 200;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save All"), b -> {
            if (this.onSaveAll != null) {
                this.onSaveAll.run();
            }
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.returnScreen);
            }
        }).m_252987_(centerX - 90 - 4 - 90 - 4, buttonY, 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.discardConfirmPending ? "\u00a7cConfirm?" : "Discard")), b -> {
            if (!this.discardConfirmPending) {
                this.discardConfirmPending = true;
                b.m_93666_((Component)Component.m_237113_((String)"\u00a7cConfirm?"));
            } else {
                if (this.onDiscard != null) {
                    this.onDiscard.run();
                }
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_(this.returnScreen);
                }
            }
        }).m_252987_(centerX - 45, buttonY, 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> {
            if (this.onCancel != null) {
                this.onCancel.run();
            }
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(centerX + 45 + 4, buttonY, 90, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
        g.m_280509_(this.dialogX, this.dialogY, this.dialogX + 400, this.dialogY + 300, -267382768);
        g.m_280509_(this.dialogX, this.dialogY, this.dialogX + 400, this.dialogY + 2, -22016);
        g.m_280509_(this.dialogX, this.dialogY, this.dialogX + 2, this.dialogY + 300, -7829368);
        g.m_280509_(this.dialogX + 400 - 2, this.dialogY, this.dialogX + 400, this.dialogY + 300, -7829368);
        g.m_280509_(this.dialogX, this.dialogY + 300 - 2, this.dialogX + 400, this.dialogY + 300, -7829368);
        g.m_280653_(this.f_96547_, this.f_96539_, this.dialogX + 200, this.dialogY + 12, -1);
        int textY = this.dialogY + 12 + 16;
        String desc = "You have " + this.unsavedEntities.size() + " unsaved " + (this.unsavedEntities.size() == 1 ? "change" : "changes") + ":";
        g.m_280488_(this.f_96547_, desc, this.dialogX + 12, textY, -3355444);
        int listY = textY + 16;
        int listHeight = 300 - (listY - this.dialogY) - 12 - 20 - 12 - 4;
        int listX = this.dialogX + 12;
        int listW = 376;
        g.m_280509_(listX, listY, listX + listW, listY + listHeight, -15066598);
        this.renderEntityList(g, listX, listY, listW, listHeight, mouseX, mouseY);
        int warningY = this.dialogY + 300 - 12 - 20 - 12 - 12;
        String warning = "\u00a7eChoose an action:";
        g.m_280137_(this.f_96547_, warning, this.dialogX + 200, warningY, -1);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderEntityList(GuiGraphics g, int x, int y, int w, int h, int mouseX, int mouseY) {
        if (this.unsavedEntities.isEmpty()) {
            return;
        }
        g.m_280588_(x, y, x + w, y + h);
        int lineHeight = 18;
        int maxLines = h / lineHeight;
        int startIndex = Math.max(0, Math.min(this.listScroll, this.unsavedEntities.size() - maxLines));
        int endIndex = Math.min(this.unsavedEntities.size(), startIndex + maxLines);
        int itemY = y + 4;
        for (int i = startIndex; i < endIndex; ++i) {
            UnsavedEntity entity = this.unsavedEntities.get(i);
            g.m_280488_(this.f_96547_, "\u2022", x + 4, itemY, -22016);
            Object label = entity.getDisplayName();
            if (entity.getType() != null && !entity.getType().isEmpty()) {
                label = entity.getType() + ": " + (String)label;
            }
            int maxWidth = w - 60;
            if (this.f_96547_.m_92895_((String)label) > maxWidth) {
                label = this.f_96547_.m_92834_((String)label, maxWidth - 20) + "...";
            }
            g.m_280488_(this.f_96547_, (String)label, x + 16, itemY, -1);
            String age = entity.getAgeString();
            int ageX = x + w - this.f_96547_.m_92895_(age) - 8;
            g.m_280488_(this.f_96547_, age, ageX, itemY, -7829368);
            itemY += lineHeight;
        }
        g.m_280618_();
        if (this.unsavedEntities.size() > maxLines) {
            int scrollBarH = Math.max(20, maxLines * h / this.unsavedEntities.size());
            int scrollBarY = y + (h - scrollBarH) * startIndex / Math.max(1, this.unsavedEntities.size() - maxLines);
            g.m_280509_(x + w - 4, scrollBarY, x + w - 2, scrollBarY + scrollBarH, -7829368);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int listY = this.dialogY + 12 + 32;
        int listHeight = 300 - (listY - this.dialogY) - 12 - 20 - 12 - 4;
        int listX = this.dialogX + 12;
        int listW = 376;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY <= (double)(listY + listHeight)) {
            int lineHeight = 18;
            int maxLines = listHeight / lineHeight;
            int maxScroll = Math.max(0, this.unsavedEntities.size() - maxLines);
            this.listScroll = Math.max(0, Math.min(maxScroll, this.listScroll - (int)Math.signum(delta)));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.onCancel != null) {
                this.onCancel.run();
            }
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return true;
    }

    public static class UnsavedEntity {
        private final String displayName;
        private final String type;
        private final long lastModified;

        public UnsavedEntity(String displayName, String type, long lastModified) {
            this.displayName = displayName;
            this.type = type;
            this.lastModified = lastModified;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getType() {
            return this.type;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String getAgeString() {
            long ageMs = System.currentTimeMillis() - this.lastModified;
            long seconds = ageMs / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            if (hours > 0L) {
                return hours + "h ago";
            }
            if (minutes > 0L) {
                return minutes + "m ago";
            }
            return seconds + "s ago";
        }
    }
}

