/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.function.Consumer;
import org.texboobcat.questory.client.gui.editor.EditorCommand;

public class PropertyChangeCommand
implements EditorCommand {
    private final String propertyName;
    private final String oldValue;
    private final String newValue;
    private final Consumer<String> setter;
    private final Runnable onExecute;

    public PropertyChangeCommand(String propertyName, String oldValue, String newValue, Consumer<String> setter, Runnable onExecute) {
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.setter = setter;
        this.onExecute = onExecute;
    }

    @Override
    public void execute() {
        this.setter.accept(this.newValue);
        if (this.onExecute != null) {
            this.onExecute.run();
        }
    }

    @Override
    public void undo() {
        this.setter.accept(this.oldValue);
        if (this.onExecute != null) {
            this.onExecute.run();
        }
    }

    @Override
    public String getDescription() {
        return "Change " + this.propertyName;
    }
}

