/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.hjson.JsonValue;
import org.texboobcat.questory.config.ConfigMigrator;
import org.texboobcat.questory.config.ConfigVersion;

public class QuestoryConfig {
    private static QuestoryConfig instance;
    public String configVersion = ConfigVersion.CURRENT.toString();
    public boolean enableQuestNotifications = true;
    public boolean enableQuestSounds = true;
    public boolean enableQuestTitles = true;
    public boolean enableQuestChatMessages = true;
    public boolean notifyOnQuestUnlock = true;
    public boolean notifyOnQuestReady = true;
    public boolean notifyOnQuestComplete = true;
    public int autoSaveIntervalTicks = 6000;
    public boolean saveOnEveryProgress = false;
    public boolean trackCompletionTime = true;
    public int maxQuestsPerPlayer = 1000;
    public int maxRequirementsPerQuest = 50;
    public int maxRewardsPerQuest = 20;
    public boolean allowQuestReset = true;
    public boolean allowQuestReload = true;
    public boolean requireOPForAdmin = true;
    public int adminPermissionLevel = 2;
    public boolean autoCompleteWhenRequirementsMet = false;
    public boolean showQuestIDInList = false;
    public boolean showProgressPercentage = true;
    public boolean useColoredMessages = true;
    public boolean observationEnabled = true;
    public int observationScanIntervalTicks = 10;
    public double observationMaxLookDistance = 5.0;
    public boolean environmentOnlyVisibleQuests = false;
    public int equipmentCheckIntervalTicks = 200;
    public boolean debugMode = false;
    public boolean logQuestProgress = false;
    public boolean logQuestCompletion = true;
    public boolean enableAdvancedEditor = false;
    public boolean advancedEditorRequiresOp = true;
    public boolean enableEditorAutoSave = true;
    public String customThemeName = "";
    public boolean ftbImportPreserveDependencies = true;
    public boolean ftbImportConvertUnknownTasks = true;
    public String ftbImportQuestPrefix = "ftb_";
    public boolean dailyEnable = false;
    public String dailyRemoteUrl = "";
    public List<String> dailyBackupUrls = new ArrayList<String>();
    public boolean dailyFetchOnWorldLoad = true;
    public int dailyFetchIntervalMinutes = 0;
    public int dailyCacheTtlMinutes = 1440;
    public String dailyOfflineFallback = "use_cache";
    public int dailyRolloverHour = 0;
    public String dailyTimeZone = "UTC";
    public String dailyGroupName = "Daily";
    public String dailyTagKey = "daily";
    public String dailyPrefixQuestIds = "daily_";
    public int dailyMaxActiveQuests = 0;
    public String dailyCompletionMode = "ALL";
    public int dailyMinQuestsToComplete = 0;
    public boolean dailyStoreHistory = true;
    public int dailyHttpTimeoutMs = 8000;
    public int dailyRetryCount = 2;
    public String dailyDataDirNameOverride = "";
    public boolean scriptIntegrationEnabled = false;
    public boolean scriptAllowExternalHttp = false;
    public String scriptWebhookUrl = "";
    public int scriptHttpTimeoutMs = 5000;
    public String scriptCommandOnUnlock = "";
    public String scriptCommandOnStarted = "";
    public String scriptCommandOnProgress = "";
    public String scriptCommandOnComplete = "";
    public String scriptCommandOnRewardClaimed = "";
    public boolean scriptEmitOnUnlock = true;
    public boolean scriptEmitOnStarted = true;
    public boolean scriptEmitOnProgress = false;
    public boolean scriptEmitOnCompleted = true;
    public boolean scriptEmitOnRewardClaimed = true;
    public boolean teamSystemEnabled = true;
    public boolean teamUseExternalProvider = true;
    public String teamPreferredProvider = "ftbteams";
    public boolean teamFallbackToBuiltIn = true;
    public String teamDefaultProgressMode = "SHARED";
    public String teamDefaultRewardMode = "SHARED";
    public int teamMaxSize = 10;
    public boolean teamAllowCreation = true;
    public boolean teamRequireAllOnlineDefault = false;
    public int teamSyncProgressDelay = 20;
    public String storageType = "json";
    public String sqliteDatabasePath = "questory.db";
    public String mysqlHost = "localhost";
    public int mysqlPort = 3306;
    public String mysqlDatabase = "questory";
    public String mysqlUsername = "questory_user";
    public String mysqlPassword = "";
    public String mysqlTablePrefix = "questory_";
    public int mysqlPoolMinConnections = 2;
    public int mysqlPoolMaxConnections = 10;
    public int mysqlConnectionTimeoutMs = 30000;
    public int mysqlIdleTimeoutMs = 600000;
    public boolean mysqlAutoReconnect = true;
    public int storageRetryAttempts = 3;
    public int storageRetryDelayMs = 1000;

    private QuestoryConfig() {
    }

    public static QuestoryConfig getInstance() {
        if (instance == null) {
            instance = new QuestoryConfig();
        }
        return instance;
    }

    public static void load(Path configPath) {
        Path hjsonFile = configPath.resolve("questory-common.hjson");
        Path jsonFile = configPath.resolve("questory-common.json");
        Path configFile = Files.exists(hjsonFile, new LinkOption[0]) ? hjsonFile : (Files.exists(jsonFile, new LinkOption[0]) ? jsonFile : hjsonFile);
        try {
            if (Files.exists(configFile, new LinkOption[0])) {
                ConfigVersion targetVersion;
                Gson gson = new Gson();
                String content = Files.readString(configFile);
                String jsonString = JsonValue.readHjson((String)content).toString();
                JsonObject jsonObj = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
                String currentVersionStr = jsonObj.has("configVersion") ? jsonObj.get("configVersion").getAsString() : "1.0.0";
                ConfigVersion currentVersion = ConfigVersion.fromString(currentVersionStr);
                if (currentVersion.isOlderThan(targetVersion = ConfigVersion.CURRENT)) {
                    System.out.println("[Questory] Config migration needed: " + String.valueOf(currentVersion) + " -> " + String.valueOf(targetVersion));
                    String fileName = configFile.getFileName().toString();
                    boolean migrationSuccess = ConfigMigrator.migrate(configPath, fileName, targetVersion);
                    if (!migrationSuccess) {
                        System.err.println("[Questory] Migration failed, attempting to load anyway...");
                    }
                    content = Files.readString(configFile);
                    jsonString = JsonValue.readHjson((String)content).toString();
                    jsonObj = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
                }
                instance = (QuestoryConfig)gson.fromJson(jsonObj.toString(), QuestoryConfig.class);
                if (QuestoryConfig.instance.configVersion == null || QuestoryConfig.instance.configVersion.isEmpty()) {
                    QuestoryConfig.instance.configVersion = ConfigVersion.CURRENT.toString();
                }
                System.out.println("[Questory] Config loaded (version " + QuestoryConfig.instance.configVersion + ") from: " + String.valueOf(configFile));
                QuestoryConfig.save(configPath);
                if (configFile.equals(jsonFile)) {
                    System.out.println("[Questory] Migrated config from JSON to HJSON format");
                }
            } else {
                instance = new QuestoryConfig();
                QuestoryConfig.save(configPath);
                System.out.println("[Questory] Created default config at: " + String.valueOf(configFile));
            }
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to load config, using defaults: " + e.getMessage());
            e.printStackTrace();
            instance = new QuestoryConfig();
        }
    }

    public static void save(Path configPath) {
        if (instance == null) {
            instance = new QuestoryConfig();
        }
        Path configFile = configPath.resolve("questory-common.hjson");
        try {
            Files.createDirectories(configPath, new FileAttribute[0]);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject json = gson.toJsonTree((Object)instance).getAsJsonObject();
            StringBuilder commented = new StringBuilder();
            commented.append("//\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("// Questory Configuration File\n");
            commented.append("// Version: ").append(QuestoryConfig.instance.configVersion != null ? QuestoryConfig.instance.configVersion : ConfigVersion.CURRENT.toString()).append("\n");
            commented.append("//\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("// Edit this file to customize quest system behavior\n");
            commented.append("// Changes require /quest reload or server restart to take effect\n");
            commented.append("// Backups are automatically created before migrations in questory-backups/\n");
            commented.append("//\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\n");
            commented.append("{\n");
            commented.append("  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550 VERSION \u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            QuestoryConfig.appendField(commented, json, "configVersion", "Config version (managed automatically, do not modify)");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 NOTIFICATION SETTINGS \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("  // Control how and when players are notified about quest events\n");
            QuestoryConfig.appendField(commented, json, "enableQuestNotifications", "Master toggle for all notifications");
            QuestoryConfig.appendField(commented, json, "enableQuestSounds", "Play sound effects");
            QuestoryConfig.appendField(commented, json, "enableQuestTitles", "Show title/subtitle messages");
            QuestoryConfig.appendField(commented, json, "enableQuestChatMessages", "Send chat messages");
            QuestoryConfig.appendField(commented, json, "notifyOnQuestUnlock", "Notify when quest becomes available");
            QuestoryConfig.appendField(commented, json, "notifyOnQuestReady", "Notify when all requirements met");
            QuestoryConfig.appendField(commented, json, "notifyOnQuestComplete", "Notify on completion");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 PROGRESS & PERFORMANCE \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("  // Settings for saving player progress and system limits\n");
            QuestoryConfig.appendField(commented, json, "autoSaveIntervalTicks", "Auto-save interval (6000 = 5 min, 20 = 1 sec)");
            QuestoryConfig.appendField(commented, json, "saveOnEveryProgress", "Save immediately after each update (impacts performance)");
            QuestoryConfig.appendField(commented, json, "trackCompletionTime", "Track quest completion timestamps");
            QuestoryConfig.appendField(commented, json, "maxQuestsPerPlayer", "Maximum quests per player");
            QuestoryConfig.appendField(commented, json, "maxRequirementsPerQuest", "Maximum requirements per quest");
            QuestoryConfig.appendField(commented, json, "maxRewardsPerQuest", "Maximum rewards per quest");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 QUEST BEHAVIOR \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            QuestoryConfig.appendField(commented, json, "allowQuestReset", "Allow players to reset quest progress");
            QuestoryConfig.appendField(commented, json, "allowQuestReload", "Allow /quest reload command");
            QuestoryConfig.appendField(commented, json, "requireOPForAdmin", "Require OP for admin commands");
            QuestoryConfig.appendField(commented, json, "adminPermissionLevel", "Permission level (2 = standard OP, 4 = full)");
            QuestoryConfig.appendField(commented, json, "autoCompleteWhenRequirementsMet", "Auto-complete when all requirements met");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 DISPLAY SETTINGS \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            QuestoryConfig.appendField(commented, json, "showQuestIDInList", "Show quest IDs (for debugging)");
            QuestoryConfig.appendField(commented, json, "showProgressPercentage", "Show progress percentages");
            QuestoryConfig.appendField(commented, json, "useColoredMessages", "Use colored chat messages");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 OBSERVATION & ENVIRONMENT \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("  // Settings for observation-type requirements (looking at blocks/entities)\n");
            QuestoryConfig.appendField(commented, json, "observationEnabled", "Enable observation requirements");
            QuestoryConfig.appendField(commented, json, "observationScanIntervalTicks", "Scan interval (10 = 0.5 sec)");
            QuestoryConfig.appendField(commented, json, "observationMaxLookDistance", "Max look distance in blocks");
            QuestoryConfig.appendField(commented, json, "environmentOnlyVisibleQuests", "Only check visible quests (performance)");
            QuestoryConfig.appendField(commented, json, "equipmentCheckIntervalTicks", "Equipment check interval (200 = 10 sec)");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 DEBUG SETTINGS \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            QuestoryConfig.appendField(commented, json, "debugMode", "Enable verbose debug logging");
            QuestoryConfig.appendField(commented, json, "logQuestProgress", "Log every progress update (very verbose)");
            QuestoryConfig.appendField(commented, json, "logQuestCompletion", "Log quest completions");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 ADVANCED EDITOR \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("  // WARNING: Powerful feature - only enable for trusted users\n");
            QuestoryConfig.appendField(commented, json, "enableAdvancedEditor", "Enable in-game quest/theme editor");
            QuestoryConfig.appendField(commented, json, "advancedEditorRequiresOp", "Require OP to use editor");
            QuestoryConfig.appendField(commented, json, "enableEditorAutoSave", "Enable auto-save in editor (uses autoSaveIntervalTicks)");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 THEME SETTINGS \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            QuestoryConfig.appendField(commented, json, "customThemeName", "Custom theme name (empty = default)");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 FTB QUESTS IMPORT \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            QuestoryConfig.appendField(commented, json, "ftbImportPreserveDependencies", "Preserve quest dependencies");
            QuestoryConfig.appendField(commented, json, "ftbImportConvertUnknownTasks", "Convert unknown task types");
            QuestoryConfig.appendField(commented, json, "ftbImportQuestPrefix", "Prefix for imported quest IDs");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 DAILY QUEST SYSTEM \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("  // Rotating quests that reset daily from remote source\n");
            QuestoryConfig.appendField(commented, json, "dailyEnable", "Enable daily quests");
            QuestoryConfig.appendField(commented, json, "dailyRemoteUrl", "Primary fetch URL (empty = disabled)");
            QuestoryConfig.appendField(commented, json, "dailyBackupUrls", "Backup URLs if primary fails");
            QuestoryConfig.appendField(commented, json, "dailyFetchOnWorldLoad", "Fetch on world/server start");
            QuestoryConfig.appendField(commented, json, "dailyFetchIntervalMinutes", "Auto-fetch interval (0 = manual only)");
            QuestoryConfig.appendField(commented, json, "dailyCacheTtlMinutes", "Cache lifetime (1440 = 24 hours)");
            QuestoryConfig.appendField(commented, json, "dailyOfflineFallback", "Fallback: use_cache|keep_previous|disable");
            QuestoryConfig.appendField(commented, json, "dailyRolloverHour", "Reset hour in 24h format (0 = midnight)");
            QuestoryConfig.appendField(commented, json, "dailyTimeZone", "Time zone (IANA format, e.g., UTC)");
            QuestoryConfig.appendField(commented, json, "dailyGroupName", "Default group name");
            QuestoryConfig.appendField(commented, json, "dailyTagKey", "Tag for filtering");
            QuestoryConfig.appendField(commented, json, "dailyPrefixQuestIds", "Quest ID prefix");
            QuestoryConfig.appendField(commented, json, "dailyMaxActiveQuests", "Max active quests (0 = all)");
            QuestoryConfig.appendField(commented, json, "dailyCompletionMode", "Completion: ALL|ANY");
            QuestoryConfig.appendField(commented, json, "dailyMinQuestsToComplete", "Min quests to complete (0 = use mode)");
            QuestoryConfig.appendField(commented, json, "dailyStoreHistory", "Store historical data");
            QuestoryConfig.appendField(commented, json, "dailyHttpTimeoutMs", "HTTP timeout (ms)");
            QuestoryConfig.appendField(commented, json, "dailyRetryCount", "Number of retry attempts");
            QuestoryConfig.appendField(commented, json, "dailyDataDirNameOverride", "Custom data subfolder (empty = default)");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 SCRIPTING & INTEGRATION \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("  // Connect quest events to webhooks and commands\n");
            QuestoryConfig.appendField(commented, json, "scriptIntegrationEnabled", "Enable integrations");
            QuestoryConfig.appendField(commented, json, "scriptAllowExternalHttp", "Allow HTTP requests (security risk)");
            QuestoryConfig.appendField(commented, json, "scriptWebhookUrl", "Webhook URL (empty = disabled)");
            QuestoryConfig.appendField(commented, json, "scriptHttpTimeoutMs", "HTTP timeout (ms)");
            commented.append("  // Command templates - Placeholders: {player}, {uuid}, {quest_id}, {quest_title}, {group}, {timestamp}\n");
            QuestoryConfig.appendField(commented, json, "scriptCommandOnUnlock", "Command on unlock");
            QuestoryConfig.appendField(commented, json, "scriptCommandOnStarted", "Command on start");
            QuestoryConfig.appendField(commented, json, "scriptCommandOnProgress", "Command on progress");
            QuestoryConfig.appendField(commented, json, "scriptCommandOnComplete", "Command on complete");
            QuestoryConfig.appendField(commented, json, "scriptCommandOnRewardClaimed", "Command on reward claim");
            commented.append("  // Event toggles\n");
            QuestoryConfig.appendField(commented, json, "scriptEmitOnUnlock", "Emit unlock events");
            QuestoryConfig.appendField(commented, json, "scriptEmitOnStarted", "Emit start events");
            QuestoryConfig.appendField(commented, json, "scriptEmitOnProgress", "Emit progress events (can be frequent)");
            QuestoryConfig.appendField(commented, json, "scriptEmitOnCompleted", "Emit completion events");
            QuestoryConfig.appendField(commented, json, "scriptEmitOnRewardClaimed", "Emit reward claim events");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 TEAM SYSTEM \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("  // Shared quest progress and team rewards\n");
            QuestoryConfig.appendField(commented, json, "teamSystemEnabled", "Enable team quests");
            QuestoryConfig.appendField(commented, json, "teamUseExternalProvider", "Use external team mods");
            QuestoryConfig.appendField(commented, json, "teamPreferredProvider", "Preferred provider (e.g., ftbteams)");
            QuestoryConfig.appendField(commented, json, "teamFallbackToBuiltIn", "Use built-in if external unavailable");
            QuestoryConfig.appendField(commented, json, "teamDefaultProgressMode", "Progress: SHARED|INDIVIDUAL|COMBINED|PARALLEL");
            QuestoryConfig.appendField(commented, json, "teamDefaultRewardMode", "Rewards: SHARED|COMPLETER_ONLY|DISTRIBUTED|ALL_MEMBERS");
            QuestoryConfig.appendField(commented, json, "teamMaxSize", "Max team size (built-in)");
            QuestoryConfig.appendField(commented, json, "teamAllowCreation", "Allow team creation");
            QuestoryConfig.appendField(commented, json, "teamRequireAllOnlineDefault", "Require all online for completion");
            QuestoryConfig.appendField(commented, json, "teamSyncProgressDelay", "Sync delay (20 = 1 sec)");
            commented.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 STORAGE BACKEND \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            commented.append("  // json = simple file-based | sqlite = local DB | mysql = remote DB\n");
            QuestoryConfig.appendField(commented, json, "storageType", "Storage type (json|sqlite|mysql)");
            commented.append("\n  // SQLite Settings (when storageType = sqlite)\n");
            QuestoryConfig.appendField(commented, json, "sqliteDatabasePath", "Database file path (relative to world)");
            commented.append("\n  // MySQL Settings (when storageType = mysql)\n");
            QuestoryConfig.appendField(commented, json, "mysqlHost", "Server hostname/IP");
            QuestoryConfig.appendField(commented, json, "mysqlPort", "Server port (default: 3306)");
            QuestoryConfig.appendField(commented, json, "mysqlDatabase", "Database name");
            QuestoryConfig.appendField(commented, json, "mysqlUsername", "Username");
            QuestoryConfig.appendField(commented, json, "mysqlPassword", "Password (can use ${ENV_VAR})");
            QuestoryConfig.appendField(commented, json, "mysqlTablePrefix", "Table prefix");
            commented.append("  // MySQL Connection Pool\n");
            QuestoryConfig.appendField(commented, json, "mysqlPoolMinConnections", "Min connections");
            QuestoryConfig.appendField(commented, json, "mysqlPoolMaxConnections", "Max connections");
            QuestoryConfig.appendField(commented, json, "mysqlConnectionTimeoutMs", "Connection timeout (ms)");
            QuestoryConfig.appendField(commented, json, "mysqlIdleTimeoutMs", "Idle timeout (ms)");
            QuestoryConfig.appendField(commented, json, "mysqlAutoReconnect", "Auto-reconnect on failure");
            commented.append("\n  // Storage Retry Settings\n");
            QuestoryConfig.appendField(commented, json, "storageRetryAttempts", "Retry attempts before failure");
            QuestoryConfig.appendFieldLast(commented, json, "storageRetryDelayMs", "Delay between retries (ms)");
            commented.append("\n}\n");
            Files.writeString(configFile, (CharSequence)commented.toString(), new OpenOption[0]);
            System.out.println("[Questory] Config saved to: " + String.valueOf(configFile));
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to save config: " + e.getMessage());
        }
    }

    private static void appendField(StringBuilder sb, JsonObject json, String key, String description) {
        if (json.has(key)) {
            sb.append("  \"").append(key).append("\": ");
            sb.append(json.get(key).toString());
            sb.append(",  // ").append(description).append("\n");
        }
    }

    private static void appendFieldLast(StringBuilder sb, JsonObject json, String key, String description) {
        if (json.has(key)) {
            sb.append("  \"").append(key).append("\": ");
            sb.append(json.get(key).toString());
            sb.append("  // ").append(description).append("\n");
        }
    }

    public static void reload(Path configPath) {
        QuestoryConfig.load(configPath);
    }

    public boolean shouldNotify(String type) {
        if (!this.enableQuestNotifications) {
            return false;
        }
        return switch (type.toLowerCase()) {
            case "unlock" -> this.notifyOnQuestUnlock;
            case "ready" -> this.notifyOnQuestReady;
            case "complete" -> this.notifyOnQuestComplete;
            default -> true;
        };
    }

    public boolean shouldPlaySound() {
        return this.enableQuestNotifications && this.enableQuestSounds;
    }

    public boolean shouldShowTitle() {
        return this.enableQuestNotifications && this.enableQuestTitles;
    }

    public boolean shouldShowChatMessage() {
        return this.enableQuestNotifications && this.enableQuestChatMessages;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debug) {
        this.debugMode = debug;
    }
}

