/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;

public class TeamSettingsPacket {
    private final SettingType type;
    private final int intValue;
    private final UUID uuidValue;

    private TeamSettingsPacket(SettingType type, int intValue, UUID uuidValue) {
        this.type = type;
        this.intValue = intValue;
        this.uuidValue = uuidValue;
    }

    public static TeamSettingsPacket setMaxMembers(int maxMembers) {
        return new TeamSettingsPacket(SettingType.MAX_MEMBERS, maxMembers, null);
    }

    public static TeamSettingsPacket transferOwnership(UUID newOwnerId) {
        return new TeamSettingsPacket(SettingType.TRANSFER_OWNERSHIP, 0, newOwnerId);
    }

    public static TeamSettingsPacket disbandTeam() {
        return new TeamSettingsPacket(SettingType.DISBAND_TEAM, 0, null);
    }

    public static void encode(TeamSettingsPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.type);
        buf.writeInt(packet.intValue);
        buf.writeBoolean(packet.uuidValue != null);
        if (packet.uuidValue != null) {
            buf.m_130077_(packet.uuidValue);
        }
    }

    public static TeamSettingsPacket decode(FriendlyByteBuf buf) {
        SettingType type = (SettingType)buf.m_130066_(SettingType.class);
        int intValue = buf.readInt();
        UUID uuidValue = buf.readBoolean() ? buf.m_130259_() : null;
        return new TeamSettingsPacket(type, intValue, uuidValue);
    }

    public void handle(ServerPlayer player) {
        TeamManager teamMgr = TeamManager.getInstance();
        UUID teamId = teamMgr.getPlayerTeamId(player.m_20148_());
        if (teamId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are not in a team"));
            return;
        }
        if (!teamMgr.isTeamOwner(player.m_20148_(), teamId)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Only the team owner can modify settings"));
            return;
        }
        QuestTeam team = teamMgr.getTeam(teamId);
        if (team == null) {
            return;
        }
        switch (this.type.ordinal()) {
            case 0: {
                this.handleMaxMembers(player, team);
                break;
            }
            case 1: {
                this.handleTransferOwnership(player, team, teamMgr);
                break;
            }
            case 2: {
                this.handleDisbandTeam(player, team, teamMgr);
            }
        }
    }

    private void handleMaxMembers(ServerPlayer player, QuestTeam team) {
        int newMax = Math.max(1, Math.min(this.intValue, 100));
        if (newMax < team.getMemberCount()) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Questory] Cannot set max members below current member count (" + team.getMemberCount() + ")")));
            return;
        }
        team.getSettings().setMaxMembers(newMax);
        TeamManager.getInstance().saveTeamProgress(team.getTeamId());
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] Team max members set to " + newMax)));
        this.syncTeamToAllMembers(team, player.m_20194_());
    }

    private void handleTransferOwnership(ServerPlayer player, QuestTeam team, TeamManager teamMgr) {
        if (this.uuidValue == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Invalid player ID"));
            return;
        }
        if (!team.isMember(this.uuidValue)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Player is not a member of this team"));
            return;
        }
        if (team.isOwner(this.uuidValue)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] That player is already the owner"));
            return;
        }
        team.setOwner(this.uuidValue);
        teamMgr.saveTeamProgress(team.getTeamId());
        String newOwnerName = this.getPlayerName(player.m_20194_(), this.uuidValue);
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] Transferred team ownership to " + newOwnerName)));
        ServerPlayer newOwner = player.m_20194_().m_6846_().m_11259_(this.uuidValue);
        if (newOwner != null) {
            newOwner.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Questory] You are now the owner of team: " + team.getTeamName())));
        }
        this.syncTeamToAllMembers(team, player.m_20194_());
    }

    private void handleDisbandTeam(ServerPlayer player, QuestTeam team, TeamManager teamMgr) {
        String teamName = team.getTeamName();
        for (UUID memberId : team.getMembers()) {
            ServerPlayer member = player.m_20194_().m_6846_().m_11259_(memberId);
            if (member == null) continue;
            member.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Questory] Team '" + teamName + "' has been disbanded")));
            this.syncTeamToPlayer(member, null);
        }
        teamMgr.deleteTeam(team.getTeamId());
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Questory] Team disbanded successfully"));
    }

    private void syncTeamToAllMembers(QuestTeam team, MinecraftServer server) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        for (UUID memberId : team.getMembers()) {
            ServerPlayer member = server.m_6846_().m_11259_(memberId);
            if (member == null) continue;
            this.syncTeamToPlayer(member, team);
        }
    }

    private void syncTeamToPlayer(ServerPlayer player, QuestTeam team) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        Set<UUID> inviteIds = teamMgr.getPendingInvites(player.m_20148_());
        ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
        for (UUID inviteTeamId : inviteIds) {
            QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
            if (inviteTeam == null) continue;
            String ownerName = this.getPlayerName(player.m_20194_(), inviteTeam.getOwner());
            TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
            inviteInfos.add(info);
        }
        int rewardCount = pendingMgr.getPendingRewardCount(player.m_20148_());
        TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.m_20148_(), inviteInfos, rewardCount);
        NetworkManager.sendToClient(player, syncPacket);
    }

    private String getPlayerName(MinecraftServer server, UUID playerId) {
        ServerPlayer player = server.m_6846_().m_11259_(playerId);
        if (player != null) {
            return player.m_7755_().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    public static enum SettingType {
        MAX_MEMBERS,
        TRANSFER_OWNERSHIP,
        DISBAND_TEAM;

    }
}

