/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import java.util.UUID;
import org.texboobcat.questory.api.RequirementRegistry;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CurrencyRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.EquipItemRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.GenericTriggerRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;
import org.texboobcat.questory.quest.XpRequirement;

public abstract class Requirement {
    protected String type;
    protected String id;

    public Requirement(String type) {
        this.type = type;
        this.id = UUID.randomUUID().toString();
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract boolean isMet(QuestProgress var1, String var2);

    public abstract String getProgressDisplay(QuestProgress var1, String var2);

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("id", this.id);
        return json;
    }

    public static Requirement fromJson(JsonObject json) {
        Requirement requirement;
        String type;
        switch (type = json.get("type").getAsString()) {
            case "item_obtain": {
                Requirement requirement2 = ItemRequirement.fromJson(json);
                break;
            }
            case "item_craft": {
                Requirement requirement2 = CraftingRequirement.fromJson(json);
                break;
            }
            case "entity_kill": {
                Requirement requirement2 = EntityKillRequirement.fromJson(json);
                break;
            }
            case "advancement": {
                Requirement requirement2 = AdvancementRequirement.fromJson(json);
                break;
            }
            case "command": {
                Requirement requirement2 = CommandRequirement.fromJson(json);
                break;
            }
            case "checkmark": {
                Requirement requirement2 = CheckmarkRequirement.fromJson(json);
                break;
            }
            case "statistic": {
                Requirement requirement2 = StatisticRequirement.fromJson(json);
                break;
            }
            case "fluid": {
                Requirement requirement2 = FluidRequirement.fromJson(json);
                break;
            }
            case "biome": {
                Requirement requirement2 = BiomeRequirement.fromJson(json);
                break;
            }
            case "dimension": {
                Requirement requirement2 = DimensionRequirement.fromJson(json);
                break;
            }
            case "location": {
                Requirement requirement2 = LocationRequirement.fromJson(json);
                break;
            }
            case "energy": {
                Requirement requirement2 = EnergyRequirement.fromJson(json);
                break;
            }
            case "structure": {
                Requirement requirement2 = StructureRequirement.fromJson(json);
                break;
            }
            case "observation": {
                Requirement requirement2 = ObservationRequirement.fromJson(json);
                break;
            }
            case "xp": {
                Requirement requirement2 = XpRequirement.fromJson(json);
                break;
            }
            case "stage": {
                Requirement requirement2 = StageRequirement.fromJson(json);
                break;
            }
            case "custom": {
                Requirement requirement2 = CustomRequirement.fromJson(json);
                break;
            }
            case "currency_req": {
                Requirement requirement2 = CurrencyRequirement.fromJson(json);
                break;
            }
            case "item_tag": {
                Requirement requirement2 = ItemTagRequirement.fromJson(json);
                break;
            }
            case "region": {
                Requirement requirement2 = RegionRequirement.fromJson(json);
                break;
            }
            case "time": {
                Requirement requirement2 = TimeRequirement.fromJson(json);
                break;
            }
            case "weather": {
                Requirement requirement2 = WeatherRequirement.fromJson(json);
                break;
            }
            case "generic_trigger": {
                Requirement requirement2 = GenericTriggerRequirement.fromJson(json);
                break;
            }
            case "equip_item": {
                Requirement requirement2 = EquipItemRequirement.fromJson(json);
                break;
            }
            default: {
                Requirement requirement2 = requirement = null;
            }
        }
        if (requirement == null && RequirementRegistry.isRegistered(type)) {
            requirement = RequirementRegistry.create(type, json);
        }
        if (requirement == null) {
            throw new IllegalArgumentException("Unknown requirement type: " + type);
        }
        if (json.has("id")) {
            String id = json.get("id").getAsString();
            requirement.setId(id);
        }
        return requirement;
    }
}

