/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.texboobcat.questory.quest.Reward;

public class ScriptReward
extends Reward {
    private String script;
    private String displayName;

    public ScriptReward(String script, String displayName) {
        super("script");
        this.script = script != null ? script : "";
        this.displayName = displayName;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script != null ? script : "";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void grant(ServerPlayer player) {
        if (this.script == null || this.script.trim().isEmpty()) {
            return;
        }
        String processedScript = this.script.replace("{player}", player.m_36316_().getName()).replace("{uuid}", player.m_20149_()).replace("{x}", String.valueOf((int)player.m_20185_())).replace("{y}", String.valueOf((int)player.m_20186_())).replace("{z}", String.valueOf((int)player.m_20189_()));
        try {
            CommandSourceStack source = new CommandSourceStack((CommandSource)player, player.m_20182_(), player.m_20155_(), player.m_284548_(), 4, player.m_7755_().getString(), player.m_5446_(), player.f_8924_, (Entity)player);
            String kubeCommand = "kubejs run_server " + this.escapeForCommand(processedScript);
            try {
                player.f_8924_.m_129892_().m_230957_(source, kubeCommand);
            }
            catch (Exception e) {
                String[] lines;
                for (String line : lines = processedScript.split("\n")) {
                    String trimmed = line.trim();
                    if (trimmed.isEmpty() || trimmed.startsWith("//")) continue;
                    try {
                        player.f_8924_.m_129892_().m_230957_(source, trimmed);
                    }
                    catch (Exception ex) {
                        System.err.println("[Questory] Failed to execute script line: " + trimmed);
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to execute script reward");
            e.printStackTrace();
        }
    }

    private String escapeForCommand(String script) {
        return script.replace("\"", "\\\"").replace("'", "\\'");
    }

    @Override
    public String getDisplayString() {
        if (this.displayName != null && !this.displayName.trim().isEmpty()) {
            return this.displayName;
        }
        return "Execute KubeJS Script";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("script", this.script);
        if (this.displayName != null && !this.displayName.trim().isEmpty()) {
            json.addProperty("displayName", this.displayName);
        }
        return json;
    }

    public static ScriptReward fromJson(JsonObject json) {
        String script = json.has("script") ? json.get("script").getAsString() : "";
        String displayName = json.has("displayName") ? json.get("displayName").getAsString() : null;
        return new ScriptReward(script, displayName);
    }
}

