/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_3222;
import org.texboobcat.questory.api.RequirementFactory;
import org.texboobcat.questory.api.RequirementRegistry;
import org.texboobcat.questory.api.RewardFactory;
import org.texboobcat.questory.api.RewardRegistry;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;

public class QuestoryAPI {
    public static void registerRequirementType(String type, RequirementFactory factory) {
        RequirementRegistry.register(type, factory);
    }

    public static void registerRewardType(String type, RewardFactory factory) {
        RewardRegistry.register(type, factory);
    }

    public static Quest getQuest(String questId) {
        return QuestManager.getInstance().getQuest(questId);
    }

    public static Collection<Quest> getAllQuests() {
        return QuestManager.getInstance().getAllQuests();
    }

    public static QuestProgress getPlayerProgress(UUID playerId) {
        return QuestManager.getInstance().getProgress(playerId);
    }

    public static boolean hasCompletedQuest(UUID playerId, String questId) {
        QuestProgress progress = QuestoryAPI.getPlayerProgress(playerId);
        return progress != null && progress.isQuestCompleted(questId);
    }

    public static void trackCustomProgress(UUID playerId, String questId, String requirementId, int amount) {
        QuestManager.getInstance().trackCustomProgress(playerId, requirementId, amount);
    }

    public static boolean completeQuest(class_3222 player, String questId) {
        return QuestManager.getInstance().completeQuest(player, questId);
    }

    public static List<Quest> getVisibleQuests(UUID playerId) {
        return QuestManager.getInstance().getVisibleQuests(playerId);
    }

    public static List<Quest> getCompletableQuests(UUID playerId) {
        return QuestManager.getInstance().getCompletableQuests(playerId);
    }
}

