/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.NewThemeEditorScreen;

class IconPickerScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<String> onOk;
    private String initial;
    private class_342 pathBox;
    private class_342 tileBox;
    private class_342 colorBox;
    private class_342 searchBox;
    private List<class_2960> resources = new ArrayList<class_2960>();
    private List<class_2960> filtered = new ArrayList<class_2960>();
    private int listScroll = 0;
    private String nsFilter = "all";
    private class_2960 selectedRL = null;
    private static final int PAD = 12;
    private static final int TOP_H = 24;
    private static final int BOTTOM_H = 34;
    private int browserX;
    private int browserY;
    private int browserW;
    private int browserH;
    private int rightX;
    private int rightY;
    private int rightW;
    private int rightH;

    protected IconPickerScreen(class_437 parent, String seed, Consumer<String> onOk) {
        super((class_2561)class_2561.method_43470((String)"Icon Browser"));
        this.parent = parent;
        this.initial = seed == null ? "" : seed;
        this.onOk = onOk;
    }

    protected void method_25426() {
        super.method_25426();
        this.browserX = 12;
        this.browserY = 60;
        this.browserW = (int)((double)(this.field_22789 - 36) * 0.6);
        this.browserH = this.field_22790 - this.browserY - 34 - 12;
        this.rightX = this.browserX + this.browserW + 12;
        this.rightY = 36;
        this.rightW = this.field_22789 - this.rightX - 12;
        this.rightH = this.field_22790 - this.rightY - 34 - 12;
        this.searchBox = new class_342(this.field_22793, this.browserX, 36, this.browserW, 18, (class_2561)class_2561.method_43470((String)"Search textures..."));
        this.searchBox.method_1880(200);
        this.searchBox.method_1852("");
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Type to filter textures..."));
        this.method_37063((class_364)this.searchBox);
        int tx = this.browserX;
        int ty = 58;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"All"), b -> {
            this.nsFilter = "all";
            this.updateFiltered();
        }).method_46434(tx, ty, 48, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Minecraft"), b -> {
            this.nsFilter = "minecraft";
            this.updateFiltered();
        }).method_46434(tx += 52, ty, 70, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"FTBQuests"), b -> {
            this.nsFilter = "ftbquests";
            this.updateFiltered();
        }).method_46434(tx += 74, ty, 70, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Other"), b -> {
            this.nsFilter = "other";
            this.updateFiltered();
        }).method_46434(tx += 74, ty, 48, 18).method_46431());
        int fy = this.rightY + 60;
        this.pathBox = new class_342(this.field_22793, this.rightX, fy, this.rightW, 18, (class_2561)class_2561.method_43470((String)"Path"));
        this.pathBox.method_1880(500);
        this.pathBox.method_1852(IconPickerScreen.extractPath(this.initial));
        this.pathBox.method_47404((class_2561)class_2561.method_43470((String)"namespace:path or item:id or tag:id"));
        this.method_37063((class_364)this.pathBox);
        this.tileBox = new class_342(this.field_22793, this.rightX, fy += 24, (this.rightW - 4) / 2, 18, (class_2561)class_2561.method_43470((String)"tile_size"));
        this.tileBox.method_1880(10);
        this.tileBox.method_1852(IconPickerScreen.extractModifier(this.initial, "tile_size"));
        this.tileBox.method_47404((class_2561)class_2561.method_43470((String)"Optional tile size"));
        this.method_37063((class_364)this.tileBox);
        this.colorBox = new class_342(this.field_22793, this.rightX + (this.rightW + 4) / 2, fy, (this.rightW - 4) / 2, 18, (class_2561)class_2561.method_43470((String)"color"));
        this.colorBox.method_1880(20);
        this.colorBox.method_1852(IconPickerScreen.extractModifier(this.initial, "color"));
        this.colorBox.method_47404((class_2561)class_2561.method_43470((String)"Optional tint #AARRGGBB"));
        this.method_37063((class_364)this.colorBox);
        int bx = this.field_22789 / 2 - 60;
        int by = this.field_22790 - 34 + 6;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"OK"), b -> {
            String result = this.build();
            if (!this.validateResource(result) && this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7eWarning: texture not found"));
            }
            this.onOk.accept(result);
            this.field_22787.method_1507(this.parent);
        }).method_46434(bx, by, 56, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(bx + 60, by, 56, 20).method_46431());
        this.loadResources();
        this.updateFiltered();
    }

    private void loadResources() {
        try {
            class_3300 rm = class_310.method_1551().method_1478();
            Map map = rm.method_14488("textures", rl -> rl.method_12832().endsWith(".png"));
            this.resources = new ArrayList(map.keySet());
            Collections.sort(this.resources, (a, b) -> a.toString().compareTo(b.toString()));
        }
        catch (Throwable t) {
            this.resources = Collections.emptyList();
        }
    }

    private void updateFiltered() {
        this.filtered.clear();
        String q = this.searchBox == null ? "" : this.searchBox.method_1882().trim().toLowerCase();
        for (class_2960 rl : this.resources) {
            boolean qok;
            boolean bl = qok = q.isEmpty() || rl.toString().toLowerCase().contains(q);
            if (!qok) continue;
            String ns = rl.method_12836();
            boolean nsok = this.nsFilter.equals("all") || this.nsFilter.equals("other") && !ns.equals("minecraft") && !ns.equals("ftbquests") || ns.equals(this.nsFilter);
            if (!nsok) continue;
            this.filtered.add(rl);
        }
        this.listScroll = 0;
    }

    private boolean validateResource(String value) {
        try {
            String v = value.trim();
            if (v.isEmpty() || v.startsWith("item:") || v.startsWith("tag:") || v.equals("builtin")) {
                return true;
            }
            String rlStr = IconPickerScreen.extractPath(v);
            class_2960 rl = new class_2960(rlStr);
            class_3300 rm = class_310.method_1551().method_1478();
            Optional opt = rm.method_14486(rl);
            if (opt.isPresent()) {
                return true;
            }
            if (!rl.method_12832().startsWith("textures/")) {
                rl = new class_2960(rl.method_12836(), "textures/" + rl.method_12832());
                return rm.method_14486(rl).isPresent();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String build() {
        String c;
        String p = this.pathBox.method_1882().trim();
        ArrayList<CallSite> mods = new ArrayList<CallSite>();
        String t = this.tileBox.method_1882().trim();
        if (!t.isEmpty()) {
            mods.add((CallSite)((Object)("tile_size=" + t)));
        }
        if (!(c = this.colorBox.method_1882().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("color=" + c)));
        }
        if (mods.isEmpty()) {
            return p;
        }
        StringBuilder sb = new StringBuilder(p);
        for (String string : mods) {
            sb.append("; ").append(string);
        }
        return sb.toString();
    }

    private static String extractPath(String s) {
        if (s == null) {
            return "";
        }
        int semi = s.indexOf(59);
        return semi < 0 ? s.trim() : s.substring(0, semi).trim();
    }

    private static String extractModifier(String s, String k) {
        if (s == null) {
            return "";
        }
        int idx = s.indexOf(k + "=");
        if (idx < 0) {
            return "";
        }
        String sub = s.substring(idx + k.length() + 1).trim();
        int semi = sub.indexOf(59);
        return (semi < 0 ? sub : sub.substring(0, semi)).trim();
    }

    public void method_25394(class_332 g, int mx, int my, float p) {
        this.method_25420(g);
        g.method_27535(this.field_22793, this.field_22785, 12, 12, -1);
        if (this.searchBox != null && this.method_25399() == this.searchBox) {
            String q = this.searchBox.method_1882().trim().toLowerCase();
            this.updateFiltered();
        }
        g.method_25294(this.browserX, this.browserY, this.browserX + this.browserW, this.browserY + this.browserH, -535818224);
        int lineH = 18;
        int visibleLines = Math.max(1, this.browserH / lineH);
        int maxScroll = Math.max(0, this.filtered.size() - visibleLines);
        this.listScroll = Math.max(0, Math.min(this.listScroll, maxScroll));
        g.method_44379(this.browserX, this.browserY, this.browserX + this.browserW, this.browserY + this.browserH);
        for (int i = 0; i < visibleLines && this.listScroll + i < this.filtered.size(); ++i) {
            class_2960 rl = this.filtered.get(this.listScroll + i);
            int y = this.browserY + i * lineH;
            boolean hover = mx >= this.browserX && mx <= this.browserX + this.browserW && my >= y && my < y + lineH;
            boolean selected = rl.equals((Object)this.selectedRL);
            if (selected) {
                g.method_25294(this.browserX, y, this.browserX + this.browserW, y + lineH, -12952966);
            } else if (hover) {
                g.method_25294(this.browserX, y, this.browserX + this.browserW, y + lineH, -14013910);
            }
            try {
                g.method_25290(rl, this.browserX + 2, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object txt = rl.toString();
            if (this.field_22793.method_1727((String)txt) > this.browserW - 24) {
                txt = ((String)txt).substring(0, Math.max(0, (this.browserW - 24) / 6)) + "...";
            }
            g.method_25303(this.field_22793, (String)txt, this.browserX + 22, y + 5, -1);
        }
        g.method_44380();
        g.method_25294(this.rightX, this.rightY, this.rightX + this.rightW, this.rightY + this.rightH, -535818224);
        g.method_25303(this.field_22793, "Preview:", this.rightX + 4, this.rightY + 4, -5592321);
        if (this.selectedRL != null) {
            int px = this.rightX + this.rightW / 2 - 32;
            int py = this.rightY + 24;
            try {
                g.method_25294(px - 2, py - 2, px + 66, py + 66, -12566464);
                g.method_25290(this.selectedRL, px, py, 0.0f, 0.0f, 64, 64, 64, 64);
            }
            catch (Throwable y) {
                // empty catch block
            }
        }
        int recentY = this.rightY + 100;
        g.method_25303(this.field_22793, "Recent:", this.rightX + 4, recentY, -5592321);
        List<String> rec = NewThemeEditorScreen.getRecentIconsSnapshot();
        int ry = recentY + 12;
        for (int i = 0; i < Math.min(5, rec.size()); ++i) {
            Object s = rec.get(i);
            if (this.field_22793.method_1727((String)s) > this.rightW - 8) {
                s = ((String)s).substring(0, Math.max(0, (this.rightW - 8) / 6)) + "...";
            }
            g.method_25303(this.field_22793, (String)s, this.rightX + 6, ry, -3355444);
            ry += 10;
        }
        super.method_25394(g, mx, my, p);
    }

    public boolean method_25402(double mx, double my, int btn) {
        int lineH;
        int row;
        int idx;
        if (mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW) && my >= (double)this.browserY && my <= (double)(this.browserY + this.browserH) && (idx = this.listScroll + (row = (int)((my - (double)this.browserY) / (double)(lineH = 18)))) >= 0 && idx < this.filtered.size()) {
            this.selectedRL = this.filtered.get(idx);
            this.pathBox.method_1852(this.selectedRL.method_12836() + ":" + this.selectedRL.method_12832());
            return true;
        }
        return super.method_25402(mx, my, btn);
    }

    public boolean method_25401(double mx, double my, double d) {
        if (mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW) && my >= (double)this.browserY && my <= (double)(this.browserY + this.browserH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(d) * 3.0);
            return true;
        }
        return super.method_25401(mx, my, d);
    }

    public boolean method_25421() {
        return false;
    }
}

