/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.texboobcat.questory.client.gui.TextFormatter;

public class MultilineTextEditorScreen
extends class_437 {
    private final class_437 parent;
    private final String initialText;
    private final Consumer<String> callback;
    private final List<String> lines = new ArrayList<String>();
    private int cursorLine = 0;
    private int cursorCol = 0;
    private int scroll = 0;
    private static final int MAX_LINES = 500;
    private static final int MAX_LINE_LENGTH = 200;
    private int selStartLine = -1;
    private int selStartCol = -1;
    private int selEndLine = -1;
    private int selEndCol = -1;
    private final Stack<String> undoStack = new Stack();
    private final Stack<String> redoStack = new Stack();
    private String lastSnapshot = "";
    private boolean isDragging = false;
    private boolean showFormatHelp = false;
    private boolean showAutocomplete = false;
    private List<String> autocompleteOptions = new ArrayList<String>();
    private int autocompleteSelectedIndex = 0;
    private String autocompletePrefix = "";
    private String textToWrap = null;
    private final List<String> recentTags = new ArrayList<String>();
    private static final int MAX_RECENT_TAGS = 10;
    private static final String[] ALL_TAGS = new String[]{"red", "blue", "green", "yellow", "gold", "aqua", "purple", "white", "gray", "black", "dark_red", "dark_blue", "dark_green", "dark_gray", "dark_aqua", "dark_purple", "bold", "italic", "underline", "strikethrough", "obfuscated", "link href=\"\"", "a href=\"\"", "reset"};
    private static final String[][] TEMPLATES = new String[][]{{"Objective", "## <gold><bold>Objective</bold></gold>\n<gray>Complete the following tasks:</gray>\n\n\u2022 <green>Task 1</green>\n\u2022 <green>Task 2</green>\n\u2022 <green>Task 3</green>"}, {"Warning", "<yellow><bold>\u26a0 Warning</bold></yellow>\n<red>This quest is dangerous!</red>"}, {"Reward", "<aqua><bold>\ud83c\udf81 Reward</bold></aqua>\n<gold>1000 Gold</gold>\n<green>Experience Points</green>"}, {"Lore", "<italic><gray>Long ago, in a distant land...</gray></italic>"}, {"Tips", "<blue><bold>\ud83d\udca1 Tip</bold></blue>\n<gray>Use the right tool for the job!</gray>"}, {"Requirements", "<red><bold>Requirements:</bold></red>\n<gray>\u2022 Level 10+</gray>\n<gray>\u2022 Iron Pickaxe</gray>"}, {"Story", "<dark_purple><italic>\"The ancient texts speak of...\"</italic></dark_purple>\n\n<gray>Your journey begins here.</gray>"}};
    private boolean showTemplates = false;
    private int selectedTemplateIndex = 0;
    private boolean showFindReplace = false;
    private String findText = "";
    private String replaceText = "";
    private int findResultLine = -1;
    private int findResultCol = -1;
    private boolean findFieldFocused = true;
    private boolean showLivePreview = false;
    private boolean showTagLibrary = false;
    private int tagLibraryScroll = 0;
    private boolean showColorPicker = false;
    private static final ColorInfo[] COMMON_COLORS = new ColorInfo[]{new ColorInfo(0, "Black"), new ColorInfo(0xFFFFFF, "White"), new ColorInfo(0xFF5555, "Red"), new ColorInfo(0x55FF55, "Green"), new ColorInfo(0x5555FF, "Blue"), new ColorInfo(0xFFFF55, "Yellow"), new ColorInfo(0xFF55FF, "Magenta"), new ColorInfo(0x55FFFF, "Cyan"), new ColorInfo(0xFFAA00, "Orange"), new ColorInfo(0xAA00AA, "Purple"), new ColorInfo(0x555555, "Gray"), new ColorInfo(0xAAAAAA, "Light Gray"), new ColorInfo(0xAA0000, "Dark Red"), new ColorInfo(43520, "Dark Green"), new ColorInfo(170, "Dark Blue"), new ColorInfo(0xAAAA00, "Dark Yellow")};
    private int selectedColorIndex = 0;

    public MultilineTextEditorScreen(class_437 parent, String text, Consumer<String> callback) {
        super((class_2561)class_2561.method_43470((String)"Edit Text"));
        this.parent = parent;
        this.initialText = text == null ? "" : text;
        this.callback = callback;
        if (!this.initialText.isEmpty()) {
            String[] split;
            for (String line : split = this.initialText.split("\n", -1)) {
                this.lines.add(line);
            }
        }
        if (this.lines.isEmpty()) {
            this.lines.add("");
        }
        this.takeSnapshot();
    }

    protected void method_25426() {
        super.method_25426();
        int btnY = this.field_22790 - 32;
        int centerX = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> {
            this.callback.accept(String.join((CharSequence)"\n", this.lines));
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX - 216, btnY, 45, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Preview"), b -> {
            this.showLivePreview = !this.showLivePreview;
        }).method_46434(centerX - 165, btnY, 55, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Templates"), b -> {
            this.showTemplates = !this.showTemplates;
            this.selectedTemplateIndex = 0;
        }).method_46434(centerX - 105, btnY, 65, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Colors"), b -> {
            this.showColorPicker = !this.showColorPicker;
            this.selectedColorIndex = 0;
        }).method_46434(centerX - 35, btnY, 50, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Help"), b -> {
            this.showTagLibrary = !this.showTagLibrary;
            this.showFormatHelp = false;
            if (this.showTagLibrary) {
                this.tagLibraryScroll = 0;
            }
        }).method_46434(centerX + 20, btnY, 40, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX + 65, btnY, 45, 20).method_46431());
    }

    private void takeSnapshot() {
        String current = String.join((CharSequence)"\n", this.lines);
        if (!current.equals(this.lastSnapshot)) {
            this.undoStack.push(this.lastSnapshot);
            this.lastSnapshot = current;
            this.redoStack.clear();
            if (this.undoStack.size() > 100) {
                this.undoStack.remove(0);
            }
        }
    }

    private void undo() {
        if (!this.undoStack.isEmpty()) {
            this.redoStack.push(this.lastSnapshot);
            this.lastSnapshot = this.undoStack.pop();
            this.restoreFromSnapshot(this.lastSnapshot);
        }
    }

    private void redo() {
        if (!this.redoStack.isEmpty()) {
            this.undoStack.push(this.lastSnapshot);
            this.lastSnapshot = this.redoStack.pop();
            this.restoreFromSnapshot(this.lastSnapshot);
        }
    }

    private void restoreFromSnapshot(String snapshot) {
        this.lines.clear();
        if (!snapshot.isEmpty()) {
            String[] split;
            for (String line : split = snapshot.split("\n", -1)) {
                this.lines.add(line);
            }
        }
        if (this.lines.isEmpty()) {
            this.lines.add("");
        }
        this.cursorLine = Math.min(this.cursorLine, this.lines.size() - 1);
        this.cursorCol = Math.min(this.cursorCol, this.lines.get(this.cursorLine).length());
        this.clearSelection();
    }

    private void clearSelection() {
        this.selEndCol = -1;
        this.selEndLine = -1;
        this.selStartCol = -1;
        this.selStartLine = -1;
    }

    private boolean hasSelection() {
        return this.selStartLine >= 0 && this.selEndLine >= 0;
    }

    private String getSelectedText() {
        int endC;
        if (!this.hasSelection()) {
            return "";
        }
        int startL = Math.min(this.selStartLine, this.selEndLine);
        int startC = this.selStartLine < this.selEndLine ? this.selStartCol : (this.selStartLine > this.selEndLine ? this.selEndCol : Math.min(this.selStartCol, this.selEndCol));
        int endL = Math.max(this.selStartLine, this.selEndLine);
        int n = this.selStartLine < this.selEndLine ? this.selEndCol : (endC = this.selStartLine > this.selEndLine ? this.selStartCol : Math.max(this.selStartCol, this.selEndCol));
        if (startL == endL) {
            return this.lines.get(startL).substring(startC, endC);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.lines.get(startL).substring(startC)).append("\n");
        for (int i = startL + 1; i < endL; ++i) {
            sb.append(this.lines.get(i)).append("\n");
        }
        sb.append(this.lines.get(endL).substring(0, endC));
        return sb.toString();
    }

    private void deleteSelection() {
        int endC;
        if (!this.hasSelection()) {
            return;
        }
        int startL = Math.min(this.selStartLine, this.selEndLine);
        int startC = this.selStartLine < this.selEndLine ? this.selStartCol : (this.selStartLine > this.selEndLine ? this.selEndCol : Math.min(this.selStartCol, this.selEndCol));
        int endL = Math.max(this.selStartLine, this.selEndLine);
        int n = this.selStartLine < this.selEndLine ? this.selEndCol : (endC = this.selStartLine > this.selEndLine ? this.selStartCol : Math.max(this.selStartCol, this.selEndCol));
        if (startL == endL) {
            String line = this.lines.get(startL);
            this.lines.set(startL, line.substring(0, startC) + line.substring(endC));
        } else {
            String firstPart = this.lines.get(startL).substring(0, startC);
            String lastPart = this.lines.get(endL).substring(endC);
            this.lines.set(startL, firstPart + lastPart);
            for (int i = endL; i > startL; --i) {
                this.lines.remove(i);
            }
        }
        this.cursorLine = startL;
        this.cursorCol = startC;
        this.clearSelection();
    }

    private void selectAll() {
        this.selStartLine = 0;
        this.selStartCol = 0;
        this.selEndLine = this.lines.size() - 1;
        this.selEndCol = this.lines.get(this.selEndLine).length();
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        super.method_25394(g, mouseX, mouseY, partialTick);
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, -1);
        g.method_25300(this.field_22793, "\u00a77Ctrl+B/I/U=Bold/Italic/Underline | Ctrl+F=Find | Ctrl+Shift+F=Format | Ctrl+[/]=Navigate", this.field_22789 / 2, 24, -7829368);
        int textX = 20;
        int textY = 44;
        int textW = this.showLivePreview ? this.field_22789 / 2 - 30 : this.field_22789 - 40;
        int textH = this.field_22790 - 88;
        g.method_25294(textX - 2, textY - 2, textX + textW + 2, textY + textH + 2, -16777216);
        g.method_25294(textX, textY, textX + textW, textY + textH, -15066598);
        g.method_44379(textX, textY, textX + textW, textY + textH);
        int lineHeight = 10;
        int startLine = this.scroll;
        int maxVisibleLines = textH / lineHeight;
        int endLine = Math.min(this.lines.size(), startLine + maxVisibleLines);
        for (int i = startLine; i < endLine; ++i) {
            int ly = textY + 4 + (i - startLine) * lineHeight;
            String line = this.lines.get(i);
            if (i == this.cursorLine && !this.hasSelection()) {
                g.method_25294(textX, ly - 1, textX + textW, ly + lineHeight - 1, 0x40FFFFFF);
            }
            String lineNum = String.format("%3d ", i + 1);
            g.method_25303(this.field_22793, lineNum, textX + 4, ly, -10066330);
            if (this.hasSelection()) {
                int endC;
                int startL = Math.min(this.selStartLine, this.selEndLine);
                int startC = this.selStartLine < this.selEndLine ? this.selStartCol : (this.selStartLine > this.selEndLine ? this.selEndCol : Math.min(this.selStartCol, this.selEndCol));
                int endL = Math.max(this.selStartLine, this.selEndLine);
                int n = this.selStartLine < this.selEndLine ? this.selEndCol : (endC = this.selStartLine > this.selEndLine ? this.selStartCol : Math.max(this.selStartCol, this.selEndCol));
                if (i >= startL && i <= endL) {
                    int selX1 = textX + 30;
                    int selX2 = textX + 30 + this.field_22793.method_1727(line);
                    if (i == startL && i == endL) {
                        selX1 += this.field_22793.method_1727(line.substring(0, Math.min(startC, line.length())));
                        selX2 = textX + 30 + this.field_22793.method_1727(line.substring(0, Math.min(endC, line.length())));
                    } else if (i == startL) {
                        selX1 += this.field_22793.method_1727(line.substring(0, Math.min(startC, line.length())));
                    } else if (i == endL) {
                        selX2 = textX + 30 + this.field_22793.method_1727(line.substring(0, Math.min(endC, line.length())));
                    }
                    g.method_25294(selX1, ly - 1, selX2, ly + lineHeight - 1, -2143659366);
                }
            }
            g.method_25303(this.field_22793, line, textX + 30, ly, -1);
            this.highlightTagErrors(g, line, i, textX + 30, ly, lineHeight);
            if (i != this.cursorLine || System.currentTimeMillis() / 500L % 2L != 0L) continue;
            int cursorX = textX + 30 + this.field_22793.method_1727(line.substring(0, Math.min(this.cursorCol, line.length())));
            g.method_25294(cursorX, ly - 1, cursorX + 1, ly + lineHeight - 2, -1);
        }
        g.method_44380();
        String info = String.format("Line %d/%d | Col %d | %d chars", this.cursorLine + 1, this.lines.size(), this.cursorCol + 1, String.join((CharSequence)"\n", this.lines).length());
        g.method_25303(this.field_22793, info, textX, textY + textH + 4, -5592406);
        if (this.showTagLibrary) {
            this.renderTagLibrary(g);
        }
        if (this.showFormatHelp) {
            this.renderFormatHelp(g);
        }
        if (this.showTemplates) {
            this.renderTemplates(g);
        }
        if (this.showColorPicker) {
            this.renderColorPicker(g);
        }
        if (this.showLivePreview) {
            this.renderLivePreview(g);
        }
        if (this.showFindReplace) {
            this.renderFindReplace(g, mouseX, mouseY);
        }
        if (this.showAutocomplete && !this.autocompleteOptions.isEmpty()) {
            this.renderAutocomplete(g);
        }
    }

    private void highlightTagErrors(class_332 g, String line, int lineNum, int x, int y, int lineHeight) {
        Stack<TagInfo> openTags = new Stack<TagInfo>();
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '<') {
                int closePos = line.indexOf(62, i);
                if (closePos > i) {
                    String tag = line.substring(i + 1, closePos);
                    boolean isClosing = tag.startsWith("/");
                    String fullTag = isClosing ? tag.substring(1) : tag;
                    String tagName = fullTag.split("\\s+")[0].split("=")[0];
                    if (!(tagName.equals("link") || tagName.equals("a") || tagName.equals("reset") || tagName.startsWith("#"))) {
                        if (isClosing) {
                            if (openTags.isEmpty() || !((TagInfo)openTags.peek()).name.equals(tagName)) {
                                int tagX = x + this.field_22793.method_1727(line.substring(0, i));
                                int tagW = this.field_22793.method_1727(line.substring(i, closePos + 1));
                                g.method_25294(tagX, y + lineHeight - 2, tagX + tagW, y + lineHeight - 1, -65536);
                            } else {
                                openTags.pop();
                            }
                        } else {
                            openTags.push(new TagInfo(tagName, i));
                        }
                    }
                    i = closePos + 1;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        for (TagInfo info : openTags) {
            int tagX = x + this.field_22793.method_1727(line.substring(0, info.pos));
            int tagW = this.field_22793.method_1727("<" + info.name + ">");
            g.method_25294(tagX, y + lineHeight - 2, tagX + tagW, y + lineHeight - 1, -22016);
        }
    }

    private void renderAutocomplete(class_332 g) {
        int cursorPixelX;
        int panelW = 200;
        int itemH = 14;
        int panelH = Math.min(this.autocompleteOptions.size() * itemH + 4, 144);
        int textX = 20;
        int textY = 44;
        int lineHeight = 10;
        String currentLine = this.cursorLine < this.lines.size() ? this.lines.get(this.cursorLine) : "";
        String textBeforeCursor = currentLine.substring(0, Math.min(this.cursorCol, currentLine.length()));
        int panelX = cursorPixelX = textX + 30 + this.field_22793.method_1727(textBeforeCursor);
        int panelY = textY + 4 + (this.cursorLine - this.scroll) * lineHeight + lineHeight;
        panelX = Math.max(10, Math.min(panelX, this.field_22789 - panelW - 10));
        panelY = Math.max(textY, Math.min(panelY, this.field_22790 - panelH - 60));
        g.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -268435456);
        g.method_25294(panelX, panelY, panelX + panelW, panelY + 1, -7829368);
        int y = panelY + 2;
        for (int i = 0; i < this.autocompleteOptions.size(); ++i) {
            boolean selected;
            String option = this.autocompleteOptions.get(i);
            boolean bl = selected = i == this.autocompleteSelectedIndex;
            if (selected) {
                g.method_25294(panelX + 2, y, panelX + panelW - 2, y + itemH, -12952966);
            }
            g.method_25303(this.field_22793, "<" + option + ">", panelX + 4, y + 3, selected ? -1 : -3355444);
            y += itemH;
        }
        g.method_25303(this.field_22793, "\u00a77Tab/Enter to complete", panelX + 4, panelY + panelH + 2, -7829368);
    }

    private void renderTagLibrary(class_332 g) {
        int panelW = 380;
        int panelH = this.field_22790 - 80;
        int panelX = this.field_22789 - panelW - 10;
        int panelY = 40;
        g.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -268435456);
        g.method_25294(panelX, panelY, panelX + panelW, panelY + 1, -7829368);
        g.method_25294(panelX, panelY + panelH - 1, panelX + panelW, panelY + panelH, -7829368);
        g.method_25303(this.field_22793, "\u00a77Scroll \u25b2\u25bc", panelX + panelW - 60, panelY + 6, -7829368);
        g.method_44379(panelX, panelY + 20, panelX + panelW, panelY + panelH);
        int y = panelY + 20 - this.tagLibraryScroll;
        int x = panelX + 8;
        g.method_25303(this.field_22793, "\u00a7l\u00a7eComplete Tag Library", x, y, -1);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Keyboard Shortcuts:", x, y += 16, -22016);
        g.method_25303(this.field_22793, "\u00a77Ctrl+B/I/U \u00a7f- Bold/Italic/Underline", x + 4, y += 12, -3355444);
        g.method_25303(this.field_22793, "\u00a77Ctrl+F \u00a7f- Find text", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77Ctrl+H \u00a7f- Find & Replace", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77Ctrl+Shift+F \u00a7f- Auto-format", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77Ctrl+Shift+M \u00a7f- Convert Markdown", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77Ctrl+[/] \u00a7f- Navigate tags", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Basic Colors:", x, y += 14, -22016);
        g.method_25303(this.field_22793, "\u00a7c<red> \u00a79<blue> \u00a7a<green> \u00a7e<yellow>", x + 4, y += 12, -3355444);
        g.method_25303(this.field_22793, "\u00a76<gold> \u00a7b<aqua> \u00a7d<purple> \u00a7f<white>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77<gray> \u00a78<dark_gray> \u00a70<black>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Dark Colors:", x, y += 14, -22016);
        g.method_25303(this.field_22793, "\u00a74<dark_red> \u00a71<dark_blue> \u00a72<dark_green>", x + 4, y += 12, -3355444);
        g.method_25303(this.field_22793, "\u00a73<dark_aqua> \u00a75<dark_purple>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Formatting:", x, y += 14, -22016);
        g.method_25303(this.field_22793, "\u00a7l<bold> \u00a7o<italic> \u00a7n<underline>", x + 4, y += 12, -3355444);
        g.method_25303(this.field_22793, "\u00a7m<strikethrough> \u00a7k<obfuscated>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77<reset> \u00a7f- Clears all formatting", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Hex Colors:", x, y += 14, -22016);
        g.method_25303(this.field_22793, "\u00a77<#FF5733>Custom color</#FF5733>", x + 4, y += 12, -3355444);
        g.method_25303(this.field_22793, "\u00a77Use Colors button for picker", x + 4, y += 10, -7829368);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Links:", x, y += 14, -22016);
        g.method_25303(this.field_22793, "\u00a79<link href=\"url\">text</link>", x + 4, y += 12, -3355444);
        g.method_25303(this.field_22793, "\u00a79<a href=\"url\">text</a>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77Opens in browser when clicked", x + 4, y += 10, -7829368);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Markdown (Ctrl+Shift+M):", x, y += 14, -22016);
        g.method_25303(this.field_22793, "\u00a77## Header \u00a7f\u2192 Bold gold header", x + 4, y += 12, -3355444);
        g.method_25303(this.field_22793, "\u00a77**text** \u00a7f\u2192 <bold>text</bold>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77*text* \u00a7f\u2192 <italic>text</italic>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77[text](url) \u00a7f\u2192 Link", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77- item \u00a7f\u2192 \u2022 Bullet point", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Examples:", x, y += 14, -22016);
        g.method_25303(this.field_22793, "\u00a77<red><bold>Important!</bold></red>", x + 4, y += 12, -3355444);
        g.method_25303(this.field_22793, "\u00a77<gold>Reward: <green>100 Gold</green></gold>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a77<italic><gray>Flavor text...</gray></italic>", x + 4, y += 10, -3355444);
        g.method_25303(this.field_22793, "\u00a7l\u00a76Pro Tips:", x, y += 14, -22016);
        g.method_25303(this.field_22793, "\u00a77\u2022 Use Templates for quick start", x + 4, y += 12, -7829368);
        g.method_25303(this.field_22793, "\u00a77\u2022 Nest tags for combinations", x + 4, y += 10, -7829368);
        g.method_25303(this.field_22793, "\u00a77\u2022 Recent tags appear first in autocomplete", x + 4, y += 10, -7829368);
        g.method_25303(this.field_22793, "\u00a77\u2022 Ctrl+Shift+F auto-indents tags", x + 4, y += 10, -7829368);
        g.method_25303(this.field_22793, "\u00a77\u2022 Red/orange underlines show errors", x + 4, y += 10, -7829368);
        g.method_25303(this.field_22793, "\u00a77\u2022 Preview button shows live formatting", x + 4, y += 10, -7829368);
        y += 10;
        g.method_44380();
    }

    private void renderFormatHelp(class_332 g) {
        this.renderTagLibrary(g);
    }

    private void renderTemplates(class_332 g) {
        int panelW = 350;
        int itemH = 16;
        int panelH = TEMPLATES.length * itemH + 40;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        g.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -268435456);
        g.method_25294(panelX, panelY, panelX + panelW, panelY + 1, -7829368);
        g.method_25294(panelX, panelY + panelH - 1, panelX + panelW, panelY + panelH, -7829368);
        int x = panelX + 8;
        int y = panelY + 8;
        g.method_25303(this.field_22793, "\u00a7l\u00a7eQuest Description Templates", x, y, -1);
        g.method_25303(this.field_22793, "\u00a77Select a template to insert", x, y += 16, -7829368);
        y += 16;
        for (int i = 0; i < TEMPLATES.length; ++i) {
            boolean selected = i == this.selectedTemplateIndex;
            String name = TEMPLATES[i][0];
            if (selected) {
                g.method_25294(panelX + 4, y - 2, panelX + panelW - 4, y + itemH - 2, -12952966);
            }
            g.method_25303(this.field_22793, i + 1 + ". " + name, x, y, selected ? -1 : -3355444);
            y += itemH;
        }
        g.method_25303(this.field_22793, "\u00a77Use number keys (1-" + TEMPLATES.length + ") or arrows + Enter", x, y += 8, -7829368);
    }

    private void insertTemplate(int index) {
        if (index < 0 || index >= TEMPLATES.length) {
            return;
        }
        String template = TEMPLATES[index][1];
        String[] templateLines = template.split("\n", -1);
        if (this.hasSelection()) {
            this.deleteSelection();
        }
        String currentLine = this.lines.get(this.cursorLine);
        String before = currentLine.substring(0, Math.min(this.cursorCol, currentLine.length()));
        String after = currentLine.substring(Math.min(this.cursorCol, currentLine.length()));
        if (templateLines.length == 1) {
            this.lines.set(this.cursorLine, before + templateLines[0] + after);
            this.cursorCol += templateLines[0].length();
        } else {
            this.lines.set(this.cursorLine, before + templateLines[0]);
            for (int i = 1; i < templateLines.length - 1; ++i) {
                this.lines.add(this.cursorLine + i, templateLines[i]);
            }
            this.lines.add(this.cursorLine + templateLines.length - 1, templateLines[templateLines.length - 1] + after);
            this.cursorLine += templateLines.length - 1;
            this.cursorCol = templateLines[templateLines.length - 1].length();
        }
        this.showTemplates = false;
        this.takeSnapshot();
        this.ensureCursorVisible();
    }

    private void renderColorPicker(class_332 g) {
        int panelW = 300;
        int swatchSize = 32;
        int cols = 4;
        int rows = (COMMON_COLORS.length + cols - 1) / cols;
        int panelH = rows * (swatchSize + 4) + 60;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        g.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -268435456);
        g.method_25294(panelX, panelY, panelX + panelW, panelY + 1, -7829368);
        g.method_25294(panelX, panelY + panelH - 1, panelX + panelW, panelY + panelH, -7829368);
        int x = panelX + 8;
        int y = panelY + 8;
        g.method_25303(this.field_22793, "\u00a7l\u00a7eColor Picker", x, y, -1);
        g.method_25303(this.field_22793, "\u00a77Select a color to insert hex tag", x, y += 16, -7829368);
        y += 20;
        for (int i = 0; i < COMMON_COLORS.length; ++i) {
            int row = i / cols;
            int col = i % cols;
            int sx = panelX + 16 + col * (swatchSize + 8);
            int sy = y + row * (swatchSize + 4);
            boolean selected = i == this.selectedColorIndex;
            int color = MultilineTextEditorScreen.COMMON_COLORS[i].color | 0xFF000000;
            if (selected) {
                g.method_25294(sx - 2, sy - 2, sx + swatchSize + 2, sy + swatchSize + 2, -1);
            }
            g.method_25294(sx, sy, sx + swatchSize, sy + swatchSize, color);
            g.method_25303(this.field_22793, String.valueOf(i + 1), sx + 2, sy + 2, -1);
        }
        g.method_25303(this.field_22793, "\u00a77Use number keys (1-" + COMMON_COLORS.length + ") or Enter", x, y += rows * (swatchSize + 4) + 8, -7829368);
    }

    private void insertHexColor(int colorIndex) {
        if (colorIndex < 0 || colorIndex >= COMMON_COLORS.length) {
            return;
        }
        int color = MultilineTextEditorScreen.COMMON_COLORS[colorIndex].color;
        String hexTag = String.format("<#%06X>", color);
        String closeTag = String.format("</#%06X>", color);
        String textToInsert = "";
        if (this.hasSelection()) {
            textToInsert = this.getSelectedText();
            this.deleteSelection();
        }
        String currentLine = this.lines.get(this.cursorLine);
        String before = currentLine.substring(0, Math.min(this.cursorCol, currentLine.length()));
        String after = currentLine.substring(Math.min(this.cursorCol, currentLine.length()));
        String insertion = hexTag + textToInsert + closeTag;
        this.lines.set(this.cursorLine, before + insertion + after);
        this.cursorCol += hexTag.length() + (textToInsert.isEmpty() ? 0 : textToInsert.length());
        this.showColorPicker = false;
        this.takeSnapshot();
    }

    private void renderFindReplace(class_332 g, int mouseX, int mouseY) {
        int btnX;
        int panelW = 300;
        int panelH = 110;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2 - 50;
        g.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -268435456);
        g.method_25294(panelX, panelY, panelX + panelW, panelY + 1, -7829368);
        g.method_25294(panelX, panelY + panelH - 1, panelX + panelW, panelY + panelH, -7829368);
        int x = panelX + 8;
        int y = panelY + 8;
        g.method_25303(this.field_22793, "\u00a7l\u00a7eFind & Replace", x, y, -1);
        g.method_25303(this.field_22793, "\u00a77Find:", x, y += 16, -3355444);
        int fieldX = x;
        int fieldY = y += 12;
        int fieldW = panelW - 100;
        boolean findFocused = this.findFieldFocused;
        g.method_25294(fieldX, fieldY, fieldX + fieldW, fieldY + 14, findFocused ? -14009782 : -15066598);
        g.method_25294(fieldX, fieldY, fieldX + fieldW, fieldY + 1, findFocused ? -10843446 : -7829368);
        g.method_25303(this.field_22793, this.findText.isEmpty() ? "\u00a78Type to find..." : this.findText, fieldX + 2, fieldY + 3, -1);
        if (findFocused && System.currentTimeMillis() / 500L % 2L == 0L) {
            int cursorX = fieldX + 2 + this.field_22793.method_1727(this.findText);
            g.method_25294(cursorX, fieldY + 2, cursorX + 1, fieldY + 12, -1);
        }
        boolean findHovered = mouseX >= (btnX = fieldX + fieldW + 4) && mouseX <= btnX + 90 && mouseY >= fieldY && mouseY <= fieldY + 14;
        g.method_25294(btnX, fieldY, btnX + 90, fieldY + 14, findHovered ? -11900278 : -14013910);
        g.method_25294(btnX, fieldY, btnX + 90, fieldY + 1, -7829368);
        g.method_25303(this.field_22793, "Find Next", btnX + 8, fieldY + 3, -1);
        g.method_25303(this.field_22793, "\u00a77Replace:", x, y += 18, -3355444);
        fieldY = y += 12;
        boolean replaceFocused = !this.findFieldFocused;
        g.method_25294(fieldX, fieldY, fieldX + fieldW, fieldY + 14, replaceFocused ? -14009782 : -15066598);
        g.method_25294(fieldX, fieldY, fieldX + fieldW, fieldY + 1, replaceFocused ? -10843446 : -7829368);
        g.method_25303(this.field_22793, this.replaceText.isEmpty() ? "\u00a78Replace with..." : this.replaceText, fieldX + 2, fieldY + 3, -1);
        if (replaceFocused && System.currentTimeMillis() / 500L % 2L == 0L) {
            int cursorX = fieldX + 2 + this.field_22793.method_1727(this.replaceText);
            g.method_25294(cursorX, fieldY + 2, cursorX + 1, fieldY + 12, -1);
        }
        boolean replaceHovered = mouseX >= (btnX = fieldX + fieldW + 4) && mouseX <= btnX + 40 && mouseY >= fieldY && mouseY <= fieldY + 14;
        g.method_25294(btnX, fieldY, btnX + 40, fieldY + 14, replaceHovered ? -11900278 : -14013910);
        g.method_25294(btnX, fieldY, btnX + 40, fieldY + 1, -7829368);
        g.method_25303(this.field_22793, "Replace", btnX + 2, fieldY + 3, -1);
        int btnX2 = btnX + 44;
        boolean replaceAllHovered = mouseX >= btnX2 && mouseX <= btnX2 + 46 && mouseY >= fieldY && mouseY <= fieldY + 14;
        g.method_25294(btnX2, fieldY, btnX2 + 46, fieldY + 14, replaceAllHovered ? -11900278 : -14013910);
        g.method_25294(btnX2, fieldY, btnX2 + 46, fieldY + 1, -7829368);
        g.method_25303(this.field_22793, "All", btnX2 + 12, fieldY + 3, -1);
        g.method_25303(this.field_22793, "\u00a77ESC=Close | Tab=Switch | Click fields/buttons", x, panelY + panelH - 12, -7829368);
    }

    private void renderLivePreview(class_332 g) {
        int previewX = this.field_22789 / 2 + 10;
        int previewY = 44;
        int previewW = this.field_22789 / 2 - 30;
        int previewH = this.field_22790 - 88;
        g.method_25294(previewX - 2, previewY - 2, previewX + previewW + 2, previewY + previewH + 2, -16777216);
        g.method_25294(previewX, previewY, previewX + previewW, previewY + previewH, -14013910);
        g.method_25303(this.field_22793, "\u00a7l\u00a7eLive Preview", previewX + 8, previewY + 8, -1);
        g.method_44379(previewX, previewY + 24, previewX + previewW, previewY + previewH);
        String fullText = String.join((CharSequence)"\n", this.lines);
        if (!fullText.isEmpty()) {
            try {
                class_2561 parsed = TextFormatter.parse(fullText);
                List previewLines = this.field_22793.method_1728((class_5348)parsed, previewW - 16);
                int totalLines = previewLines.size();
                int visibleLines = (previewH - 32) / 10;
                int estimatedPreviewLine = (int)((float)this.cursorLine / (float)this.lines.size() * (float)totalLines);
                int previewScroll = Math.max(0, Math.min(totalLines - visibleLines, estimatedPreviewLine - visibleLines / 2));
                int y = previewY + 28;
                for (int i = previewScroll; i < Math.min(previewLines.size(), previewScroll + visibleLines); ++i) {
                    g.method_35720(this.field_22793, (class_5481)previewLines.get(i), previewX + 8, y, -1);
                    y += 10;
                }
                if (totalLines > visibleLines) {
                    g.method_25303(this.field_22793, "\u00a77\u25b2\u25bc", previewX + previewW - 20, previewY + 8, -7829368);
                }
            }
            catch (Exception e) {
                g.method_25303(this.field_22793, "\u00a7cFormatting error", previewX + 8, previewY + 28, -43691);
            }
        } else {
            g.method_25303(this.field_22793, "\u00a77(Empty text)", previewX + 8, previewY + 28, -7829368);
        }
        g.method_44380();
    }

    public boolean method_25400(char c, int modifiers) {
        if (c < ' ' && c != '\n') {
            return false;
        }
        if (this.showFindReplace && c >= ' ') {
            if (this.findFieldFocused) {
                this.findText = this.findText + c;
            } else {
                this.replaceText = this.replaceText + c;
            }
            return true;
        }
        if (c == '<' && this.hasSelection()) {
            this.textToWrap = this.getSelectedText();
            this.deleteSelection();
            this.takeSnapshot();
        } else if (this.hasSelection()) {
            this.deleteSelection();
            this.takeSnapshot();
        }
        String line = this.lines.get(this.cursorLine);
        if (line.length() >= 200) {
            return false;
        }
        String before = line.substring(0, Math.min(this.cursorCol, line.length()));
        String after = line.substring(Math.min(this.cursorCol, line.length()));
        this.lines.set(this.cursorLine, before + c + after);
        ++this.cursorCol;
        if (c == '<') {
            this.showAutocomplete = true;
            this.autocompletePrefix = "";
            this.updateAutocompleteOptions();
            this.autocompleteSelectedIndex = 0;
        } else if (this.showAutocomplete) {
            this.updateAutocompletePrefix();
            if (this.autocompleteOptions.isEmpty()) {
                this.showAutocomplete = false;
                this.textToWrap = null;
            }
        }
        this.takeSnapshot();
        return true;
    }

    private void updateAutocompletePrefix() {
        int searchStart;
        String line = this.lines.get(this.cursorLine);
        int openBracket = line.lastIndexOf(60, searchStart = this.cursorCol - 1);
        if (openBracket >= 0 && openBracket < this.cursorCol) {
            this.autocompletePrefix = line.substring(openBracket + 1, this.cursorCol);
            this.updateAutocompleteOptions();
        } else {
            this.showAutocomplete = false;
        }
    }

    private void updateAutocompleteOptions() {
        this.autocompleteOptions.clear();
        String prefix = this.autocompletePrefix.toLowerCase();
        ArrayList<String> matchingRecent = new ArrayList<String>();
        for (String tag : this.recentTags) {
            if (!tag.toLowerCase().startsWith(prefix)) continue;
            matchingRecent.add(tag);
        }
        ArrayList<String> matchingOthers = new ArrayList<String>();
        for (String tag : ALL_TAGS) {
            if (!tag.toLowerCase().startsWith(prefix) || matchingRecent.contains(tag)) continue;
            matchingOthers.add(tag);
        }
        this.autocompleteOptions.addAll(matchingRecent);
        this.autocompleteOptions.addAll(matchingOthers);
        if (this.autocompleteOptions.size() > 10) {
            this.autocompleteOptions = this.autocompleteOptions.subList(0, 10);
        }
        if (this.autocompleteSelectedIndex >= this.autocompleteOptions.size()) {
            this.autocompleteSelectedIndex = Math.max(0, this.autocompleteOptions.size() - 1);
        }
    }

    private void completeAutocomplete() {
        if (!this.showAutocomplete || this.autocompleteOptions.isEmpty()) {
            return;
        }
        String selected = this.autocompleteOptions.get(this.autocompleteSelectedIndex);
        String line = this.lines.get(this.cursorLine);
        int openBracket = line.lastIndexOf(60, this.cursorCol - 1);
        if (openBracket >= 0) {
            boolean hasWrapText;
            String before = line.substring(0, openBracket);
            String after = line.substring(this.cursorCol);
            String content = this.textToWrap != null ? this.textToWrap : "";
            boolean bl = hasWrapText = this.textToWrap != null && !this.textToWrap.isEmpty();
            if (selected.startsWith("link href=") || selected.startsWith("a href=")) {
                String tagName = selected.split(" ")[0];
                String linkContent = hasWrapText ? this.textToWrap : "TEXT";
                this.lines.set(this.cursorLine, before + "<" + selected + ">" + linkContent + "</" + tagName + ">" + after);
                this.cursorCol = openBracket + selected.length() + 2;
            } else {
                this.lines.set(this.cursorLine, before + "<" + selected + ">" + content + "</" + selected + ">" + after);
                this.cursorCol = openBracket + selected.length() + 2 + (hasWrapText ? content.length() : 0);
            }
            this.showAutocomplete = false;
            this.textToWrap = null;
            this.addRecentTag(selected);
            this.takeSnapshot();
        }
    }

    private void addRecentTag(String tag) {
        this.recentTags.remove(tag);
        this.recentTags.add(0, tag);
        if (this.recentTags.size() > 10) {
            this.recentTags.remove(10);
        }
    }

    private void autoFormatDocument() {
        ArrayList<String> formattedLines = new ArrayList<String>();
        int indentLevel = 0;
        String indent = "  ";
        for (String line : this.lines) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) {
                formattedLines.add("");
                continue;
            }
            if (trimmed.startsWith("</")) {
                indentLevel = Math.max(0, indentLevel - 1);
            }
            StringBuilder indentedLine = new StringBuilder();
            for (int i = 0; i < indentLevel; ++i) {
                indentedLine.append(indent);
            }
            indentedLine.append(trimmed);
            formattedLines.add(indentedLine.toString());
            int opens = this.countOccurrences(trimmed, "<", "</", "<#", "<reset>");
            int closes = this.countOccurrences(trimmed, "</");
            indentLevel = Math.max(0, indentLevel + opens - closes);
        }
        this.lines.clear();
        this.lines.addAll(formattedLines);
        this.cursorLine = Math.min(this.cursorLine, this.lines.size() - 1);
        this.cursorCol = Math.min(this.cursorCol, this.lines.get(this.cursorLine).length());
        this.takeSnapshot();
    }

    private int countOccurrences(String text, String ... patterns) {
        int count = 0;
        for (String pattern : patterns) {
            int index = 0;
            while ((index = text.indexOf(pattern, index)) != -1) {
                if (pattern.equals("<") && (text.indexOf("<#", index) == index || text.indexOf("<reset>", index) == index)) {
                    ++index;
                    continue;
                }
                ++count;
                index += pattern.length();
            }
        }
        return count;
    }

    private void findNext(String searchText) {
        int col;
        String line;
        int i;
        if (searchText.isEmpty()) {
            return;
        }
        int startLine = this.cursorLine;
        int startCol = this.cursorCol + 1;
        for (i = startLine; i < this.lines.size(); ++i) {
            line = this.lines.get(i);
            int found = line.indexOf(searchText, col = i == startLine ? startCol : 0);
            if (found < 0) continue;
            this.cursorLine = i;
            this.cursorCol = found;
            this.findResultLine = i;
            this.findResultCol = found;
            this.selStartLine = i;
            this.selStartCol = found;
            this.selEndLine = i;
            this.selEndCol = found + searchText.length();
            this.ensureCursorVisible();
            return;
        }
        for (i = 0; i <= startLine; ++i) {
            line = this.lines.get(i);
            col = i == startLine ? 0 : 0;
            int maxCol = i == startLine ? startCol - 1 : line.length();
            int found = line.indexOf(searchText, col);
            if (found < 0 || found >= maxCol) continue;
            this.cursorLine = i;
            this.cursorCol = found;
            this.findResultLine = i;
            this.findResultCol = found;
            this.selStartLine = i;
            this.selStartCol = found;
            this.selEndLine = i;
            this.selEndCol = found + searchText.length();
            this.ensureCursorVisible();
            return;
        }
    }

    private void replaceSelection(String replacement) {
        if (this.hasSelection() && this.findResultLine >= 0) {
            this.deleteSelection();
            String line = this.lines.get(this.cursorLine);
            String before = line.substring(0, Math.min(this.cursorCol, line.length()));
            String after = line.substring(Math.min(this.cursorCol, line.length()));
            this.lines.set(this.cursorLine, before + replacement + after);
            this.cursorCol += replacement.length();
            this.clearSelection();
            this.findResultLine = -1;
            this.takeSnapshot();
        }
    }

    private void replaceAll(String searchText, String replacement) {
        if (searchText.isEmpty()) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            String newLine = line.replace(searchText, replacement);
            if (newLine.equals(line)) continue;
            this.lines.set(i, newLine);
            ++count;
        }
        if (count > 0) {
            this.takeSnapshot();
        }
    }

    private void convertMarkdownToTags() {
        ArrayList<Object> convertedLines = new ArrayList<Object>();
        for (String line : this.lines) {
            Object converted = line;
            if (((String)converted).startsWith("## ")) {
                converted = "<gold><bold>" + ((String)converted).substring(3) + "</bold></gold>";
            } else if (((String)converted).startsWith("# ")) {
                converted = "<yellow><bold>" + ((String)converted).substring(2) + "</bold></yellow>";
            }
            converted = ((String)converted).replaceAll("\\*\\*(.+?)\\*\\*", "<bold>$1</bold>");
            converted = ((String)converted).replaceAll("(?<!\\*)\\*([^*]+?)\\*(?!\\*)", "<italic>$1</italic>");
            converted = ((String)converted).replaceAll("~~(.+?)~~", "<strikethrough>$1</strikethrough>");
            converted = ((String)converted).replaceAll("\\[(.+?)\\]\\((.+?)\\)", "<link href=\"$2\">$1</link>");
            if (((String)converted).trim().startsWith("- ")) {
                converted = "\u2022 <gray>" + ((String)converted).trim().substring(2) + "</gray>";
            }
            convertedLines.add(converted);
        }
        this.lines.clear();
        this.lines.addAll(convertedLines);
        this.cursorLine = Math.min(this.cursorLine, this.lines.size() - 1);
        this.cursorCol = Math.min(this.cursorCol, this.lines.get(this.cursorLine).length());
        this.takeSnapshot();
    }

    private void jumpToMatchingTag(boolean findOpening) {
        boolean searchBackward;
        String tagName;
        String currentLine = this.lines.get(this.cursorLine);
        int tagStart = currentLine.lastIndexOf(60, this.cursorCol);
        if (tagStart == -1 && (tagStart = currentLine.indexOf(60, this.cursorCol)) == -1) {
            return;
        }
        int tagEnd = currentLine.indexOf(62, tagStart);
        if (tagEnd == -1) {
            return;
        }
        String tag = currentLine.substring(tagStart + 1, tagEnd);
        boolean isClosing = tag.startsWith("/");
        String string = tagName = isClosing ? tag.substring(1) : tag;
        if (tagName.equals("reset") || tagName.startsWith("#") || tagName.startsWith("link") || tagName.startsWith("a href")) {
            return;
        }
        boolean bl = searchBackward = isClosing && findOpening || !isClosing && !findOpening;
        if (searchBackward) {
            Stack<String> stack = new Stack<String>();
            stack.push(tagName);
            int col = tagStart - 1;
            int line = this.cursorLine;
            while (line >= 0 && !stack.isEmpty()) {
                String searchLine = this.lines.get(line);
                while (col >= 0) {
                    if (searchLine.charAt(col) == '>') {
                        int openPos = searchLine.lastIndexOf(60, col);
                        if (openPos >= 0) {
                            String foundName;
                            String foundTag = searchLine.substring(openPos + 1, col);
                            boolean foundIsClosing = foundTag.startsWith("/");
                            String string2 = foundName = foundIsClosing ? foundTag.substring(1) : foundTag;
                            if (foundName.equals(tagName)) {
                                if (foundIsClosing) {
                                    stack.push(foundName);
                                } else {
                                    stack.pop();
                                    if (stack.isEmpty()) {
                                        this.cursorLine = line;
                                        this.cursorCol = openPos;
                                        this.ensureCursorVisible();
                                        return;
                                    }
                                }
                            }
                            col = openPos - 1;
                            continue;
                        }
                        --col;
                        continue;
                    }
                    --col;
                }
                if (--line < 0) continue;
                col = this.lines.get(line).length() - 1;
            }
        } else {
            Stack<String> stack = new Stack<String>();
            stack.push(tagName);
            int col = tagEnd + 1;
            for (int line = this.cursorLine; line < this.lines.size() && !stack.isEmpty(); ++line) {
                String searchLine = this.lines.get(line);
                while (col < searchLine.length()) {
                    if (searchLine.charAt(col) == '<') {
                        int closePos = searchLine.indexOf(62, col);
                        if (closePos > col) {
                            String foundName;
                            String foundTag = searchLine.substring(col + 1, closePos);
                            boolean foundIsClosing = foundTag.startsWith("/");
                            String string3 = foundName = foundIsClosing ? foundTag.substring(1) : foundTag;
                            if (foundName.equals(tagName)) {
                                if (foundIsClosing) {
                                    stack.pop();
                                    if (stack.isEmpty()) {
                                        this.cursorLine = line;
                                        this.cursorCol = col;
                                        this.ensureCursorVisible();
                                        return;
                                    }
                                } else {
                                    stack.push(foundName);
                                }
                            }
                            col = closePos + 1;
                            continue;
                        }
                        ++col;
                        continue;
                    }
                    ++col;
                }
                col = 0;
            }
        }
    }

    private void wrapSelectionInTag(String tagName) {
        if (this.hasSelection()) {
            String selectedText = this.getSelectedText();
            this.deleteSelection();
            String line = this.lines.get(this.cursorLine);
            String before = line.substring(0, Math.min(this.cursorCol, line.length()));
            String after = line.substring(Math.min(this.cursorCol, line.length()));
            String wrapped = "<" + tagName + ">" + selectedText + "</" + tagName + ">";
            this.lines.set(this.cursorLine, before + wrapped + after);
            this.cursorCol += tagName.length() + 2;
        } else {
            String line = this.lines.get(this.cursorLine);
            String before = line.substring(0, Math.min(this.cursorCol, line.length()));
            String after = line.substring(Math.min(this.cursorCol, line.length()));
            String tags = "<" + tagName + "></" + tagName + ">";
            this.lines.set(this.cursorLine, before + tags + after);
            this.cursorCol += tagName.length() + 2;
        }
        this.addRecentTag(tagName);
        this.clearSelection();
        this.takeSnapshot();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        int jump;
        int index;
        boolean shift;
        boolean ctrl = (modifiers & 2) != 0;
        boolean bl = shift = (modifiers & 1) != 0;
        if (this.showFindReplace) {
            if (keyCode == 256) {
                this.showFindReplace = false;
                return true;
            }
            if (keyCode == 258) {
                this.findFieldFocused = !this.findFieldFocused;
                return true;
            }
            if (keyCode == 259) {
                if (this.findFieldFocused && !this.findText.isEmpty()) {
                    this.findText = this.findText.substring(0, this.findText.length() - 1);
                } else if (!this.findFieldFocused && !this.replaceText.isEmpty()) {
                    this.replaceText = this.replaceText.substring(0, this.replaceText.length() - 1);
                }
                return true;
            }
            if (keyCode == 257) {
                this.findNext(this.findText);
                return true;
            }
        }
        if (this.showTemplates) {
            if (keyCode == 256) {
                this.showTemplates = false;
                return true;
            }
            if (keyCode == 265) {
                this.selectedTemplateIndex = Math.max(0, this.selectedTemplateIndex - 1);
                return true;
            }
            if (keyCode == 264) {
                this.selectedTemplateIndex = Math.min(TEMPLATES.length - 1, this.selectedTemplateIndex + 1);
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.insertTemplate(this.selectedTemplateIndex);
                return true;
            }
            if (keyCode >= 49 && keyCode <= 57 && (index = keyCode - 49) < TEMPLATES.length) {
                this.insertTemplate(index);
                return true;
            }
        }
        if (this.showColorPicker) {
            if (keyCode == 256) {
                this.showColorPicker = false;
                return true;
            }
            if (keyCode == 263) {
                this.selectedColorIndex = Math.max(0, this.selectedColorIndex - 1);
                return true;
            }
            if (keyCode == 262) {
                this.selectedColorIndex = Math.min(COMMON_COLORS.length - 1, this.selectedColorIndex + 1);
                return true;
            }
            if (keyCode == 265) {
                this.selectedColorIndex = Math.max(0, this.selectedColorIndex - 4);
                return true;
            }
            if (keyCode == 264) {
                this.selectedColorIndex = Math.min(COMMON_COLORS.length - 1, this.selectedColorIndex + 4);
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.insertHexColor(this.selectedColorIndex);
                return true;
            }
            if (keyCode >= 49 && keyCode <= 57) {
                index = keyCode - 49;
                if (index < COMMON_COLORS.length) {
                    this.insertHexColor(index);
                    return true;
                }
            } else if (keyCode == 48 && (index = 9) < COMMON_COLORS.length) {
                this.insertHexColor(index);
                return true;
            }
        }
        if (this.showAutocomplete && !this.autocompleteOptions.isEmpty()) {
            if (keyCode == 265) {
                this.autocompleteSelectedIndex = Math.max(0, this.autocompleteSelectedIndex - 1);
                return true;
            }
            if (keyCode == 264) {
                this.autocompleteSelectedIndex = Math.min(this.autocompleteOptions.size() - 1, this.autocompleteSelectedIndex + 1);
                return true;
            }
            if (keyCode == 258 || keyCode == 257) {
                this.completeAutocomplete();
                return true;
            }
            if (keyCode == 256) {
                this.showAutocomplete = false;
                this.textToWrap = null;
                return true;
            }
        }
        if (ctrl && !shift && keyCode == 66) {
            this.wrapSelectionInTag("bold");
            return true;
        }
        if (ctrl && !shift && keyCode == 73) {
            this.wrapSelectionInTag("italic");
            return true;
        }
        if (ctrl && !shift && keyCode == 85) {
            this.wrapSelectionInTag("underline");
            return true;
        }
        if (ctrl && shift && keyCode == 70) {
            this.autoFormatDocument();
            return true;
        }
        if (ctrl && shift && keyCode == 77) {
            this.convertMarkdownToTags();
            return true;
        }
        if (ctrl && !shift && keyCode == 70) {
            boolean bl2 = this.showFindReplace = !this.showFindReplace;
            if (this.showFindReplace) {
                this.findFieldFocused = true;
                if (this.hasSelection()) {
                    this.findText = this.getSelectedText();
                }
            }
            return true;
        }
        if (ctrl && keyCode == 72) {
            this.showFindReplace = true;
            this.findFieldFocused = true;
            if (this.hasSelection()) {
                this.findText = this.getSelectedText();
            }
            return true;
        }
        if (ctrl && keyCode == 91) {
            this.jumpToMatchingTag(true);
            return true;
        }
        if (ctrl && keyCode == 93) {
            this.jumpToMatchingTag(false);
            return true;
        }
        if (ctrl && keyCode == 65) {
            this.selectAll();
            return true;
        }
        if (ctrl && keyCode == 67) {
            if (this.hasSelection()) {
                this.field_22787.field_1774.method_1455(this.getSelectedText());
            }
            return true;
        }
        if (ctrl && keyCode == 88) {
            if (this.hasSelection()) {
                this.field_22787.field_1774.method_1455(this.getSelectedText());
                this.deleteSelection();
                this.takeSnapshot();
            }
            return true;
        }
        if (ctrl && keyCode == 86) {
            String clipboard = this.field_22787.field_1774.method_1460();
            if (clipboard != null && !clipboard.isEmpty()) {
                if (this.hasSelection()) {
                    this.deleteSelection();
                }
                clipboard = MultilineTextEditorScreen.convertFormattingCodes(clipboard);
                String[] pasteLines = clipboard.split("\n", -1);
                String currentLine = this.lines.get(this.cursorLine);
                String before = currentLine.substring(0, Math.min(this.cursorCol, currentLine.length()));
                String after = currentLine.substring(Math.min(this.cursorCol, currentLine.length()));
                if (pasteLines.length == 1) {
                    this.lines.set(this.cursorLine, before + pasteLines[0] + after);
                    this.cursorCol += pasteLines[0].length();
                } else {
                    this.lines.set(this.cursorLine, before + pasteLines[0]);
                    for (int i = 1; i < pasteLines.length - 1; ++i) {
                        this.lines.add(this.cursorLine + i, pasteLines[i]);
                    }
                    this.lines.add(this.cursorLine + pasteLines.length - 1, pasteLines[pasteLines.length - 1] + after);
                    this.cursorLine += pasteLines.length - 1;
                    this.cursorCol = pasteLines[pasteLines.length - 1].length();
                }
                this.takeSnapshot();
                this.ensureCursorVisible();
            }
            return true;
        }
        if (ctrl && keyCode == 90) {
            this.undo();
            return true;
        }
        if (ctrl && (keyCode == 89 || shift && keyCode == 90)) {
            this.redo();
            return true;
        }
        if (keyCode == 257) {
            if (this.hasSelection()) {
                this.deleteSelection();
            }
            if (this.lines.size() >= 500) {
                return false;
            }
            String line = this.lines.get(this.cursorLine);
            String before = line.substring(0, Math.min(this.cursorCol, line.length()));
            String after = line.substring(Math.min(this.cursorCol, line.length()));
            this.lines.set(this.cursorLine, before);
            this.lines.add(this.cursorLine + 1, after);
            ++this.cursorLine;
            this.cursorCol = 0;
            this.clearSelection();
            this.showAutocomplete = false;
            this.textToWrap = null;
            this.takeSnapshot();
            this.ensureCursorVisible();
            return true;
        }
        if (keyCode == 259) {
            if (this.hasSelection()) {
                this.deleteSelection();
                this.takeSnapshot();
            } else if (this.cursorCol > 0) {
                String line = this.lines.get(this.cursorLine);
                String before = line.substring(0, this.cursorCol - 1);
                String after = line.substring(Math.min(this.cursorCol, line.length()));
                this.lines.set(this.cursorLine, before + after);
                --this.cursorCol;
                if (this.showAutocomplete) {
                    this.updateAutocompletePrefix();
                    if (this.autocompleteOptions.isEmpty()) {
                        this.showAutocomplete = false;
                        this.textToWrap = null;
                    }
                }
                this.takeSnapshot();
            } else if (this.cursorLine > 0) {
                String currentLine = this.lines.get(this.cursorLine);
                this.lines.remove(this.cursorLine);
                --this.cursorLine;
                String prevLine = this.lines.get(this.cursorLine);
                this.cursorCol = prevLine.length();
                this.lines.set(this.cursorLine, prevLine + currentLine);
                this.showAutocomplete = false;
                this.textToWrap = null;
                this.takeSnapshot();
                this.ensureCursorVisible();
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.hasSelection()) {
                this.deleteSelection();
                this.takeSnapshot();
            } else {
                String line = this.lines.get(this.cursorLine);
                if (this.cursorCol < line.length()) {
                    String before = line.substring(0, this.cursorCol);
                    String after = line.substring(Math.min(this.cursorCol + 1, line.length()));
                    this.lines.set(this.cursorLine, before + after);
                    if (this.showAutocomplete) {
                        this.updateAutocompletePrefix();
                        if (this.autocompleteOptions.isEmpty()) {
                            this.showAutocomplete = false;
                            this.textToWrap = null;
                        }
                    }
                    this.takeSnapshot();
                } else if (this.cursorLine < this.lines.size() - 1) {
                    String nextLine = this.lines.get(this.cursorLine + 1);
                    this.lines.remove(this.cursorLine + 1);
                    this.lines.set(this.cursorLine, line + nextLine);
                    this.showAutocomplete = false;
                    this.textToWrap = null;
                    this.takeSnapshot();
                }
            }
            return true;
        }
        if (keyCode == 265) {
            if (shift && !this.hasSelection()) {
                this.selStartLine = this.cursorLine;
                this.selStartCol = this.cursorCol;
            }
            if (this.cursorLine > 0) {
                --this.cursorLine;
                this.cursorCol = Math.min(this.cursorCol, this.lines.get(this.cursorLine).length());
                this.ensureCursorVisible();
            }
            if (shift) {
                this.selEndLine = this.cursorLine;
                this.selEndCol = this.cursorCol;
            } else {
                this.clearSelection();
            }
            return true;
        }
        if (keyCode == 264) {
            if (shift && !this.hasSelection()) {
                this.selStartLine = this.cursorLine;
                this.selStartCol = this.cursorCol;
            }
            if (this.cursorLine < this.lines.size() - 1) {
                ++this.cursorLine;
                this.cursorCol = Math.min(this.cursorCol, this.lines.get(this.cursorLine).length());
                this.ensureCursorVisible();
            }
            if (shift) {
                this.selEndLine = this.cursorLine;
                this.selEndCol = this.cursorCol;
            } else {
                this.clearSelection();
            }
            return true;
        }
        if (keyCode == 263) {
            if (!this.showAutocomplete || this.autocompleteOptions.isEmpty()) {
                this.showAutocomplete = false;
                this.textToWrap = null;
            }
            if (shift && !this.hasSelection()) {
                this.selStartLine = this.cursorLine;
                this.selStartCol = this.cursorCol;
            }
            if (this.cursorCol > 0) {
                --this.cursorCol;
                if (this.showAutocomplete) {
                    this.updateAutocompletePrefix();
                    if (this.autocompleteOptions.isEmpty()) {
                        this.showAutocomplete = false;
                        this.textToWrap = null;
                    }
                }
            } else if (this.cursorLine > 0) {
                --this.cursorLine;
                this.cursorCol = this.lines.get(this.cursorLine).length();
                this.showAutocomplete = false;
                this.textToWrap = null;
                this.ensureCursorVisible();
            }
            if (shift) {
                this.selEndLine = this.cursorLine;
                this.selEndCol = this.cursorCol;
            } else {
                this.clearSelection();
            }
            return true;
        }
        if (keyCode == 262) {
            String line;
            if (!this.showAutocomplete || this.autocompleteOptions.isEmpty()) {
                this.showAutocomplete = false;
                this.textToWrap = null;
            }
            if (shift && !this.hasSelection()) {
                this.selStartLine = this.cursorLine;
                this.selStartCol = this.cursorCol;
            }
            if (this.cursorCol < (line = this.lines.get(this.cursorLine)).length()) {
                ++this.cursorCol;
                if (this.showAutocomplete) {
                    this.updateAutocompletePrefix();
                    if (this.autocompleteOptions.isEmpty()) {
                        this.showAutocomplete = false;
                        this.textToWrap = null;
                    }
                }
            } else if (this.cursorLine < this.lines.size() - 1) {
                ++this.cursorLine;
                this.cursorCol = 0;
                this.showAutocomplete = false;
                this.textToWrap = null;
                this.ensureCursorVisible();
            }
            if (shift) {
                this.selEndLine = this.cursorLine;
                this.selEndCol = this.cursorCol;
            } else {
                this.clearSelection();
            }
            return true;
        }
        if (keyCode == 268) {
            if (shift && !this.hasSelection()) {
                this.selStartLine = this.cursorLine;
                this.selStartCol = this.cursorCol;
            }
            this.cursorCol = 0;
            if (shift) {
                this.selEndLine = this.cursorLine;
                this.selEndCol = this.cursorCol;
            } else {
                this.clearSelection();
            }
            return true;
        }
        if (keyCode == 269) {
            if (shift && !this.hasSelection()) {
                this.selStartLine = this.cursorLine;
                this.selStartCol = this.cursorCol;
            }
            this.cursorCol = this.lines.get(this.cursorLine).length();
            if (shift) {
                this.selEndLine = this.cursorLine;
                this.selEndCol = this.cursorCol;
            } else {
                this.clearSelection();
            }
            return true;
        }
        if (keyCode == 266) {
            jump = Math.max(1, 20);
            this.cursorLine = Math.max(0, this.cursorLine - jump);
            this.cursorCol = Math.min(this.cursorCol, this.lines.get(this.cursorLine).length());
            this.clearSelection();
            this.ensureCursorVisible();
            return true;
        }
        if (keyCode == 267) {
            jump = Math.max(1, 20);
            this.cursorLine = Math.min(this.lines.size() - 1, this.cursorLine + jump);
            this.cursorCol = Math.min(this.cursorCol, this.lines.get(this.cursorLine).length());
            this.clearSelection();
            this.ensureCursorVisible();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int lineHeight;
        int clickedLine;
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.showFindReplace) {
            int panelW = 300;
            int panelH = 110;
            int panelX = this.field_22789 / 2 - panelW / 2;
            int panelY = this.field_22790 / 2 - panelH / 2 - 50;
            int fieldX = panelX + 8;
            int fieldW = panelW - 100;
            int findFieldY = panelY + 36;
            if (mouseX >= (double)fieldX && mouseX <= (double)(fieldX + fieldW) && mouseY >= (double)findFieldY && mouseY <= (double)(findFieldY + 14)) {
                this.findFieldFocused = true;
                return true;
            }
            int replaceFieldY = panelY + 72;
            if (mouseX >= (double)fieldX && mouseX <= (double)(fieldX + fieldW) && mouseY >= (double)replaceFieldY && mouseY <= (double)(replaceFieldY + 14)) {
                this.findFieldFocused = false;
                return true;
            }
            int findBtnX = fieldX + fieldW + 4;
            if (mouseX >= (double)findBtnX && mouseX <= (double)(findBtnX + 90) && mouseY >= (double)findFieldY && mouseY <= (double)(findFieldY + 14)) {
                if (!this.findText.isEmpty()) {
                    this.findNext(this.findText);
                }
                return true;
            }
            int replaceBtnX = fieldX + fieldW + 4;
            if (mouseX >= (double)replaceBtnX && mouseX <= (double)(replaceBtnX + 40) && mouseY >= (double)replaceFieldY && mouseY <= (double)(replaceFieldY + 14)) {
                if (!this.findText.isEmpty()) {
                    this.replaceSelection(this.replaceText);
                }
                return true;
            }
            int replaceAllBtnX = replaceBtnX + 44;
            if (mouseX >= (double)replaceAllBtnX && mouseX <= (double)(replaceAllBtnX + 46) && mouseY >= (double)replaceFieldY && mouseY <= (double)(replaceFieldY + 14)) {
                if (!this.findText.isEmpty()) {
                    this.replaceAll(this.findText, this.replaceText);
                    this.showFindReplace = false;
                }
                return true;
            }
            if (mouseX < (double)panelX || mouseX > (double)(panelX + panelW) || mouseY < (double)panelY || mouseY > (double)(panelY + panelH)) {
                return true;
            }
        }
        int textX = 20;
        int textY = 44;
        int textW = this.field_22789 - 40;
        int textH = this.field_22790 - 88;
        if (mouseX >= (double)(textX + 30) && mouseX <= (double)(textX + textW) && mouseY >= (double)textY && mouseY < (double)(textY + textH) && (clickedLine = this.scroll + ((int)mouseY - textY - 4) / (lineHeight = 10)) >= 0 && clickedLine < this.lines.size()) {
            String line = this.lines.get(clickedLine);
            int clickedCol = 0;
            int i = 0;
            while (i <= line.length()) {
                int charX = textX + 30 + this.field_22793.method_1727(line.substring(0, i));
                if (mouseX < (double)charX) {
                    clickedCol = Math.max(0, i - 1);
                    break;
                }
                clickedCol = i++;
            }
            this.cursorLine = clickedLine;
            this.cursorCol = clickedCol;
            this.isDragging = true;
            this.clearSelection();
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            int textX = 20;
            int textY = 44;
            int textW = this.field_22789 - 40;
            int textH = this.field_22790 - 88;
            if (!this.hasSelection()) {
                this.selStartLine = this.cursorLine;
                this.selStartCol = this.cursorCol;
            }
            int lineHeight = 10;
            int clickedLine = this.scroll + ((int)mouseY - textY - 4) / lineHeight;
            clickedLine = Math.max(0, Math.min(this.lines.size() - 1, clickedLine));
            String line = this.lines.get(clickedLine);
            int clickedCol = 0;
            int i = 0;
            while (i <= line.length()) {
                int charX = textX + 30 + this.field_22793.method_1727(line.substring(0, i));
                if (mouseX < (double)charX) {
                    clickedCol = Math.max(0, i - 1);
                    break;
                }
                clickedCol = i++;
            }
            this.cursorLine = clickedLine;
            this.cursorCol = clickedCol;
            this.selEndLine = this.cursorLine;
            this.selEndCol = this.cursorCol;
            this.ensureCursorVisible();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.showTagLibrary) {
            int panelW = 380;
            int panelX = this.field_22789 - panelW - 10;
            int panelY = 40;
            int panelH = this.field_22790 - 80;
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
                int maxScroll = Math.max(0, 600 - panelH);
                this.tagLibraryScroll = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.tagLibraryScroll - delta * 20.0));
                return true;
            }
        }
        this.scroll = (int)Math.max(0.0, Math.min((double)Math.max(0, this.lines.size() - 10), (double)this.scroll - Math.signum(delta)));
        return true;
    }

    private void ensureCursorVisible() {
        int lineHeight = 10;
        int textH = this.field_22790 - 88;
        int maxVisibleLines = textH / lineHeight;
        if (this.cursorLine < this.scroll) {
            this.scroll = this.cursorLine;
        } else if (this.cursorLine >= this.scroll + maxVisibleLines) {
            this.scroll = this.cursorLine - maxVisibleLines + 1;
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static String convertFormattingCodes(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replace('\u00a7', '&');
        StringBuilder result = new StringBuilder();
        Stack<String> openTags = new Stack<String>();
        int i = 0;
        while (i < text.length()) {
            char code;
            String tag;
            if (i < text.length() - 1 && text.charAt(i) == '&' && (tag = MultilineTextEditorScreen.getTagForCode(code = Character.toLowerCase(text.charAt(i + 1)))) != null) {
                if (tag.equals("reset")) {
                    while (!openTags.isEmpty()) {
                        result.append("</").append((String)openTags.pop()).append(">");
                    }
                } else if (MultilineTextEditorScreen.isColorCode(code)) {
                    Stack<String> formatTags = new Stack<String>();
                    while (!openTags.isEmpty()) {
                        String openTag = (String)openTags.peek();
                        if (MultilineTextEditorScreen.isFormattingTag(openTag)) {
                            formatTags.push((String)openTags.pop());
                            continue;
                        }
                        result.append("</").append((String)openTags.pop()).append(">");
                    }
                    result.append("<").append(tag).append(">");
                    openTags.push(tag);
                    while (!formatTags.isEmpty()) {
                        String fmt = (String)formatTags.pop();
                        openTags.push(fmt);
                    }
                } else {
                    result.append("<").append(tag).append(">");
                    openTags.push(tag);
                }
                i += 2;
                continue;
            }
            result.append(text.charAt(i));
            ++i;
        }
        while (!openTags.isEmpty()) {
            result.append("</").append((String)openTags.pop()).append(">");
        }
        return result.toString();
    }

    private static String getTagForCode(char code) {
        return switch (code) {
            case '0' -> "black";
            case '1' -> "dark_blue";
            case '2' -> "dark_green";
            case '3' -> "dark_aqua";
            case '4' -> "dark_red";
            case '5' -> "dark_purple";
            case '6' -> "gold";
            case '7' -> "gray";
            case '8' -> "dark_gray";
            case '9' -> "blue";
            case 'a' -> "green";
            case 'b' -> "aqua";
            case 'c' -> "red";
            case 'd' -> "light_purple";
            case 'e' -> "yellow";
            case 'f' -> "white";
            case 'k' -> "obfuscated";
            case 'l' -> "bold";
            case 'm' -> "strikethrough";
            case 'n' -> "underline";
            case 'o' -> "italic";
            case 'r' -> "reset";
            default -> null;
        };
    }

    private static boolean isColorCode(char code) {
        return "0123456789abcdef".indexOf(code) >= 0;
    }

    private static boolean isFormattingTag(String tag) {
        return tag.equals("bold") || tag.equals("italic") || tag.equals("underline") || tag.equals("strikethrough") || tag.equals("obfuscated");
    }

    private static class TagInfo {
        String name;
        int pos;

        TagInfo(String name, int pos) {
            this.name = name;
            this.pos = pos;
        }
    }

    private static class ColorInfo {
        int color;
        String name;

        ColorInfo(int color, String name) {
            this.color = color;
            this.name = name;
        }
    }
}

