/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamManager;

public class TeamCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"questory").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"team").then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> TeamCommands.createTeam((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"invite").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> TeamCommands.invitePlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(class_2170.method_9247((String)"accept").executes(TeamCommands::acceptInvite))).then(class_2170.method_9247((String)"decline").executes(TeamCommands::declineInvite))).then(class_2170.method_9247((String)"leave").executes(TeamCommands::leaveTeam))).then(class_2170.method_9247((String)"kick").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> TeamCommands.kickPlayer((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(class_2170.method_9247((String)"info").executes(TeamCommands::showTeamInfo))).then(class_2170.method_9247((String)"list").executes(TeamCommands::listTeams))).then(class_2170.method_9247((String)"rewards").executes(TeamCommands::checkPendingRewards))));
    }

    private static int createTeam(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.teamSystemEnabled) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Team system is disabled"));
            return 0;
        }
        if (TeamManager.getInstance().getPlayerTeamId(player.method_5667()) != null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are already in a team! Use /questory team leave first."));
            return 0;
        }
        QuestTeam team = TeamManager.getInstance().createTeam(name, player.method_5667());
        if (team == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Team creation is disabled or failed"));
            return 0;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] Team '" + name + "' created successfully!")));
        return 1;
    }

    private static int invitePlayer(CommandContext<class_2168> ctx, class_3222 target) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.method_5667());
        if (teamId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are not in a team"));
            return 0;
        }
        if (!TeamManager.getInstance().isTeamOwner(player.method_5667(), teamId)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Only the team owner can invite players"));
            return 0;
        }
        if (TeamManager.getInstance().invitePlayer(teamId, target.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] Invited " + target.method_5477().getString() + " to your team")));
            target.method_43496((class_2561)class_2561.method_43470((String)"\u00a7e[Questory] You have been invited to join a team! Use /questory team accept"));
            return 1;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Failed to invite player (already in a team?)"));
        return 0;
    }

    private static int acceptInvite(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        Set<UUID> invites = TeamManager.getInstance().getPendingInvites(player.method_5667());
        if (invites.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You have no pending team invites"));
            return 0;
        }
        UUID teamId = invites.iterator().next();
        if (TeamManager.getInstance().acceptInvite(player.method_5667(), teamId)) {
            String teamName = TeamManager.getInstance().getTeamName(teamId);
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] You joined the team: " + teamName)));
            for (UUID memberId : TeamManager.getInstance().getTeamMembers(teamId)) {
                class_3222 member;
                if (memberId.equals(player.method_5667()) || (member = player.method_5682().method_3760().method_14602(memberId)) == null) continue;
                member.method_43496((class_2561)class_2561.method_43470((String)("\u00a7e[Questory] " + player.method_5477().getString() + " joined the team!")));
            }
            return 1;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Failed to join team (team full?)"));
        return 0;
    }

    private static int declineInvite(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        Set<UUID> invites = TeamManager.getInstance().getPendingInvites(player.method_5667());
        if (invites.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You have no pending team invites"));
            return 0;
        }
        UUID teamId = invites.iterator().next();
        if (TeamManager.getInstance().declineInvite(player.method_5667(), teamId)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7a[Questory] Declined team invite"));
            return 1;
        }
        return 0;
    }

    private static int leaveTeam(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.method_5667());
        if (teamId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are not in a team"));
            return 0;
        }
        String teamName = TeamManager.getInstance().getTeamName(teamId);
        if (TeamManager.getInstance().leaveTeam(player.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] You left the team: " + teamName)));
            for (UUID memberId : TeamManager.getInstance().getTeamMembers(teamId)) {
                class_3222 member = player.method_5682().method_3760().method_14602(memberId);
                if (member == null) continue;
                member.method_43496((class_2561)class_2561.method_43470((String)("\u00a7e[Questory] " + player.method_5477().getString() + " left the team")));
            }
            return 1;
        }
        return 0;
    }

    private static int kickPlayer(CommandContext<class_2168> ctx, class_3222 target) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.method_5667());
        if (teamId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are not in a team"));
            return 0;
        }
        if (TeamManager.getInstance().kickPlayer(teamId, target.method_5667(), player.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] Kicked " + target.method_5477().getString() + " from the team")));
            target.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You were kicked from the team"));
            return 1;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Failed to kick player (not owner or player not in team?)"));
        return 0;
    }

    private static int showTeamInfo(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.method_5667());
        if (teamId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are not in a team"));
            return 0;
        }
        String teamName = TeamManager.getInstance().getTeamName(teamId);
        Set<UUID> members = TeamManager.getInstance().getTeamMembers(teamId);
        boolean isOwner = TeamManager.getInstance().isTeamOwner(player.method_5667(), teamId);
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76=== Team Info ==="));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7eName: \u00a7f" + teamName)));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7eMembers: \u00a7f" + members.size())));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7eYour Role: \u00a7f" + (isOwner ? "Owner" : "Member"))));
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7eMembers:"));
        for (UUID memberId : members) {
            class_3222 member = player.method_5682().method_3760().method_14602(memberId);
            String status = member != null ? "\u00a7aOnline" : "\u00a77Offline";
            String name = member != null ? member.method_5477().getString() : memberId.toString();
            boolean memberIsOwner = TeamManager.getInstance().isTeamOwner(memberId, teamId);
            player.method_43496((class_2561)class_2561.method_43470((String)("  \u00a7f- " + name + " " + status + (memberIsOwner ? " \u00a76[Owner]" : ""))));
        }
        return 1;
    }

    private static int listTeams(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        Collection<QuestTeam> teams = TeamManager.getInstance().getAllTeams();
        if (teams.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7e[Questory] No teams exist yet"));
            return 0;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76=== All Teams ==="));
        for (QuestTeam team : teams) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7f- " + team.getTeamName() + " \u00a77(" + team.getMemberCount() + " members)")));
        }
        return 1;
    }

    private static int checkPendingRewards(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.teamSystemEnabled) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Team system is disabled"));
            return 0;
        }
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        int count = pendingMgr.getPendingRewardCount(player.method_5667());
        if (count > 0) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7e[Questory] You have \u00a7f" + count + " \u00a7epending team rewards")));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77They will be automatically granted on your next login"));
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7a[Questory] You have no pending team rewards"));
        }
        return 1;
    }
}

