/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.config;

public class ConfigVersion
implements Comparable<ConfigVersion> {
    public static final ConfigVersion V1_0_0 = new ConfigVersion(1, 0, 0);
    public static final ConfigVersion V1_1_0 = new ConfigVersion(1, 1, 0);
    public static final ConfigVersion V1_2_0;
    public static final ConfigVersion CURRENT;
    private final int major;
    private final int minor;
    private final int patch;

    public ConfigVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static ConfigVersion fromString(String version) {
        if (version == null || version.isEmpty()) {
            return V1_0_0;
        }
        String[] parts = version.split("\\.");
        try {
            int major = parts.length > 0 ? Integer.parseInt(parts[0]) : 1;
            int minor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            int patch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
            return new ConfigVersion(major, minor, patch);
        }
        catch (NumberFormatException e) {
            System.err.println("[Questory] Invalid version format: " + version + ", using default");
            return V1_0_0;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    @Override
    public int compareTo(ConfigVersion other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        return Integer.compare(this.patch, other.patch);
    }

    public boolean isNewerThan(ConfigVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isOlderThan(ConfigVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(ConfigVersion other) {
        if (other == null) {
            return false;
        }
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigVersion) {
            return this.equals((ConfigVersion)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.major * 10000 + this.minor * 100 + this.patch;
    }

    static {
        CURRENT = V1_2_0 = new ConfigVersion(1, 2, 0);
    }
}

