/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.property;

import org.texboobcat.questory.theme.property.ThemeProperty;

public class DoubleProperty
extends ThemeProperty<Double> {
    private final double min;
    private final double max;

    public DoubleProperty(String name, double min, double max) {
        super(name, min);
        this.min = min;
        this.max = max;
    }

    @Override
    public Double parse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            double value = Double.parseDouble(string.trim());
            return Math.max(this.min, Math.min(this.max, value));
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse double: " + string);
            return null;
        }
    }
}

