/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.ColorPickerScreen;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.quest.ChapterImage;

public class ChapterImageEditorScreen
extends class_437 {
    private final class_437 parent;
    private final ChapterImage image;
    private final Consumer<ChapterImage> onSave;
    private class_342 xField;
    private class_342 yField;
    private class_342 widthField;
    private class_342 heightField;
    private class_342 rotationField;
    private class_342 imageUrlField;
    private class_342 colorField;
    private class_342 alphaField;
    private class_342 orderField;
    private class_4185 browseBtn;
    private class_4185 colorPickerBtn;
    private class_342 clickUrlField;
    private class_342 depQuestIdField;
    private List<class_342> hoverTextFields = new ArrayList<class_342>();
    private class_4185 addHoverBtn;
    private class_4185 removeHoverBtn;
    private class_4185 editorsOnlyBtn;
    private class_4185 alignCornerBtn;
    private boolean editorsOnly = false;
    private boolean alignCorner = false;
    private class_4185 saveBtn;
    private class_4185 cancelBtn;
    private int scrollOffset = 0;

    public ChapterImageEditorScreen(class_437 parent, ChapterImage image, Consumer<ChapterImage> onSave) {
        super((class_2561)class_2561.method_43470((String)"Edit Chapter Image"));
        this.parent = parent;
        this.image = image;
        this.onSave = onSave;
    }

    protected void method_25426() {
        super.method_25426();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "chapter_image_editor");
        int panelW = Math.min(600, this.field_22789 - 40);
        int panelX = (this.field_22789 - panelW) / 2;
        int fieldY = 60;
        int fieldW = panelW - 140;
        this.xField = new class_342(this.field_22793, panelX + 120, fieldY, 80, 18, (class_2561)class_2561.method_43470((String)"x"));
        this.xField.method_1852(String.valueOf(this.image.getX()));
        this.method_37063((class_364)this.xField);
        this.yField = new class_342(this.field_22793, panelX + 220, fieldY, 80, 18, (class_2561)class_2561.method_43470((String)"y"));
        this.yField.method_1852(String.valueOf(this.image.getY()));
        this.method_37063((class_364)this.yField);
        this.widthField = new class_342(this.field_22793, panelX + 120, fieldY += 24, 80, 18, (class_2561)class_2561.method_43470((String)"width"));
        this.widthField.method_1852(String.valueOf(this.image.getWidth()));
        this.method_37063((class_364)this.widthField);
        this.heightField = new class_342(this.field_22793, panelX + 220, fieldY, 80, 18, (class_2561)class_2561.method_43470((String)"height"));
        this.heightField.method_1852(String.valueOf(this.image.getHeight()));
        this.method_37063((class_364)this.heightField);
        this.rotationField = new class_342(this.field_22793, panelX + 120, fieldY += 24, 100, 18, (class_2561)class_2561.method_43470((String)"rotation"));
        this.rotationField.method_1852(String.valueOf(this.image.getRotation()));
        this.rotationField.method_47404((class_2561)class_2561.method_43470((String)"0-360 degrees"));
        this.method_37063((class_364)this.rotationField);
        this.imageUrlField = new class_342(this.field_22793, panelX + 120, fieldY += 30, fieldW - 90, 18, (class_2561)class_2561.method_43470((String)"image"));
        this.imageUrlField.method_1852(this.image.getImageUrl());
        this.imageUrlField.method_47404((class_2561)class_2561.method_43470((String)"textures/chapter/image.png"));
        this.method_37063((class_364)this.imageUrlField);
        this.browseBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Browse..."), b -> this.openImageBrowser()).method_46434(panelX + 120 + fieldW - 85, fieldY, 80, 18).method_46431();
        this.method_37063((class_364)this.browseBtn);
        this.colorField = new class_342(this.field_22793, panelX + 120, fieldY += 24, 100, 18, (class_2561)class_2561.method_43470((String)"color"));
        this.colorField.method_1852(this.image.getColor());
        this.colorField.method_47404((class_2561)class_2561.method_43470((String)"#FFFFFF"));
        this.method_37063((class_364)this.colorField);
        this.colorPickerBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Pick..."), b -> this.openColorPicker()).method_46434(panelX + 230, fieldY, 70, 18).method_46431();
        this.method_37063((class_364)this.colorPickerBtn);
        this.alphaField = new class_342(this.field_22793, panelX + 120, fieldY += 24, 80, 18, (class_2561)class_2561.method_43470((String)"alpha"));
        this.alphaField.method_1852(String.valueOf(this.image.getAlpha()));
        this.alphaField.method_47404((class_2561)class_2561.method_43470((String)"0-255"));
        this.method_37063((class_364)this.alphaField);
        this.orderField = new class_342(this.field_22793, panelX + 120, fieldY += 24, 80, 18, (class_2561)class_2561.method_43470((String)"order"));
        this.orderField.method_1852(String.valueOf(this.image.getOrder()));
        this.orderField.method_47404((class_2561)class_2561.method_43470((String)"z-index/layer"));
        this.method_37063((class_364)this.orderField);
        fieldY += 30;
        if (!this.image.getHoverText().isEmpty()) {
            for (int i = 0; i < Math.min(3, this.image.getHoverText().size()); ++i) {
                class_342 hoverField = new class_342(this.field_22793, panelX + 120, fieldY, fieldW, 18, (class_2561)class_2561.method_43470((String)("hover" + i)));
                hoverField.method_1852(this.image.getHoverText().get(i));
                hoverField.method_47404((class_2561)class_2561.method_43470((String)("Hover text line " + (i + 1))));
                this.method_37063((class_364)hoverField);
                this.hoverTextFields.add(hoverField);
                fieldY += 20;
            }
        } else {
            class_342 hoverField = new class_342(this.field_22793, panelX + 120, fieldY, fieldW, 18, (class_2561)class_2561.method_43470((String)"hover"));
            hoverField.method_47404((class_2561)class_2561.method_43470((String)"Hover text (optional)"));
            this.method_37063((class_364)hoverField);
            this.hoverTextFields.add(hoverField);
            fieldY += 20;
        }
        this.addHoverBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> this.addHoverLine()).method_46434(panelX + 120 + fieldW + 4, fieldY - 20, 20, 18).method_46431();
        this.method_37063((class_364)this.addHoverBtn);
        this.clickUrlField = new class_342(this.field_22793, panelX + 120, fieldY += 10, fieldW, 18, (class_2561)class_2561.method_43470((String)"click"));
        this.clickUrlField.method_1852(this.image.getClickUrl());
        this.clickUrlField.method_47404((class_2561)class_2561.method_43470((String)"http://example.com (optional)"));
        this.method_37063((class_364)this.clickUrlField);
        this.editorsOnly = this.image.isEditorsOnly();
        this.editorsOnlyBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Editors Only: " + (this.editorsOnly ? "Yes" : "No"))), b -> {
            this.editorsOnly = !this.editorsOnly;
            this.editorsOnlyBtn.method_25355((class_2561)class_2561.method_43470((String)("Editors Only: " + (this.editorsOnly ? "Yes" : "No"))));
        }).method_46434(panelX + 120, fieldY += 30, 140, 18).method_46431();
        this.method_37063((class_364)this.editorsOnlyBtn);
        this.alignCorner = this.image.isAlignToCorner();
        this.alignCornerBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Align To Corner: " + (this.alignCorner ? "Yes" : "No"))), b -> {
            this.alignCorner = !this.alignCorner;
            this.alignCornerBtn.method_25355((class_2561)class_2561.method_43470((String)("Align To Corner: " + (this.alignCorner ? "Yes" : "No"))));
        }).method_46434(panelX + 120, fieldY += 22, 140, 18).method_46431();
        this.method_37063((class_364)this.alignCornerBtn);
        this.depQuestIdField = new class_342(this.field_22793, panelX + 120, fieldY += 22, fieldW, 18, (class_2561)class_2561.method_43470((String)"dependency"));
        this.depQuestIdField.method_1852(this.image.getDependencyQuestId() == null ? "" : this.image.getDependencyQuestId());
        this.depQuestIdField.method_47404((class_2561)class_2561.method_43470((String)"quest_id (optional)"));
        this.method_37063((class_364)this.depQuestIdField);
        int btnY = this.field_22790 - 32;
        this.saveBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.save()).method_46434(panelX + panelW - 130, btnY, 60, 20).method_46431();
        this.method_37063((class_364)this.saveBtn);
        this.cancelBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(panelX + panelW - 65, btnY, 60, 20).method_46431();
        this.method_37063((class_364)this.cancelBtn);
    }

    private void addHoverLine() {
        if (this.hoverTextFields.size() < 5) {
            this.save();
        }
    }

    private void openImageBrowser() {
        this.field_22787.method_1507((class_437)new IconPickerScreen(this, this.imageUrlField.method_1882(), result -> {
            this.imageUrlField.method_1852(result);
            this.field_22787.method_1507((class_437)this);
        }));
    }

    private void openColorPicker() {
        int currentColor = this.parseColor(this.colorField.method_1882());
        this.field_22787.method_1507((class_437)new ColorPickerScreen(this, currentColor, color -> {
            this.colorField.method_1852(String.format("#%06X", color & 0xFFFFFF));
            this.field_22787.method_1507((class_437)this);
        }));
    }

    private int parseColor(String hex) {
        try {
            String clean = hex.trim();
            if (clean.startsWith("#")) {
                clean = clean.substring(1);
            }
            return (int)Long.parseLong(clean, 16) | 0xFF000000;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void save() {
        try {
            ChapterImage updated = new ChapterImage(Integer.parseInt(this.xField.method_1882().trim()), Integer.parseInt(this.yField.method_1882().trim()), Double.parseDouble(this.widthField.method_1882().trim()), Double.parseDouble(this.heightField.method_1882().trim()), this.imageUrlField.method_1882().trim());
            updated.setRotation(Double.parseDouble(this.rotationField.method_1882().trim()));
            updated.setColor(this.colorField.method_1882().trim());
            updated.setAlpha(Integer.parseInt(this.alphaField.method_1882().trim()));
            updated.setOrder(Integer.parseInt(this.orderField.method_1882().trim()));
            updated.setClickUrl(this.clickUrlField.method_1882().trim());
            updated.setEditorsOnly(this.editorsOnly);
            updated.setAlignToCorner(this.alignCorner);
            String depId = this.depQuestIdField.method_1882().trim();
            if (!depId.isEmpty()) {
                updated.setDependencyQuestId(depId);
            }
            for (class_342 hoverField : this.hoverTextFields) {
                String text = hoverField.method_1882().trim();
                if (text.isEmpty()) continue;
                updated.addHoverText(text);
            }
            this.onSave.accept(updated);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        int panelW = Math.min(600, this.field_22789 - 40);
        int panelX = (this.field_22789 - panelW) / 2;
        int fieldY = 60 - this.scrollOffset;
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, -1);
        int labelX = panelX + 12;
        g.method_25303(this.field_22793, "\u00a7lPosition & Size", labelX, fieldY - 8, -86);
        g.method_25303(this.field_22793, "X:", labelX, fieldY + 5, -1);
        g.method_25303(this.field_22793, "Y:", labelX + 100, fieldY + 5, -1);
        g.method_25303(this.field_22793, "Width:", labelX, (fieldY += 24) + 5, -1);
        g.method_25303(this.field_22793, "Height:", labelX + 100, fieldY + 5, -1);
        g.method_25303(this.field_22793, "Rotation:", labelX, (fieldY += 24) + 5, -1);
        g.method_25303(this.field_22793, "\u00a7lAppearance", labelX, fieldY += 30, -86);
        g.method_25303(this.field_22793, "Image URL:", labelX, (fieldY += 12) + 5, -1);
        g.method_25303(this.field_22793, "Color Tint:", labelX, (fieldY += 24) + 5, -1);
        g.method_25303(this.field_22793, "Alpha:", labelX, (fieldY += 24) + 5, -1);
        g.method_25303(this.field_22793, "Order:", labelX, (fieldY += 24) + 5, -1);
        g.method_25303(this.field_22793, "\u00a7lInteractivity", labelX, fieldY += 30, -86);
        g.method_25303(this.field_22793, "Hover Text:", labelX, (fieldY += 12) + 5, -1);
        g.method_25303(this.field_22793, "Click URL:", labelX, (fieldY += 20 * this.hoverTextFields.size() + 10) + 5, -1);
        g.method_25303(this.field_22793, "\u00a7lOptions", labelX, fieldY += 30, -86);
        fieldY += 12;
        fieldY += 22;
        g.method_25303(this.field_22793, "Dependency:", labelX, (fieldY += 22) + 5, -1);
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        this.scrollOffset = (int)Math.max(0.0, (double)this.scrollOffset - Math.signum(delta) * 20.0);
        return true;
    }

    public boolean method_25421() {
        return false;
    }
}

