/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamActionPacket;
import org.texboobcat.questory.team.TeamInviteInfo;

public class TeamJoinScreen
extends class_437 {
    private static final int WINDOW_WIDTH = 260;
    private static final int WINDOW_HEIGHT = 220;
    private final class_437 parent;
    private int leftPos;
    private int topPos;
    private List<InviteEntry> inviteEntries = new ArrayList<InviteEntry>();
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_INVITES = 6;
    private class_4185 closeButton;

    public TeamJoinScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Join Team"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - 260) / 2;
        this.topPos = (this.field_22790 - 220) / 2;
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), btn -> this.method_25419()).method_46434(this.leftPos + 260 - 70, this.topPos + 5, 65, 20).method_46431();
        this.method_37063((class_364)this.closeButton);
        this.buildInviteEntries();
    }

    private void buildInviteEntries() {
        this.inviteEntries.clear();
        ClientTeamManager clientMgr = ClientTeamManager.getInstance();
        List<TeamInviteInfo> pendingInvites = clientMgr.getPendingInvites();
        if (pendingInvites.isEmpty()) {
            return;
        }
        for (TeamInviteInfo inviteInfo : pendingInvites) {
            InviteEntry entry = new InviteEntry(inviteInfo);
            int entryY = this.topPos + 35 + this.inviteEntries.size() * 40 - this.scrollOffset * 40;
            entry.acceptButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Accept"), btn -> this.acceptInvite(inviteInfo.getTeamId())).method_46434(this.leftPos + 10, entryY + 20, 55, 18).method_46431();
            entry.declineButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Decline"), btn -> this.declineInvite(inviteInfo.getTeamId())).method_46434(this.leftPos + 70, entryY + 20, 55, 18).method_46431();
            this.inviteEntries.add(entry);
        }
        for (InviteEntry entry : this.inviteEntries) {
            this.method_37063((class_364)entry.acceptButton);
            this.method_37063((class_364)entry.declineButton);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 220, -872415232);
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 28, -14540254);
        graphics.method_25303(this.field_22793, "Join Team - Pending Invites", this.leftPos + 5, this.topPos + 10, 0xFFFFFF);
        if (this.inviteEntries.isEmpty()) {
            graphics.method_25303(this.field_22793, "\u00a77No pending team invites", this.leftPos + 10, this.topPos + 50, 0x888888);
            graphics.method_25303(this.field_22793, "\u00a77Teams can invite you to join", this.leftPos + 10, this.topPos + 65, 0x888888);
            graphics.method_25303(this.field_22793, "\u00a77them. Check back later!", this.leftPos + 10, this.topPos + 80, 0x888888);
        } else {
            int i;
            int entryY = this.topPos + 35;
            int visibleCount = 0;
            for (i = this.scrollOffset; i < this.inviteEntries.size() && visibleCount < 6; ++visibleCount, ++i) {
                InviteEntry entry = this.inviteEntries.get(i);
                if (visibleCount > 0) {
                    graphics.method_25294(this.leftPos + 10, entryY - 2, this.leftPos + 260 - 10, entryY - 1, 0x44FFFFFF);
                }
                graphics.method_25303(this.field_22793, "\u00a7e" + entry.inviteInfo.getTeamName(), this.leftPos + 10, entryY + 3, 0xFFFFFF);
                graphics.method_25303(this.field_22793, "\u00a77Owner: \u00a7f" + entry.inviteInfo.getOwnerName(), this.leftPos + 10, entryY + 13, 0x888888);
                graphics.method_25303(this.field_22793, "\u00a77Members: \u00a7f" + entry.inviteInfo.getMemberCount(), this.leftPos + 140, entryY + 13, 0x888888);
                entry.acceptButton.method_46419(entryY + 20);
                entry.declineButton.method_46419(entryY + 20);
                entry.acceptButton.field_22764 = true;
                entry.declineButton.field_22764 = true;
                entryY += 43;
            }
            for (i = 0; i < this.inviteEntries.size(); ++i) {
                if (i >= this.scrollOffset && i < this.scrollOffset + 6) continue;
                this.inviteEntries.get((int)i).acceptButton.field_22764 = false;
                this.inviteEntries.get((int)i).declineButton.field_22764 = false;
            }
            if (this.inviteEntries.size() > 6) {
                String scrollHint = "(" + (this.scrollOffset + 1) + "-" + Math.min(this.scrollOffset + 6, this.inviteEntries.size()) + " of " + this.inviteEntries.size() + ")";
                graphics.method_25303(this.field_22793, "\u00a77" + scrollHint, this.leftPos + 10, this.topPos + 220 - 15, 0x888888);
            }
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        if (this.inviteEntries.size() > 6) {
            if (scrollDelta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
                this.method_37067();
                this.method_25426();
                return true;
            }
            if (scrollDelta < 0.0 && this.scrollOffset < this.inviteEntries.size() - 6) {
                ++this.scrollOffset;
                this.method_37067();
                this.method_25426();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, scrollDelta);
    }

    private void acceptInvite(UUID teamId) {
        TeamActionPacket packet = TeamActionPacket.accept(teamId);
        NetworkManager.sendToServer(packet);
        this.method_25419();
    }

    private void declineInvite(UUID teamId) {
        TeamActionPacket packet = TeamActionPacket.decline(teamId);
        NetworkManager.sendToServer(packet);
        this.method_37067();
        this.method_25426();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    static class InviteEntry {
        TeamInviteInfo inviteInfo;
        class_4185 acceptButton;
        class_4185 declineButton;

        InviteEntry(TeamInviteInfo inviteInfo) {
            this.inviteInfo = inviteInfo;
        }
    }
}

