/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.client.gui.ConfirmationDialog;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSettingsPacket;
import org.texboobcat.questory.team.QuestTeam;

public class TransferOwnershipDialog
extends class_437 {
    private static final int WINDOW_WIDTH = 260;
    private static final int WINDOW_HEIGHT = 220;
    private static final int MAX_VISIBLE_MEMBERS = 5;
    private final class_437 parent;
    private int leftPos;
    private int topPos;
    private List<MemberEntry> memberEntries = new ArrayList<MemberEntry>();
    private int scrollOffset = 0;
    private class_4185 closeButton;

    public TransferOwnershipDialog(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Transfer Ownership"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - 260) / 2;
        this.topPos = (this.field_22790 - 220) / 2;
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.method_25419()).method_46434(this.leftPos + 260 - 75, this.topPos + 5, 70, 20).method_46431();
        this.method_37063((class_364)this.closeButton);
        this.buildMemberEntries();
    }

    private void buildMemberEntries() {
        this.memberEntries.clear();
        ClientTeamManager clientMgr = ClientTeamManager.getInstance();
        QuestTeam team = clientMgr.getCurrentTeam();
        if (team == null) {
            return;
        }
        UUID currentPlayerId = class_310.method_1551().field_1724.method_5667();
        for (UUID memberId : team.getMembers()) {
            if (memberId.equals(currentPlayerId)) continue;
            String name = this.getPlayerName(memberId);
            boolean isOnline = this.isPlayerOnline(memberId);
            MemberEntry entry = new MemberEntry(memberId, name, isOnline);
            int entryY = this.topPos + 40 + this.memberEntries.size() * 30 - this.scrollOffset * 30;
            entry.transferButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Transfer"), btn -> this.transferToMember(memberId)).method_46434(this.leftPos + 260 - 85, entryY, 75, 18).method_46431();
            this.memberEntries.add(entry);
        }
        for (MemberEntry entry : this.memberEntries) {
            this.method_37063((class_364)entry.transferButton);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 220, -872415232);
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 28, -14540254);
        graphics.method_25303(this.field_22793, "Transfer Ownership", this.leftPos + 5, this.topPos + 10, 0xFFFFFF);
        if (this.memberEntries.isEmpty()) {
            graphics.method_25303(this.field_22793, "\u00a77No other team members", this.leftPos + 10, this.topPos + 50, 0x888888);
            graphics.method_25303(this.field_22793, "\u00a77Invite players to transfer", this.leftPos + 10, this.topPos + 65, 0x888888);
            graphics.method_25303(this.field_22793, "\u00a77ownership to them.", this.leftPos + 10, this.topPos + 80, 0x888888);
        } else {
            int i;
            graphics.method_25303(this.field_22793, "\u00a77Select a member to make them", this.leftPos + 10, this.topPos + 35, 0x888888);
            graphics.method_25303(this.field_22793, "\u00a77the new team owner:", this.leftPos + 10, this.topPos + 47, 0x888888);
            int entryY = this.topPos + 65;
            int visibleCount = 0;
            for (i = this.scrollOffset; i < this.memberEntries.size() && visibleCount < 5; ++visibleCount, ++i) {
                MemberEntry entry = this.memberEntries.get(i);
                if (visibleCount > 0) {
                    graphics.method_25294(this.leftPos + 10, entryY - 2, this.leftPos + 260 - 10, entryY - 1, 0x44FFFFFF);
                }
                String status = entry.isOnline ? "\u00a7a\u25cf" : "\u00a77\u25cf";
                graphics.method_25303(this.field_22793, status + " \u00a7f" + entry.name, this.leftPos + 10, entryY + 4, 0xFFFFFF);
                entry.transferButton.method_46419(entryY);
                entry.transferButton.field_22764 = true;
                entryY += 30;
            }
            for (i = 0; i < this.memberEntries.size(); ++i) {
                if (i >= this.scrollOffset && i < this.scrollOffset + 5) continue;
                this.memberEntries.get((int)i).transferButton.field_22764 = false;
            }
            if (this.memberEntries.size() > 5) {
                String scrollHint = "(" + (this.scrollOffset + 1) + "-" + Math.min(this.scrollOffset + 5, this.memberEntries.size()) + " of " + this.memberEntries.size() + ")";
                graphics.method_25303(this.field_22793, "\u00a77" + scrollHint, this.leftPos + 10, this.topPos + 220 - 15, 0x888888);
            }
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        if (this.memberEntries.size() > 5) {
            if (scrollDelta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
                return true;
            }
            if (scrollDelta < 0.0 && this.scrollOffset < this.memberEntries.size() - 5) {
                ++this.scrollOffset;
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, scrollDelta);
    }

    private void transferToMember(UUID memberId) {
        String memberName = this.getPlayerName(memberId);
        String message = "Transfer team ownership to " + memberName + "? You will no longer be the owner.";
        this.field_22787.method_1507((class_437)new ConfirmationDialog(this.parent, "Confirm Transfer", message, "Transfer", "Cancel", () -> this.sendTransferPacket(memberId), false));
    }

    private void sendTransferPacket(UUID newOwnerId) {
        TeamSettingsPacket packet = TeamSettingsPacket.transferOwnership(newOwnerId);
        NetworkManager.sendToServer(packet);
    }

    private String getPlayerName(UUID playerId) {
        class_1657 player = class_310.method_1551().field_1687.method_18470(playerId);
        if (player != null) {
            return player.method_5477().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    private boolean isPlayerOnline(UUID playerId) {
        return class_310.method_1551().field_1687.method_18470(playerId) != null;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    static class MemberEntry {
        UUID playerId;
        String name;
        boolean isOnline;
        class_4185 transferButton;

        MemberEntry(UUID playerId, String name, boolean isOnline) {
            this.playerId = playerId;
            this.name = name;
            this.isOnline = isOnline;
        }
    }
}

