/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import org.texboobcat.questory.client.gui.QuestIconRenderer;

public class EntityPickerScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<String> onOk;
    private final String initial;
    private final int suggestedIconPx;
    private class_342 searchBox;
    private class_342 fitBox;
    private class_342 minBox;
    private class_342 maxBox;
    private class_342 spinBox;
    private class_342 bobBox;
    private class_342 bobSpeedBox;
    private class_342 iconSizeBox;
    private boolean seqMode = false;
    private class_4185 seqToggleBtn;
    private class_342 intervalBox;
    private class_342 manualFrameBox;
    private class_4185 addCurrentBtn;
    private class_4185 addManualBtn;
    private class_4185 removeFrameBtn;
    private class_4185 upFrameBtn;
    private class_4185 downFrameBtn;
    private class_4185 clearFramesBtn;
    private List<String> frames = new ArrayList<String>();
    private int framesScroll = 0;
    private int framesSel = -1;
    private List<class_2960> all = new ArrayList<class_2960>();
    private List<class_2960> filtered = new ArrayList<class_2960>();
    private class_2960 selected = null;
    private int listScroll = 0;
    private String lastQuery = null;
    private static final int PAD = 12;
    private int listX;
    private int listY;
    private int listW;
    private int listH;
    private int rightX;
    private int rightY;
    private int rightW;
    private int rightH;

    public EntityPickerScreen(class_437 parent, String seed, Consumer<String> onOk) {
        this(parent, seed, onOk, 42);
    }

    public EntityPickerScreen(class_437 parent, String seed, Consumer<String> onOk, int suggestedIconPx) {
        super((class_2561)class_2561.method_43470((String)"Entity Browser"));
        this.parent = parent;
        this.onOk = onOk;
        this.initial = seed == null ? "" : seed;
        this.suggestedIconPx = Math.max(8, Math.min(128, suggestedIconPx));
    }

    protected void method_25426() {
        super.method_25426();
        this.listX = 12;
        this.listY = 48;
        this.listW = (int)((double)(this.field_22789 - 36) * 0.55);
        this.listH = this.field_22790 - this.listY - 12 - 30;
        this.rightX = this.listX + this.listW + 12;
        this.rightY = 36;
        this.rightW = this.field_22789 - this.rightX - 12;
        this.rightH = this.field_22790 - this.rightY - 12 - 30;
        this.searchBox = new class_342(this.field_22793, this.listX, 18, this.listW, 18, (class_2561)class_2561.method_43470((String)"Search entities..."));
        this.searchBox.method_1880(200);
        this.searchBox.method_1852("");
        this.method_37063((class_364)this.searchBox);
        int by = this.field_22790 - 26;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"OK"), b -> this.applySelection()).method_46434(this.field_22789 / 2 - 60, by, 56, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 + 4, by, 56, 20).method_46431());
        int fy = this.rightY + 100;
        this.iconSizeBox = new class_342(this.field_22793, this.rightX, fy, 60, 18, (class_2561)class_2561.method_43470((String)"icon px"));
        this.iconSizeBox.method_1852(Integer.toString(this.suggestedIconPx));
        try {
            this.iconSizeBox.method_47404((class_2561)class_2561.method_43470((String)"icon px"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_37063((class_364)this.iconSizeBox);
        int presetX = this.rightX + 66;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"32"), b -> this.iconSizeBox.method_1852("32")).method_46434(presetX, fy, 28, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"42"), b -> this.iconSizeBox.method_1852("42")).method_46434(presetX += 30, fy, 28, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"64"), b -> this.iconSizeBox.method_1852("64")).method_46434(presetX += 30, fy, 28, 18).method_46431());
        int colW = Math.max(60, this.rightW / 3 - 8);
        this.fitBox = new class_342(this.field_22793, this.rightX, fy += 22, colW, 18, (class_2561)class_2561.method_43470((String)"fit"));
        this.minBox = new class_342(this.field_22793, this.rightX + colW + 6, fy, colW, 18, (class_2561)class_2561.method_43470((String)"min"));
        this.maxBox = new class_342(this.field_22793, this.rightX + (colW + 6) * 2, fy, colW, 18, (class_2561)class_2561.method_43470((String)"max"));
        try {
            this.fitBox.method_47404((class_2561)class_2561.method_43470((String)"0.1 - 2.0"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.minBox.method_47404((class_2561)class_2561.method_43470((String)"min scale"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.maxBox.method_47404((class_2561)class_2561.method_43470((String)"max scale"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.spinBox = new class_342(this.field_22793, this.rightX, fy += 22, colW, 18, (class_2561)class_2561.method_43470((String)"spin"));
        this.bobBox = new class_342(this.field_22793, this.rightX + colW + 6, fy, colW, 18, (class_2561)class_2561.method_43470((String)"bob"));
        this.bobSpeedBox = new class_342(this.field_22793, this.rightX + (colW + 6) * 2, fy, colW, 18, (class_2561)class_2561.method_43470((String)"bob_speed"));
        try {
            this.spinBox.method_47404((class_2561)class_2561.method_43470((String)"deg/tick"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.bobBox.method_47404((class_2561)class_2561.method_43470((String)"px"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.bobSpeedBox.method_47404((class_2561)class_2561.method_43470((String)"speed"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_37063((class_364)this.fitBox);
        this.method_37063((class_364)this.minBox);
        this.method_37063((class_364)this.maxBox);
        this.method_37063((class_364)this.spinBox);
        this.method_37063((class_364)this.bobBox);
        this.method_37063((class_364)this.bobSpeedBox);
        int seqY = fy + 22 + 22 + 72;
        this.seqToggleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sequence: Off"), b -> {
            this.seqMode = !this.seqMode;
            this.seqToggleBtn.method_25355((class_2561)class_2561.method_43470((String)(this.seqMode ? "Sequence: On" : "Sequence: Off")));
        }).method_46434(this.rightX, seqY, 120, 18).method_46431();
        this.method_37063((class_364)this.seqToggleBtn);
        this.intervalBox = new class_342(this.field_22793, this.rightX + 126, seqY, 40, 18, (class_2561)class_2561.method_43470((String)"ticks"));
        this.intervalBox.method_1852("20");
        try {
            this.intervalBox.method_47404((class_2561)class_2561.method_43470((String)"ticks"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_37063((class_364)this.intervalBox);
        this.manualFrameBox = new class_342(this.field_22793, this.rightX + 170, seqY, Math.max(60, this.rightW - 170 - 4), 18, (class_2561)class_2561.method_43470((String)"manual frame"));
        this.manualFrameBox.method_1852("");
        this.method_37063((class_364)this.manualFrameBox);
        int btnY = seqY + 22;
        this.addCurrentBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+Current"), b -> {
            if (this.selected != null) {
                this.frames.add("entity:" + this.selected.toString());
            }
        }).method_46434(this.rightX, btnY, 68, 18).method_46431();
        this.addManualBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+Add"), b -> {
            String v = this.manualFrameBox.method_1882().trim();
            if (!v.isEmpty()) {
                this.frames.add(v);
            }
        }).method_46434(this.rightX + 72, btnY, 48, 18).method_46431();
        this.removeFrameBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-Del"), b -> {
            if (this.framesSel >= 0 && this.framesSel < this.frames.size()) {
                this.frames.remove(this.framesSel);
                this.framesSel = -1;
            }
        }).method_46434(this.rightX + 124, btnY, 44, 18).method_46431();
        this.upFrameBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Up"), b -> {
            if (this.framesSel > 0) {
                String s = this.frames.remove(this.framesSel);
                --this.framesSel;
                this.frames.add(this.framesSel, s);
            }
        }).method_46434(this.rightX + 172, btnY, 36, 18).method_46431();
        this.downFrameBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Down"), b -> {
            if (this.framesSel >= 0 && this.framesSel < this.frames.size() - 1) {
                String s = this.frames.remove(this.framesSel);
                ++this.framesSel;
                this.frames.add(this.framesSel, s);
            }
        }).method_46434(this.rightX + 212, btnY, 44, 18).method_46431();
        this.clearFramesBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear"), b -> {
            this.frames.clear();
            this.framesSel = -1;
        }).method_46434(this.rightX + 260, btnY, 48, 18).method_46431();
        this.method_37063((class_364)this.addCurrentBtn);
        this.method_37063((class_364)this.addManualBtn);
        this.method_37063((class_364)this.removeFrameBtn);
        this.method_37063((class_364)this.upFrameBtn);
        this.method_37063((class_364)this.downFrameBtn);
        this.method_37063((class_364)this.clearFramesBtn);
        this.all = new ArrayList<class_2960>();
        for (class_2960 id : class_7923.field_41177.method_10235()) {
            this.all.add(id);
        }
        this.all.sort(Comparator.comparing(class_2960::toString));
        if (this.initial.startsWith("entity:")) {
            try {
                String raw = this.initial.substring("entity:".length()).trim();
                int semi = raw.indexOf(59);
                String idStr = semi >= 0 ? raw.substring(0, semi).trim() : raw;
                class_2960 sel = new class_2960(idStr);
                if (class_7923.field_41177.method_10250(sel)) {
                    this.selected = sel;
                }
                if (semi >= 0) {
                    String rest = raw.substring(semi + 1);
                    HashMap<String, String> mods = new HashMap<String, String>();
                    for (String p : rest.split(";")) {
                        int eq;
                        String s = p.trim();
                        if (s.isEmpty() || (eq = s.indexOf(61)) <= 0) continue;
                        mods.put(s.substring(0, eq).trim().toLowerCase(Locale.ROOT), s.substring(eq + 1).trim());
                    }
                    this.fitBox.method_1852(mods.getOrDefault("fit", ""));
                    this.minBox.method_1852(mods.getOrDefault("min", ""));
                    this.maxBox.method_1852(mods.getOrDefault("max", ""));
                    this.spinBox.method_1852(mods.getOrDefault("spin", ""));
                    this.bobBox.method_1852(mods.getOrDefault("bob", ""));
                    this.bobSpeedBox.method_1852(mods.getOrDefault("bob_speed", ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateFiltered();
    }

    private void updateFiltered() {
        String q = this.searchBox == null ? "" : this.searchBox.method_1882().trim().toLowerCase(Locale.ROOT);
        this.filtered = new ArrayList<class_2960>();
        for (class_2960 id : this.all) {
            if (!q.isEmpty() && !id.toString().toLowerCase(Locale.ROOT).contains(q)) continue;
            this.filtered.add(id);
        }
        if (this.selected == null || !this.filtered.contains(this.selected)) {
            // empty if block
        }
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - this.visibleRows())));
    }

    private int visibleRows() {
        return Math.max(1, this.listH / 18);
    }

    private void applySelection() {
        String result;
        if (this.seqMode && !this.frames.isEmpty()) {
            int interval;
            try {
                interval = Math.max(1, Integer.parseInt(this.intervalBox.method_1882().trim()));
            }
            catch (Exception e) {
                interval = 20;
            }
            StringBuilder sb = new StringBuilder("rotate:").append(interval).append('|');
            for (int i = 0; i < this.frames.size(); ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                sb.append(this.frames.get(i));
            }
            result = sb.toString();
        } else {
            result = this.selected != null ? this.buildIconString(this.selected) : this.initial;
        }
        this.onOk.accept(result);
        this.field_22787.method_1507(this.parent);
    }

    private String buildIconString(class_2960 id) {
        String bobSp;
        String bob;
        String spin;
        String max;
        String min;
        ArrayList<CallSite> mods = new ArrayList<CallSite>();
        String fit = this.fitBox.method_1882().trim();
        if (!fit.isEmpty()) {
            mods.add((CallSite)((Object)("fit=" + fit)));
        }
        if (!(min = this.minBox.method_1882().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("min=" + min)));
        }
        if (!(max = this.maxBox.method_1882().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("max=" + max)));
        }
        if (!(spin = this.spinBox.method_1882().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("spin=" + spin)));
        }
        if (!(bob = this.bobBox.method_1882().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("bob=" + bob)));
        }
        if (!(bobSp = this.bobSpeedBox.method_1882().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("bob_speed=" + bobSp)));
        }
        if (mods.isEmpty()) {
            return "entity:" + id.toString();
        }
        StringBuilder sb = new StringBuilder("entity:").append(id.toString()).append("; ");
        for (int i = 0; i < mods.size(); ++i) {
            if (i > 0) {
                sb.append("; ");
            }
            sb.append((String)mods.get(i));
        }
        return sb.toString();
    }

    public boolean method_25402(double mx, double my, int button) {
        int row;
        int idx;
        if (super.method_25402(mx, my, button)) {
            return true;
        }
        if (mx >= (double)this.listX && mx <= (double)(this.listX + this.listW) && my >= (double)this.listY && my <= (double)(this.listY + this.listH) && (idx = this.listScroll + (row = (int)((my - (double)this.listY) / 18.0))) >= 0 && idx < this.filtered.size()) {
            this.selected = this.filtered.get(idx);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mx, double my, double delta) {
        if (mx >= (double)this.listX && mx <= (double)(this.listX + this.listW) && my >= (double)this.listY && my <= (double)(this.listY + this.listH)) {
            this.listScroll = Math.max(0, Math.min(this.listScroll - (int)Math.signum(delta), Math.max(0, this.filtered.size() - this.visibleRows())));
            return true;
        }
        return super.method_25401(mx, my, delta);
    }

    public void method_25394(class_332 g, int mx, int my, float p) {
        String q;
        this.method_25420(g);
        g.method_27535(this.field_22793, this.field_22785, 12, 12, -1);
        if (this.searchBox != null && (q = this.searchBox.method_1882()) != null && !q.equals(this.lastQuery)) {
            this.lastQuery = q;
            this.updateFiltered();
        }
        g.method_25294(this.listX, this.listY, this.listX + this.listW, this.listY + this.listH, -535818224);
        g.method_44379(this.listX, this.listY, this.listX + this.listW, this.listY + this.listH);
        int vis = this.visibleRows();
        for (int i = 0; i < vis && this.listScroll + i < this.filtered.size(); ++i) {
            class_2960 id = this.filtered.get(this.listScroll + i);
            int y = this.listY + i * 18;
            boolean hover = mx >= this.listX && mx <= this.listX + this.listW && my >= y && my < y + 18;
            boolean sel = id.equals((Object)this.selected);
            if (sel) {
                g.method_25294(this.listX, y, this.listX + this.listW, y + 18, -12952966);
            } else if (hover) {
                g.method_25294(this.listX, y, this.listX + this.listW, y + 18, -14013910);
            }
            g.method_25303(this.field_22793, id.toString(), this.listX + 6, y + 5, -1);
        }
        g.method_44380();
        g.method_25303(this.field_22793, "Preview:", this.rightX, this.rightY, -5592321);
        int pv = Math.min(96, Math.min(this.rightW, this.rightH) - 20);
        int px = this.rightX + (this.rightW - pv) / 2;
        int py = this.rightY + 20;
        g.method_25294(px - 2, py - 2, px + pv + 2, py + pv + 2, -12566464);
        if (this.seqMode && !this.frames.isEmpty()) {
            int interval;
            try {
                iconSize = Math.max(8, Math.min(128, Integer.parseInt(this.iconSizeBox.method_1882().trim())));
            }
            catch (Exception e) {
                iconSize = 42;
            }
            ix = px + (pv - iconSize) / 2;
            iy = py + (pv - iconSize) / 2;
            try {
                interval = Math.max(1, Integer.parseInt(this.intervalBox.method_1882().trim()));
            }
            catch (Exception e) {
                interval = 20;
            }
            StringBuilder sb = new StringBuilder("rotate:").append(interval).append('|');
            for (int i = 0; i < this.frames.size(); ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                sb.append(this.frames.get(i));
            }
            try {
                QuestIconRenderer.render(g, sb.toString(), ix, iy, iconSize, false, false);
            }
            catch (Throwable throwable) {}
        } else if (this.selected != null) {
            try {
                try {
                    iconSize = Math.max(8, Math.min(128, Integer.parseInt(this.iconSizeBox.method_1882().trim())));
                }
                catch (Exception e) {
                    iconSize = 42;
                }
                ix = px + (pv - iconSize) / 2;
                iy = py + (pv - iconSize) / 2;
                QuestIconRenderer.render(g, this.buildIconString(this.selected), ix, iy, iconSize, false, false);
            }
            catch (Throwable iconSize) {
                // empty catch block
            }
        }
        int colW = Math.max(60, this.rightW / 3 - 8);
        int row1Y = this.rightY + 84;
        g.method_25303(this.field_22793, "Fit  Min  Max", this.rightX, row1Y, -3355444);
        int row2Y = row1Y + 22 + 22;
        g.method_25303(this.field_22793, "Spin  Bob  Bob Speed", this.rightX, row2Y, -3355444);
        int helpY = row2Y + 26;
        g.method_25303(this.field_22793, "Help:", this.rightX, helpY, -5592321);
        g.method_25303(this.field_22793, "- Icon px: matches graph icon size (node*0.65)", this.rightX, helpY + 12, -7829368);
        super.method_25394(g, mx, my, p);
    }
}

