/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.NewThemeEditorScreen;
import org.texboobcat.questory.client.gui.QuestIconRenderer;

class IconPickerScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<String> onOk;
    private String initial;
    private class_342 pathBox;
    private class_342 tileBox;
    private class_342 colorBox;
    private class_342 searchBox;
    private List<class_2960> resources = new ArrayList<class_2960>();
    private List<class_2960> filtered = new ArrayList<class_2960>();
    private List<String> availableNamespaces = new ArrayList<String>();
    private int listScroll = 0;
    private int namespaceScroll = 0;
    private String nsFilter = "all";
    private class_2960 selectedRL = null;
    private boolean seqMode = false;
    private class_4185 seqToggleBtn;
    private class_342 intervalBox;
    private class_4185 addCurrentBtn;
    private class_4185 addFromPathBtn;
    private class_4185 removeLastBtn;
    private class_4185 clearBtn;
    private List<String> frames = new ArrayList<String>();
    private static final int PAD = 12;
    private static final int TOP_H = 24;
    private static final int BOTTOM_H = 34;
    private int browserX;
    private int browserY;
    private int browserW;
    private int browserH;
    private int rightX;
    private int rightY;
    private int rightW;
    private int rightH;

    protected IconPickerScreen(class_437 parent, String seed, Consumer<String> onOk) {
        super((class_2561)class_2561.method_43470((String)"Icon Browser"));
        this.parent = parent;
        this.initial = seed == null ? "" : seed;
        this.onOk = onOk;
    }

    protected void method_25426() {
        super.method_25426();
        this.browserX = 12;
        this.browserY = 82;
        this.browserW = (int)((double)(this.field_22789 - 36) * 0.6);
        this.browserH = this.field_22790 - this.browserY - 34 - 12;
        this.rightX = this.browserX + this.browserW + 12;
        this.rightY = 36;
        this.rightW = this.field_22789 - this.rightX - 12;
        this.rightH = this.field_22790 - this.rightY - 34 - 12;
        this.searchBox = new class_342(this.field_22793, this.browserX, 36, this.browserW, 18, (class_2561)class_2561.method_43470((String)"Search textures..."));
        this.searchBox.method_1880(200);
        this.searchBox.method_1852("");
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Type to filter textures..."));
        this.method_37063((class_364)this.searchBox);
        int fy = this.rightY + 110;
        this.pathBox = new class_342(this.field_22793, this.rightX, fy, this.rightW, 18, (class_2561)class_2561.method_43470((String)"Path"));
        this.pathBox.method_1880(500);
        this.pathBox.method_1852(IconPickerScreen.extractPath(this.initial));
        this.pathBox.method_47404((class_2561)class_2561.method_43470((String)"namespace:path or item:id or tag:id"));
        this.method_37063((class_364)this.pathBox);
        this.tileBox = new class_342(this.field_22793, this.rightX, fy += 24, (this.rightW - 4) / 2, 18, (class_2561)class_2561.method_43470((String)"tile_size"));
        this.tileBox.method_1880(10);
        this.tileBox.method_1852(IconPickerScreen.extractModifier(this.initial, "tile_size"));
        this.tileBox.method_47404((class_2561)class_2561.method_43470((String)"Optional tile size"));
        this.method_37063((class_364)this.tileBox);
        this.colorBox = new class_342(this.field_22793, this.rightX + (this.rightW + 4) / 2, fy, (this.rightW - 4) / 2, 18, (class_2561)class_2561.method_43470((String)"color"));
        this.colorBox.method_1880(20);
        this.colorBox.method_1852(IconPickerScreen.extractModifier(this.initial, "color"));
        this.colorBox.method_47404((class_2561)class_2561.method_43470((String)"Optional tint #AARRGGBB"));
        this.method_37063((class_364)this.colorBox);
        int seqY = this.rightY + 86;
        this.seqToggleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sequence: Off"), b -> {
            this.seqMode = !this.seqMode;
            this.seqToggleBtn.method_25355((class_2561)class_2561.method_43470((String)(this.seqMode ? "Sequence: On" : "Sequence: Off")));
        }).method_46434(this.rightX, seqY, 120, 18).method_46431();
        this.method_37063((class_364)this.seqToggleBtn);
        this.intervalBox = new class_342(this.field_22793, this.rightX + 126, seqY, 40, 18, (class_2561)class_2561.method_43470((String)"ticks"));
        this.intervalBox.method_1852("20");
        try {
            this.intervalBox.method_47404((class_2561)class_2561.method_43470((String)"ticks"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_37063((class_364)this.intervalBox);
        this.addCurrentBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+Current"), b -> {
            if (this.selectedRL != null) {
                this.frames.add("texture:" + this.selectedRL.method_12836() + ":" + this.selectedRL.method_12832());
            }
        }).method_46434(this.rightX + 170, seqY, 68, 18).method_46431();
        this.method_37063((class_364)this.addCurrentBtn);
        this.addFromPathBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+Path"), b -> {
            String p = IconPickerScreen.extractPath(this.pathBox.method_1882().trim());
            if (!p.isEmpty()) {
                Object s = p.startsWith("texture:") ? p : "texture:" + p;
                this.frames.add((String)s);
            }
        }).method_46434(this.rightX + 240, seqY, 44, 18).method_46431();
        this.removeLastBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-Last"), b -> {
            if (!this.frames.isEmpty()) {
                this.frames.remove(this.frames.size() - 1);
            }
        }).method_46434(this.rightX + 288, seqY, 44, 18).method_46431();
        this.method_37063((class_364)this.removeLastBtn);
        this.clearBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear"), b -> this.frames.clear()).method_46434(this.rightX + 336, seqY, 44, 18).method_46431();
        this.method_37063((class_364)this.clearBtn);
        int bx = this.field_22789 / 2 - 60;
        int by = this.field_22790 - 34 + 6;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"OK"), b -> {
            String result;
            if (this.seqMode && !this.frames.isEmpty()) {
                int interval;
                try {
                    interval = Math.max(1, Integer.parseInt(this.intervalBox.method_1882().trim()));
                }
                catch (Exception e) {
                    interval = 20;
                }
                StringBuilder sb = new StringBuilder("rotate:").append(interval).append('|');
                for (int i = 0; i < this.frames.size(); ++i) {
                    if (i > 0) {
                        sb.append('|');
                    }
                    sb.append(this.frames.get(i));
                }
                result = sb.toString();
            } else {
                result = this.build();
            }
            if (!this.validateResource(result) && this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7eWarning: texture not found"));
            }
            this.onOk.accept(result);
            this.field_22787.method_1507(this.parent);
        }).method_46434(bx, by, 56, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(bx + 60, by, 56, 20).method_46431());
        this.loadResources();
        this.updateFiltered();
    }

    private void loadResources() {
        try {
            class_3300 rm = class_310.method_1551().method_1478();
            Map map = rm.method_14488("textures", rl -> rl.method_12832().endsWith(".png"));
            this.resources = new ArrayList(map.keySet());
            Collections.sort(this.resources, (a, b) -> a.toString().compareTo(b.toString()));
            HashSet<String> namespaces = new HashSet<String>();
            for (class_2960 rl2 : this.resources) {
                namespaces.add(rl2.method_12836());
            }
            this.availableNamespaces = new ArrayList<String>(namespaces);
            Collections.sort(this.availableNamespaces);
            this.availableNamespaces.remove("minecraft");
            this.availableNamespaces.remove("ftbquests");
            this.availableNamespaces.add(0, "minecraft");
            if (namespaces.contains("ftbquests")) {
                this.availableNamespaces.add(1, "ftbquests");
            }
        }
        catch (Throwable t) {
            this.resources = Collections.emptyList();
            this.availableNamespaces = List.of("minecraft");
        }
    }

    private void updateFiltered() {
        this.filtered.clear();
        String q = this.searchBox == null ? "" : this.searchBox.method_1882().trim().toLowerCase();
        for (class_2960 rl : this.resources) {
            boolean qok;
            boolean bl = qok = q.isEmpty() || rl.toString().toLowerCase().contains(q);
            if (!qok) continue;
            String ns = rl.method_12836();
            boolean nsok = this.nsFilter.equals("all") || ns.equals(this.nsFilter);
            if (!nsok) continue;
            this.filtered.add(rl);
        }
        this.listScroll = 0;
    }

    private boolean validateResource(String value) {
        try {
            String v = value.trim();
            if (v.isEmpty() || v.startsWith("item:") || v.startsWith("tag:") || v.equals("builtin")) {
                return true;
            }
            String rlStr = IconPickerScreen.extractPath(v);
            class_2960 rl = new class_2960(rlStr);
            class_3300 rm = class_310.method_1551().method_1478();
            Optional opt = rm.method_14486(rl);
            if (opt.isPresent()) {
                return true;
            }
            if (!rl.method_12832().startsWith("textures/")) {
                rl = new class_2960(rl.method_12836(), "textures/" + rl.method_12832());
                return rm.method_14486(rl).isPresent();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String build() {
        String c;
        String p = this.pathBox.method_1882().trim();
        ArrayList<CallSite> mods = new ArrayList<CallSite>();
        String t = this.tileBox.method_1882().trim();
        if (!t.isEmpty()) {
            mods.add((CallSite)((Object)("tile_size=" + t)));
        }
        if (!(c = this.colorBox.method_1882().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("color=" + c)));
        }
        if (mods.isEmpty()) {
            return p;
        }
        StringBuilder sb = new StringBuilder(p);
        for (String string : mods) {
            sb.append("; ").append(string);
        }
        return sb.toString();
    }

    private static String extractPath(String s) {
        if (s == null) {
            return "";
        }
        int semi = s.indexOf(59);
        return semi < 0 ? s.trim() : s.substring(0, semi).trim();
    }

    private static String extractModifier(String s, String k) {
        if (s == null) {
            return "";
        }
        int idx = s.indexOf(k + "=");
        if (idx < 0) {
            return "";
        }
        String sub = s.substring(idx + k.length() + 1).trim();
        int semi = sub.indexOf(59);
        return (semi < 0 ? sub : sub.substring(0, semi)).trim();
    }

    public void method_25394(class_332 g, int mx, int my, float p) {
        block26: {
            String ns;
            int btnW;
            this.method_25420(g);
            g.method_27535(this.field_22793, this.field_22785, 12, 12, -1);
            if (this.searchBox != null && this.method_25399() == this.searchBox) {
                String q = this.searchBox.method_1882().trim().toLowerCase();
                this.updateFiltered();
            }
            int tabsY = 58;
            int tabsH = 18;
            int tabsX = this.browserX;
            int tabsW = this.browserW;
            g.method_25294(tabsX, tabsY, tabsX + tabsW, tabsY + tabsH, -15066598);
            int btnX = tabsX + 2 - this.namespaceScroll;
            g.method_25294(btnX, tabsY, btnX + 40, tabsY + tabsH, this.nsFilter.equals("all") ? -12952966 : -14013910);
            g.method_25303(this.field_22793, "All", btnX + 4, tabsY + 5, -1);
            btnX += 44;
            Iterator<String> iterator = this.availableNamespaces.iterator();
            while (iterator.hasNext() && btnX + (btnW = this.field_22793.method_1727(ns = iterator.next()) + 8) <= tabsX + tabsW + this.namespaceScroll) {
                if (btnX >= tabsX) {
                    g.method_25294(btnX, tabsY, btnX + btnW, tabsY + tabsH, this.nsFilter.equals(ns) ? -12952966 : -14013910);
                    g.method_25303(this.field_22793, ns, btnX + 4, tabsY + 5, -1);
                }
                btnX += btnW + 4;
            }
            if (this.namespaceScroll > 0) {
                g.method_25303(this.field_22793, "\u25c0", tabsX + 2, tabsY + 5, -22016);
            }
            if (btnX > tabsX + tabsW + this.namespaceScroll) {
                g.method_25303(this.field_22793, "\u25b6", tabsX + tabsW - 12, tabsY + 5, -22016);
            }
            g.method_25294(this.browserX, this.browserY, this.browserX + this.browserW, this.browserY + this.browserH, -535818224);
            int lineH = 18;
            int visibleLines = Math.max(1, this.browserH / lineH);
            int maxScroll = Math.max(0, this.filtered.size() - visibleLines);
            this.listScroll = Math.max(0, Math.min(this.listScroll, maxScroll));
            g.method_44379(this.browserX, this.browserY, this.browserX + this.browserW, this.browserY + this.browserH);
            for (int i = 0; i < visibleLines && this.listScroll + i < this.filtered.size(); ++i) {
                class_2960 rl = this.filtered.get(this.listScroll + i);
                int y = this.browserY + i * lineH;
                boolean hover = mx >= this.browserX && mx <= this.browserX + this.browserW && my >= y && my < y + lineH;
                boolean selected = rl.equals((Object)this.selectedRL);
                if (selected) {
                    g.method_25294(this.browserX, y, this.browserX + this.browserW, y + lineH, -12952966);
                } else if (hover) {
                    g.method_25294(this.browserX, y, this.browserX + this.browserW, y + lineH, -14013910);
                }
                try {
                    g.method_25290(rl, this.browserX + 2, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Object txt = rl.toString();
                if (this.field_22793.method_1727((String)txt) > this.browserW - 24) {
                    txt = ((String)txt).substring(0, Math.max(0, (this.browserW - 24) / 6)) + "...";
                }
                g.method_25303(this.field_22793, (String)txt, this.browserX + 22, y + 5, -1);
            }
            g.method_44380();
            g.method_25294(this.rightX, this.rightY, this.rightX + this.rightW, this.rightY + this.rightH, -535818224);
            g.method_25303(this.field_22793, "Preview:", this.rightX + 4, this.rightY + 4, -5592321);
            if (this.selectedRL != null || this.seqMode && !this.frames.isEmpty()) {
                int px = this.rightX + this.rightW / 2 - 32;
                int py = this.rightY + 24;
                try {
                    g.method_25294(px - 2, py - 2, px + 66, py + 66, -12566464);
                    if (this.seqMode && !this.frames.isEmpty()) {
                        int interval;
                        try {
                            interval = Math.max(1, Integer.parseInt(this.intervalBox.method_1882().trim()));
                        }
                        catch (Exception e) {
                            interval = 20;
                        }
                        StringBuilder sb = new StringBuilder("rotate:").append(interval).append('|');
                        for (int i = 0; i < this.frames.size(); ++i) {
                            if (i > 0) {
                                sb.append('|');
                            }
                            sb.append(this.frames.get(i));
                        }
                        QuestIconRenderer.render(g, sb.toString(), px, py, 64, false, false);
                        break block26;
                    }
                    if (this.selectedRL != null) {
                        g.method_25290(this.selectedRL, px, py, 0.0f, 0.0f, 64, 64, 64, 64);
                    }
                }
                catch (Throwable interval) {
                    // empty catch block
                }
            }
        }
        int recentY = this.rightY + 100;
        g.method_25303(this.field_22793, "Recent:", this.rightX + 4, recentY, -5592321);
        List<String> rec = NewThemeEditorScreen.getRecentIconsSnapshot();
        int ry = recentY + 12;
        for (int i = 0; i < Math.min(5, rec.size()); ++i) {
            Object s = rec.get(i);
            if (this.field_22793.method_1727((String)s) > this.rightW - 8) {
                s = ((String)s).substring(0, Math.max(0, (this.rightW - 8) / 6)) + "...";
            }
            g.method_25303(this.field_22793, (String)s, this.rightX + 6, ry, -3355444);
            ry += 10;
        }
        if (this.seqMode) {
            int ly = recentY + 70;
            g.method_25303(this.field_22793, "Frames:", this.rightX + 4, ly, -5592321);
            int shown = Math.min(this.frames.size(), Math.max(2, (this.rightH - ((ly += 12) - this.rightY) - 40) / 10));
            for (int i = 0; i < shown; ++i) {
                Object s = this.frames.get(i);
                if (this.field_22793.method_1727((String)s) > this.rightW - 8) {
                    s = ((String)s).substring(0, Math.max(0, (this.rightW - 8) / 6)) + "...";
                }
                g.method_25303(this.field_22793, i + 1 + ". " + (String)s, this.rightX + 6, ly, -3355444);
                ly += 10;
            }
        }
        super.method_25394(g, mx, my, p);
    }

    public boolean method_25402(double mx, double my, int btn) {
        int lineH;
        int row;
        int idx;
        int tabsY = 58;
        int tabsH = 18;
        if (my >= (double)tabsY && my <= (double)(tabsY + tabsH) && mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW)) {
            int btnX = this.browserX + 2 - this.namespaceScroll;
            if (mx >= (double)btnX && mx <= (double)(btnX + 40)) {
                this.nsFilter = "all";
                this.updateFiltered();
                return true;
            }
            btnX += 44;
            for (String ns : this.availableNamespaces) {
                int btnW = this.field_22793.method_1727(ns) + 8;
                if (btnX >= this.browserX && mx >= (double)btnX && mx <= (double)(btnX + btnW)) {
                    this.nsFilter = ns;
                    this.updateFiltered();
                    return true;
                }
                btnX += btnW + 4;
            }
        }
        if (mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW) && my >= (double)this.browserY && my <= (double)(this.browserY + this.browserH) && (idx = this.listScroll + (row = (int)((my - (double)this.browserY) / (double)(lineH = 18)))) >= 0 && idx < this.filtered.size()) {
            this.selectedRL = this.filtered.get(idx);
            this.pathBox.method_1852(this.selectedRL.method_12836() + ":" + this.selectedRL.method_12832());
            return true;
        }
        return super.method_25402(mx, my, btn);
    }

    public boolean method_25401(double mx, double my, double d) {
        int tabsY = 58;
        int tabsH = 18;
        if (my >= (double)tabsY && my <= (double)(tabsY + tabsH) && mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW)) {
            this.namespaceScroll = (int)Math.max(0.0, (double)this.namespaceScroll - Math.signum(d) * 20.0);
            return true;
        }
        if (mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW) && my >= (double)this.browserY && my <= (double)(this.browserY + this.browserH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(d) * 3.0);
            return true;
        }
        return super.method_25401(mx, my, d);
    }

    public boolean method_25421() {
        return false;
    }
}

