/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.rendering;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_332;
import org.texboobcat.questory.client.rendering.ShapeTessellator;
import org.texboobcat.questory.shape.ShapeDef;
import org.texboobcat.questory.shape.ShapeRegistry;

public class CustomShapeRenderer {
    private static final Map<String, boolean[]> MASK_CACHE = new HashMap<String, boolean[]>();
    private static final Map<String, ShapeTessellator.Mesh> MESH_CACHE = new HashMap<String, ShapeTessellator.Mesh>();

    private static String cacheKey(ShapeDef def, int size) {
        return def.id + "#" + def.version + "#" + def.paths.size() + "@" + size;
    }

    private static String meshKey(ShapeDef def) {
        return def.id + "#" + def.version + "#" + def.paths.size();
    }

    private static ShapeTessellator.Mesh getMesh(ShapeDef def) {
        String key = CustomShapeRenderer.meshKey(def);
        ShapeTessellator.Mesh m = MESH_CACHE.get(key);
        if (m != null) {
            return m;
        }
        m = ShapeTessellator.buildMesh(def);
        if (m != null) {
            MESH_CACHE.put(key, m);
        }
        return m;
    }

    public static void drawOutsideMask(ShapeDef def, class_332 g, int shapeX, int shapeY, int size, int regionX, int regionY, int regionW, int regionH, int color) {
        if (def == null || regionW <= 0 || regionH <= 0) {
            return;
        }
        boolean[] mask = CustomShapeRenderer.getMask(def, shapeX, shapeY, size);
        for (int py = 0; py < regionH; ++py) {
            int sy = regionY + py;
            if (sy < shapeY || sy >= shapeY + size) continue;
            for (int px = 0; px < regionW; ++px) {
                boolean inside;
                int sx = regionX + px;
                if (sx < shapeX || sx >= shapeX + size || (inside = mask[(sy - shapeY) * size + (sx - shapeX)])) continue;
                g.method_25294(sx, sy, sx + 1, sy + 1, color);
            }
        }
    }

    private static boolean[] getMask(ShapeDef def, int x, int y, int size) {
        String key = CustomShapeRenderer.cacheKey(def, size);
        boolean[] mask = MASK_CACHE.get(key);
        if (mask != null) {
            return mask;
        }
        mask = new boolean[size * size];
        int idx = 0;
        for (int py = 0; py < size; ++py) {
            for (int px = 0; px < size; ++px) {
                mask[idx++] = CustomShapeRenderer.contains(def, x, y, size, x + px, y + py);
            }
        }
        MASK_CACHE.put(key, mask);
        return mask;
    }

    public static void draw(ShapeDef def, class_332 g, int x, int y, int size, int argb) {
        ShapeRegistry.initIfNeeded();
        if (def == null) {
            return;
        }
        ShapeTessellator.Mesh mesh = CustomShapeRenderer.getMesh(def);
        if (mesh != null) {
            ShapeTessellator.drawMesh(g, mesh, x, y, size, argb);
        } else {
            boolean[] mask = CustomShapeRenderer.getMask(def, x, y, size);
            int idx = 0;
            for (int py = 0; py < size; ++py) {
                int px = 0;
                while (px < size) {
                    if (mask[idx]) {
                        g.method_25294(x + px, y + py, x + px + 1, y + py + 1, argb);
                    }
                    ++px;
                    ++idx;
                }
            }
        }
    }

    public static boolean contains(ShapeDef def, int x, int y, int size, int pointX, int pointY) {
        if (def == null) {
            return false;
        }
        double u = (double)(pointX - x) / (double)size;
        double v = (double)(pointY - y) / (double)size;
        double vx = def.viewBox[0];
        double vy = def.viewBox[1];
        double vw = def.viewBox[2];
        double vh = def.viewBox[3];
        double sx = vx + u * vw;
        double sy = vy + v * vh;
        boolean inside = false;
        for (ShapeDef.Path p : def.paths) {
            if (!p.fill || !CustomShapeRenderer.pathContains(p, sx, sy)) continue;
            inside = !inside;
        }
        return inside;
    }

    private static boolean pathContains(ShapeDef.Path p, double sx, double sy) {
        String t;
        switch (t = p.type == null ? "polygon" : p.type.toLowerCase()) {
            case "circle": {
                double cx = p.num.getOrDefault("cx", 0.5);
                double cy = p.num.getOrDefault("cy", 0.5);
                double r = p.num.getOrDefault("r", 0.5);
                double dx = sx - cx;
                double dy = sy - cy;
                return dx * dx + dy * dy <= r * r;
            }
            case "ellipse": {
                double cx = p.num.getOrDefault("cx", 0.5);
                double cy = p.num.getOrDefault("cy", 0.5);
                double rx = p.num.getOrDefault("rx", 0.5);
                double ry = p.num.getOrDefault("ry", 0.3);
                double dx = (sx - cx) / Math.max(1.0E-6, rx);
                double dy = (sy - cy) / Math.max(1.0E-6, ry);
                return dx * dx + dy * dy <= 1.0;
            }
            case "rounded_rect": {
                double rx = p.num.getOrDefault("rx", 0.1);
                double ry = p.num.getOrDefault("ry", rx);
                double px = p.num.getOrDefault("x", 0.1);
                double py = p.num.getOrDefault("y", 0.1);
                double w = p.num.getOrDefault("w", 0.8);
                double h = p.num.getOrDefault("h", 0.8);
                double left = px;
                double right = px + w;
                double top = py;
                double bottom = py + h;
                if (sx >= left + rx && sx <= right - rx && sy >= top && sy <= bottom) {
                    return true;
                }
                if (sy >= top + ry && sy <= bottom - ry && sx >= left && sx <= right) {
                    return true;
                }
                double cx = sx < left + rx ? left + rx : right - rx;
                double cy = sy < top + ry ? top + ry : bottom - ry;
                double dx = (sx - cx) / Math.max(1.0E-6, rx);
                double dy = (sy - cy) / Math.max(1.0E-6, ry);
                return dx * dx + dy * dy <= 1.0;
            }
            case "star": {
                int points = (int)Math.round(p.num.getOrDefault("points", 5.0));
                double cx = p.num.getOrDefault("cx", 0.5);
                double cy = p.num.getOrDefault("cy", 0.5);
                double innerR = p.num.getOrDefault("innerR", 0.25);
                double outerR = p.num.getOrDefault("outerR", 0.48);
                double rot = Math.toRadians(p.num.getOrDefault("rotation", -90.0));
                double dx = sx - cx;
                double dy = sy - cy;
                double ang = Math.atan2(dy, dx) - rot;
                double dist = Math.hypot(dx, dy);
                double seg = Math.PI * 2 / (double)(points * 2);
                double mod = ang % (seg * 2.0);
                if (mod < 0.0) {
                    mod += seg * 2.0;
                }
                boolean outer = mod < seg;
                double fracStar = mod % seg / seg;
                double maxR = outer ? outerR + (innerR - outerR) * fracStar : innerR + (outerR - innerR) * fracStar;
                return dist <= maxR;
            }
            case "gear": {
                double phase;
                double lobe;
                double rMax;
                double period;
                int teeth = (int)Math.round(p.num.getOrDefault("teeth", 8.0));
                double cx = p.num.getOrDefault("cx", 0.5);
                double cy = p.num.getOrDefault("cy", 0.5);
                double innerR = p.num.getOrDefault("innerR", 0.28);
                double outerR = p.num.getOrDefault("outerR", 0.48);
                double dx = sx - cx;
                double dy = sy - cy;
                double dist = Math.hypot(dx, dy);
                if (dist > outerR) {
                    return false;
                }
                double angle = Math.atan2(dy, dx);
                double a = angle % (period = Math.PI * 2 / (double)Math.max(3, teeth));
                if (a < 0.0) {
                    a += period;
                }
                return dist <= (rMax = innerR + (outerR - innerR) * Math.pow(lobe = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (phase = a / period))), 0.55));
            }
        }
        List<Double> pts = p.points;
        int n = pts.size() / 2;
        if (n < 3) {
            return false;
        }
        boolean inside = false;
        int i = 0;
        int j = n - 1;
        while (i < n) {
            boolean intersect;
            double xi = pts.get(2 * i);
            double yi = pts.get(2 * i + 1);
            double xj = pts.get(2 * j);
            double yj = pts.get(2 * j + 1);
            boolean bl = intersect = yi > sy != yj > sy && sx < (xj - xi) * (sy - yi) / Math.max(1.0E-9, yj - yi) + xi;
            if (intersect) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public static void drawShadeOverlay(ShapeDef def, class_332 g, int x, int y, int size, String mode, String direction, double strength, int tintColor) {
        if (def == null) {
            return;
        }
        if (mode == null) {
            mode = "linear";
        }
        if (direction == null) {
            direction = "down_right";
        }
        if (strength <= 0.0) {
            return;
        }
        int halfSize = size / 2;
        double maxAlpha = Math.max(0.0, Math.min(1.0, strength)) * 140.0;
        int tint = tintColor;
        int denom = Math.max(1, size - 1);
        double normDiag = Math.sqrt(0.5);
        boolean[] mask = CustomShapeRenderer.getMask(def, x, y, size);
        int idx = 0;
        for (int py = 0; py < size; ++py) {
            int px = 0;
            while (px < size) {
                if (mask[idx]) {
                    double t;
                    double u = (double)px / (double)denom;
                    double v = (double)py / (double)denom;
                    if ("radial".equalsIgnoreCase(mode)) {
                        double rx = u - 0.5;
                        double ry = v - 0.5;
                        t = Math.sqrt(rx * rx + ry * ry) / normDiag;
                    } else {
                        switch (direction.toLowerCase(Locale.ROOT)) {
                            case "down": {
                                t = v;
                                break;
                            }
                            case "right": {
                                t = u;
                                break;
                            }
                            case "up": {
                                t = 1.0 - v;
                                break;
                            }
                            case "left": {
                                t = 1.0 - u;
                                break;
                            }
                            case "up_right": {
                                t = (u - v + 1.0) / 2.0;
                                break;
                            }
                            case "down_left": {
                                t = (v - u + 1.0) / 2.0;
                                break;
                            }
                            case "up_left": {
                                t = 1.0 - (u + v) / 2.0;
                                break;
                            }
                            default: {
                                t = (u + v) / 2.0;
                            }
                        }
                    }
                    if (t < 0.0) {
                        t = 0.0;
                    } else if (t > 1.0) {
                        t = 1.0;
                    }
                    int a = (int)Math.round(maxAlpha * t) & 0xFF;
                    if (a > 0) {
                        int argb = a << 24 | tint & 0xFFFFFF;
                        g.method_25294(x + px, y + py, x + px + 1, y + py + 1, argb);
                    }
                }
                ++px;
                ++idx;
            }
        }
    }

    public static void drawOutline(ShapeDef def, class_332 g, int x, int y, int size, int color, int thickness) {
        if (def == null) {
            return;
        }
        thickness = Math.max(1, thickness);
        boolean[] mask = CustomShapeRenderer.getMask(def, x, y, size);
        for (int py = -thickness; py < size + thickness; ++py) {
            for (int px = -thickness; px < size + thickness; ++px) {
                boolean isInside;
                int sx = x + px;
                int sy = y + py;
                boolean bl = isInside = sx >= x && sx < x + size && sy >= y && sy < y + size && mask[(sy - y) * size + (sx - x)];
                if (isInside) continue;
                boolean hasInsideNeighbor = false;
                for (int dy = -thickness; dy <= thickness && !hasInsideNeighbor; ++dy) {
                    for (int dx = -thickness; dx <= thickness && !hasInsideNeighbor; ++dx) {
                        if (dx == 0 && dy == 0) continue;
                        int nx = sx + dx;
                        int ny = sy + dy;
                        if (nx < x || nx >= x + size || ny < y || ny >= y + size || !mask[(ny - y) * size + (nx - x)]) continue;
                        hasInsideNeighbor = true;
                    }
                }
                if (!hasInsideNeighbor) continue;
                g.method_25294(sx, sy, sx + 1, sy + 1, color);
            }
        }
    }
}

