/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.manager;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.api.events.QuestCompletedEvent;
import org.texboobcat.questory.api.events.QuestEventBus;
import org.texboobcat.questory.api.events.QuestProgressEvent;
import org.texboobcat.questory.api.events.QuestStartedEvent;
import org.texboobcat.questory.api.events.QuestUnlockedEvent;
import org.texboobcat.questory.api.events.RewardClaimedEvent;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.events.QuestNotifications;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.network.ChapterDataSyncPacket;
import org.texboobcat.questory.network.ConfigSyncPacket;
import org.texboobcat.questory.network.DailyDataSyncPacket;
import org.texboobcat.questory.network.GroupTreeSyncPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.network.QuestSyncPacket;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CurrencyRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.GroupNode;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.storage.PlayerProgressStorage;
import org.texboobcat.questory.storage.QuestStorage;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;
import org.texboobcat.questory.team.TeamQuestHelper;

public class QuestManager {
    private static QuestManager instance;
    private final Map<String, Quest> quests;
    private final QuestStorage questStorage;
    private PlayerProgressStorage progressStorage;
    private final Map<String, List<String>> questGroups;
    private Map<String, ChapterData> chaptersByGroup;
    private GroupNode groupTree;
    private final Map<UUID, Set<String>> notifiedCompletableQuests;
    private Set<String> cachedRequiredStatistics = null;
    private List<QuestRequirementRef> observationReqs = new ArrayList<QuestRequirementRef>();
    private boolean hasObservationRequirements = false;

    private QuestManager(Path dataPath) {
        this.quests = new HashMap<String, Quest>();
        this.questStorage = new QuestStorage(dataPath);
        this.progressStorage = new PlayerProgressStorage(dataPath);
        this.questGroups = new HashMap<String, List<String>>();
        this.notifiedCompletableQuests = new HashMap<UUID, Set<String>>();
        this.chaptersByGroup = new HashMap<String, ChapterData>();
        this.groupTree = null;
    }

    public void trackFluidProgress(UUID playerId, String fluidId, long amount) {
        this.trackFluidProgress(playerId, fluidId, amount, null);
    }

    public void trackFluidProgress(UUID playerId, String fluidId, long amount, class_3222 player) {
        if (amount <= 0L) {
            return;
        }
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            QuestProgress progress;
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                FluidRequirement fr;
                if (!(req instanceof FluidRequirement) || !(fr = (FluidRequirement)req).getFluidId().equals(fluidId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                long cap = Math.min(Integer.MAX_VALUE, Math.max(0L, fr.getAmount()));
                long next = Math.min(cap, (long)old + Math.max(1L, amount));
                progress.setRequirementProgress(quest.getId(), req, (int)next);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (isTeamQuest && player != null) {
                    try {
                        UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                        if (teamId != null) {
                            TeamManager.getInstance().saveTeamProgress(teamId);
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.progressStorage.saveProgress(progress);
                }
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        if (player != null && !updatedQuests.isEmpty()) {
            for (String qid : updatedQuests) {
                QuestProgress toSync;
                Quest q = this.getQuest(qid);
                if (q == null) continue;
                boolean isTeamQuest = false;
                try {
                    QuestoryConfig cfg = QuestoryConfig.getInstance();
                    isTeamQuest = cfg.teamSystemEnabled && q.getTeamSettings() != null && q.getTeamSettings().isTeamEnabled();
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
                if ((toSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), q) : this.getProgress(player.method_5667())) == null) continue;
                NetworkManager.sendToClient(player, new ProgressSyncPacket(toSync));
            }
            this.checkAndNotifyCompletableQuests(player, this.getProgress(player.method_5667()), updatedQuests);
        }
    }

    public void trackEnergyProgress(UUID playerId, long amount) {
        this.trackEnergyProgress(playerId, amount, null);
    }

    public void trackEnergyProgress(UUID playerId, long amount, class_3222 player) {
        if (amount <= 0L) {
            return;
        }
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            QuestProgress progress;
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                if (!(req instanceof EnergyRequirement)) continue;
                EnergyRequirement er = (EnergyRequirement)req;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                long cap = Math.min(Integer.MAX_VALUE, Math.max(0L, er.getAmount()));
                long next = Math.min(cap, (long)old + Math.max(1L, amount));
                progress.setRequirementProgress(quest.getId(), req, (int)next);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (isTeamQuest && player != null) {
                    try {
                        UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                        if (teamId != null) {
                            TeamManager.getInstance().saveTeamProgress(teamId);
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.progressStorage.saveProgress(progress);
                }
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        if (player != null && !updatedQuests.isEmpty()) {
            for (String qid : updatedQuests) {
                QuestProgress toSync;
                Quest q = this.getQuest(qid);
                if (q == null) continue;
                boolean isTeamQuest = false;
                try {
                    QuestoryConfig cfg = QuestoryConfig.getInstance();
                    isTeamQuest = cfg.teamSystemEnabled && q.getTeamSettings() != null && q.getTeamSettings().isTeamEnabled();
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
                if ((toSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), q) : this.getProgress(player.method_5667())) == null) continue;
                NetworkManager.sendToClient(player, new ProgressSyncPacket(toSync));
            }
            this.checkAndNotifyCompletableQuests(player, this.getProgress(player.method_5667()), updatedQuests);
        }
    }

    private boolean hasAnyProgress(QuestProgress progress, Quest quest) {
        if (quest == null) {
            return false;
        }
        for (Requirement r : quest.getRequirements()) {
            if (progress.getRequirementProgress(quest.getId(), r) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void initialize(Path dataPath) {
        if (instance == null) {
            instance = new QuestManager(dataPath);
            instance.loadAll();
        }
    }

    private static String normalizeStatId(String id) {
        if (id == null) {
            return "";
        }
        Object s = id.trim().toLowerCase(Locale.ROOT);
        if (((String)s).isEmpty()) {
            return s;
        }
        if (!((String)s).contains(":")) {
            s = "minecraft:" + (String)s;
        }
        return s;
    }

    public static QuestManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("QuestManager not initialized!");
        }
        return instance;
    }

    public void reinitializeProgressStorage(Path worldDataPath) {
        System.out.println("[Questory] Reinitializing progress storage for world: " + String.valueOf(worldDataPath));
        if (this.progressStorage != null) {
            this.progressStorage.saveAll();
            this.progressStorage.clearCache();
        }
        this.progressStorage = new PlayerProgressStorage(worldDataPath);
        this.notifiedCompletableQuests.clear();
        System.out.println("[Questory] Progress storage reinitialized successfully");
    }

    public void loadAll() {
        this.quests.clear();
        this.questGroups.clear();
        this.cachedRequiredStatistics = null;
        Map<String, Quest> loadedQuests = this.questStorage.loadAllQuests();
        this.quests.putAll(loadedQuests);
        for (Quest quest : this.quests.values()) {
            String group = quest.getGroup();
            this.questGroups.computeIfAbsent(group, k -> new ArrayList()).add(quest.getId());
        }
        this.chaptersByGroup.clear();
        Map<String, ChapterData> loadedChapters = this.questStorage.loadAllChapters();
        this.chaptersByGroup.putAll(loadedChapters);
        try {
            GroupNode gt;
            this.groupTree = gt = this.questStorage.loadGroupTree();
            if (gt != null) {
                System.out.println("[Questory] Loaded group tree with " + gt.getChildren().size() + " top-level sections");
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to load group tree: " + t.getMessage());
        }
        if (this.quests.isEmpty()) {
            System.out.println("No quests found, creating example quest...");
            this.questStorage.createExampleQuest();
            this.loadAll();
        }
        System.out.println("Quest system loaded: " + this.quests.size() + " quests in " + this.questGroups.size() + " groups");
        this.rebuildRequirementIndices();
    }

    public Set<String> getRequiredStatistics() {
        if (this.cachedRequiredStatistics == null) {
            this.cachedRequiredStatistics = new HashSet<String>();
            for (Quest quest : this.quests.values()) {
                for (Requirement req : quest.getRequirements()) {
                    if (!(req instanceof StatisticRequirement)) continue;
                    StatisticRequirement statReq = (StatisticRequirement)req;
                    this.cachedRequiredStatistics.add(QuestManager.normalizeStatId(statReq.getStatistic()));
                }
            }
            System.out.println("[Questory] Cached " + this.cachedRequiredStatistics.size() + " required statistics from quests");
        }
        return this.cachedRequiredStatistics;
    }

    public void saveAll() {
        this.questStorage.saveAllQuests(this.quests.values());
        this.progressStorage.saveAll();
    }

    public void savePlayerProgress(QuestProgress progress) {
        if (progress != null) {
            this.progressStorage.saveProgress(progress);
        }
    }

    public void reload() {
        this.saveAll();
        this.loadAll();
    }

    public Quest getQuest(String questId) {
        return this.quests.get(questId);
    }

    public Collection<Quest> getAllQuests() {
        return new ArrayList<Quest>(this.quests.values());
    }

    public void updateQuestPosition(String questId, int x, int y) {
        Quest quest = this.quests.get(questId);
        if (quest == null) {
            return;
        }
        quest.setX(x);
        quest.setY(y);
        this.questStorage.saveQuest(quest);
    }

    public List<Quest> getQuestsByGroup(String group) {
        List<String> questIds = this.questGroups.get(group);
        if (questIds == null) {
            return Collections.emptyList();
        }
        return questIds.stream().map(this.quests::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Collection<ChapterData> getAllChapters() {
        return this.chaptersByGroup == null ? Collections.emptyList() : new ArrayList<ChapterData>(this.chaptersByGroup.values());
    }

    public GroupNode getGroupTree() {
        return this.groupTree;
    }

    public void updateChapterData(ChapterData chapter) {
        if (chapter == null || chapter.getTitle() == null || chapter.getTitle().isBlank()) {
            return;
        }
        if (this.chaptersByGroup == null) {
            this.chaptersByGroup = new HashMap<String, ChapterData>();
        }
        this.chaptersByGroup.put(chapter.getTitle(), chapter);
        this.questStorage.saveChapter(chapter);
    }

    public Set<String> getQuestGroups() {
        return new HashSet<String>(this.questGroups.keySet());
    }

    public void registerQuest(Quest quest) {
        this.quests.put(quest.getId(), quest);
        String group = quest.getGroup();
        this.questGroups.computeIfAbsent(group, k -> new ArrayList()).add(quest.getId());
        this.questStorage.saveQuest(quest);
        this.rebuildRequirementIndices();
    }

    public void unregisterQuest(String questId) {
        Quest quest = this.quests.remove(questId);
        if (quest != null) {
            String group = quest.getGroup();
            List<String> groupQuests = this.questGroups.get(group);
            if (groupQuests != null) {
                groupQuests.remove(questId);
            }
            this.questStorage.deleteQuest(questId);
        }
        this.rebuildRequirementIndices();
    }

    public void rebuildRequirementIndices() {
        ArrayList<QuestRequirementRef> obs = new ArrayList<QuestRequirementRef>();
        for (Quest q : this.quests.values()) {
            if (q == null || q.getRequirements() == null) continue;
            for (Requirement r : q.getRequirements()) {
                if (!(r instanceof ObservationRequirement)) continue;
                obs.add(new QuestRequirementRef(q, r));
            }
        }
        this.observationReqs = obs;
        this.hasObservationRequirements = !obs.isEmpty();
    }

    public List<QuestRequirementRef> getObservationRequirements() {
        return this.observationReqs;
    }

    public boolean hasObservationRequirements() {
        return this.hasObservationRequirements;
    }

    public QuestProgress getProgress(UUID playerId) {
        return this.progressStorage.getProgress(playerId);
    }

    public List<Quest> getVisibleQuests(UUID playerId) {
        QuestProgress progress = this.getProgress(playerId);
        return this.quests.values().stream().filter(q -> q.isVisible(progress)).collect(Collectors.toList());
    }

    public List<Quest> getCompletableQuests(UUID playerId) {
        QuestProgress progress = this.getProgress(playerId);
        return this.quests.values().stream().filter(q -> q.canComplete(progress) && !progress.isQuestCompleted(q.getId())).collect(Collectors.toList());
    }

    public boolean completeQuest(class_3222 player, String questId) {
        Quest quest = this.getQuest(questId);
        if (quest == null) {
            return false;
        }
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled()) {
                return TeamQuestHelper.completeTeamQuest(player, quest);
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Team completion error, falling back to solo: " + t.getMessage());
        }
        QuestProgress progress = this.getProgress(player.method_5667());
        if (progress.isQuestCompleted(questId)) {
            return false;
        }
        if (!quest.canComplete(progress)) {
            return false;
        }
        progress.completeQuest(questId);
        if (!progress.hasClaimedReward(questId)) {
            for (Reward reward : quest.getRewards()) {
                reward.grant(player);
            }
            progress.claimReward(questId);
            QuestEventBus.post(new RewardClaimedEvent(player, quest));
        }
        this.clearQuestNotification(player.method_5667(), questId);
        QuestNotifications.notifyQuestClaimed(player, quest);
        QuestEventBus.post(new QuestCompletedEvent(player, quest, progress.getCompletionTime(questId)));
        this.progressStorage.saveProgress(progress);
        NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        this.checkForNewlyUnlockedQuests(player, progress);
        try {
            DailyQuestManager.getInstance().onQuestCompleted(player, quest);
        }
        catch (Throwable t) {
            System.err.println("[Questory] DailyQuestManager onQuestCompleted error: " + t.getMessage());
        }
        return true;
    }

    private void checkForNewlyUnlockedQuests(class_3222 player, QuestProgress progress) {
        for (Quest quest : this.quests.values()) {
            Set<String> notified;
            if (progress.isQuestCompleted(quest.getId()) || !quest.isVisible(progress) || (notified = this.notifiedCompletableQuests.get(player.method_5667())) != null && notified.contains("unlocked_" + quest.getId())) continue;
            QuestNotifications.notifyQuestUnlocked(player, quest);
            QuestEventBus.post(new QuestUnlockedEvent(player, quest));
            if (notified == null) {
                notified = new HashSet<String>();
                this.notifiedCompletableQuests.put(player.method_5667(), notified);
            }
            notified.add("unlocked_" + quest.getId());
        }
    }

    public void trackItemProgress(UUID playerId, String itemId, int amount) {
        this.trackItemProgress(playerId, itemId, amount, null);
    }

    public void trackItemProgress(UUID playerId, String itemId, int amount, class_3222 player) {
        System.out.println("[Questory Debug] trackItemProgress called: playerId=" + String.valueOf(playerId) + ", itemId=" + itemId + ", amount=" + amount);
        System.out.println("[Questory Debug] Total quests loaded: " + this.quests.size());
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            QuestProgress progress;
            System.out.println("[Questory Debug] Checking quest: " + quest.getId());
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                System.out.println("[Questory Debug] Checking requirement: type=" + req.getType());
                if (!(req instanceof ItemRequirement)) continue;
                ItemRequirement itemReq = (ItemRequirement)req;
                System.out.println("[Questory Debug] ItemRequirement found: item=" + itemReq.getItem() + ", looking for=" + itemId + ", match=" + itemReq.getItem().equals(itemId));
                if (!itemReq.getItem().equals(itemId)) continue;
                int oldProgress = progress.getRequirementProgress(quest.getId(), req);
                boolean questHadAnyBefore = this.hasAnyProgress(progress, quest);
                progress.addRequirementProgress(quest.getId(), req, amount);
                int newProgress = progress.getRequirementProgress(quest.getId(), req);
                System.out.println("[Questory Debug] Updated quest " + quest.getId() + " progress from " + oldProgress + " to " + newProgress);
                updatedQuests.add(quest.getId());
                if (isTeamQuest && player != null) {
                    try {
                        UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                        if (teamId != null) {
                            TeamManager.getInstance().saveTeamProgress(teamId);
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.progressStorage.saveProgress(progress);
                }
                if (player == null || newProgress == oldProgress) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, oldProgress, newProgress));
                if (questHadAnyBefore || newProgress <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        if (player != null && !updatedQuests.isEmpty()) {
            for (String questId : updatedQuests) {
                QuestProgress progressToSync;
                Quest quest = this.getQuest(questId);
                if (quest == null) continue;
                boolean isTeamQuest = false;
                try {
                    QuestoryConfig cfg = QuestoryConfig.getInstance();
                    isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
                if ((progressToSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), quest) : this.getProgress(player.method_5667())) == null) continue;
                NetworkManager.sendToClient(player, new ProgressSyncPacket(progressToSync));
            }
        }
        if (player != null) {
            QuestProgress checkProgress = this.getProgress(player.method_5667());
            this.checkAndNotifyCompletableQuests(player, checkProgress, updatedQuests);
        }
    }

    public void trackItemTagProgress(UUID playerId, String itemId, int amount, class_3222 player) {
        block17: {
            try {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemId));
                if (item == null) {
                    return;
                }
                HashSet<String> updatedQuests = new HashSet<String>();
                for (Quest quest : this.quests.values()) {
                    QuestProgress progress;
                    boolean isTeamQuest = false;
                    try {
                        QuestoryConfig cfg = QuestoryConfig.getInstance();
                        isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
                    }
                    catch (Throwable cfg) {
                        // empty catch block
                    }
                    if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
                    for (Requirement req : quest.getRequirements()) {
                        ItemTagRequirement tagReq;
                        if (!(req instanceof ItemTagRequirement) || !(tagReq = (ItemTagRequirement)req).shouldConsume()) continue;
                        try {
                            String tagId = tagReq.getTag();
                            class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(tagId));
                            if (!item.method_40131().method_40220(key)) continue;
                            int old = progress.getRequirementProgress(quest.getId(), req);
                            boolean anyBefore = this.hasAnyProgress(progress, quest);
                            progress.addRequirementProgress(quest.getId(), req, amount);
                            int now = progress.getRequirementProgress(quest.getId(), req);
                            updatedQuests.add(quest.getId());
                            if (isTeamQuest && player != null) {
                                try {
                                    UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                                    if (teamId != null) {
                                        TeamManager.getInstance().saveTeamProgress(teamId);
                                    }
                                }
                                catch (Throwable throwable) {}
                            } else {
                                this.progressStorage.saveProgress(progress);
                            }
                            if (player == null || now == old) continue;
                            QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                            if (anyBefore || now <= 0) continue;
                            QuestEventBus.post(new QuestStartedEvent(player, quest));
                        }
                        catch (Throwable throwable) {}
                    }
                }
                if (player == null || updatedQuests.isEmpty()) break block17;
                for (String qid : updatedQuests) {
                    QuestProgress progressToSync;
                    Quest q = this.getQuest(qid);
                    if (q == null) continue;
                    boolean isTeamQuest = false;
                    try {
                        QuestoryConfig cfg = QuestoryConfig.getInstance();
                        isTeamQuest = cfg.teamSystemEnabled && q.getTeamSettings() != null && q.getTeamSettings().isTeamEnabled();
                    }
                    catch (Throwable cfg) {
                        // empty catch block
                    }
                    if ((progressToSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), q) : this.getProgress(player.method_5667())) == null) continue;
                    NetworkManager.sendToClient(player, new ProgressSyncPacket(progressToSync));
                }
                QuestProgress checkProgress = this.getProgress(player.method_5667());
                this.checkAndNotifyCompletableQuests(player, checkProgress, updatedQuests);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trackCustomProgress(UUID playerId, String taskId, int amount) {
        this.trackCustomProgress(playerId, taskId, amount, null);
    }

    public void trackCustomProgress(UUID playerId, String taskId, int amount, class_3222 player) {
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            QuestProgress progress;
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                CustomRequirement cr;
                if (!(req instanceof CustomRequirement) || !(cr = (CustomRequirement)req).getTaskId().equals(taskId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                long cap = Math.max(1L, cr.getMaxProgress());
                long next = Math.min(cap, (long)old + (long)Math.max(1, amount));
                progress.setRequirementProgress(quest.getId(), req, (int)next);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (isTeamQuest && player != null) {
                    try {
                        UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                        if (teamId != null) {
                            TeamManager.getInstance().saveTeamProgress(teamId);
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.progressStorage.saveProgress(progress);
                }
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        if (player != null && !updatedQuests.isEmpty()) {
            for (String questId : updatedQuests) {
                QuestProgress progressToSync;
                Quest quest = this.getQuest(questId);
                if (quest == null) continue;
                boolean isTeamQuest = false;
                try {
                    QuestoryConfig cfg = QuestoryConfig.getInstance();
                    isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
                if ((progressToSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), quest) : this.getProgress(player.method_5667())) == null) continue;
                NetworkManager.sendToClient(player, new ProgressSyncPacket(progressToSync));
            }
            QuestProgress check = this.getProgress(player.method_5667());
            this.checkAndNotifyCompletableQuests(player, check, updatedQuests);
        }
    }

    public void trackCraftingProgress(UUID playerId, String itemId, int amount) {
        this.trackCraftingProgress(playerId, itemId, amount, null);
    }

    public void trackCraftingProgress(UUID playerId, String itemId, int amount, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        String crafted = QuestManager.normalizeId(itemId);
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                if (!(req instanceof CraftingRequirement)) continue;
                CraftingRequirement craftReq = (CraftingRequirement)req;
                String want = QuestManager.normalizeId(craftReq.getItem());
                if (QuestoryConfig.getInstance().debugMode) {
                    System.out.println("[Questory Debug] CraftingRequirement check: want=" + want + ", crafted=" + crafted + ", match=" + want.equals(crafted));
                }
                if (!want.equals(crafted)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                progress.addRequirementProgress(quest.getId(), req, amount);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (QuestoryConfig.getInstance().debugMode) {
                    System.out.println("[Questory Debug] Crafting progress updated: quest=" + quest.getId() + ", item=" + crafted + ", old=" + old + ", +=" + amount + ", now=" + now);
                }
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    private static String normalizeId(String id) {
        if (id == null) {
            return "";
        }
        Object s = id.trim().toLowerCase(Locale.ROOT);
        if (((String)s).isEmpty()) {
            return s;
        }
        if (!((String)s).contains(":")) {
            if (((String)s).startsWith("minecraft")) {
                String path = ((String)s).substring("minecraft".length());
                if (path.startsWith("_") || path.startsWith("/")) {
                    path = path.substring(1);
                }
                s = "minecraft:" + path;
            } else {
                s = "minecraft:" + (String)s;
            }
        }
        return s;
    }

    public void trackEntityKillProgress(UUID playerId, String entityId, int amount) {
        this.trackEntityKillProgress(playerId, entityId, amount, null);
    }

    public void trackEntityKillProgress(UUID playerId, String entityId, int amount, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                EntityKillRequirement killReq;
                if (!(req instanceof EntityKillRequirement) || !(killReq = (EntityKillRequirement)req).getEntity().equals(entityId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                progress.addRequirementProgress(quest.getId(), req, amount);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public void trackAdvancementProgress(UUID playerId, String advancementId) {
        this.trackAdvancementProgress(playerId, advancementId, null);
    }

    public void trackAdvancementProgress(UUID playerId, String advancementId, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                AdvancementRequirement advReq;
                if (!(req instanceof AdvancementRequirement) || !(advReq = (AdvancementRequirement)req).getAdvancement().equals(advancementId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                progress.setRequirementProgress(quest.getId(), req, 1);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public void trackCommandProgress(UUID playerId, String commandId) {
        QuestProgress progress = this.getProgress(playerId);
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                CommandRequirement cmdReq;
                if (!(req instanceof CommandRequirement) || !(cmdReq = (CommandRequirement)req).getRequirementId().equals(commandId)) continue;
                progress.setRequirementProgress(quest.getId(), req, 1);
            }
        }
        this.progressStorage.saveProgress(progress);
    }

    public void trackStatisticProgress(UUID playerId, String statistic, int value) {
        this.trackStatisticProgress(playerId, statistic, value, null);
    }

    public void trackStatisticProgress(UUID playerId, String statistic, int value, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        String statNorm = QuestManager.normalizeStatId(statistic);
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                StatisticRequirement statReq;
                if (!(req instanceof StatisticRequirement) || !QuestManager.normalizeStatId((statReq = (StatisticRequirement)req).getStatistic()).equals(statNorm)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                progress.setRequirementProgress(quest.getId(), req, value);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (player != null && QuestoryConfig.getInstance().debugMode) {
                    System.out.println("[Questory Debug] trackStatisticProgress: stat=" + statNorm + ", quest=" + quest.getId() + ", old=" + old + ", now=" + now);
                }
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    private void checkAndNotifyCompletableQuests(class_3222 player, QuestProgress progress, Set<String> updatedQuests) {
        Set notified = this.notifiedCompletableQuests.computeIfAbsent(player.method_5667(), k -> new HashSet());
        for (String questId : updatedQuests) {
            Quest quest = this.getQuest(questId);
            if (quest == null || !quest.canComplete(progress) || notified.contains(questId)) continue;
            QuestNotifications.notifyQuestReady(player, quest);
            notified.add(questId);
        }
    }

    public void notifyQuestReadyOnce(class_3222 player, QuestProgress progress, Quest quest) {
        if (player == null || quest == null || progress == null) {
            return;
        }
        Set notified = this.notifiedCompletableQuests.computeIfAbsent(player.method_5667(), k -> new HashSet());
        if (quest.canComplete(progress) && !notified.contains(quest.getId())) {
            QuestNotifications.notifyQuestReady(player, quest);
            notified.add(quest.getId());
        }
    }

    private void clearQuestNotification(UUID playerId, String questId) {
        Set<String> notified = this.notifiedCompletableQuests.get(playerId);
        if (notified != null) {
            notified.remove(questId);
        }
    }

    public void onPlayerDisconnect(UUID playerId) {
        this.progressStorage.unloadPlayer(playerId);
        this.notifiedCompletableQuests.remove(playerId);
    }

    public void onPlayerJoin(class_3222 player) {
        QuestoryConfig cfg;
        NetworkManager.sendToClient(player, new QuestSyncPacket(new ArrayList<Quest>(this.quests.values())));
        QuestProgress progress = this.getProgress(player.method_5667());
        NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        if (this.chaptersByGroup != null && !this.chaptersByGroup.isEmpty()) {
            NetworkManager.sendToClient(player, new ChapterDataSyncPacket(new ArrayList<ChapterData>(this.chaptersByGroup.values())));
        }
        try {
            cfg = QuestoryConfig.getInstance();
            if (cfg.dailyEnable) {
                DailyQuestManager dm = DailyQuestManager.getInstance();
                NetworkManager.sendToClient(player, new DailyDataSyncPacket(dm.getCurrentDailyId(), dm.getCurrentTitle(), dm.getCurrentValidFrom(), dm.getCurrentValidUntil(), dm.getCurrentRolloverTz()));
            }
            boolean permitted = !cfg.advancedEditorRequiresOp || player.method_5687(cfg.adminPermissionLevel);
            NetworkManager.sendToClient(player, new ConfigSyncPacket(cfg.enableAdvancedEditor, cfg.advancedEditorRequiresOp, permitted));
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to sync daily meta: " + t.getMessage());
        }
        try {
            if (this.groupTree != null) {
                NetworkManager.sendToClient(player, new GroupTreeSyncPacket(this.groupTree));
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to sync group tree: " + t.getMessage());
        }
        try {
            cfg = QuestoryConfig.getInstance();
            if (cfg.teamSystemEnabled) {
                int count;
                PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
                if (pendingMgr.hasPendingRewards(player.method_5667()) && (count = pendingMgr.grantPendingRewards(player)) > 0) {
                    player.method_43496((class_2561)class_2561.method_43470((String)("\u00a76[Questory] \u00a7eYou received \u00a7f" + count + " \u00a7epending team rewards!")));
                }
                this.syncTeamDataToPlayer(player);
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to grant pending rewards: " + t.getMessage());
        }
        System.out.println("[Questory] Synced quest data to player: " + player.method_5477().getString());
    }

    private void syncTeamDataToPlayer(class_3222 player) {
        try {
            TeamManager teamMgr = TeamManager.getInstance();
            PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
            UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
            QuestTeam team = teamId != null ? teamMgr.getTeam(teamId) : null;
            Set<UUID> inviteIds = teamMgr.getPendingInvites(player.method_5667());
            ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
            for (UUID inviteTeamId : inviteIds) {
                QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
                if (inviteTeam == null) continue;
                String ownerName = this.getPlayerName(player.method_5682(), inviteTeam.getOwner());
                TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
                inviteInfos.add(info);
            }
            int rewardCount = pendingMgr.getPendingRewardCount(player.method_5667());
            TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.method_5667(), inviteInfos, rewardCount);
            NetworkManager.sendToClient(player, syncPacket);
            System.out.println("[Questory] Synced team data to player: " + player.method_5477().getString() + " (Team: " + (team != null ? team.getTeamName() : "none") + ")");
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to sync team data: " + t.getMessage());
        }
    }

    private String getPlayerName(MinecraftServer server, UUID playerId) {
        class_3222 player = server.method_3760().method_14602(playerId);
        if (player != null) {
            return player.method_5477().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    public void trackCurrencyProgress(UUID playerId, String currencyId, long value) {
        this.trackCurrencyProgress(playerId, currencyId, value, null);
    }

    public void trackCurrencyProgress(UUID playerId, String currencyId, long value, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                CurrencyRequirement curReq;
                if (!(req instanceof CurrencyRequirement) || !(curReq = (CurrencyRequirement)req).getCurrencyId().equals(currencyId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                int clamped = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, value));
                progress.setRequirementProgress(quest.getId(), req, clamped);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public static class QuestRequirementRef {
        public final Quest quest;
        public final Requirement requirement;

        public QuestRequirementRef(Quest quest, Requirement requirement) {
            this.quest = quest;
            this.requirement = requirement;
        }
    }
}

