/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.texboobcat.questory.quest.Reward;

public class AdvancementReward
extends Reward {
    private String advancementId;
    private String criterion;

    public AdvancementReward(String advancementId, String criterion) {
        super("advancement");
        this.advancementId = advancementId;
        this.criterion = criterion;
    }

    public String getAdvancementId() {
        return this.advancementId;
    }

    public String getCriterion() {
        return this.criterion;
    }

    public void setAdvancementId(String advancementId) {
        this.advancementId = advancementId;
    }

    public void setCriterion(String criterion) {
        this.criterion = criterion;
    }

    @Override
    public void grant(class_3222 player) {
        try {
            if (player.field_13995 == null) {
                return;
            }
            class_2960 advId = class_2960.method_12829((String)this.advancementId);
            if (advId == null) {
                return;
            }
            for (class_161 advancement : player.field_13995.method_3851().method_12893()) {
                boolean matches = false;
                try {
                    Object reflectId = advancement.getClass().getMethod("getId", new Class[0]).invoke((Object)advancement, new Object[0]);
                    matches = advId.equals(reflectId);
                }
                catch (Exception e1) {
                    try {
                        Object reflectId = advancement.getClass().getMethod("id", new Class[0]).invoke((Object)advancement, new Object[0]);
                        matches = advId.equals(reflectId);
                    }
                    catch (Exception e2) {
                        matches = advancement.toString().contains(advId.toString());
                    }
                }
                if (!matches) continue;
                class_167 progress = player.method_14236().method_12882(advancement);
                if (this.criterion == null || this.criterion.isEmpty()) {
                    for (String c : progress.method_731()) {
                        player.method_14236().method_12878(advancement, c);
                    }
                } else {
                    player.method_14236().method_12878(advancement, this.criterion);
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getDisplayString() {
        String desc = "Grant advancement: " + this.advancementId;
        if (this.criterion != null && !this.criterion.isEmpty()) {
            desc = desc + " [" + this.criterion + "]";
        }
        return desc;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "advancement");
        json.addProperty("advancement", this.advancementId);
        if (this.criterion != null && !this.criterion.isEmpty()) {
            json.addProperty("criterion", this.criterion);
        }
        return json;
    }

    public static AdvancementReward fromJson(JsonObject json) {
        String advancementId = json.get("advancement").getAsString();
        String criterion = json.has("criterion") ? json.get("criterion").getAsString() : null;
        return new AdvancementReward(advancementId, criterion);
    }
}

