/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class ItemTagRequirement
extends Requirement {
    private String tag;
    private int count;
    private boolean consume;

    public ItemTagRequirement(String tag, int count) {
        super("item_tag");
        this.tag = tag.startsWith("#") ? tag.substring(1) : tag;
        this.count = count;
        this.consume = false;
    }

    public String getTag() {
        return this.tag;
    }

    public int getCount() {
        return this.count;
    }

    public boolean shouldConsume() {
        return this.consume;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.count;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.count + " #" + this.tag;
    }

    public boolean matches(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(this.tag));
        return stack.method_31573(key);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "item_tag");
        json.addProperty("tag", "#" + this.tag);
        json.addProperty("count", (Number)this.count);
        json.addProperty("consume", Boolean.valueOf(this.consume));
        return json;
    }

    public static ItemTagRequirement fromJson(JsonObject json) {
        String tag = json.get("tag").getAsString();
        int count = json.get("count").getAsInt();
        ItemTagRequirement req = new ItemTagRequirement(tag, count);
        if (json.has("consume")) {
            req.setConsume(json.get("consume").getAsBoolean());
        }
        return req;
    }
}

