/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.shape;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShapeDef {
    public String id;
    public String displayName;
    public int version = 1;
    public double[] viewBox = new double[]{0.0, 0.0, 1.0, 1.0};
    public List<Path> paths = new ArrayList<Path>();
    public String hitTest = "auto";
    public Map<String, String> metadata = new HashMap<String, String>();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ShapeDef.class, (Object)new Deserializer()).create();

    public static class Deserializer
    implements JsonDeserializer<ShapeDef> {
        public ShapeDef deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject o = json.getAsJsonObject();
            ShapeDef d = new ShapeDef();
            d.id = Deserializer.getString(o, "id", null);
            d.displayName = Deserializer.getString(o, "displayName", d.id);
            d.version = (int)Deserializer.getNumber(o, "version", 1.0);
            if (o.has("viewBox")) {
                JsonArray a = o.getAsJsonArray("viewBox");
                d.viewBox = new double[]{a.get(0).getAsDouble(), a.get(1).getAsDouble(), a.get(2).getAsDouble(), a.get(3).getAsDouble()};
            }
            if (o.has("hitTest")) {
                d.hitTest = o.get("hitTest").getAsString();
            }
            if (o.has("metadata")) {
                for (Map.Entry e : o.getAsJsonObject("metadata").entrySet()) {
                    d.metadata.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                }
            }
            if (o.has("paths")) {
                JsonArray arr = o.getAsJsonArray("paths");
                for (JsonElement el : arr) {
                    JsonObject po = el.getAsJsonObject();
                    Path p = new Path();
                    p.type = Deserializer.getString(po, "type", "polygon");
                    p.fill = Deserializer.getBool(po, "fill", true);
                    if (po.has("stroke") && po.get("stroke").isJsonObject()) {
                        Path.Stroke s = new Path.Stroke();
                        JsonObject so = po.getAsJsonObject("stroke");
                        s.width = Deserializer.getNumber(so, "width", 0.02);
                        s.join = Deserializer.getString(so, "join", "miter");
                        s.cap = Deserializer.getString(so, "cap", "butt");
                        p.stroke = s;
                    }
                    if (po.has("points")) {
                        for (JsonElement pe : po.getAsJsonArray("points")) {
                            p.points.add(pe.getAsDouble());
                        }
                    }
                    for (Map.Entry e : po.entrySet()) {
                        String k = (String)e.getKey();
                        if (k.equals("type") || k.equals("fill") || k.equals("stroke") || k.equals("points") || !((JsonElement)e.getValue()).isJsonPrimitive() || !((JsonPrimitive)e.getValue()).isNumber()) continue;
                        p.num.put(k, ((JsonElement)e.getValue()).getAsDouble());
                    }
                    d.paths.add(p);
                }
            }
            return d;
        }

        private static String getString(JsonObject o, String k, String def) {
            return o.has(k) ? o.get(k).getAsString() : def;
        }

        private static double getNumber(JsonObject o, String k, double def) {
            return o.has(k) ? o.get(k).getAsDouble() : def;
        }

        private static boolean getBool(JsonObject o, String k, boolean def) {
            return o.has(k) ? o.get(k).getAsBoolean() : def;
        }
    }

    public static class Path {
        public String type;
        public Map<String, Double> num = new HashMap<String, Double>();
        public List<Double> points = new ArrayList<Double>();
        public boolean fill = true;
        public Stroke stroke = null;

        public static class Stroke {
            public double width = 0.02;
            public String join = "miter";
            public String cap = "butt";
        }
    }
}

