/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme;

import java.util.HashMap;
import java.util.Map;
import org.texboobcat.questory.theme.PropertyMetadata;

public class PropertyDescriptions {
    private static final Map<String, PropertyMetadata> METADATA = new HashMap<String, PropertyMetadata>();

    private static void addMetadata(String key, String name, String description, String category, String subcategory, Object defaultValue, String icon) {
        METADATA.put(key, new PropertyMetadata(key, name, description, category, subcategory, defaultValue, icon, new String[0]));
    }

    public static PropertyMetadata get(String key) {
        return METADATA.getOrDefault(key, PropertyDescriptions.createFallback(key));
    }

    public static boolean has(String key) {
        return METADATA.containsKey(key);
    }

    public static Map<String, PropertyMetadata> getAll() {
        return new HashMap<String, PropertyMetadata>(METADATA);
    }

    private static PropertyMetadata createFallback(String key) {
        String category = "Other";
        if (key.contains("color")) {
            category = "Colors";
        } else if (key.contains("icon")) {
            category = "Icons";
        } else if (key.contains("background")) {
            category = "Background";
        }
        return new PropertyMetadata(key, key, "No description available", category, "", null, "\u2753", new String[0]);
    }

    public static String getTooltip(String key) {
        PropertyMetadata meta = PropertyDescriptions.get(key);
        return meta.getIcon() + " " + meta.getDisplayName() + "\n" + meta.getDescription();
    }

    public static Object getDefaultValue(String key) {
        PropertyMetadata meta = PropertyDescriptions.get(key);
        return meta.getDefaultValue();
    }

    static {
        PropertyDescriptions.addMetadata("quest.background", "Quest Background", "Background color/texture for the quest panel", "Background", "Quest Panel", -15066598, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("chapter.panel.background", "Chapter Panel Background", "Background for chapter selection panel", "Background", "Chapter Panel", -15790321, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("key.reference.background", "Key Reference Background", "Background for the key reference overlay", "Background", "Overlays", -16777216, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("text_color", "Text Color", "Default text color for UI elements", "Colors", "Text Colors", -1, "\ud83d\udd24");
        PropertyDescriptions.addMetadata("hover_text_color", "Hover Text Color", "Text color when hovering over elements", "Colors", "Text Colors", -96, "\ud83d\udd24");
        PropertyDescriptions.addMetadata("disabled_text_color", "Disabled Text Color", "Text color for disabled UI elements", "Colors", "Text Colors", -6710887, "\ud83d\udd24");
        PropertyDescriptions.addMetadata("tasks_text_color", "Tasks Text Color", "Color for task text in quest panels", "Colors", "Text Colors", -11184641, "\ud83d\udd24");
        PropertyDescriptions.addMetadata("rewards_text_color", "Rewards Text Color", "Color for reward text in quest panels", "Colors", "Text Colors", -22016, "\ud83d\udd24");
        PropertyDescriptions.addMetadata("quest_view_title", "Quest View Title Color", "Color of quest titles in the quest view", "Colors", "Text Colors", -5592406, "\ud83d\udd24");
        PropertyDescriptions.addMetadata("quest_view_background", "Quest View Background", "Background for the quest details panel. Accepts 'texture:namespace:path' or color '#AARRGGBB'. Modifiers: '; color=#AARRGGBB; tile_size=64; padding=2'.", "Quest Appearance", "Quest View", "", "\ud83d\uddbc\ufe0f");
        PropertyDescriptions.addMetadata("icon", "Default Quest Icon", "Fallback/default icon. Used when a quest has no icon, or always when 'force_theme_icon=1'. Accepts 'builtin', 'texture:ns:path', or color '#AARRGGBB'. Modifiers: '; color=#AARRGGBB; tile_size=64; padding=2'.", "Quest Appearance", "Quest Window", "", "\ud83e\udde9");
        PropertyDescriptions.addMetadata("force_theme_icon", "Force Theme Icon", "1 = always use Default Quest Icon (overrides quest-specific icons). 0 = use quest icon if provided.", "Quest Appearance", "Quest Window", 0, "\ud83e\udde9");
        PropertyDescriptions.addMetadata("quest.icon.completed", "Completed Quest Icon", "Icon overlay shown on completed quests", "Icons", "Quest States", "minecraft:lime_concrete", "\ud83d\udce6");
        PropertyDescriptions.addMetadata("quest.icon.locked", "Locked Quest Icon", "Icon overlay for locked/unavailable quests", "Icons", "Quest States", "minecraft:iron_bars", "\ud83d\udce6");
        PropertyDescriptions.addMetadata("quest.icon.repeatable", "Repeatable Quest Icon", "Icon indicating a quest can be repeated", "Icons", "Quest States", "minecraft:recovery_compass", "\ud83d\udce6");
        PropertyDescriptions.addMetadata("widget_border", "Widget Border", "Border color for UI widgets", "Colors", "Widget Colors", -15000290, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("widget_background", "Widget Background", "Background color for UI widgets", "Colors", "Widget Colors", 0x44000000, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("symbol_in", "Symbol In Color", "Color for incoming symbols", "Colors", "Widget Colors", -6568448, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("symbol_out", "Symbol Out Color", "Color for outgoing symbols", "Colors", "Widget Colors", -12549376, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("quest_completed_color", "Quest Completed Color", "Color overlay for completed quests", "Colors", "Quest States", -933822634, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("quest_started_color", "Quest Started Color", "Color overlay for started quests", "Colors", "Quest States", -939458561, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("quest_not_started_color", "Quest Not Started Color", "Color overlay for not started quests", "Colors", "Quest States", -1761607681, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("quest_locked_color", "Quest Locked Color", "Color overlay for locked quests", "Colors", "Quest States", -6710887, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("quest_selected_color", "Quest Selected Color", "Color overlay for selected quests", "Colors", "Quest States", -12303105, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("quest_view_border", "Quest View Border", "Border color for quest view panel", "Colors", "Borders", -15000290, "\ud83d\udccf");
        PropertyDescriptions.addMetadata("dependency.line.color", "Dependency Line Color", "Color of lines connecting dependent quests", "Dependency Lines", "Colors", -8355712, "\ud83d\udccd");
        PropertyDescriptions.addMetadata("dependency.line.completed.color", "Completed Dependency Color", "Color of dependency lines when quest is completed", "Dependency Lines", "Colors", -16711936, "\ud83d\udccd");
        PropertyDescriptions.addMetadata("dependency_line_completed_color", "Completed Dependency Line", "Color of dependency lines for completed quests", "Dependency Lines", "Colors", -10167196, "\ud83d\udccd");
        PropertyDescriptions.addMetadata("dependency_line_uncompleted_color", "Uncompleted Dependency Line", "Color of dependency lines for uncompleted quests", "Dependency Lines", "Colors", -1261657181, "\ud83d\udccd");
        PropertyDescriptions.addMetadata("dependency_line_unavailable_color", "Unavailable Dependency Line", "Color of dependency lines for unavailable quests", "Dependency Lines", "Colors", 1691132835, "\ud83d\udccd");
        PropertyDescriptions.addMetadata("dependency_line_requires_color", "Requires Dependency Line", "Color of dependency lines showing requirements", "Dependency Lines", "Colors", -16725816, "\ud83d\udccd");
        PropertyDescriptions.addMetadata("dependency_line_required_for_color", "Required For Dependency Line", "Color of dependency lines showing what requires this quest", "Dependency Lines", "Colors", -3618816, "\ud83d\udccd");
        PropertyDescriptions.addMetadata("scroll.bar.background", "Scrollbar Background", "Background color of scroll bars", "Other", "Scrollbar", -13421773, "\ud83d\udcdc");
        PropertyDescriptions.addMetadata("scroll.bar.foreground", "Scrollbar Foreground", "Color of the scrollbar thumb/handle", "Other", "Scrollbar", -10066330, "\ud83d\udcdc");
        PropertyDescriptions.addMetadata("widget.background", "Widget Background", "Default background for UI widgets", "Background", "Widgets", -14013910, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("quest.view.background", "Quest View Background", "Background for the main quest viewing area", "Background", "Quest View", -16119286, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("background", "Main Background Texture", "Background texture for quest book (empty = default)", "Background", "Main", "", "\ud83d\uddbc\ufe0f");
        PropertyDescriptions.addMetadata("chapter_panel_background", "Chapter Panel Background", "Background texture for chapter panel (empty = default)", "Background", "Panels", "", "\ud83d\uddbc\ufe0f");
        PropertyDescriptions.addMetadata("key_reference_background", "Key Reference Background", "Background for key reference overlay (empty = default)", "Background", "Overlays", "", "\ud83d\uddbc\ufe0f");
        PropertyDescriptions.addMetadata("button", "Button Texture", "Texture for normal buttons (empty = default)", "Icons", "Widgets", "", "\ud83d\udd18");
        PropertyDescriptions.addMetadata("disabled_button", "Disabled Button Texture", "Texture for disabled buttons (empty = default)", "Icons", "Widgets", "", "\ud83d\udd18");
        PropertyDescriptions.addMetadata("hover_button", "Hover Button Texture", "Texture for hovered buttons (empty = default)", "Icons", "Widgets", "", "\ud83d\udd18");
        PropertyDescriptions.addMetadata("panel", "Panel Texture", "Texture for UI panels (empty = default)", "Icons", "Widgets", "", "\ud83d\udd32");
        PropertyDescriptions.addMetadata("context_menu", "Context Menu Texture", "Texture for context menus (empty = default)", "Icons", "Widgets", "", "\ud83d\udccb");
        PropertyDescriptions.addMetadata("scroll_bar_background", "Scrollbar Background Texture", "Background texture for scrollbars (empty = default)", "Icons", "Scrollbar", "", "\ud83d\udcdc");
        PropertyDescriptions.addMetadata("scroll_bar", "Scrollbar Texture", "Texture for scrollbar thumb (empty = default)", "Icons", "Scrollbar", "", "\ud83d\udcdc");
        PropertyDescriptions.addMetadata("container_slot", "Container Slot Texture", "Texture for item slots (empty = default)", "Icons", "Widgets", "", "\ud83d\udce6");
        PropertyDescriptions.addMetadata("text_box", "Text Box Texture", "Texture for text input fields (empty = default)", "Icons", "Widgets", "", "\ud83d\udcdd");
        PropertyDescriptions.addMetadata("check_icon", "Check Icon", "Icon for checkmarks (empty or 'builtin' = default)", "Icons", "UI Icons", "builtin", "\u2713");
        PropertyDescriptions.addMetadata("checkmark_task_active", "Task Checkmark Active", "Task row checkmark for active/progressing tasks. Values: 'builtin' (vector), 'texture:ns:path', or color '#AARRGGBB'. Supports modifiers: '; color=#...; tile_size=...; padding=...'.", "Icons", "Quest States", "", "\u2705");
        PropertyDescriptions.addMetadata("checkmark_task_inactive", "Task Checkmark Inactive", "Task row icon for inactive tasks. Values: 'builtin' (vector), 'texture:ns:path', or color '#AARRGGBB'. Supports modifiers: '; color=#...; tile_size=...; padding=...'.", "Icons", "Quest States", "", "\u2611\ufe0f");
        PropertyDescriptions.addMetadata("add_icon", "Add Icon", "Icon for add/plus buttons (empty or 'builtin' = default)", "Icons", "UI Icons", "builtin", "\u2795");
        PropertyDescriptions.addMetadata("alert_icon", "Alert Icon", "Icon for alerts/warnings (empty = default)", "Icons", "UI Icons", "", "\u26a0\ufe0f");
        PropertyDescriptions.addMetadata("support_icon", "Support Icon", "Icon for support/help (empty = default)", "Icons", "UI Icons", "", "\u2753");
        PropertyDescriptions.addMetadata("wiki_icon", "Wiki Icon", "Icon for wiki links (empty = default)", "Icons", "UI Icons", "", "\ud83d\udcd6");
        PropertyDescriptions.addMetadata("pin_icon_on", "Pin Icon (On)", "Icon when something is pinned (empty = default)", "Icons", "UI Icons", "", "\ud83d\udccc");
        PropertyDescriptions.addMetadata("pin_icon_off", "Pin Icon (Off)", "Icon when something is not pinned (empty = default)", "Icons", "UI Icons", "", "\ud83d\udccd");
        PropertyDescriptions.addMetadata("hidden_icon", "Hidden Icon", "Icon for hidden elements (empty = default)", "Icons", "UI Icons", "", "\ud83d\udc41\ufe0f");
        PropertyDescriptions.addMetadata("link_icon", "Link Icon", "Icon for links (empty = default)", "Icons", "UI Icons", "", "\ud83d\udd17");
        PropertyDescriptions.addMetadata("save_icon", "Save Icon", "Icon for save buttons (empty = default)", "Icons", "UI Icons", "", "\ud83d\udcbe");
        PropertyDescriptions.addMetadata("settings_icon", "Settings Icon", "Icon for settings/preferences (empty = default)", "Icons", "UI Icons", "", "\u2699\ufe0f");
        PropertyDescriptions.addMetadata("close_icon", "Close Icon", "Icon for close buttons (empty = default)", "Icons", "UI Icons", "", "\u274c");
        PropertyDescriptions.addMetadata("delete_icon", "Delete Icon", "Icon for delete buttons (empty = default)", "Icons", "UI Icons", "", "\ud83d\uddd1\ufe0f");
        PropertyDescriptions.addMetadata("edit_icon", "Edit Icon", "Icon for edit buttons (empty = default)", "Icons", "UI Icons", "", "\u270f\ufe0f");
        PropertyDescriptions.addMetadata("reload_icon", "Reload Icon", "Icon for reload/refresh buttons (empty = default)", "Icons", "UI Icons", "", "\ud83d\udd04");
        PropertyDescriptions.addMetadata("lock_icon", "Lock Icon", "Icon for locked items (empty = default)", "Icons", "UI Icons", "", "\ud83d\udd12");
        PropertyDescriptions.addMetadata("show_quest_titles", "Show Quest Titles", "Show quest titles below icons on the quest graph (1=show, 0=hide)", "Quest Display", "Titles", 1, "\ud83d\udcdd");
        PropertyDescriptions.addMetadata("quest_spacing", "Quest Spacing", "Spacing between quest nodes on the graph", "Quest Display", "Layout", 1.0, "\ud83d\udcd0");
        PropertyDescriptions.addMetadata("pinned_quest_size", "Pinned Quest Size", "Size multiplier for pinned quests", "Quest Display", "Layout", 1.0, "\ud83d\udccc");
        PropertyDescriptions.addMetadata("quest_shade_mode", "Quest Shade Mode", "Shading style applied over quest backgrounds (none | linear | radial).", "Quest Appearance", "Shading", "linear", "\ud83c\udf17");
        PropertyDescriptions.addMetadata("quest_shade_direction", "Quest Shade Direction", "Direction for linear shading (down_right, down, right, up_left, up, left, up_right, down_left).", "Quest Appearance", "Shading", "down_right", "\ud83e\udded");
        PropertyDescriptions.addMetadata("quest_shade_strength", "Quest Shade Strength", "Shading intensity 0.0\u20131.0 (0 disables). Typical: 0.20\u20130.40.", "Quest Appearance", "Shading", 0.0, "\u2696\ufe0f");
        PropertyDescriptions.addMetadata("quest_shade_color", "Quest Shade Color", "Tint color for the shade (ARGB). Combine with strength to control darkness and hue.", "Quest Appearance", "Shading", -16777216, "\ud83c\udfa8");
        PropertyDescriptions.addMetadata("extra_quest_shapes", "Extra Quest Shapes", "CSV list of additional shapes to enable. Built-ins: square, circle, rsquare, diamond, hexagon, octagon, heart, gear, pentagon, star, triangle, oval, cross, shield, arrow.", "Quest Appearance", "General", "diamond, pentagon, hexagon, octagon, heart, gear, star, triangle, oval, cross, shield, arrow", "\u2b1b");
        PropertyDescriptions.addMetadata("full_screen_quest", "Full Screen Quest", "0 = open quest details in side panel; 1 = open full-screen quest view.", "Quest Appearance", "General", 0, "\ud83d\udda5\ufe0f");
    }
}

