/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.team.ITeamProvider;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamManager;
import org.texboobcat.questory.team.TeamQuestSettings;

public class TeamAPI {
    public static void registerTeamProvider(ITeamProvider provider) {
        TeamManager.getInstance().registerProvider(provider);
    }

    public static ITeamProvider getActiveProvider() {
        return TeamManager.getInstance().getActiveProvider();
    }

    public static List<ITeamProvider> getProviders() {
        return TeamManager.getInstance().getProviders();
    }

    public static boolean setActiveProvider(ITeamProvider provider) {
        return TeamManager.getInstance().setActiveProvider(provider);
    }

    public static UUID getPlayerTeamId(UUID playerId) {
        return TeamManager.getInstance().getPlayerTeamId(playerId);
    }

    public static Set<UUID> getTeamMembers(UUID teamId) {
        return TeamManager.getInstance().getTeamMembers(teamId);
    }

    public static String getTeamName(UUID teamId) {
        return TeamManager.getInstance().getTeamName(teamId);
    }

    public static boolean isInTeam(UUID playerId) {
        return TeamManager.getInstance().isInTeam(playerId);
    }

    public static boolean isTeamOwner(UUID playerId, UUID teamId) {
        return TeamManager.getInstance().isTeamOwner(playerId, teamId);
    }

    public static QuestTeam createTeam(String name, UUID owner) {
        return TeamManager.getInstance().createTeam(name, owner);
    }

    public static boolean deleteTeam(UUID teamId) {
        return TeamManager.getInstance().deleteTeam(teamId);
    }

    public static boolean invitePlayer(UUID teamId, UUID playerId) {
        return TeamManager.getInstance().invitePlayer(teamId, playerId);
    }

    public static boolean acceptInvite(UUID playerId, UUID teamId) {
        return TeamManager.getInstance().acceptInvite(playerId, teamId);
    }

    public static boolean declineInvite(UUID playerId, UUID teamId) {
        return TeamManager.getInstance().declineInvite(playerId, teamId);
    }

    public static boolean leaveTeam(UUID playerId) {
        return TeamManager.getInstance().leaveTeam(playerId);
    }

    public static boolean kickPlayer(UUID teamId, UUID playerId, UUID kickerId) {
        return TeamManager.getInstance().kickPlayer(teamId, playerId, kickerId);
    }

    public static Set<UUID> getPendingInvites(UUID playerId) {
        return TeamManager.getInstance().getPendingInvites(playerId);
    }

    public static Collection<QuestTeam> getAllTeams() {
        return TeamManager.getInstance().getAllTeams();
    }

    public static void setQuestTeamSettings(String questId, TeamQuestSettings settings) {
        Quest quest = QuestManager.getInstance().getQuest(questId);
        if (quest != null) {
            quest.setTeamSettings(settings);
            QuestManager.getInstance().registerQuest(quest);
        }
    }

    public static TeamQuestSettings getQuestTeamSettings(String questId) {
        Quest quest = QuestManager.getInstance().getQuest(questId);
        return quest != null ? quest.getTeamSettings() : null;
    }

    public static QuestProgress getTeamProgress(UUID teamId, String questId) {
        return TeamManager.getInstance().getTeamProgress(teamId, questId);
    }

    public static boolean canTeamCompleteQuest(UUID teamId, String questId) {
        Quest quest = QuestManager.getInstance().getQuest(questId);
        if (quest == null) {
            return false;
        }
        QuestProgress progress = TeamAPI.getTeamProgress(teamId, questId);
        if (progress == null) {
            return false;
        }
        return quest.canComplete(progress);
    }

    public static boolean isTeamQuestEnabled(String questId) {
        TeamQuestSettings settings = TeamAPI.getQuestTeamSettings(questId);
        return settings != null && settings.isTeamEnabled();
    }
}

