/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.texboobcat.questory.api.events.QuestEvent;

public class QuestEventBus {
    private static final Map<Class<? extends QuestEvent>, List<Consumer<? extends QuestEvent>>> LISTENERS = new HashMap<Class<? extends QuestEvent>, List<Consumer<? extends QuestEvent>>>();

    public static <T extends QuestEvent> void register(Class<T> eventClass, Consumer<T> listener) {
        LISTENERS.computeIfAbsent(eventClass, k -> new ArrayList()).add(listener);
        System.out.println("[Questory API] Registered event listener for: " + eventClass.getSimpleName());
    }

    public static <T extends QuestEvent> void post(T event) {
        List<Consumer<? extends QuestEvent>> listeners = LISTENERS.get(event.getClass());
        if (listeners != null) {
            for (Consumer<? extends QuestEvent> listener : listeners) {
                try {
                    listener.accept(event);
                }
                catch (Exception e) {
                    System.err.println("[Questory API] Error in event listener: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

