/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class TeamEventBus {
    private static final Map<Class<?>, List<Consumer<?>>> LISTENERS = new HashMap();

    public static <T> void register(Class<T> eventClass, Consumer<T> listener) {
        LISTENERS.computeIfAbsent(eventClass, k -> new ArrayList()).add(listener);
        System.out.println("[Questory Team API] Registered event listener for: " + eventClass.getSimpleName());
    }

    public static <T> void post(T event) {
        List<Consumer<?>> listeners = LISTENERS.get(event.getClass());
        if (listeners != null) {
            for (Consumer<?> listener : listeners) {
                try {
                    listener.accept(event);
                }
                catch (Exception e) {
                    System.err.println("[Questory Team API] Error in event listener: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public static void unregister(Class<?> eventClass) {
        LISTENERS.remove(eventClass);
    }

    public static void clearAll() {
        LISTENERS.clear();
    }
}

