/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;

public class AdvancedTabPanel
extends TabPanel {
    private class_4185 optionalBtn;
    private class_4185 canRepeatBtn;
    private class_4185 ignoreRewardBlockingBtn;
    private boolean optional = false;
    private String canRepeat = "default";
    private boolean ignoreRewardBlocking = false;
    private class_4185 hideUntilDepsVisibleBtn;
    private class_4185 hideUntilDepsCompleteBtn;
    private class_4185 invisibleUntilCompletedBtn;
    private class_4185 hideLockIconBtn;
    private boolean hideUntilDepsVisible = false;
    private boolean hideUntilDepsComplete = false;
    private boolean invisibleUntilCompleted = false;
    private boolean hideLockIcon = false;
    private class_342 minRequiredDepsField;
    private class_342 maxCompletableDepsField;
    private class_4185 progressionModeBtn;
    private String progressionMode = "default";
    private class_342 minWidthField;
    private class_4185 hideDependentLinesBtn;
    private boolean hideDependentLines = false;

    public AdvancedTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int fieldX = this.x + 160;
        int fieldY = this.y + 32;
        int btnW = 120;
        this.optionalBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Optional: No"), b -> {
            this.optional = !this.optional;
            this.optionalBtn.method_25355((class_2561)class_2561.method_43470((String)("Optional: " + (this.optional ? "Yes" : "No"))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY, btnW, 18).method_46431();
        this.canRepeatBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Can Repeat: Default"), b -> {
            switch (this.canRepeat) {
                case "default": {
                    String string = "true";
                    break;
                }
                case "true": {
                    String string = "false";
                    break;
                }
                default: {
                    String string = this.canRepeat = "default";
                }
            }
            this.canRepeatBtn.method_25355((class_2561)class_2561.method_43470((String)("Can Repeat: " + (this.canRepeat.equals("default") ? "Default" : (this.canRepeat.equals("true") ? "Yes" : "No")))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY += 22, btnW + 40, 18).method_46431();
        this.ignoreRewardBlockingBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Ignore Reward Blocking: No"), b -> {
            this.ignoreRewardBlocking = !this.ignoreRewardBlocking;
            this.ignoreRewardBlockingBtn.method_25355((class_2561)class_2561.method_43470((String)("Ignore Reward Blocking: " + (this.ignoreRewardBlocking ? "Yes" : "No"))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY += 22, btnW + 80, 18).method_46431();
        this.hideUntilDepsVisibleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hide Until Deps Visible: No"), b -> {
            this.hideUntilDepsVisible = !this.hideUntilDepsVisible;
            this.hideUntilDepsVisibleBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Until Deps Visible: " + (this.hideUntilDepsVisible ? "Yes" : "No"))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY += 40, btnW + 80, 18).method_46431();
        this.hideUntilDepsCompleteBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hide Until Deps Complete: No"), b -> {
            this.hideUntilDepsComplete = !this.hideUntilDepsComplete;
            this.hideUntilDepsCompleteBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Until Deps Complete: " + (this.hideUntilDepsComplete ? "Yes" : "No"))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY += 22, btnW + 80, 18).method_46431();
        this.invisibleUntilCompletedBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Invisible Until Completed: No"), b -> {
            this.invisibleUntilCompleted = !this.invisibleUntilCompleted;
            this.invisibleUntilCompletedBtn.method_25355((class_2561)class_2561.method_43470((String)("Invisible Until Completed: " + (this.invisibleUntilCompleted ? "Yes" : "No"))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY += 22, btnW + 80, 18).method_46431();
        this.hideLockIconBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hide Lock Icon: No"), b -> {
            this.hideLockIcon = !this.hideLockIcon;
            this.hideLockIconBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Lock Icon: " + (this.hideLockIcon ? "Yes" : "No"))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY += 22, btnW + 40, 18).method_46431();
        this.minRequiredDepsField = this.createField(fieldX, fieldY += 40, 80, "0");
        this.maxCompletableDepsField = this.createField(fieldX, fieldY += 26, 80, "0");
        this.progressionModeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Progression: Default"), b -> {
            this.progressionMode = switch (this.progressionMode) {
                case "default" -> "linear";
                case "linear" -> "flexible";
                default -> "default";
            };
            this.progressionModeBtn.method_25355((class_2561)class_2561.method_43470((String)("Progression: " + Character.toUpperCase(this.progressionMode.charAt(0)) + this.progressionMode.substring(1))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY += 26, btnW + 40, 18).method_46431();
        this.minWidthField = this.createField(fieldX, fieldY += 40, 80, "0");
        this.hideDependentLinesBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hide Dependent Lines: No"), b -> {
            this.hideDependentLines = !this.hideDependentLines;
            this.hideDependentLinesBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Dependent Lines: " + (this.hideDependentLines ? "Yes" : "No"))));
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX, fieldY += 26, btnW + 80, 18).method_46431();
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.optional = quest.isOptional();
        this.optionalBtn.method_25355((class_2561)class_2561.method_43470((String)("Optional: " + (this.optional ? "Yes" : "No"))));
        this.canRepeat = quest.getCanRepeat();
        this.canRepeatBtn.method_25355((class_2561)class_2561.method_43470((String)("Can Repeat: " + (this.canRepeat.equals("default") ? "Default" : (this.canRepeat.equals("true") ? "Yes" : "No")))));
        this.ignoreRewardBlocking = quest.isIgnoreRewardBlocking();
        this.ignoreRewardBlockingBtn.method_25355((class_2561)class_2561.method_43470((String)("Ignore Reward Blocking: " + (this.ignoreRewardBlocking ? "Yes" : "No"))));
        this.hideUntilDepsVisible = "true".equals(quest.getHideUntilDepsVisible());
        this.hideUntilDepsVisibleBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Until Deps Visible: " + (this.hideUntilDepsVisible ? "Yes" : "No"))));
        this.hideUntilDepsComplete = "true".equals(quest.getHideUntilDepsComplete());
        this.hideUntilDepsCompleteBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Until Deps Complete: " + (this.hideUntilDepsComplete ? "Yes" : "No"))));
        this.invisibleUntilCompleted = quest.isInvisibleUntilCompleted();
        this.invisibleUntilCompletedBtn.method_25355((class_2561)class_2561.method_43470((String)("Invisible Until Completed: " + (this.invisibleUntilCompleted ? "Yes" : "No"))));
        this.hideLockIcon = quest.isHideLockIcon();
        this.hideLockIconBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Lock Icon: " + (this.hideLockIcon ? "Yes" : "No"))));
        this.minRequiredDepsField.method_1852(String.valueOf(quest.getMinRequiredDependencies()));
        this.maxCompletableDepsField.method_1852(String.valueOf(quest.getMaxCompletableDeps()));
        this.progressionMode = quest.getProgressionMode();
        this.progressionModeBtn.method_25355((class_2561)class_2561.method_43470((String)("Progression: " + Character.toUpperCase(this.progressionMode.charAt(0)) + this.progressionMode.substring(1))));
        this.minWidthField.method_1852(String.valueOf(quest.getMinWidth()));
        this.hideDependentLines = quest.isHideDependentLines();
        this.hideDependentLinesBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Dependent Lines: " + (this.hideDependentLines ? "Yes" : "No"))));
    }

    @Override
    public void saveToQuest(Quest quest) {
        quest.setOptional(this.optional);
        quest.setCanRepeat(this.canRepeat);
        quest.setIgnoreRewardBlocking(this.ignoreRewardBlocking);
        quest.setHideUntilDepsVisible(this.hideUntilDepsVisible ? "true" : "default");
        quest.setHideUntilDepsComplete(this.hideUntilDepsComplete ? "true" : "default");
        quest.setInvisibleUntilCompleted(this.invisibleUntilCompleted);
        quest.setHideLockIcon(this.hideLockIcon);
        try {
            quest.setMinRequiredDependencies(Integer.parseInt(this.minRequiredDepsField.method_1882().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            quest.setMaxCompletableDeps(Integer.parseInt(this.maxCompletableDepsField.method_1882().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setProgressionMode(this.progressionMode);
        try {
            quest.setMinWidth(Integer.parseInt(this.minWidthField.method_1882().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setHideDependentLines(this.hideDependentLines);
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.updateFieldPositions();
        int labelX = this.x + 12;
        int fieldX = this.x + 160;
        int fieldY = this.y + 12;
        g.method_44379(this.x, this.y, this.x + this.w, this.y + this.h);
        g.method_25303(this.getFont(), "\u00a7lQuest Behavior", labelX, fieldY, -86);
        fieldY += 20;
        this.optionalBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 22;
        this.canRepeatBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 22;
        this.ignoreRewardBlockingBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "\u00a7lVisibility & Unlocking", labelX, fieldY += 28, -86);
        fieldY += 20;
        this.hideUntilDepsVisibleBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 22;
        this.hideUntilDepsCompleteBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 22;
        this.invisibleUntilCompletedBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 22;
        this.hideLockIconBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "\u00a7lProgression Control", labelX, fieldY += 28, -86);
        g.method_25303(this.getFont(), "Min Required Deps:", labelX, fieldY += 20, -1);
        this.minRequiredDepsField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Max Completable Deps:", labelX, fieldY += 26, -1);
        this.maxCompletableDepsField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Progression Mode:", labelX, fieldY += 26, -1);
        this.progressionModeBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "\u00a7lDisplay", labelX, fieldY += 28, -86);
        g.method_25303(this.getFont(), "Min Width:", labelX, fieldY += 20, -1);
        this.minWidthField.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 26;
        this.hideDependentLinesBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_44380();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateFieldPositions();
        if (this.optionalBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canRepeatBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.ignoreRewardBlockingBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hideUntilDepsVisibleBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hideUntilDepsCompleteBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.invisibleUntilCompletedBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hideLockIconBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.progressionModeBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hideDependentLinesBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void updateFieldPositions() {
        int fieldX = this.x + 160;
        int fieldY = this.y + 12;
        this.optionalBtn.method_46421(fieldX);
        this.optionalBtn.method_46419(fieldY += 20);
        this.canRepeatBtn.method_46421(fieldX);
        this.canRepeatBtn.method_46419(fieldY += 22);
        this.ignoreRewardBlockingBtn.method_46421(fieldX);
        this.ignoreRewardBlockingBtn.method_46419(fieldY += 22);
        fieldY += 28;
        this.hideUntilDepsVisibleBtn.method_46421(fieldX);
        this.hideUntilDepsVisibleBtn.method_46419(fieldY += 20);
        this.hideUntilDepsCompleteBtn.method_46421(fieldX);
        this.hideUntilDepsCompleteBtn.method_46419(fieldY += 22);
        this.invisibleUntilCompletedBtn.method_46421(fieldX);
        this.invisibleUntilCompletedBtn.method_46419(fieldY += 22);
        this.hideLockIconBtn.method_46421(fieldX);
        this.hideLockIconBtn.method_46419(fieldY += 22);
        fieldY += 28;
        this.minRequiredDepsField.method_46421(fieldX);
        this.minRequiredDepsField.method_46419(fieldY += 20);
        this.maxCompletableDepsField.method_46421(fieldX);
        this.maxCompletableDepsField.method_46419(fieldY += 26);
        this.progressionModeBtn.method_46421(fieldX);
        this.progressionModeBtn.method_46419(fieldY += 26);
        fieldY += 28;
        this.minWidthField.method_46421(fieldX);
        this.minWidthField.method_46419(fieldY += 20);
        this.hideDependentLinesBtn.method_46421(fieldX);
        this.hideDependentLinesBtn.method_46419(fieldY += 26);
    }
}

