/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.EntityPickerScreen;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.client.gui.MultilineTextEditorScreen;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.QuestPositionPickerScreen;
import org.texboobcat.questory.client.gui.ShapeDesignerScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;

public class GeneralTabPanel
extends TabPanel {
    private class_342 idField;
    private class_342 titleField;
    private class_4185 titleEditBtn;
    private class_342 descField;
    private class_4185 descEditBtn;
    private class_342 iconField;
    private class_4185 iconBrowseBtn;
    private class_4185 entityBrowseBtn;
    private class_342 groupField;
    private class_342 tagsField;
    private class_342 xField;
    private class_342 yField;
    private class_4185 positionBtn;
    private class_342 shapeField;
    private class_342 sizeField;
    private class_342 iconScaleField;
    private class_4185 hiddenBtn;
    private class_4185 shapeDesignBtn;
    private class_342 entityFitField;
    private class_342 entityMinField;
    private class_342 entityMaxField;
    private class_342 entitySpinField;
    private class_342 entityBobField;
    private class_342 entityBobSpeedField;
    private boolean hidden = false;

    public GeneralTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void openShapeDesigner() {
        this.editor.saveCurrentTabToQuest();
        String initial = this.shapeField.method_1882();
        this.getMinecraft().method_1507((class_437)new ShapeDesignerScreen(this.editor, initial, shapeId -> {
            String val = shapeId == null || shapeId.isBlank() ? initial : shapeId.trim();
            this.shapeField.method_1852(val);
            this.editor.updateQuest(q -> q.setShape(val));
            this.getMinecraft().method_1507((class_437)this.editor);
        }));
    }

    private static Map<String, String> parseEntityMods(String icon) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String raw = icon.substring("entity:".length()).trim();
            int semi = raw.indexOf(59);
            if (semi < 0) {
                return map;
            }
            String rest = raw.substring(semi + 1);
            for (String part : rest.split(";")) {
                int eq;
                String p = part.trim();
                if (p.isEmpty() || (eq = p.indexOf(61)) <= 0) continue;
                map.put(p.substring(0, eq).trim().toLowerCase(Locale.ROOT), p.substring(eq + 1).trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private static String buildEntityIconString(String current, String fit, String min, String max, String spin, String bob, String bobSpeed) {
        try {
            String raw = current.substring("entity:".length()).trim();
            int semi = raw.indexOf(59);
            String id = semi >= 0 ? raw.substring(0, semi).trim() : raw;
            ArrayList<CallSite> mods = new ArrayList<CallSite>();
            if (fit != null && !fit.isBlank()) {
                mods.add((CallSite)((Object)("fit=" + fit.trim())));
            }
            if (min != null && !min.isBlank()) {
                mods.add((CallSite)((Object)("min=" + min.trim())));
            }
            if (max != null && !max.isBlank()) {
                mods.add((CallSite)((Object)("max=" + max.trim())));
            }
            if (spin != null && !spin.isBlank()) {
                mods.add((CallSite)((Object)("spin=" + spin.trim())));
            }
            if (bob != null && !bob.isBlank()) {
                mods.add((CallSite)((Object)("bob=" + bob.trim())));
            }
            if (bobSpeed != null && !bobSpeed.isBlank()) {
                mods.add((CallSite)((Object)("bob_speed=" + bobSpeed.trim())));
            }
            if (mods.isEmpty()) {
                return "entity:" + id;
            }
            StringBuilder sb = new StringBuilder("entity:").append(id).append("; ");
            for (int i = 0; i < mods.size(); ++i) {
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append((String)mods.get(i));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return current;
        }
    }

    private void openEntityPicker() {
        this.editor.saveCurrentTabToQuest();
        int suggestedPx = this.suggestIconPx(this.editor.getWorkingQuest());
        this.getMinecraft().method_1507((class_437)new EntityPickerScreen(this.editor, this.iconField.method_1882(), result -> {
            this.editor.getWorkingQuest().setIcon((String)result);
            this.getMinecraft().method_1507((class_437)this.editor);
        }, suggestedPx));
    }

    private int suggestIconPx(Quest q) {
        if (q == null) {
            return 42;
        }
        double base = 64.0 * Math.max(0.5, q.getSize()) * Math.max(0.5, q.getIconScale());
        double clamped = Math.max(20.0, Math.min(96.0, base));
        int iconPx = (int)Math.round(clamped * 0.65);
        return Math.max(64, Math.min(128, iconPx));
    }

    public String getIdFieldValue() {
        return this.idField.method_1882();
    }

    private void initWidgets() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int fieldW = Math.min(400, this.w - 24);
        int labelW = 120;
        int inputW = fieldW - labelW - 8;
        this.idField = this.createField(fieldX + labelW, fieldY, inputW, "quest_id");
        this.idField.method_1880(200);
        this.idField.method_1863(value -> {
            if (this.editor.getFieldValidation() != null) {
                this.editor.getFieldValidation().validate("questId", (String)value);
            }
        });
        int titleW = inputW - 70;
        this.titleField = this.createField(fieldX + labelW, fieldY += 26, titleW, "Quest Title");
        this.titleField.method_1880(500);
        this.titleField.method_1863(value -> {
            if (this.editor.getFieldValidation() != null) {
                this.editor.getFieldValidation().validate("title", (String)value);
            }
        });
        this.titleEditBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit..."), b -> this.openTitleEditor()).method_46434(fieldX + labelW + titleW + 4, fieldY, 66, 18).method_46431();
        int descW = inputW - 70;
        this.descField = this.createField(fieldX + labelW, fieldY += 26, descW, "Enter quest description...");
        this.descField.method_1880(500);
        this.descEditBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit..."), b -> this.openDescriptionEditor()).method_46434(fieldX + labelW + descW + 4, fieldY, 66, 18).method_46431();
        int iconW = inputW - 160;
        this.iconField = this.createField(fieldX + labelW, fieldY += 26, iconW, "minecraft:writable_book");
        this.iconField.method_1880(200);
        this.iconBrowseBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Texture..."), b -> this.openIconPicker()).method_46434(fieldX + labelW + iconW + 4, fieldY, 76, 18).method_46431();
        this.entityBrowseBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Entity..."), b -> this.openEntityPicker()).method_46434(fieldX + labelW + iconW + 4 + 80, fieldY, 76, 18).method_46431();
        this.entityFitField = this.createField(fieldX + labelW, fieldY += 30, 60, "");
        this.entityMinField = this.createField(fieldX + labelW + 66, fieldY, 60, "");
        this.entityMaxField = this.createField(fieldX + labelW + 132, fieldY, 60, "");
        this.entitySpinField = this.createField(fieldX + labelW, fieldY += 24, 60, "");
        this.entityBobField = this.createField(fieldX + labelW + 66, fieldY, 60, "");
        this.entityBobSpeedField = this.createField(fieldX + labelW + 132, fieldY, 60, "");
        fieldY += 10;
        this.groupField = this.createField(fieldX + labelW, fieldY += 12, inputW, "default");
        this.groupField.method_1880(200);
        this.tagsField = this.createField(fieldX + labelW, fieldY += 26, inputW, "comma, separated, tags");
        this.tagsField.method_1880(500);
        int halfW = (inputW - 90) / 2;
        this.xField = this.createField(fieldX + labelW, fieldY += 26, halfW, "0");
        this.xField.method_1863(value -> {
            if (this.editor.getFieldValidation() != null) {
                this.editor.getFieldValidation().validate("xPos", (String)value);
            }
        });
        this.yField = this.createField(fieldX + labelW + halfW + 4, fieldY, halfW, "0");
        this.yField.method_1863(value -> {
            if (this.editor.getFieldValidation() != null) {
                this.editor.getFieldValidation().validate("yPos", (String)value);
            }
        });
        this.positionBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Position..."), b -> this.openPositionPicker()).method_46434(fieldX + labelW + halfW * 2 + 8, fieldY, 82, 18).method_46431();
        fieldY += 30;
        int shapeW = inputW - 90;
        this.shapeField = this.createField(fieldX + labelW, fieldY += 12, shapeW, "square (or circle, hexagon...)");
        this.shapeDesignBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Design..."), b -> this.openShapeDesigner()).method_46434(fieldX + labelW + shapeW + 4, fieldY, 84, 18).method_46431();
        this.shapeField.method_1880(100);
        this.sizeField = this.createField(fieldX + labelW, fieldY += 26, 80, "1.0");
        this.sizeField.method_1863(value -> {
            if (this.editor.getFieldValidation() != null) {
                this.editor.getFieldValidation().validate("size", (String)value);
            }
        });
        this.iconScaleField = this.createField(fieldX + labelW, fieldY += 26, 80, "1.0");
        this.iconScaleField.method_1863(value -> {
            if (this.editor.getFieldValidation() != null) {
                this.editor.getFieldValidation().validate("iconScale", (String)value);
            }
        });
        this.hiddenBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hidden: No"), b -> this.toggleHidden()).method_46434(fieldX + labelW, fieldY += 26, 120, 20).method_46431();
    }

    private void toggleHidden() {
        this.hidden = !this.hidden;
        this.hiddenBtn.method_25355((class_2561)class_2561.method_43470((String)("Hidden: " + (this.hidden ? "Yes" : "No"))));
    }

    private void openTitleEditor() {
        this.editor.saveCurrentTabToQuest();
        MultilineTextEditorScreen titleEditor = new MultilineTextEditorScreen(this.editor, this.titleField.method_1882(), result -> {
            this.editor.updateQuest(q -> q.setTitle((String)result));
            this.getMinecraft().method_1507((class_437)this.editor);
        });
        titleEditor.setCustomTitle((class_2561)class_2561.method_43470((String)"Edit Title (recommended: single line)"));
        this.getMinecraft().method_1507((class_437)titleEditor);
    }

    private void openDescriptionEditor() {
        this.editor.saveCurrentTabToQuest();
        this.getMinecraft().method_1507((class_437)new MultilineTextEditorScreen(this.editor, this.descField.method_1882(), result -> {
            this.editor.updateQuest(q -> q.setDescription((String)result));
            this.getMinecraft().method_1507((class_437)this.editor);
        }));
    }

    private void openIconPicker() {
        this.editor.saveCurrentTabToQuest();
        this.getMinecraft().method_1507((class_437)new IconPickerScreen(this.editor, this.iconField.method_1882(), result -> {
            this.editor.updateQuest(q -> q.setIcon((String)result));
            this.getMinecraft().method_1507((class_437)this.editor);
        }));
    }

    private void openPositionPicker() {
        this.editor.saveCurrentTabToQuest();
        this.getMinecraft().method_1507((class_437)new QuestPositionPickerScreen(this.editor, this.editor.getWorkingQuest(), (x, y) -> this.editor.updateQuest(q -> {
            q.setX((int)x);
            q.setY((int)y);
        })));
    }

    @Override
    public void loadFromQuest(Quest quest) {
        System.out.println("[GeneralTab] loadFromQuest() - Loading quest: " + quest.getId() + ", Title: " + quest.getTitle() + ", Icon: " + quest.getIcon());
        this.idField.method_1852(quest.getId());
        this.titleField.method_1852(quest.getTitle());
        this.descField.method_1852(quest.getDescription());
        this.iconField.method_1852(quest.getIcon());
        System.out.println("[GeneralTab] loadFromQuest() - Set iconField to: " + this.iconField.method_1882());
        this.groupField.method_1852(quest.getGroup());
        this.tagsField.method_1852(String.join((CharSequence)", ", quest.getTags()));
        this.xField.method_1852(String.valueOf(quest.getX()));
        this.yField.method_1852(String.valueOf(quest.getY()));
        this.shapeField.method_1852(quest.getShape().isEmpty() ? "" : quest.getShape());
        this.sizeField.method_1852(String.valueOf(quest.getSize()));
        this.iconScaleField.method_1852(String.valueOf(quest.getIconScale()));
        this.hidden = quest.isHidden();
        this.hiddenBtn.method_25355((class_2561)class_2561.method_43470((String)("Hidden: " + (this.hidden ? "Yes" : "No"))));
        System.out.println("[GeneralTab] loadFromQuest() - Loaded fields - ID: " + this.idField.method_1882() + ", Title: " + this.titleField.method_1882());
    }

    @Override
    public void saveToQuest(Quest quest) {
        String[] tags;
        System.out.println("[GeneralTab] saveToQuest() - BEFORE save - Quest ID: " + quest.getId() + ", Title: " + quest.getTitle());
        System.out.println("[GeneralTab] saveToQuest() - Field values - ID: " + this.idField.method_1882() + ", Title: " + this.titleField.method_1882());
        String newId = this.idField.method_1882().trim();
        if (!newId.isEmpty() && !newId.equals(quest.getId())) {
            quest.setId(newId);
            System.out.println("[GeneralTab] saveToQuest() - ID changed from '" + quest.getId() + "' to '" + newId + "'");
        }
        quest.setTitle(this.titleField.method_1882().trim().isEmpty() ? quest.getId() : this.titleField.method_1882().trim());
        quest.setDescription(this.descField.method_1882());
        String iconVal = this.iconField.method_1882().trim().isEmpty() ? "minecraft:writable_book" : this.iconField.method_1882().trim();
        quest.setIcon(iconVal);
        quest.setGroup(this.groupField.method_1882().trim().isEmpty() ? "default" : this.groupField.method_1882().trim());
        quest.getTags().clear();
        for (String tag : tags = this.tagsField.method_1882().split(",")) {
            String t = tag.trim();
            if (t.isEmpty()) continue;
            quest.addTag(t);
        }
        try {
            quest.setX(Integer.parseInt(this.xField.method_1882().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            quest.setY(Integer.parseInt(this.yField.method_1882().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setShape(this.shapeField.method_1882().trim());
        try {
            double size = Double.parseDouble(this.sizeField.method_1882().trim());
            quest.setSize(Math.max(0.1, Math.min(5.0, size)));
        }
        catch (Exception size) {
            // empty catch block
        }
        try {
            double scale = Double.parseDouble(this.iconScaleField.method_1882().trim());
            quest.setIconScale(Math.max(0.1, Math.min(3.0, scale)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setHidden(this.hidden);
        System.out.println("[GeneralTab] saveToQuest() - AFTER save - Quest ID: " + quest.getId() + ", Title: " + quest.getTitle());
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.updateFieldPositions();
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int labelW = 120;
        g.method_44379(this.x, this.y, this.x + this.w, this.y + this.h);
        g.method_25303(this.getFont(), "\u00a7lIdentity", fieldX, fieldY - 8, -86);
        g.method_25303(this.getFont(), "ID:", fieldX, fieldY += 12, -1);
        this.idField.method_25394(g, mouseX, mouseY, partialTick);
        if (this.editor.getFieldValidation() != null) {
            this.editor.getFieldValidation().renderFieldIndicator(g, this.getFont(), this.idField, "questId", mouseX, mouseY);
        }
        g.method_25303(this.getFont(), "Title:", fieldX, fieldY += 26, -1);
        this.titleField.method_25394(g, mouseX, mouseY, partialTick);
        if (this.editor.getFieldValidation() != null) {
            this.editor.getFieldValidation().renderFieldIndicator(g, this.getFont(), this.titleField, "title", mouseX, mouseY);
        }
        this.titleEditBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Description:", fieldX, fieldY += 26, -1);
        this.descField.method_25394(g, mouseX, mouseY, partialTick);
        this.descEditBtn.method_25394(g, mouseX, mouseY, partialTick);
        String desc = this.descField.method_1882();
        if (desc.contains("\n")) {
            String preview = desc.substring(0, Math.min(40, desc.length())).replace("\n", " ") + "...";
            g.method_25303(this.getFont(), "\u00a77" + preview, fieldX + labelW, fieldY + 20, -7829368);
        }
        int inputW = Math.min(400, this.w - 24) - labelW - 8;
        int iconW = inputW - 160;
        g.method_25303(this.getFont(), "Icon:", fieldX, fieldY += 26, -1);
        this.iconField.method_25394(g, mouseX, mouseY, partialTick);
        this.iconBrowseBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.entityBrowseBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        g.method_25303(this.getFont(), "\u00a7lOrganization", fieldX, fieldY += 4, -86);
        g.method_25303(this.getFont(), "Group/Chapter:", fieldX, fieldY += 12, -1);
        this.groupField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Tags:", fieldX, fieldY += 26, -1);
        this.tagsField.method_25394(g, mouseX, mouseY, partialTick);
        int halfW = (inputW - 90) / 2;
        g.method_25303(this.getFont(), "Position:", fieldX, fieldY += 26, -1);
        g.method_25303(this.getFont(), "X:", fieldX + labelW, fieldY, -3355444);
        this.xField.method_25394(g, mouseX, mouseY, partialTick);
        if (this.editor.getFieldValidation() != null) {
            this.editor.getFieldValidation().renderFieldIndicator(g, this.getFont(), this.xField, "xPos", mouseX, mouseY);
        }
        g.method_25303(this.getFont(), "Y:", fieldX + labelW + halfW + 4, fieldY, -3355444);
        this.yField.method_25394(g, mouseX, mouseY, partialTick);
        if (this.editor.getFieldValidation() != null) {
            this.editor.getFieldValidation().renderFieldIndicator(g, this.getFont(), this.yField, "yPos", mouseX, mouseY);
        }
        this.positionBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        g.method_25303(this.getFont(), "\u00a7lAppearance", fieldX, fieldY += 4, -86);
        g.method_25303(this.getFont(), "Shape:", fieldX, fieldY += 12, -1);
        this.shapeField.method_25394(g, mouseX, mouseY, partialTick);
        this.shapeDesignBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Size:", fieldX, fieldY += 26, -1);
        this.sizeField.method_25394(g, mouseX, mouseY, partialTick);
        if (this.editor.getFieldValidation() != null) {
            this.editor.getFieldValidation().renderFieldIndicator(g, this.getFont(), this.sizeField, "size", mouseX, mouseY);
        }
        g.method_25303(this.getFont(), "(0.5 - 3.0)", fieldX + labelW + 88, fieldY, -7829368);
        g.method_25303(this.getFont(), "Icon Scale:", fieldX, fieldY += 26, -1);
        this.iconScaleField.method_25394(g, mouseX, mouseY, partialTick);
        if (this.editor.getFieldValidation() != null) {
            this.editor.getFieldValidation().renderFieldIndicator(g, this.getFont(), this.iconScaleField, "iconScale", mouseX, mouseY);
        }
        g.method_25303(this.getFont(), "(0.5 - 2.0)", fieldX + labelW + 88, fieldY, -7829368);
        g.method_25303(this.getFont(), "Visibility:", fieldX, fieldY += 26, -1);
        this.hiddenBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_44380();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateFieldPositions();
        if (this.titleEditBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.descEditBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.iconBrowseBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.entityBrowseBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.positionBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.shapeDesignBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hiddenBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void updateFieldPositions() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int labelW = 120;
        int inputW = Math.min(400, this.w - 24) - labelW - 8;
        this.idField.method_46421(fieldX + labelW);
        this.idField.method_46419(fieldY);
        int titleW = inputW - 70;
        this.titleField.method_46421(fieldX + labelW);
        this.titleField.method_46419(fieldY += 26);
        this.titleEditBtn.method_46421(fieldX + labelW + titleW + 4);
        this.titleEditBtn.method_46419(fieldY);
        int descW = inputW - 70;
        this.descField.method_46421(fieldX + labelW);
        this.descField.method_46419(fieldY += 26);
        this.descEditBtn.method_46421(fieldX + labelW + descW + 4);
        this.descEditBtn.method_46419(fieldY);
        int iconW = inputW - 160;
        this.iconField.method_46421(fieldX + labelW);
        this.iconField.method_46419(fieldY += 26);
        this.iconBrowseBtn.method_46421(fieldX + labelW + iconW + 4);
        this.iconBrowseBtn.method_46419(fieldY);
        this.entityBrowseBtn.method_46421(fieldX + labelW + iconW + 4 + 80);
        this.entityBrowseBtn.method_46419(fieldY);
        fieldY += 30;
        this.groupField.method_46421(fieldX + labelW);
        this.groupField.method_46419(fieldY += 12);
        this.tagsField.method_46421(fieldX + labelW);
        this.tagsField.method_46419(fieldY += 26);
        int halfW = (inputW - 90) / 2;
        this.xField.method_46421(fieldX + labelW);
        this.xField.method_46419(fieldY += 26);
        this.yField.method_46421(fieldX + labelW + halfW + 4);
        this.yField.method_46419(fieldY);
        this.positionBtn.method_46421(fieldX + labelW + halfW * 2 + 8);
        this.positionBtn.method_46419(fieldY);
        fieldY += 30;
        this.shapeField.method_46421(fieldX + labelW);
        this.shapeField.method_46419(fieldY += 12);
        this.shapeDesignBtn.method_46421(fieldX + labelW + (Math.min(400, this.w - 24) - 120 - 8) - 90 + 4);
        this.shapeDesignBtn.method_46419(fieldY);
        this.sizeField.method_46421(fieldX + labelW);
        this.sizeField.method_46419(fieldY += 26);
        this.iconScaleField.method_46421(fieldX + labelW);
        this.iconScaleField.method_46419(fieldY += 26);
        this.hiddenBtn.method_46421(fieldX + labelW);
        this.hiddenBtn.method_46419(fieldY += 26);
    }
}

