/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.texboobcat.questory.client.gui.QuestIconRenderer;

public class IconPickerScreen
extends class_437 {
    private final class_437 parent;
    private final String initialValue;
    private final Consumer<String> callback;
    private Tab currentTab = Tab.ITEMS;
    private final List<class_2960> allItems = new ArrayList<class_2960>();
    private List<class_2960> filteredItems = new ArrayList<class_2960>();
    private final List<class_2960> allTextures = new ArrayList<class_2960>();
    private List<class_2960> filteredTextures = new ArrayList<class_2960>();
    private boolean texturesLoaded = false;
    private class_2960 selectedId = null;
    private String manualValue = "";
    private class_342 searchBox;
    private class_342 manualInputBox;
    private class_4185 itemsTabBtn;
    private class_4185 texturesTabBtn;
    private float scrollOffset = 0.0f;
    private boolean isDraggingScroll = false;
    private static final int PAD = 10;
    private static final int ITEM_SIZE = 18;
    private static final int COLS = 9;
    private static final int TEXTURE_ROW_H = 14;
    private int listX;
    private int listY;
    private int listW;
    private int listH;
    private int previewX;
    private int previewY;
    private int previewW;
    private int previewH;

    public IconPickerScreen(class_437 parent, String currentValue, Consumer<String> callback) {
        super((class_2561)class_2561.method_43470((String)"Icon Picker"));
        this.parent = parent;
        this.manualValue = this.initialValue = currentValue == null ? "" : currentValue;
        this.callback = callback;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.allItems.isEmpty()) {
            for (class_2960 id : class_7923.field_41178.method_10235()) {
                if (id.equals((Object)class_7923.field_41178.method_10221((Object)class_1802.field_8162))) continue;
                this.allItems.add(id);
            }
            this.allItems.sort(Comparator.comparing(class_2960::toString));
            this.updateFilter("");
        }
        int totalW = Math.min(420, this.field_22789 - 20);
        int totalH = this.field_22790 - 40;
        int startX = (this.field_22789 - totalW) / 2;
        int startY = 20;
        this.itemsTabBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Items"), b -> this.setTab(Tab.ITEMS)).method_46434(startX, startY, 60, 20).method_46431();
        this.texturesTabBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Textures"), b -> this.setTab(Tab.TEXTURES)).method_46434(startX + 65, startY, 70, 20).method_46431();
        this.method_37063((class_364)this.itemsTabBtn);
        this.method_37063((class_364)this.texturesTabBtn);
        this.updateTabButtons();
        this.searchBox = new class_342(this.field_22793, startX + 140, startY + 1, totalW - 140, 18, (class_2561)class_2561.method_43470((String)"Search..."));
        this.searchBox.method_1863(this::updateFilter);
        this.method_37063((class_364)this.searchBox);
        this.listX = startX;
        this.listY = startY + 25;
        this.listW = (int)((double)totalW * 0.65);
        this.listH = totalH - 60;
        this.previewX = this.listX + this.listW + 10;
        this.previewY = this.listY;
        this.previewW = totalW - this.listW - 10;
        this.previewH = this.listH;
        this.manualInputBox = new class_342(this.field_22793, startX, this.listY + this.listH + 5, totalW - 130, 18, (class_2561)class_2561.method_43470((String)"Icon path"));
        this.manualInputBox.method_1880(256);
        this.manualInputBox.method_1852(this.manualValue);
        this.manualInputBox.method_1863(val -> {
            this.manualValue = val;
            if (this.currentTab == Tab.ITEMS && class_7923.field_41178.method_10250(new class_2960(val))) {
                this.selectedId = new class_2960(val);
            } else if (this.currentTab == Tab.TEXTURES && val.startsWith("texture:")) {
                try {
                    String path = val.substring("texture:".length());
                    if (path.contains(":")) {
                        String[] p = path.split(":", 2);
                        this.selectedId = new class_2960(p[0], p[1]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.method_37063((class_364)this.manualInputBox);
        int btnY = this.listY + this.listH + 5;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Select"), b -> this.confirm()).method_46434(startX + totalW - 125, btnY, 60, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.method_25419()).method_46434(startX + totalW - 60, btnY, 60, 18).method_46431());
        if (this.initialValue.startsWith("texture:")) {
            this.setTab(Tab.TEXTURES);
        }
    }

    private void setTab(Tab tab) {
        this.currentTab = tab;
        this.updateTabButtons();
        this.scrollOffset = 0.0f;
        if (tab == Tab.TEXTURES && !this.texturesLoaded) {
            this.loadTextures();
        }
        this.updateFilter(this.searchBox.method_1882());
    }

    private void updateTabButtons() {
        this.itemsTabBtn.field_22763 = this.currentTab != Tab.ITEMS;
        this.texturesTabBtn.field_22763 = this.currentTab != Tab.TEXTURES;
    }

    private void loadTextures() {
        this.texturesLoaded = true;
        this.allTextures.clear();
        try {
            class_3300 rm = class_310.method_1551().method_1478();
            Map resources = rm.method_14488("textures", path -> path.method_12832().endsWith(".png"));
            this.allTextures.addAll(resources.keySet());
            this.allTextures.sort(Comparator.comparing(class_2960::toString));
        }
        catch (Exception e) {
            System.err.println("Failed to list textures: " + e.getMessage());
        }
    }

    private void updateFilter(String query) {
        String q = query.toLowerCase(Locale.ROOT).trim();
        if (this.currentTab == Tab.ITEMS) {
            this.filteredItems.clear();
            if (q.isEmpty()) {
                this.filteredItems.addAll(this.allItems);
            } else {
                for (class_2960 id : this.allItems) {
                    if (!id.toString().contains(q)) continue;
                    this.filteredItems.add(id);
                }
            }
        } else {
            this.filteredTextures.clear();
            if (q.isEmpty()) {
                this.filteredTextures.addAll(this.allTextures);
            } else {
                for (class_2960 id : this.allTextures) {
                    if (!id.toString().contains(q)) continue;
                    this.filteredTextures.add(id);
                }
            }
        }
        this.scrollOffset = 0.0f;
    }

    private void confirm() {
        if (this.callback != null) {
            this.callback.accept(this.manualInputBox.method_1882());
        }
        this.method_25419();
    }

    public void method_25419() {
        if (this.parent != null) {
            this.field_22787.method_1507(this.parent);
        } else {
            super.method_25419();
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        super.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25294(this.listX, this.listY, this.listX + this.listW, this.listY + this.listH, Integer.MIN_VALUE);
        g.method_49601(this.listX - 1, this.listY - 1, this.listW + 2, this.listH + 2, -1);
        if (this.currentTab == Tab.ITEMS) {
            this.renderItems(g, mouseX, mouseY);
        } else {
            this.renderTextures(g, mouseX, mouseY);
        }
        g.method_25303(this.field_22793, "Preview", this.previewX, this.previewY, -1);
        int pvSize = Math.min(128, this.previewW);
        int px = this.previewX + (this.previewW - pvSize) / 2;
        int py = this.previewY + 20;
        g.method_25294(px - 2, py - 2, px + pvSize + 2, py + pvSize + 2, -16777216);
        g.method_49601(px - 2, py - 2, pvSize + 4, pvSize + 4, -7829368);
        String val = this.manualInputBox.method_1882();
        if (!val.isEmpty()) {
            try {
                QuestIconRenderer.render(g, val, px, py, pvSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.currentTab == Tab.TEXTURES) {
            g.method_51440(this.field_22793, (class_5348)class_2561.method_43470((String)"Showing all loaded textures. Use search to filter by mod ID (e.g. 'create') or name."), this.previewX, py + pvSize + 10, this.previewW, -5592406);
        }
    }

    private void renderItems(class_332 g, int mouseX, int mouseY) {
        int visibleRows = this.listH / 18;
        int totalRows = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
        int startIndex = (int)(this.scrollOffset * (float)Math.max(0, totalRows - visibleRows)) * 9;
        g.method_44379(this.listX, this.listY, this.listX + this.listW - 8, this.listY + this.listH);
        int x = this.listX + 2;
        int y = this.listY + 2;
        for (int i = startIndex; i < this.filteredItems.size(); ++i) {
            boolean hovered;
            class_2960 id = this.filteredItems.get(i);
            int row = (i - startIndex) / 9;
            int col = (i - startIndex) % 9;
            if (row >= visibleRows) break;
            int itemX = x + col * 18;
            int itemY = y + row * 18;
            boolean bl = hovered = mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18;
            if (id.equals((Object)this.selectedId)) {
                g.method_25294(itemX, itemY, itemX + 18, itemY + 18, -11513696);
                g.method_49601(itemX, itemY, 18, 18, -1);
            } else if (hovered) {
                g.method_25294(itemX, itemY, itemX + 18, itemY + 18, -12566464);
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            g.method_51427(new class_1799((class_1935)item), itemX + 1, itemY + 1);
            if (!hovered) continue;
            g.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)id.toString()), mouseX, mouseY);
        }
        g.method_44380();
        this.renderScrollbar(g, totalRows, visibleRows);
    }

    private void renderTextures(class_332 g, int mouseX, int mouseY) {
        int visibleCount = this.listH / 14;
        int totalCount = this.filteredTextures.size();
        int startIndex = (int)(this.scrollOffset * (float)Math.max(0, totalCount - visibleCount));
        g.method_44379(this.listX, this.listY, this.listX + this.listW - 8, this.listY + this.listH);
        for (int i = 0; i < visibleCount && startIndex + i < totalCount; ++i) {
            class_2960 id = this.filteredTextures.get(startIndex + i);
            int y = this.listY + 2 + i * 14;
            boolean hovered = mouseX >= this.listX && mouseX < this.listX + this.listW - 10 && mouseY >= y && mouseY < y + 14;
            boolean selected = id.equals((Object)this.selectedId);
            if (selected) {
                g.method_25294(this.listX + 1, y, this.listX + this.listW - 9, y + 14, -12952966);
            } else if (hovered) {
                g.method_25294(this.listX + 1, y, this.listX + this.listW - 9, y + 14, -14013910);
            }
            Object name = id.toString();
            if (this.field_22793.method_1727((String)name) > this.listW - 12) {
                name = this.field_22793.method_1714((class_5348)class_2561.method_43470((String)name), this.listW - 20).getString() + "...";
            }
            g.method_25303(this.field_22793, (String)name, this.listX + 4, y + 3, -2236963);
        }
        g.method_44380();
        this.renderScrollbar(g, totalCount, visibleCount);
    }

    private void renderScrollbar(class_332 g, int total, int visible) {
        int scrollBarH = this.listH;
        int scrollBarW = 6;
        int scrollBarX = this.listX + this.listW - 8;
        int scrollBarY = this.listY;
        g.method_25294(scrollBarX, scrollBarY, scrollBarX + scrollBarW, scrollBarY + scrollBarH, -14671840);
        if (total > visible) {
            int thumbH = Math.max(20, (int)((float)visible / (float)total * (float)scrollBarH));
            int thumbY = scrollBarY + (int)(this.scrollOffset * (float)(scrollBarH - thumbH));
            g.method_25294(scrollBarX, thumbY, scrollBarX + scrollBarW, thumbY + thumbH, -8355712);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)this.listX && mouseX < (double)(this.listX + this.listW - 10) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listH)) {
            if (this.currentTab == Tab.ITEMS) {
                int index;
                int visibleRows = this.listH / 18;
                int totalRows = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
                int startRow = (int)(this.scrollOffset * (float)Math.max(0, totalRows - visibleRows));
                int col = (int)((mouseX - (double)this.listX - 2.0) / 18.0);
                int row = (int)((mouseY - (double)this.listY - 2.0) / 18.0);
                if (col >= 0 && col < 9 && row >= 0 && row < visibleRows && (index = (startRow + row) * 9 + col) >= 0 && index < this.filteredItems.size()) {
                    this.selectedId = this.filteredItems.get(index);
                    this.manualInputBox.method_1852(this.selectedId.toString());
                    this.manualValue = this.selectedId.toString();
                    return true;
                }
            } else {
                int index;
                int visibleCount = this.listH / 14;
                int totalCount = this.filteredTextures.size();
                int startIndex = (int)(this.scrollOffset * (float)Math.max(0, totalCount - visibleCount));
                int row = (int)((mouseY - (double)this.listY - 2.0) / 14.0);
                if (row >= 0 && row < visibleCount && (index = startIndex + row) >= 0 && index < this.filteredTextures.size()) {
                    this.selectedId = this.filteredTextures.get(index);
                    String val = "texture:" + this.selectedId.method_12836() + ":" + this.selectedId.method_12832();
                    this.manualInputBox.method_1852(val);
                    this.manualValue = val;
                    return true;
                }
            }
        }
        if (mouseX >= (double)(this.listX + this.listW - 10) && mouseX < (double)(this.listX + this.listW) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listH)) {
            this.isDraggingScroll = true;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScroll = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)this.listX && mouseX < (double)(this.listX + this.listW) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listH)) {
            int total;
            int visible;
            if (this.currentTab == Tab.ITEMS) {
                visible = this.listH / 18;
                total = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
            } else {
                visible = this.listH / 14;
                total = this.filteredTextures.size();
            }
            if (total > visible) {
                float scrollStep = 1.0f / (float)(total - visible);
                this.scrollOffset = Math.max(0.0f, Math.min(1.0f, this.scrollOffset - (float)delta * scrollStep));
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScroll) {
            int total;
            int visible;
            if (this.currentTab == Tab.ITEMS) {
                visible = this.listH / 18;
                total = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
            } else {
                visible = this.listH / 14;
                total = this.filteredTextures.size();
            }
            if (total > visible) {
                int scrollBarH = this.listH;
                int thumbH = Math.max(20, (int)((float)visible / (float)total * (float)scrollBarH));
                float trackH = scrollBarH - thumbH;
                this.scrollOffset = Math.max(0.0f, Math.min(1.0f, this.scrollOffset + (float)dragY / trackH));
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25421() {
        return false;
    }

    private static enum Tab {
        ITEMS,
        TEXTURES;

    }
}

