/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.editor.EditorUndoManager;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeValidator;
import org.texboobcat.questory.theme.panel.BindingContext;
import org.texboobcat.questory.theme.panel.ButtonNode;
import org.texboobcat.questory.theme.panel.ConditionalNode;
import org.texboobcat.questory.theme.panel.DividerNode;
import org.texboobcat.questory.theme.panel.GridNode;
import org.texboobcat.questory.theme.panel.HStackNode;
import org.texboobcat.questory.theme.panel.IconNode;
import org.texboobcat.questory.theme.panel.ImageListNode;
import org.texboobcat.questory.theme.panel.ImageNode;
import org.texboobcat.questory.theme.panel.ListNode;
import org.texboobcat.questory.theme.panel.PanelNode;
import org.texboobcat.questory.theme.panel.PanelRenderer;
import org.texboobcat.questory.theme.panel.PanelTemplate;
import org.texboobcat.questory.theme.panel.ProgressBarNode;
import org.texboobcat.questory.theme.panel.RichTextNode;
import org.texboobcat.questory.theme.panel.ScrollNode;
import org.texboobcat.questory.theme.panel.SliderNode;
import org.texboobcat.questory.theme.panel.SpacerNode;
import org.texboobcat.questory.theme.panel.StackNode;
import org.texboobcat.questory.theme.panel.TabContainerNode;
import org.texboobcat.questory.theme.panel.TextNode;
import org.texboobcat.questory.theme.panel.VStackNode;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class NewThemeEditorScreen
extends class_437 {
    private static final int TOP_BAR_HEIGHT = 30;
    private static final int LEFT_SIDEBAR_WIDTH = 250;
    private static final int RIGHT_SIDEBAR_WIDTH = 300;
    private static final int PALETTE_HEIGHT_PERCENT = 50;
    private final class_437 parent;
    private PanelNode rootNode;
    private PanelNode selectedNode;
    private PanelNode draggedNode;
    private boolean isDraggingFromPalette = false;
    private final List<PanelNode> paletteItems = new ArrayList<PanelNode>();
    private float canvasScale = 1.0f;
    private float canvasOffsetX = 0.0f;
    private float canvasOffsetY = 0.0f;
    private float hierarchyScrollY = 0.0f;
    private float maxHierarchyScroll = 0.0f;
    private float paletteScrollY = 0.0f;
    private float maxPaletteScroll = 0.0f;
    private boolean isDraggingElement = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private String originalWidth = null;
    private String originalHeight = null;
    private int originalParsedWidth = 0;
    private int originalParsedHeight = 0;
    private ResizeHandle activeResizeHandle = ResizeHandle.NONE;
    private boolean isResizing = false;
    private final PanelRenderer panelRenderer;
    private final BindingContext editorContext;
    private final List<class_339> propertyWidgets = new ArrayList<class_339>();
    private final Map<class_339, Integer> widgetBaseY = new HashMap<class_339, Integer>();
    private final List<LabelEntry> propertyLabels = new ArrayList<LabelEntry>();
    private int rightSidebarScroll = 0;
    private int totalPropertyHeight = 0;
    private final Map<String, ThemeValidator.ValidationResult> validationIssues = new HashMap<String, ThemeValidator.ValidationResult>();
    private final EditorUndoManager undoManager = new EditorUndoManager();
    private boolean themePickerOpen = false;
    private class_342 themePickerTarget = null;
    private Consumer<String> themePickerSetter = null;
    private List<String> themeIconKeys = null;
    private boolean showColorPicker = false;
    private class_342 colorPickerTarget = null;
    private Consumer<String> colorPickerSetter = null;
    private static final ColorInfo[] COMMON_COLORS = new ColorInfo[]{new ColorInfo(0, "Black"), new ColorInfo(0xFFFFFF, "White"), new ColorInfo(0xFF5555, "Red"), new ColorInfo(0x55FF55, "Green"), new ColorInfo(0x5555FF, "Blue"), new ColorInfo(0xFFFF55, "Yellow"), new ColorInfo(0xFF55FF, "Magenta"), new ColorInfo(0x55FFFF, "Cyan"), new ColorInfo(0xFFAA00, "Orange"), new ColorInfo(0xAA00AA, "Purple"), new ColorInfo(0x555555, "Gray"), new ColorInfo(0xAAAAAA, "Light Gray"), new ColorInfo(0xAA0000, "Dark Red"), new ColorInfo(43520, "Dark Green"), new ColorInfo(170, "Dark Blue"), new ColorInfo(0xAAAA00, "Dark Yellow")};
    private float pickerHue = 0.0f;
    private float pickerSat = 1.0f;
    private float pickerVal = 1.0f;
    private boolean dragPickerSV = false;
    private boolean dragPickerHue = false;
    private int pickerSVX;
    private int pickerSVY;
    private int pickerSVSize;
    private int pickerHueX;
    private int pickerHueY;
    private int pickerHueW;
    private int pickerHueH;
    private double themePickerScrollY = 0.0;
    private String rawJsonError = null;
    private String rawJsonBuffer = "";
    private boolean namePromptOpen = false;
    private String namePromptTitle = "";
    private class_342 namePromptField = null;
    private Consumer<String> namePromptHandler = null;
    private String namePromptError = null;
    private NameAction namePromptAction = NameAction.CREATE;
    private int nameFieldX = 0;
    private int nameFieldY = 0;
    private int nameFieldW = 0;
    private int nameFieldH = 0;
    private String currentPanelName = "custom_panel";
    private boolean isSelectingPanel = false;

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.namePromptOpen) {
            if (this.namePromptField != null && this.namePromptField.method_25400(codePoint, modifiers)) {
                return true;
            }
            return super.method_25400(codePoint, modifiers);
        }
        return super.method_25400(codePoint, modifiers);
    }

    private int[] toLocalCanvas(int screenX, int screenY) {
        int canvasX = screenX - 250;
        int canvasY = screenY - 30;
        int w = this.field_22789 - 250 - 300;
        int h = this.field_22790 - 30;
        float localX = ((float)canvasX - (float)w / 2.0f - this.canvasOffsetX) / this.canvasScale;
        float localY = ((float)canvasY - (float)h / 2.0f - this.canvasOffsetY) / this.canvasScale;
        return new int[]{(int)Math.floor(localX), (int)Math.floor(localY)};
    }

    public NewThemeEditorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Theme Editor"));
        this.parent = parent;
        this.panelRenderer = new PanelRenderer();
        this.editorContext = new BindingContext(null, null);
        this.populateMockContext();
        this.initializePalette();
        this.rootNode = new VStackNode();
        this.rootNode.setId("root");
        this.rootNode.setWidth("100%");
        this.rootNode.setHeight("100%");
        this.rootNode.setPadding(10);
        this.rootNode.setBackground("#202020");
        this.selectedNode = this.rootNode;
    }

    private void populateMockContext() {
        HashMap<String, Object> quest = new HashMap<String, Object>();
        quest.put("title", "Example Quest Title");
        quest.put("description", "This is an example description for the quest. It can be quite long and contain multiple lines of text.");
        quest.put("icon", "minecraft:diamond_sword");
        quest.put("id", "example_quest");
        quest.put("progress", 0.5);
        quest.put("isCompleted", false);
        quest.put("canComplete", true);
        ArrayList tasks = new ArrayList();
        for (int i = 1; i <= 3; ++i) {
            HashMap<String, Object> task = new HashMap<String, Object>();
            task.put("title", "Task " + i);
            task.put("icon", "minecraft:iron_ingot");
            task.put("progress", (double)i * 0.3);
            task.put("maxProgress", 1.0);
            tasks.add(task);
        }
        quest.put("tasks", tasks);
        ArrayList rewards = new ArrayList();
        for (int i = 1; i <= 2; ++i) {
            HashMap<String, Object> reward = new HashMap<String, Object>();
            reward.put("title", "Reward " + i);
            reward.put("icon", "minecraft:gold_nugget");
            rewards.add(reward);
        }
        quest.put("rewards", rewards);
        this.editorContext.put("quest", quest);
        HashMap<String, String> chapter = new HashMap<String, String>();
        chapter.put("title", "Example Chapter");
        chapter.put("description", "Chapter description goes here.");
        this.editorContext.put("chapter", chapter);
        HashMap global = new HashMap();
        global.put("inventory", Collections.emptyList());
        global.put("quests", Collections.emptyList());
        this.editorContext.put("global", global);
    }

    private void initializePalette() {
        this.paletteItems.add(new VStackNode());
        this.paletteItems.add(new HStackNode());
        this.paletteItems.add(new StackNode());
        ScrollNode scroll = new ScrollNode();
        scroll.setHeight("100%");
        this.paletteItems.add(scroll);
        TextNode text = new TextNode();
        text.setText("Label");
        this.paletteItems.add(text);
        RichTextNode richText = new RichTextNode();
        richText.setText("Rich Text");
        this.paletteItems.add(richText);
        IconNode icon = new IconNode();
        icon.setValue("minecraft:apple");
        icon.setSize(16);
        this.paletteItems.add(icon);
        ButtonNode button = new ButtonNode();
        button.setText("Button");
        this.paletteItems.add(button);
        ImageNode image = new ImageNode();
        image.setSrc("texture:minecraft:textures/item/apple.png");
        this.paletteItems.add(image);
        ImageListNode imageList = new ImageListNode();
        imageList.setItems("global.inventory");
        this.paletteItems.add(imageList);
        ListNode list = new ListNode();
        list.setItems("global.quests");
        this.paletteItems.add(list);
        SpacerNode spacer = new SpacerNode();
        spacer.setSize(10);
        this.paletteItems.add(spacer);
        this.paletteItems.add(new ConditionalNode());
        GridNode grid = new GridNode();
        grid.setColumns(2);
        grid.setGap(4);
        this.paletteItems.add(grid);
        ProgressBarNode progress = new ProgressBarNode();
        progress.setValue("50");
        progress.setMax("100");
        this.paletteItems.add(progress);
        SliderNode slider = new SliderNode();
        slider.setMin("0");
        slider.setMax("100");
        slider.setValue("50");
        this.paletteItems.add(slider);
        DividerNode divider = new DividerNode();
        divider.setOrientation("horizontal");
        divider.setThickness(2);
        divider.setColor("#FF888888");
        this.paletteItems.add(divider);
        TabContainerNode tabs = new TabContainerNode();
        TabContainerNode.Tab tab1 = new TabContainerNode.Tab("tab1", "Tab 1", new VStackNode());
        TabContainerNode.Tab tab2 = new TabContainerNode.Tab("tab2", "Tab 2", new VStackNode());
        tabs.getTabs().add(tab1);
        tabs.getTabs().add(tab2);
        this.paletteItems.add(tabs);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.saveTheme()).method_46434(10, 5, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Load Panel"), b -> this.showLoadPanelDialog()).method_46434(80, 5, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(this.field_22789 - 70, 5, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Undo"), b -> {
            if (this.undoManager.undo()) {
                this.rebuildPropertyWidgets();
            }
        }).method_46434(170, 5, 50, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Redo"), b -> {
            if (this.undoManager.redo()) {
                this.rebuildPropertyWidgets();
            }
        }).method_46434(225, 5, 50, 20).method_46431());
        this.rebuildPropertyWidgets();
    }

    private void saveTheme() {
        if (this.rootNode != null && this.currentPanelName != null) {
            try {
                Path configDir = Paths.get("config", "questory", "themes", "default", "panels");
                Files.createDirectories(configDir, new FileAttribute[0]);
                Path file = configDir.resolve(this.currentPanelName + ".json");
                JsonObject json = this.rootNode.toJson();
                Files.writeString(file, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json), new OpenOption[0]);
                if (QuestTheme.instance != null) {
                    QuestTheme.instance.addPanel(this.currentPanelName, new PanelTemplate(this.currentPanelName, this.rootNode.deepCopy()));
                }
                System.out.println("Saved panel: " + String.valueOf(file));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void showLoadPanelDialog() {
        if (QuestTheme.instance == null) {
            return;
        }
        this.isSelectingPanel = true;
    }

    private void renderPanelSelection(class_332 g, int mouseX, int mouseY) {
        g.method_51448().method_22903();
        g.method_51448().method_46416(0.0f, 0.0f, 800.0f);
        g.method_25294(0, 0, this.field_22789, this.field_22790, -872415232);
        int w = 280;
        int listH = 200;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - (listH + 70)) / 2;
        g.method_25294(x, y, x + w, y + listH + 70, -14671840);
        g.method_49601(x, y, w, listH + 70, -1);
        g.method_25303(this.field_22793, "Panels", x + 10, y + 10, -1);
        int listX = x + 10;
        int listY = y + 28;
        int listW = w - 20;
        int itemH = 22;
        g.method_44379(listX, listY, listX + listW, listY + listH);
        int itemY = listY + (int)this.themePickerScrollY;
        if (QuestTheme.instance.getPanels() != null) {
            for (String name : QuestTheme.instance.getPanels().keySet()) {
                boolean hovered = mouseX >= listX && mouseX < listX + listW && mouseY >= itemY && mouseY < itemY + itemH;
                int bg = hovered ? -12566464 : -13619152;
                g.method_25294(listX, itemY, listX + listW, itemY + itemH, bg);
                g.method_25303(this.field_22793, name, listX + 6, itemY + 6, -3355444);
                itemY += itemH + 2;
            }
        }
        g.method_44380();
        int cx = x + 10;
        int cy = y + listH + 40;
        this.drawButtonLike(g, cx, cy, 60, 20, -12952934, "Create");
        this.drawButtonLike(g, cx + 70, cy, 80, 20, -12952934, "Duplicate");
        this.drawButtonLike(g, cx + 160, cy, 60, 20, -12952934, "Rename");
        this.drawButtonLike(g, cx + 230, cy, 40, 20, -5618620, "Delete");
    }

    private void handlePanelSelectionClick(double mouseX, double mouseY) {
        int cy;
        int cx;
        int w = 280;
        int listH = 200;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - (listH + 70)) / 2;
        int listX = x + 10;
        int listY = y + 28;
        int listW = w - 20;
        int itemH = 22;
        if (mouseX >= (double)listX && mouseX < (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int idx = (int)((mouseY - (double)listY - this.themePickerScrollY) / (double)(itemH + 2));
            int i = 0;
            if (QuestTheme.instance.getPanels() != null) {
                for (String name : QuestTheme.instance.getPanels().keySet()) {
                    if (i == idx) {
                        this.loadPanel(name);
                        this.isSelectingPanel = false;
                        return;
                    }
                    ++i;
                }
            }
        }
        if (this.inRect(mouseX, mouseY, cx = x + 10, cy = y + listH + 40, 60, 20)) {
            this.openNamePrompt("Create Panel", this.uniquePanelName("panel"), NameAction.CREATE, this::createPanelWithName);
            return;
        }
        if (this.inRect(mouseX, mouseY, cx + 70, cy, 80, 20)) {
            String suggest = this.uniquePanelName((this.currentPanelName == null ? "panel" : this.currentPanelName) + "_copy");
            this.openNamePrompt("Duplicate Panel", suggest, NameAction.DUPLICATE, this::duplicatePanelTo);
            return;
        }
        if (this.inRect(mouseX, mouseY, cx + 160, cy, 60, 20)) {
            this.openNamePrompt("Rename Panel", this.currentPanelName == null ? "" : this.currentPanelName, NameAction.RENAME, this::renamePanelTo);
            return;
        }
        if (this.inRect(mouseX, mouseY, cx + 230, cy, 40, 20)) {
            this.deleteCurrentPanel();
            return;
        }
        if (mouseX < (double)x || mouseX > (double)(x + w) || mouseY < (double)y || mouseY > (double)(y + listH + 70)) {
            this.isSelectingPanel = false;
        }
    }

    private void openNamePrompt(String title, String initial, NameAction action, Consumer<String> handler) {
        this.namePromptTitle = title;
        this.namePromptAction = action;
        this.namePromptHandler = handler;
        this.namePromptError = null;
        this.namePromptOpen = true;
        int w = 300;
        int h = 130;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - h) / 2;
        if (this.namePromptField != null) {
            this.method_37066((class_364)this.namePromptField);
        }
        this.nameFieldX = x + 10;
        this.nameFieldY = y + 40;
        this.nameFieldW = w - 20;
        this.nameFieldH = 20;
        this.namePromptField = new class_342(this.field_22793, this.nameFieldX, this.nameFieldY, this.nameFieldW, this.nameFieldH, (class_2561)class_2561.method_43470((String)"Name"));
        this.namePromptField.method_1888(true);
        try {
            this.namePromptField.method_1858(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.namePromptField.method_1862(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.namePromptField.method_1852(initial == null ? "" : initial);
        this.method_37063((class_364)this.namePromptField);
        this.method_25395((class_364)this.namePromptField);
        try {
            this.namePromptField.method_25365(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.namePromptField.method_1875(this.namePromptField.method_1882().length());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.namePromptField.method_1884(this.namePromptField.method_1882().length());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void renderNamePrompt(class_332 g, int mouseX, int mouseY) {
        g.method_51448().method_22903();
        g.method_51448().method_46416(0.0f, 0.0f, 1200.0f);
        g.method_25294(0, 0, this.field_22789, this.field_22790, -1442840576);
        int w = 300;
        int h = 130;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - h) / 2;
        g.method_25294(x, y, x + w, y + h, -14803426);
        g.method_49601(x, y, w, h, -1);
        g.method_25303(this.field_22793, this.namePromptTitle, x + 10, y + 10, -22016);
        g.method_25303(this.field_22793, "Name", x + 10, y + 30, -3355444);
        int fx = this.nameFieldX;
        int fy = this.nameFieldY;
        int fw = this.nameFieldW;
        int fh = this.nameFieldH;
        g.method_25294(fx - 1, fy - 1, fx + fw + 1, fy + fh + 1, -11184811);
        g.method_25294(fx, fy, fx + fw, fy + fh, -15790321);
        this.drawButtonLike(g, x + w - 140, y + h - 28, 60, 20, -12952934, "OK");
        this.drawButtonLike(g, x + w - 70, y + h - 28, 60, 20, -11184811, "Cancel");
        if (this.namePromptError != null && !this.namePromptError.isEmpty()) {
            g.method_25303(this.field_22793, this.namePromptError, x + 10, y + h - 26, -43691);
        }
        g.method_51448().method_22909();
    }

    private void handleNamePromptClick(int mx, int my) {
        int w = 300;
        int x = (this.field_22789 - w) / 2;
        int h = 130;
        int y = (this.field_22790 - h) / 2;
        if (this.inRect(mx, my, x + w - 140, y + h - 28, 60, 20)) {
            this.confirmNamePrompt();
            return;
        }
        if (this.inRect(mx, my, x + w - 70, y + h - 28, 60, 20)) {
            this.closeNamePrompt();
            return;
        }
        if (mx < x || mx > x + w || my < y || my > y + h) {
            this.closeNamePrompt();
        }
    }

    private void confirmNamePrompt() {
        boolean exists;
        String newName;
        if (this.namePromptField == null) {
            this.closeNamePrompt();
            return;
        }
        String string = newName = this.namePromptField.method_1882() == null ? "" : this.namePromptField.method_1882().trim();
        if (newName.isEmpty()) {
            this.namePromptError = "Name cannot be empty";
            return;
        }
        QuestTheme theme = QuestTheme.instance;
        boolean bl = exists = theme != null && theme.getPanels() != null && theme.getPanels().containsKey(newName);
        if (this.namePromptAction == NameAction.RENAME) {
            if (!newName.equals(this.currentPanelName) && exists) {
                this.namePromptError = "A panel with that name exists";
                return;
            }
        } else if (exists) {
            this.namePromptError = "A panel with that name exists";
            return;
        }
        if (this.namePromptHandler != null) {
            this.namePromptHandler.accept(newName);
        }
        this.closeNamePrompt();
    }

    public void method_25393() {
        super.method_25393();
        if (this.namePromptOpen && this.namePromptField != null) {
            this.namePromptField.method_1865();
        }
        for (class_339 w : this.propertyWidgets) {
            if (!(w instanceof class_342)) continue;
            class_342 eb = (class_342)w;
            eb.method_1865();
        }
    }

    private void closeNamePrompt() {
        this.namePromptOpen = false;
        this.namePromptTitle = "";
        this.namePromptError = null;
        if (this.namePromptField != null) {
            this.method_37066((class_364)this.namePromptField);
            this.namePromptField = null;
        }
        this.namePromptHandler = null;
    }

    private void loadPanel(String name) {
        PanelTemplate template = QuestTheme.instance.getPanel(name);
        if (template != null && template.getRoot() != null) {
            this.rootNode = template.getRoot().deepCopy();
            this.currentPanelName = name;
            this.selectedNode = this.rootNode;
            this.rebuildPropertyWidgets();
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        this.renderTopBar(g, mouseX, mouseY);
        this.renderCanvas(g, mouseX, mouseY);
        this.renderLeftSidebar(g, mouseX, mouseY);
        this.renderRightSidebar(g, mouseX, mouseY);
        super.method_25394(g, mouseX, mouseY, partialTick);
        if (this.isSelectingPanel) {
            this.renderPanelSelection(g, mouseX, mouseY);
        }
        if (this.themePickerOpen) {
            this.renderThemePicker(g, mouseX, mouseY);
        }
        if (this.showColorPicker) {
            this.renderColorPicker(g);
        }
        if (this.namePromptOpen) {
            this.renderNamePrompt(g, mouseX, mouseY);
            if (this.namePromptField != null) {
                try {
                    this.namePromptField.method_1865();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                g.method_51448().method_22903();
                g.method_51448().method_46416(0.0f, 0.0f, 1300.0f);
                this.namePromptField.method_25394(g, mouseX, mouseY, partialTick);
                g.method_51448().method_22909();
            }
        }
        if (this.draggedNode != null) {
            this.renderDraggedItem(g, mouseX, mouseY);
        }
    }

    private void renderTopBar(class_332 g, int mouseX, int mouseY) {
        g.method_25294(0, 0, this.field_22789, 30, -14671840);
        g.method_25292(0, this.field_22789, 29, -16777216);
        Object t = "Theme Editor";
        if (this.currentPanelName != null && !this.currentPanelName.isEmpty()) {
            t = (String)t + " \u2014 " + this.currentPanelName;
        }
        g.method_25300(this.field_22793, (String)t, this.field_22789 / 2, 10, -1);
    }

    private void renderLeftSidebar(class_332 g, int mouseX, int mouseY) {
        int x = 0;
        int y = 30;
        int w = 250;
        int h = this.field_22790 - 30;
        g.method_25294(x, y, x + w, y + h, -14013910);
        g.method_25301(x + w - 1, y, y + h, -16777216);
        int paletteH = (int)((double)h * 0.5);
        this.renderPalette(g, x, y, w, paletteH, mouseX, mouseY);
        int hierarchyY = y + paletteH;
        int hierarchyH = h - paletteH;
        this.renderHierarchy(g, x, hierarchyY, w, hierarchyH, mouseX, mouseY);
        g.method_25292(x, x + w, hierarchyY, -16777216);
    }

    private void renderPalette(class_332 g, int x, int y, int w, int h, int mouseX, int mouseY) {
        g.method_25303(this.field_22793, "Palette", x + 10, y + 10, -2039584);
        int itemH = 24;
        int gap = 2;
        int headerHeight = 30;
        int contentTop = y + headerHeight;
        int contentHeight = h - headerHeight;
        g.method_44379(x, contentTop, x + w, y + h);
        int itemY = contentTop + (int)this.paletteScrollY;
        for (PanelNode item : this.paletteItems) {
            boolean visible = itemY + itemH > contentTop && itemY < y + h;
            boolean hovered = visible && mouseX >= x + 5 && mouseX < x + w - 5 && mouseY >= itemY && mouseY < itemY + itemH;
            int bg = hovered ? -12566464 : -13619152;
            g.method_25294(x + 5, itemY, x + w - 5, itemY + itemH, bg);
            g.method_49601(x + 5, itemY, w - 10, itemH, -15724528);
            g.method_25303(this.field_22793, item.getType(), x + 15, itemY + 8, -3355444);
            itemY += itemH + gap;
        }
        g.method_44380();
        int totalContentHeight = this.paletteItems.size() * (itemH + gap);
        this.maxPaletteScroll = Math.max(0, totalContentHeight - contentHeight);
    }

    private void renderHierarchy(class_332 g, int x, int y, int w, int h, int mouseX, int mouseY) {
        g.method_25303(this.field_22793, "Hierarchy", x + 10, y + 10, -2039584);
        g.method_44379(x, y + 25, x + w, y + h);
        int contentHeight = 0;
        if (this.rootNode != null) {
            contentHeight = this.renderHierarchyNode(g, this.rootNode, x + 10, y + 30 + (int)this.hierarchyScrollY, w - 20, 0, mouseX, mouseY) - (y + 30 + (int)this.hierarchyScrollY);
        }
        g.method_44380();
        this.maxHierarchyScroll = Math.max(0, contentHeight - (h - 30));
    }

    private int renderHierarchyNode(class_332 g, PanelNode node, int x, int y, int w, int depth, int mouseX, int mouseY) {
        boolean hovered;
        int h = 20;
        int indent = depth * 10;
        boolean bl = hovered = mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h;
        if (node == this.selectedNode) {
            g.method_25294(x, y, x + w, y + h, -12952934);
        } else if (hovered) {
            g.method_25294(x, y, x + w, y + h, -13290187);
        }
        if (depth > 0) {
            g.method_25301(x + indent - 5, y, y + h, -12566464);
            g.method_25292(x + indent - 5, x + indent, y + h / 2, -12566464);
        }
        g.method_25303(this.field_22793, node.getType(), x + indent + 5, y + 6, -2236963);
        if (node.getId() != null && !node.getId().isEmpty()) {
            g.method_25303(this.field_22793, "#" + node.getId(), x + indent + 5 + this.field_22793.method_1727(node.getType()) + 5, y + 6, -7829368);
        }
        int currentY = y + h;
        List<PanelNode> children = this.getChildren(node);
        if (children != null) {
            for (PanelNode child : children) {
                currentY = this.renderHierarchyNode(g, child, x, currentY, w, depth + 1, mouseX, mouseY);
            }
        }
        return currentY;
    }

    private PanelNode getNodeAt(int mouseX, int mouseY) {
        if (mouseX <= 250 || mouseX >= this.field_22789 - 300 || mouseY <= 30) {
            return null;
        }
        int canvasX = mouseX - 250;
        int canvasY = mouseY - 30;
        int w = this.field_22789 - 250 - 300;
        int h = this.field_22790 - 30;
        float localX = ((float)canvasX - (float)w / 2.0f - this.canvasOffsetX) / this.canvasScale;
        float localY = ((float)canvasY - (float)h / 2.0f - this.canvasOffsetY) / this.canvasScale;
        int rootW = 400;
        int rootH = 300;
        int localXAdjusted = (int)Math.floor(localX);
        int localYAdjusted = (int)Math.floor(localY);
        PanelNode hit = this.panelRenderer.findTopmostNodeAtPoint(localXAdjusted, localYAdjusted);
        return hit;
    }

    private PanelNode findNodeAtRecursive(PanelNode node, int x, int startY, int w, int depth, int mouseX, int mouseY) {
        int h = 20;
        if (mouseY >= startY && mouseY < startY + h && mouseX >= x && mouseX < x + w) {
            return node;
        }
        int currentY = startY + h;
        List<PanelNode> children = this.getChildren(node);
        if (children != null) {
            for (PanelNode child : children) {
                PanelNode found = this.findNodeAtRecursive(child, x, currentY, w, depth + 1, mouseX, mouseY);
                if (found != null) {
                    return found;
                }
                currentY = this.getSubTreeHeight(child, currentY);
            }
        }
        return null;
    }

    private boolean reorderWithinParent(PanelNode node, int canvasX, int canvasY) {
        PanelNode parent = this.findParent(this.rootNode, node);
        if (parent == null) {
            return false;
        }
        List<PanelNode> list = this.getChildren(parent);
        if (list == null) {
            return false;
        }
        int cur = list.indexOf(node);
        if (cur < 0) {
            return false;
        }
        int targetIndex = cur;
        if (parent instanceof VStackNode) {
            for (int i = 0; i < list.size(); ++i) {
                PanelRenderer.Rect r = this.panelRenderer.getNodeBounds(list.get(i));
                if (r == null) continue;
                int midY = r.y() + r.height() / 2;
                if (canvasY < midY) {
                    targetIndex = i;
                    break;
                }
                targetIndex = i + 1;
            }
        } else if (parent instanceof HStackNode) {
            for (int i = 0; i < list.size(); ++i) {
                PanelRenderer.Rect r = this.panelRenderer.getNodeBounds(list.get(i));
                if (r == null) continue;
                int midX = r.x() + r.width() / 2;
                if (canvasX < midX) {
                    targetIndex = i;
                    break;
                }
                targetIndex = i + 1;
            }
        } else {
            return false;
        }
        if (targetIndex == cur || targetIndex == cur + 1) {
            return false;
        }
        list.remove(cur);
        if (targetIndex > cur) {
            --targetIndex;
        }
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        if (targetIndex > list.size()) {
            targetIndex = list.size();
        }
        list.add(targetIndex, node);
        return true;
    }

    private void openThemePicker(class_342 target, Consumer<String> setter, String defaultKey) {
        this.themePickerTarget = target;
        this.themePickerSetter = setter;
        if (this.themeIconKeys == null) {
            this.themeIconKeys = new ArrayList<String>();
            for (Field f : ThemeProperties.class.getFields()) {
                if (!IconProperty.class.isAssignableFrom(f.getType())) continue;
                this.themeIconKeys.add(f.getName().toLowerCase());
            }
            Collections.sort(this.themeIconKeys);
        }
        this.themePickerOpen = true;
        this.themePickerScrollY = 0.0;
    }

    private void renderThemePicker(class_332 g, int mouseX, int mouseY) {
        g.method_51448().method_22903();
        g.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
        g.method_25294(0, 0, this.field_22789, this.field_22790, -1442840576);
        int w = 320;
        int h = 260;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - h) / 2;
        g.method_25294(x, y, x + w, y + h, -14803426);
        g.method_49601(x, y, w, h, -1);
        g.method_25303(this.field_22793, "Pick Theme Icon", x + 10, y + 8, -22016);
        int listX = x + 10;
        int listY = y + 26;
        int listW = w - 20;
        int listH = h - 36;
        g.method_44379(listX, listY, listX + listW, listY + listH);
        int itemY = listY + (int)this.themePickerScrollY;
        int itemH = 18;
        if (this.themeIconKeys != null) {
            for (String key : this.themeIconKeys) {
                boolean hovered = mouseX >= listX && mouseX < listX + listW && mouseY >= itemY && mouseY < itemY + itemH;
                g.method_25294(listX, itemY, listX + listW, itemY + itemH, hovered ? -13419964 : -14012618);
                g.method_25303(this.field_22793, key, listX + 6, itemY + 5, -2236963);
                itemY += itemH + 2;
            }
        }
        g.method_44380();
        g.method_51448().method_22909();
    }

    private void handleThemePickerClick(int mx, int my) {
        int w = 320;
        int h = 260;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - h) / 2;
        int listX = x + 10;
        int listY = y + 26;
        int listW = w - 20;
        int listH = h - 36;
        int itemH = 18;
        if (mx >= listX && mx < listX + listW && my >= listY && my < listY + listH) {
            int idx = (int)(((double)(my - listY) - this.themePickerScrollY) / (double)(itemH + 2));
            if (this.themeIconKeys != null && idx >= 0 && idx < this.themeIconKeys.size()) {
                String key = this.themeIconKeys.get(idx);
                String bind = "${theme." + key + "}";
                if (this.themePickerTarget != null) {
                    this.themePickerTarget.method_1852(bind);
                }
                if (this.themePickerSetter != null) {
                    this.themePickerSetter.accept(bind);
                }
                this.themePickerOpen = false;
                return;
            }
        }
        if (mx < x || mx > x + w || my < y || my > y + h) {
            this.themePickerOpen = false;
        }
    }

    private void createNewPanel() {
        String name = this.uniquePanelName("panel");
        VStackNode root = new VStackNode();
        root.setWidth("100%");
        root.setHeight("100%");
        root.setPadding(10);
        this.rootNode = root;
        this.currentPanelName = name;
        this.selectedNode = root;
        if (QuestTheme.instance != null) {
            QuestTheme.instance.addPanel(name, new PanelTemplate(name, ((PanelNode)root).deepCopy()));
        }
        this.isSelectingPanel = false;
        this.rebuildPropertyWidgets();
    }

    private void duplicateCurrentPanel() {
        if (this.currentPanelName == null || this.rootNode == null) {
            return;
        }
        String name = this.uniquePanelName(this.currentPanelName + "_copy");
        if (QuestTheme.instance != null) {
            QuestTheme.instance.addPanel(name, new PanelTemplate(name, this.rootNode.deepCopy()));
        }
        this.currentPanelName = name;
        this.isSelectingPanel = false;
    }

    private void renameCurrentPanel() {
        if (this.currentPanelName == null) {
            return;
        }
        String name = this.uniquePanelName(this.currentPanelName + "_renamed");
        if (QuestTheme.instance != null) {
            QuestTheme.instance.addPanel(name, new PanelTemplate(name, this.rootNode != null ? this.rootNode.deepCopy() : new VStackNode()));
        }
        this.currentPanelName = name;
        this.isSelectingPanel = false;
    }

    private void deleteCurrentPanel() {
        QuestTheme theme = QuestTheme.instance;
        if (theme == null || theme.getPanels() == null || this.currentPanelName == null) {
            this.isSelectingPanel = false;
            return;
        }
        theme.getPanels().remove(this.currentPanelName);
        if (!theme.getPanels().isEmpty()) {
            String next = theme.getPanels().keySet().iterator().next();
            this.loadPanel(next);
        } else {
            this.createNewPanel();
        }
        this.isSelectingPanel = false;
    }

    private String uniquePanelName(String base) {
        QuestTheme theme = QuestTheme.instance;
        int i = 1;
        Object name = base;
        while (theme != null && theme.getPanels() != null && theme.getPanels().containsKey(name)) {
            name = base + "_" + i++;
        }
        return name;
    }

    private void createPanelWithName(String name) {
        VStackNode root = new VStackNode();
        root.setWidth("100%");
        root.setHeight("100%");
        root.setPadding(10);
        this.rootNode = root;
        this.currentPanelName = name;
        this.selectedNode = root;
        QuestTheme theme = QuestTheme.instance;
        if (theme != null) {
            theme.addPanel(name, new PanelTemplate(name, ((PanelNode)root).deepCopy()));
        }
        this.isSelectingPanel = false;
        this.rebuildPropertyWidgets();
    }

    private void duplicatePanelTo(String name) {
        if (this.rootNode == null) {
            return;
        }
        PanelNode copy = this.rootNode.deepCopy();
        QuestTheme theme = QuestTheme.instance;
        if (theme != null) {
            theme.addPanel(name, new PanelTemplate(name, copy.deepCopy()));
        }
        this.rootNode = copy;
        this.currentPanelName = name;
        this.selectedNode = copy;
        this.isSelectingPanel = false;
        this.rebuildPropertyWidgets();
    }

    private void renamePanelTo(String name) {
        QuestTheme theme = QuestTheme.instance;
        if (theme == null || theme.getPanels() == null || this.currentPanelName == null) {
            return;
        }
        theme.getPanels().remove(this.currentPanelName);
        theme.addPanel(name, new PanelTemplate(name, this.rootNode != null ? this.rootNode.deepCopy() : new VStackNode()));
        this.currentPanelName = name;
        this.isSelectingPanel = false;
    }

    private int getSubTreeHeight(PanelNode node, int currentY) {
        int h = 20;
        int nextY = currentY + h;
        List<PanelNode> children = this.getChildren(node);
        if (children != null) {
            for (PanelNode child : children) {
                nextY = this.getSubTreeHeight(child, nextY);
            }
        }
        return nextY;
    }

    private void renderRightSidebar(class_332 g, int mouseX, int mouseY) {
        int x = this.field_22789 - 300;
        int w = 300;
        int h = this.field_22790 - 30;
        int y = 30;
        g.method_25294(x, y, x + w, y + h, -14671840);
        g.method_25294(x, y, x + 1, y + h, -12566464);
        g.method_25303(this.field_22793, "Details", x + 10, y + 10, -1);
        if (this.selectedNode != null) {
            g.method_25303(this.field_22793, "Type: " + this.selectedNode.getType(), x + 10, y + 25, -5592406);
            int contentY = y + 40;
            int contentH = h - 40;
            g.method_44379(x, contentY, x + w, contentY + contentH);
            for (LabelEntry entry : this.propertyLabels) {
                int drawY = entry.y - this.rightSidebarScroll;
                if (drawY + 20 < contentY || drawY > contentY + contentH) continue;
                if (entry.isHeader) {
                    g.method_25294(entry.x + 5, drawY, entry.x + w - 5, drawY + 14, -13290187);
                    g.method_25303(this.field_22793, entry.text, entry.x + 8, drawY + 3, entry.color);
                    continue;
                }
                g.method_25303(this.field_22793, entry.text, entry.x, drawY + 5, entry.color);
            }
            for (class_339 widget : this.propertyWidgets) {
                Integer baseY = this.widgetBaseY.get(widget);
                if (baseY == null) continue;
                widget.method_46419(baseY - this.rightSidebarScroll);
                if (widget.method_46427() + widget.method_25364() <= contentY || widget.method_46427() >= contentY + contentH) continue;
                widget.method_25394(g, mouseX, mouseY, 0.0f);
            }
            g.method_44380();
            if (this.totalPropertyHeight > contentH) {
                int scrollbarW = 4;
                int scrollbarX = x + w - 6;
                int trackH = contentH;
                int thumbH = Math.max(20, (int)((float)contentH / (float)this.totalPropertyHeight * (float)contentH));
                int thumbY = contentY + (int)((float)this.rightSidebarScroll / (float)(this.totalPropertyHeight - contentH) * (float)(trackH - thumbH));
                g.method_25294(scrollbarX, contentY, scrollbarX + scrollbarW, contentY + trackH, -13619152);
                g.method_25294(scrollbarX, thumbY, scrollbarX + scrollbarW, thumbY + thumbH, -10461088);
            }
        } else {
            g.method_25303(this.field_22793, "Select an element to edit", x + 10, y + 40, -7829368);
        }
    }

    private void rebuildPropertyWidgets() {
        this.propertyWidgets.clear();
        this.widgetBaseY.clear();
        this.propertyLabels.clear();
        this.rightSidebarScroll = 0;
        if (this.selectedNode == null) {
            return;
        }
        int x = this.field_22789 - 300;
        int y = 70;
        int w = 300;
        int h = 20;
        int gap = 24;
        this.rawJsonBuffer = this.selectedNode.toJson().toString();
        y = this.addSectionHeader("Layout", x, y, w) + 5;
        class_342 widthBox = this.addField("Width", this.selectedNode.getWidth(), val -> this.selectedNode.setWidth((String)val), x, y, w, h);
        this.addUnitButtons(widthBox, x, y, w, h, v -> this.selectedNode.setWidth((String)v));
        class_342 heightBox = this.addField("Height", this.selectedNode.getHeight(), val -> this.selectedNode.setHeight((String)val), x, y += gap, w, h);
        this.addUnitButtons(heightBox, x, y, w, h, v -> this.selectedNode.setHeight((String)v));
        this.addPropertyField("Min Width", this.selectedNode.getMinWidth() == null ? "" : this.selectedNode.getMinWidth(), val -> {
            if (!val.isEmpty()) {
                this.selectedNode.setMinWidth((String)val);
            } else {
                this.selectedNode.setMinWidth(null);
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Max Width", this.selectedNode.getMaxWidth() == null ? "" : this.selectedNode.getMaxWidth(), val -> {
            if (!val.isEmpty()) {
                this.selectedNode.setMaxWidth((String)val);
            } else {
                this.selectedNode.setMaxWidth(null);
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Min Height", this.selectedNode.getMinHeight() == null ? "" : this.selectedNode.getMinHeight(), val -> {
            if (!val.isEmpty()) {
                this.selectedNode.setMinHeight((String)val);
            } else {
                this.selectedNode.setMinHeight(null);
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Max Height", this.selectedNode.getMaxHeight() == null ? "" : this.selectedNode.getMaxHeight(), val -> {
            if (!val.isEmpty()) {
                this.selectedNode.setMaxHeight((String)val);
            } else {
                this.selectedNode.setMaxHeight(null);
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Padding", String.valueOf(this.selectedNode.getPadding() == null ? "" : this.selectedNode.getPadding()), val -> {
            try {
                if (!val.isEmpty()) {
                    this.selectedNode.setPadding(Integer.parseInt(val));
                } else {
                    this.selectedNode.setPadding(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Margin", String.valueOf(this.selectedNode.getMargin() == null ? "" : this.selectedNode.getMargin()), val -> {
            try {
                if (!val.isEmpty()) {
                    this.selectedNode.setMargin(Integer.parseInt(val));
                } else {
                    this.selectedNode.setMargin(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, x, y += gap, w, h);
        class_342 alignBox = this.addField("Align", this.selectedNode.getAlign(), val -> this.selectedNode.setAlign((String)val), x, y += gap, w, h);
        this.addCycleButton(x, y, w, h, alignBox, new String[]{"start", "center", "end"}, v -> this.selectedNode.setAlign((String)v));
        class_342 justifyBox = this.addField("Justify", this.selectedNode.getJustify(), val -> this.selectedNode.setJustify((String)val), x, y += gap, w, h);
        this.addCycleButton(x, y, w, h, justifyBox, new String[]{"start", "center", "end", "space_between"}, v -> this.selectedNode.setJustify((String)v));
        y += gap + 5;
        y = this.addSectionHeader("Styling", x, y, w) + 5;
        class_342 bgBox = this.addField("Background", this.selectedNode.getBackground(), val -> this.selectedNode.setBackground((String)val), x, y, w, h);
        this.addThemeQuickButton(x, y, w, h, bgBox, "quest_view_background");
        class_342 borderBox = this.addField("Border Color", this.selectedNode.getBorderColor(), val -> this.selectedNode.setBorderColor((String)val), x, y += gap, w, h);
        this.addPresetColorButton(x, y, w, h, borderBox);
        this.addPropertyField("Border Width", this.selectedNode.getBorderWidth() == null ? "" : String.valueOf(this.selectedNode.getBorderWidth()), val -> {
            try {
                if (!val.isEmpty()) {
                    this.selectedNode.setBorderWidth(Integer.parseInt(val));
                } else {
                    this.selectedNode.setBorderWidth(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Border Radius", this.selectedNode.getBorderRadius() == null ? "" : String.valueOf(this.selectedNode.getBorderRadius()), val -> {
            try {
                if (!val.isEmpty()) {
                    this.selectedNode.setBorderRadius(Integer.parseInt(val));
                } else {
                    this.selectedNode.setBorderRadius(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Shadow", this.selectedNode.getShadow(), val -> this.selectedNode.setShadow(val.isEmpty() ? null : val), x, y += gap, w, h);
        this.addPropertyField("Opacity", this.selectedNode.getOpacity() == null ? "" : String.valueOf(this.selectedNode.getOpacity()), val -> {
            try {
                if (!val.isEmpty()) {
                    this.selectedNode.setOpacity(Float.valueOf(Float.parseFloat(val)));
                } else {
                    this.selectedNode.setOpacity(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Rotation", this.selectedNode.getRotation() == null ? "" : String.valueOf(this.selectedNode.getRotation()), val -> {
            try {
                if (!val.isEmpty()) {
                    this.selectedNode.setRotation(Float.valueOf(Float.parseFloat(val)));
                } else {
                    this.selectedNode.setRotation(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, x, y += gap, w, h);
        this.addPropertyField("Scale", this.selectedNode.getScale() == null ? "" : String.valueOf(this.selectedNode.getScale()), val -> {
            try {
                if (!val.isEmpty()) {
                    this.selectedNode.setScale(Float.valueOf(Float.parseFloat(val)));
                } else {
                    this.selectedNode.setScale(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, x, y += gap, w, h);
        y += gap + 5;
        y = this.addSectionHeader("Identity", x, y, w) + 5;
        this.addPropertyField("ID", this.selectedNode.getId(), val -> this.selectedNode.setId((String)val), x, y, w, h);
        class_342 visibleBox = this.addField("Visible", this.selectedNode.getVisible(), val -> this.selectedNode.setVisible((String)val), x, y += gap, w, h);
        this.addToggleButton(x, y, w, h, visibleBox, v -> this.selectedNode.setVisible((String)v));
        y += gap + 10;
        y = this.addSectionHeader("Type: " + this.selectedNode.getType(), x, y, w) + 5;
        PanelNode panelNode = this.selectedNode;
        if (panelNode instanceof VStackNode) {
            VStackNode n = (VStackNode)panelNode;
            this.addPropertyField("Spacing", n.getSpacing() == null ? "" : String.valueOf(n.getSpacing()), val -> {
                try {
                    if (!val.isEmpty()) {
                        n.setSpacing(Integer.parseInt(val));
                    } else {
                        n.setSpacing(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, x, y, w, h);
            y += gap;
        } else {
            panelNode = this.selectedNode;
            if (panelNode instanceof HStackNode) {
                HStackNode n = (HStackNode)panelNode;
                this.addPropertyField("Spacing", n.getSpacing() == null ? "" : String.valueOf(n.getSpacing()), val -> {
                    try {
                        if (!val.isEmpty()) {
                            n.setSpacing(Integer.parseInt(val));
                        } else {
                            n.setSpacing(null);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, x, y, w, h);
                y += gap;
            } else if (!(this.selectedNode instanceof StackNode)) {
                panelNode = this.selectedNode;
                if (panelNode instanceof TextNode) {
                    TextNode n = (TextNode)panelNode;
                    this.addPropertyField("Text", n.getText(), val -> n.setText((String)val), x, y, w, h);
                    textColor = this.addField("Color", n.getColor(), val -> n.setColor((String)val), x, y += gap, w, h);
                    this.addColorPickerButton(x, y, w, h, (class_342)textColor, s -> {
                        n.setColor((String)s);
                        this.validateField("Color", (String)s, 0);
                    });
                    this.addPropertyField("Font", n.getFont(), val -> n.setFont((String)val), x, y += gap, w, h);
                    class_342 textAlignBox = this.addField("Align", n.getTextAlign(), val -> n.setTextAlign((String)val), x, y += gap, w, h);
                    this.addCycleButton(x, y, w, h, textAlignBox, new String[]{"left", "center", "right"}, v -> n.setTextAlign((String)v));
                    this.addPropertyField("Font Size", n.getFontSize() == null ? "" : String.valueOf(n.getFontSize()), val -> {
                        try {
                            if (!val.isEmpty()) {
                                n.setFontSize(Float.valueOf(Float.parseFloat(val)));
                            } else {
                                n.setFontSize(null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }, x, y += gap, w, h);
                    this.addPropertyField("Line Height", n.getLineHeight() == null ? "" : n.getLineHeight(), val -> n.setLineHeight(val.isEmpty() ? null : val), x, y += gap, w, h);
                    class_342 boldBox = this.addField("Bold", n.getBold() != null && n.getBold() != false ? "true" : "false", val -> n.setBold("true".equals(val)), x, y += gap, w, h);
                    this.addToggleButton(x, y, w, h, boldBox, v -> n.setBold("true".equals(v)));
                    class_342 italicBox = this.addField("Italic", n.getItalic() != null && n.getItalic() != false ? "true" : "false", val -> n.setItalic("true".equals(val)), x, y += gap, w, h);
                    this.addToggleButton(x, y, w, h, italicBox, v -> n.setItalic("true".equals(v)));
                    this.addPropertyField("Shadow", n.getTextShadow(), val -> n.setTextShadow(val.isEmpty() ? null : val), x, y += gap, w, h);
                    class_342 wrapBox = this.addField("Wrap", n.getWrap() != null && n.getWrap() != false ? "true" : "false", val -> n.setWrap("true".equals(val)), x, y += gap, w, h);
                    this.addToggleButton(x, y, w, h, wrapBox, v -> n.setWrap("true".equals(v)));
                    y += gap;
                } else {
                    textColor = this.selectedNode;
                    if (textColor instanceof RichTextNode) {
                        RichTextNode n = (RichTextNode)textColor;
                        this.addPropertyField("Text", n.getText(), val -> n.setText((String)val), x, y, w, h);
                        rtColor = this.addField("Color", n.getColor(), val -> n.setColor((String)val), x, y += gap, w, h);
                        this.addColorPickerButton(x, y, w, h, (class_342)rtColor, s -> {
                            n.setColor((String)s);
                            this.validateField("Color", (String)s, 0);
                        });
                        y += gap;
                    } else {
                        rtColor = this.selectedNode;
                        if (rtColor instanceof ButtonNode) {
                            ButtonNode n = (ButtonNode)rtColor;
                            this.addPropertyField("Text", n.getText(), val -> n.setText((String)val), x, y, w, h);
                            this.addPropertyField("OnClick", n.getOnClick(), val -> n.setOnClick((String)val), x, y += gap, w, h);
                            this.addPropertyField("Enabled", n.getEnabled(), val -> n.setEnabled((String)val), x, y += gap, w, h);
                            y += gap;
                        } else {
                            rtColor = this.selectedNode;
                            if (rtColor instanceof IconNode) {
                                IconNode n = (IconNode)rtColor;
                                valBox = this.addField("Value", n.getValue(), val -> n.setValue((String)val), x, y, w, h);
                                this.addThemeQuickButton(x, y, w, h, (class_342)valBox, "check_icon");
                                this.addPropertyField("Size", n.getSize() == null ? "" : String.valueOf(n.getSize()), val -> {
                                    try {
                                        if (!val.isEmpty()) {
                                            n.setSize(Integer.parseInt(val));
                                        } else {
                                            n.setSize(null);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }, x, y += gap, w, h);
                                y += gap;
                            } else {
                                valBox = this.selectedNode;
                                if (valBox instanceof ImageNode) {
                                    ImageNode n = (ImageNode)valBox;
                                    srcBox = this.addField("Src", n.getSrc(), val -> n.setSrc((String)val), x, y, w, h);
                                    int bx = x + 80;
                                    class_4185 tx = class_4185.method_46430((class_2561)class_2561.method_43470((String)"texture:"), arg_0 -> NewThemeEditorScreen.lambda$rebuildPropertyWidgets$56((class_342)srcBox, arg_0)).method_46434(bx - 72, y, 66, h).method_46431();
                                    this.propertyWidgets.add((class_339)tx);
                                    this.widgetBaseY.put((class_339)tx, y);
                                    y += gap;
                                    class_342 fitBox = this.addField("Fit", n.getFit(), val -> n.setFit((String)val), x, y += gap, w, h);
                                    this.addCycleButton(x, y, w, h, fitBox, new String[]{"contain", "cover", "fill", "none"}, v -> n.setFit((String)v));
                                    this.addPropertyField("Img Width", n.getImageWidth() == null ? "" : String.valueOf(n.getImageWidth()), val -> {
                                        try {
                                            if (!val.isEmpty()) {
                                                n.setImageWidth(Integer.parseInt(val));
                                            } else {
                                                n.setImageWidth(null);
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }, x, y += gap, w, h);
                                    this.addPropertyField("Img Height", n.getImageHeight() == null ? "" : String.valueOf(n.getImageHeight()), val -> {
                                        try {
                                            if (!val.isEmpty()) {
                                                n.setImageHeight(Integer.parseInt(val));
                                            } else {
                                                n.setImageHeight(null);
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }, x, y += gap, w, h);
                                    this.addPropertyField("Max Width", n.getMaxWidth() == null ? "" : n.getMaxWidth(), val -> {
                                        if (!val.isEmpty()) {
                                            n.setMaxWidth((String)val);
                                        } else {
                                            n.setMaxWidth(null);
                                        }
                                    }, x, y += gap, w, h);
                                    y += gap;
                                } else {
                                    srcBox = this.selectedNode;
                                    if (srcBox instanceof ImageListNode) {
                                        ImageListNode n = (ImageListNode)srcBox;
                                        this.addPropertyField("Items", n.getItems(), val -> n.setItems((String)val), x, y, w, h);
                                        this.addPropertyField("Max Width", n.getMaxWidth(), val -> n.setMaxWidth((String)val), x, y += gap, w, h);
                                        y += gap;
                                    } else {
                                        srcBox = this.selectedNode;
                                        if (srcBox instanceof ListNode) {
                                            ListNode n = (ListNode)srcBox;
                                            this.addPropertyField("Items", n.getItems(), val -> n.setItems((String)val), x, y, w, h);
                                            y += gap;
                                        } else {
                                            srcBox = this.selectedNode;
                                            if (srcBox instanceof SpacerNode) {
                                                SpacerNode n = (SpacerNode)srcBox;
                                                this.addPropertyField("Size", n.getSize() == null ? "" : String.valueOf(n.getSize()), val -> {
                                                    try {
                                                        if (!val.isEmpty()) {
                                                            n.setSize(Integer.parseInt(val));
                                                        } else {
                                                            n.setSize(null);
                                                        }
                                                    }
                                                    catch (Exception exception) {
                                                        // empty catch block
                                                    }
                                                }, x, y, w, h);
                                                y += gap;
                                            } else {
                                                srcBox = this.selectedNode;
                                                if (srcBox instanceof ConditionalNode) {
                                                    ConditionalNode n = (ConditionalNode)srcBox;
                                                    this.addPropertyField("Condition", n.getWhen(), val -> n.setWhen((String)val), x, y, w, h);
                                                    y += gap;
                                                } else {
                                                    srcBox = this.selectedNode;
                                                    if (srcBox instanceof DividerNode) {
                                                        DividerNode n = (DividerNode)srcBox;
                                                        orientBox = this.addField("Orientation", n.getOrientation(), val -> n.setOrientation((String)val), x, y, w, h);
                                                        this.addCycleButton(x, y, w, h, (class_342)orientBox, new String[]{"horizontal", "vertical"}, v -> n.setOrientation((String)v));
                                                        this.addPropertyField("Thickness", n.getThickness() == null ? "" : String.valueOf(n.getThickness()), val -> {
                                                            try {
                                                                if (!val.isEmpty()) {
                                                                    n.setThickness(Integer.parseInt(val));
                                                                } else {
                                                                    n.setThickness(null);
                                                                }
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                        }, x, y += gap, w, h);
                                                        class_342 divColor = this.addField("Color", n.getColor(), val -> n.setColor((String)val), x, y += gap, w, h);
                                                        this.addColorPickerButton(x, y, w, h, divColor, s -> n.setColor((String)s));
                                                        class_342 styleBox = this.addField("Style", n.getStyle(), val -> n.setStyle((String)val), x, y += gap, w, h);
                                                        this.addCycleButton(x, y, w, h, styleBox, new String[]{"solid", "dashed", "dotted"}, v -> n.setStyle((String)v));
                                                        y += gap;
                                                    } else {
                                                        orientBox = this.selectedNode;
                                                        if (orientBox instanceof TabContainerNode) {
                                                            TabContainerNode n = (TabContainerNode)orientBox;
                                                            this.addPropertyField("Selected Tab", n.getSelectedTab(), val -> n.setSelectedTab((String)val), x, y, w, h);
                                                            posBox = this.addField("Tab Position", n.getTabPosition(), val -> n.setTabPosition((String)val), x, y += gap, w, h);
                                                            this.addCycleButton(x, y, w, h, (class_342)posBox, new String[]{"top", "bottom", "left", "right"}, v -> n.setTabPosition((String)v));
                                                            this.addPropertyField("Tab Spacing", n.getTabSpacing() == null ? "" : String.valueOf(n.getTabSpacing()), val -> {
                                                                try {
                                                                    if (!val.isEmpty()) {
                                                                        n.setTabSpacing(Integer.parseInt(val));
                                                                    } else {
                                                                        n.setTabSpacing(null);
                                                                    }
                                                                }
                                                                catch (Exception exception) {
                                                                    // empty catch block
                                                                }
                                                            }, x, y += gap, w, h);
                                                            class_342 tabBgBox = this.addField("Tab BG", n.getTabBackground(), val -> n.setTabBackground((String)val), x, y += gap, w, h);
                                                            this.addColorPickerButton(x, y, w, h, tabBgBox, s -> n.setTabBackground((String)s));
                                                            class_342 activeTabBgBox = this.addField("Active BG", n.getActiveTabBackground(), val -> n.setActiveTabBackground((String)val), x, y += gap, w, h);
                                                            this.addColorPickerButton(x, y, w, h, activeTabBgBox, s -> n.setActiveTabBackground((String)s));
                                                            class_342 tabColorBox = this.addField("Tab Color", n.getTabColor(), val -> n.setTabColor((String)val), x, y += gap, w, h);
                                                            this.addColorPickerButton(x, y, w, h, tabColorBox, s -> n.setTabColor((String)s));
                                                            class_342 activeTabColorBox = this.addField("Active Color", n.getActiveTabColor(), val -> n.setActiveTabColor((String)val), x, y += gap, w, h);
                                                            this.addColorPickerButton(x, y, w, h, activeTabColorBox, s -> n.setActiveTabColor((String)s));
                                                            y += gap;
                                                            y = this.addSectionHeader("Tabs", x, y, w) + 5;
                                                            for (int i = 0; i < n.getTabs().size(); ++i) {
                                                                TabContainerNode.Tab tab = n.getTabs().get(i);
                                                                this.addPropertyField("Tab " + (i + 1) + " ID", tab.id, val -> {
                                                                    tab.id = val;
                                                                }, x, y, w, h);
                                                                this.addPropertyField("Tab " + (i + 1) + " Label", tab.label, val -> {
                                                                    tab.label = val;
                                                                }, x, y += gap, w, h);
                                                                this.addPropertyField("Tab " + (i + 1) + " Icon", tab.icon, val -> {
                                                                    tab.icon = val;
                                                                }, x, y += gap, w, h);
                                                                this.addPropertyField("Tab " + (i + 1) + " Icon", tab.icon, val -> {
                                                                    tab.icon = val;
                                                                }, x, y += gap, w, h);
                                                                class_342 styleBox = this.addField("Tab " + (i + 1) + " Style", tab.style, val -> {
                                                                    tab.style = val;
                                                                }, x, y += gap, w, h);
                                                                this.addCycleButton(x, y, w, h, styleBox, new String[]{"none", "primary", "danger", "success", "warning"}, v -> {
                                                                    tab.style = v;
                                                                });
                                                                int btnY = y += gap;
                                                                class_4185 editContent = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit Content"), b -> {
                                                                    if (tab.content == null) {
                                                                        tab.content = new VStackNode();
                                                                        tab.content.setId(tab.id + "_content");
                                                                    }
                                                                    this.selectedNode = tab.content;
                                                                    this.rebuildPropertyWidgets();
                                                                }).method_46434(x + 80, btnY, w - 160, h).method_46431();
                                                                this.propertyWidgets.add((class_339)editContent);
                                                                this.widgetBaseY.put((class_339)editContent, btnY);
                                                                this.propertyLabels.add(new LabelEntry("Content", x + 10, btnY, -3355444, false));
                                                                y += gap;
                                                                class_4185 upBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), b -> {
                                                                    int idx = n.getTabs().indexOf(tab);
                                                                    if (idx > 0) {
                                                                        Collections.swap(n.getTabs(), idx, idx - 1);
                                                                        this.rebuildPropertyWidgets();
                                                                    }
                                                                }).method_46434(x + w - 70, btnY, 20, h).method_46431();
                                                                this.propertyWidgets.add((class_339)upBtn);
                                                                this.widgetBaseY.put((class_339)upBtn, btnY);
                                                                class_4185 downBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), b -> {
                                                                    int idx = n.getTabs().indexOf(tab);
                                                                    if (idx < n.getTabs().size() - 1) {
                                                                        Collections.swap(n.getTabs(), idx, idx + 1);
                                                                        this.rebuildPropertyWidgets();
                                                                    }
                                                                }).method_46434(x + w - 48, btnY, 20, h).method_46431();
                                                                this.propertyWidgets.add((class_339)downBtn);
                                                                this.widgetBaseY.put((class_339)downBtn, btnY);
                                                                class_4185 removeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), b -> {
                                                                    n.getTabs().remove(tab);
                                                                    if (n.getTabs().isEmpty()) {
                                                                        n.getTabs().add(new TabContainerNode.Tab("tab1", "Tab 1", new VStackNode()));
                                                                    }
                                                                    this.rebuildPropertyWidgets();
                                                                }).method_46434(x + w - 26, btnY, 20, h).method_46431();
                                                                this.propertyWidgets.add((class_339)removeBtn);
                                                                this.widgetBaseY.put((class_339)removeBtn, btnY);
                                                                y += gap;
                                                            }
                                                            class_4185 addTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+ Tab"), b -> {
                                                                int idx = n.getTabs().size() + 1;
                                                                n.getTabs().add(new TabContainerNode.Tab("tab" + idx, "Tab " + idx, new VStackNode()));
                                                                this.rebuildPropertyWidgets();
                                                            }).method_46434(x + w - 90, y - gap - 10, 80, h).method_46431();
                                                            this.propertyWidgets.add((class_339)addTab);
                                                            this.widgetBaseY.put((class_339)addTab, y - gap - 10);
                                                        } else {
                                                            posBox = this.selectedNode;
                                                            if (posBox instanceof GridNode) {
                                                                GridNode n = (GridNode)posBox;
                                                                this.addPropertyField("Columns", n.getColumns() == null ? "" : String.valueOf(n.getColumns()), val -> {
                                                                    try {
                                                                        if (!val.isEmpty()) {
                                                                            n.setColumns(Integer.parseInt(val));
                                                                        } else {
                                                                            n.setColumns(null);
                                                                        }
                                                                    }
                                                                    catch (Exception exception) {
                                                                        // empty catch block
                                                                    }
                                                                }, x, y, w, h);
                                                                this.addPropertyField("Rows", n.getRows() == null ? "" : String.valueOf(n.getRows()), val -> {
                                                                    try {
                                                                        if (!val.isEmpty()) {
                                                                            n.setRows(Integer.parseInt(val));
                                                                        } else {
                                                                            n.setRows(null);
                                                                        }
                                                                    }
                                                                    catch (Exception exception) {
                                                                        // empty catch block
                                                                    }
                                                                }, x, y += gap, w, h);
                                                                this.addPropertyField("Gap", n.getGap() == null ? "" : String.valueOf(n.getGap()), val -> {
                                                                    try {
                                                                        if (!val.isEmpty()) {
                                                                            n.setGap(Integer.parseInt(val));
                                                                        } else {
                                                                            n.setGap(null);
                                                                        }
                                                                    }
                                                                    catch (Exception exception) {
                                                                        // empty catch block
                                                                    }
                                                                }, x, y += gap, w, h);
                                                                y += gap;
                                                            } else {
                                                                posBox = this.selectedNode;
                                                                if (posBox instanceof ProgressBarNode) {
                                                                    ProgressBarNode n = (ProgressBarNode)posBox;
                                                                    this.addPropertyField("Value", n.getValue(), val -> n.setValue((String)val), x, y, w, h);
                                                                    this.addPropertyField("Max", n.getMax(), val -> n.setMax((String)val), x, y += gap, w, h);
                                                                    fillBox = this.addField("Color", n.getColor(), val -> n.setColor((String)val), x, y += gap, w, h);
                                                                    this.addColorPickerButton(x, y, w, h, (class_342)fillBox, s -> n.setColor((String)s));
                                                                    class_342 progBgBox = this.addField("BG Color", n.getBackgroundColor(), val -> n.setBackgroundColor((String)val), x, y += gap, w, h);
                                                                    this.addColorPickerButton(x, y, w, h, progBgBox, s -> n.setBackgroundColor((String)s));
                                                                    class_342 dirBox = this.addField("Direction", n.getDirection(), val -> n.setDirection((String)val), x, y += gap, w, h);
                                                                    this.addCycleButton(x, y, w, h, dirBox, new String[]{"horizontal", "vertical"}, v -> n.setDirection((String)v));
                                                                    this.addPropertyField("Bar Height", n.getBarHeight() == null ? "" : String.valueOf(n.getBarHeight()), val -> {
                                                                        try {
                                                                            if (!val.isEmpty()) {
                                                                                n.setBarHeight(Integer.parseInt(val));
                                                                            } else {
                                                                                n.setBarHeight(null);
                                                                            }
                                                                        }
                                                                        catch (Exception exception) {
                                                                            // empty catch block
                                                                        }
                                                                    }, x, y += gap, w, h);
                                                                    y += gap;
                                                                } else {
                                                                    fillBox = this.selectedNode;
                                                                    if (fillBox instanceof SliderNode) {
                                                                        SliderNode n = (SliderNode)fillBox;
                                                                        this.addPropertyField("Value", n.getValue(), val -> n.setValue((String)val), x, y, w, h);
                                                                        this.addPropertyField("Min", n.getMin(), val -> n.setMin((String)val), x, y += gap, w, h);
                                                                        this.addPropertyField("Max", n.getMax(), val -> n.setMax((String)val), x, y += gap, w, h);
                                                                        this.addPropertyField("Step", n.getStep() == null ? "" : String.valueOf(n.getStep()), val -> {
                                                                            try {
                                                                                if (!val.isEmpty()) {
                                                                                    n.setStep(Double.parseDouble(val));
                                                                                } else {
                                                                                    n.setStep(null);
                                                                                }
                                                                            }
                                                                            catch (Exception exception) {
                                                                                // empty catch block
                                                                            }
                                                                        }, x, y += gap, w, h);
                                                                        this.addPropertyField("OnChange", n.getOnChange(), val -> n.setOnChange((String)val), x, y += gap, w, h);
                                                                        class_342 trackColorBox = this.addField("Track Color", n.getTrackColor(), val -> n.setTrackColor((String)val), x, y += gap, w, h);
                                                                        this.addColorPickerButton(x, y, w, h, trackColorBox, s -> n.setTrackColor((String)s));
                                                                        class_342 thumbColorBox = this.addField("Thumb Color", n.getThumbColor(), val -> n.setThumbColor((String)val), x, y += gap, w, h);
                                                                        this.addColorPickerButton(x, y, w, h, thumbColorBox, s -> n.setThumbColor((String)s));
                                                                        this.addPropertyField("Track Height", n.getTrackHeight() == null ? "" : String.valueOf(n.getTrackHeight()), val -> {
                                                                            try {
                                                                                if (!val.isEmpty()) {
                                                                                    n.setTrackHeight(Integer.parseInt(val));
                                                                                } else {
                                                                                    n.setTrackHeight(null);
                                                                                }
                                                                            }
                                                                            catch (Exception exception) {
                                                                                // empty catch block
                                                                            }
                                                                        }, x, y += gap, w, h);
                                                                        y += gap;
                                                                    } else if (this.selectedNode instanceof ScrollNode) {
                                                                        class_4185 editChild = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit Child"), b -> {
                                                                            ScrollNode n = (ScrollNode)this.selectedNode;
                                                                            if (n.getChild() == null) {
                                                                                VStackNode child = new VStackNode();
                                                                                child.setId("scroll_child");
                                                                                n.setChild(child);
                                                                            }
                                                                            this.selectedNode = n.getChild();
                                                                            this.rebuildPropertyWidgets();
                                                                        }).method_46434(x + 80, y, w - 100, h).method_46431();
                                                                        this.method_37063((class_364)editChild);
                                                                        this.propertyWidgets.add((class_339)editChild);
                                                                        this.widgetBaseY.put((class_339)editChild, y);
                                                                        y += gap;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        y = this.addSectionHeader("Hover Style", x, y, w) + 5;
        class_342 hoverBg = this.addField("Background", this.getHoverValue(this.selectedNode, "background"), val -> this.setHoverValue(this.selectedNode, "background", (String)val), x, y, w, h);
        this.addColorPickerButton(x, y, w, h, hoverBg, s -> this.setHoverValue(this.selectedNode, "background", (String)s));
        class_342 hoverBorder = this.addField("Border Color", this.getHoverValue(this.selectedNode, "borderColor"), val -> this.setHoverValue(this.selectedNode, "borderColor", (String)val), x, y += gap, w, h);
        this.addColorPickerButton(x, y, w, h, hoverBorder, s -> this.setHoverValue(this.selectedNode, "borderColor", (String)s));
        this.addPropertyField("Border Width", this.getHoverValue(this.selectedNode, "borderWidth"), val -> this.setHoverValue(this.selectedNode, "borderWidth", (String)val), x, y += gap, w, h);
        this.addPropertyField("Border Radius", this.getHoverValue(this.selectedNode, "borderRadius"), val -> this.setHoverValue(this.selectedNode, "borderRadius", (String)val), x, y += gap, w, h);
        this.addPropertyField("Shadow", this.getHoverValue(this.selectedNode, "shadow"), val -> this.setHoverValue(this.selectedNode, "shadow", (String)val), x, y += gap, w, h);
        this.addPropertyField("Opacity", this.getHoverValue(this.selectedNode, "opacity"), val -> this.setHoverValue(this.selectedNode, "opacity", (String)val), x, y += gap, w, h);
        this.addPropertyField("Scale", this.getHoverValue(this.selectedNode, "scale"), val -> this.setHoverValue(this.selectedNode, "scale", (String)val), x, y += gap, w, h);
        y += gap + 5;
        y = this.addSectionHeader("Advanced", x, y, w) + 5;
        class_342 rawBox = this.addField("Raw JSON", this.rawJsonBuffer, val -> {
            this.rawJsonBuffer = val;
        }, x, y, w, h);
        rawBox.method_1880(Integer.MAX_VALUE);
        class_4185 applyRaw = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply JSON"), b -> this.applyRawJson()).method_46434(x + 80, y += gap, w - 90, h).method_46431();
        this.propertyWidgets.add((class_339)applyRaw);
        this.widgetBaseY.put((class_339)applyRaw, y);
        class_4185 refreshRaw = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Refresh"), b -> {
            this.rawJsonBuffer = this.selectedNode.toJson().toString();
            rawBox.method_1852(this.rawJsonBuffer);
        }).method_46434(x, y, 70, h).method_46431();
        this.propertyWidgets.add((class_339)refreshRaw);
        this.widgetBaseY.put((class_339)refreshRaw, y);
        this.totalPropertyHeight = y - 70;
    }

    private String getHoverValue(PanelNode node, String key) {
        if (node == null) {
            return "";
        }
        JsonObject hover = node.getHoverStyle();
        if (hover == null) {
            return "";
        }
        if (!hover.has(key)) {
            return "";
        }
        try {
            return hover.get(key).getAsString();
        }
        catch (Exception e) {
            return hover.get(key).toString();
        }
    }

    private void setHoverValue(PanelNode node, String key, String value) {
        if (node == null) {
            return;
        }
        JsonObject hover = node.getHoverStyle();
        if (hover == null) {
            hover = new JsonObject();
            node.setHoverStyle(hover);
        }
        if (value == null || value.isEmpty()) {
            hover.remove(key);
            if (hover.size() == 0) {
                node.setHoverStyle(null);
            }
            return;
        }
        try {
            if ("borderWidth".equals(key) || "borderRadius".equals(key)) {
                hover.addProperty(key, (Number)Integer.parseInt(value));
                return;
            }
            if ("opacity".equals(key) || "scale".equals(key)) {
                hover.addProperty(key, (Number)Float.valueOf(Float.parseFloat(value)));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hover.addProperty(key, value);
    }

    private void applyRawJson() {
        this.rawJsonError = null;
        try {
            JsonObject obj = JsonParser.parseString((String)this.rawJsonBuffer).getAsJsonObject();
            PanelNode parsed = PanelNode.fromJson(obj);
            if (parsed == null) {
                this.rawJsonError = "Invalid node type";
                return;
            }
            this.replaceNode(this.selectedNode, parsed);
            this.selectedNode = parsed;
            this.rawJsonBuffer = parsed.toJson().toString();
            this.rebuildPropertyWidgets();
        }
        catch (JsonSyntaxException e) {
            this.rawJsonError = "JSON syntax error";
        }
        catch (Exception e) {
            this.rawJsonError = e.getMessage();
        }
    }

    private boolean replaceNode(PanelNode target, PanelNode replacement) {
        if (target == null || replacement == null) {
            return false;
        }
        if (target == this.rootNode) {
            this.rootNode = replacement;
            return true;
        }
        PanelNode parent = this.findParent(this.rootNode, target);
        if (parent == null) {
            return false;
        }
        if (parent instanceof VStackNode) {
            VStackNode v = (VStackNode)parent;
            int idx = v.getChildren().indexOf(target);
            if (idx >= 0) {
                v.getChildren().set(idx, replacement);
                return true;
            }
        } else if (parent instanceof HStackNode) {
            HStackNode h = (HStackNode)parent;
            int idx = h.getChildren().indexOf(target);
            if (idx >= 0) {
                h.getChildren().set(idx, replacement);
                return true;
            }
        } else if (parent instanceof StackNode) {
            StackNode s = (StackNode)parent;
            int idx = s.getChildren().indexOf(target);
            if (idx >= 0) {
                s.getChildren().set(idx, replacement);
                return true;
            }
        } else if (parent instanceof ScrollNode) {
            ScrollNode sc = (ScrollNode)parent;
            if (sc.getChild() == target) {
                sc.setChild(replacement);
                return true;
            }
        } else if (parent instanceof ConditionalNode) {
            ConditionalNode c = (ConditionalNode)parent;
            if (c.getChild() == target) {
                c.setChild(replacement);
                return true;
            }
        } else if (parent instanceof ListNode) {
            ListNode l = (ListNode)parent;
            if (l.getItemTemplate() == target) {
                l.setItemTemplate(replacement);
                return true;
            }
        } else if (parent instanceof TabContainerNode) {
            TabContainerNode t = (TabContainerNode)parent;
            for (TabContainerNode.Tab tab : t.getTabs()) {
                if (tab.content != target) continue;
                tab.content = replacement;
                return true;
            }
        }
        return false;
    }

    private int addSectionHeader(String title, int x, int y, int w) {
        this.propertyLabels.add(new LabelEntry(title, x - 5, y, -22016, true));
        return y + 15;
    }

    private class_342 addField(String label, String value, Consumer<String> setter, int x, int y, int w, int h) {
        class_342 box = new class_342(this.field_22793, x + 80, y, w - 80, h, (class_2561)class_2561.method_43470((String)label));
        box.method_1880(256);
        box.method_1852(value != null ? value : "");
        box.method_1863(setter);
        this.propertyWidgets.add((class_339)box);
        this.widgetBaseY.put((class_339)box, y);
        this.propertyLabels.add(new LabelEntry(label, x + 10, y, -3355444, false));
        return box;
    }

    private void addPropertyField(String label, String value, Consumer<String> setter, int x, int y, int w, int h) {
        this.addField(label, value, setter, x, y, w, h);
    }

    private void addUnitButtons(class_342 target, int x, int y, int w, int h, Consumer<String> setter) {
        int bx = x + 80;
        int bw = w - 80;
        int btnW = 28;
        int right = bx + bw;
        class_4185 px = class_4185.method_46430((class_2561)class_2561.method_43470((String)"px"), b -> {
            setter.accept("" + this.safeInt(target.method_1882(), 0));
            target.method_1852("" + this.safeInt(target.method_1882(), 0));
        }).method_46434(right - (btnW * 4 + 8), y, btnW, h).method_46431();
        class_4185 pc = class_4185.method_46430((class_2561)class_2561.method_43470((String)"%"), b -> {
            setter.accept("100%");
            target.method_1852("100%");
        }).method_46434(right - (btnW * 3 + 6), y, btnW, h).method_46431();
        class_4185 fill = class_4185.method_46430((class_2561)class_2561.method_43470((String)"fill"), b -> {
            setter.accept("fill");
            target.method_1852("fill");
        }).method_46434(right - (btnW * 2 + 4), y, btnW, h).method_46431();
        class_4185 auto = class_4185.method_46430((class_2561)class_2561.method_43470((String)"auto"), b -> {
            setter.accept("auto");
            target.method_1852("auto");
        }).method_46434(right - (btnW + 2), y, btnW, h).method_46431();
        this.method_37063((class_364)px);
        this.method_37063((class_364)pc);
        this.method_37063((class_364)fill);
        this.method_37063((class_364)auto);
        this.propertyWidgets.add((class_339)px);
        this.widgetBaseY.put((class_339)px, y);
        this.propertyWidgets.add((class_339)pc);
        this.widgetBaseY.put((class_339)pc, y);
        this.propertyWidgets.add((class_339)fill);
        this.widgetBaseY.put((class_339)fill, y);
        this.propertyWidgets.add((class_339)auto);
        this.widgetBaseY.put((class_339)auto, y);
    }

    private void addCycleButton(int x, int y, int w, int h, class_342 targetBox, String[] values, Consumer<String> setter) {
        targetBox.method_1862(false);
        class_4185 cycleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)targetBox.method_1882()), b -> {
            String current = targetBox.method_1882();
            int idx = -1;
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(current)) continue;
                idx = i;
                break;
            }
            int nextIdx = (idx + 1) % values.length;
            String nextVal = values[nextIdx];
            targetBox.method_1852(nextVal);
            b.method_25355((class_2561)class_2561.method_43470((String)nextVal));
            setter.accept(nextVal);
        }).method_46434(x + 80, y, w - 80, h).method_46431();
        this.propertyWidgets.add((class_339)cycleBtn);
        this.widgetBaseY.put((class_339)cycleBtn, y);
    }

    private void addToggleButton(int x, int y, int w, int h, class_342 target, Consumer<String> setter) {
        int bx = x + 80;
        class_4185 tog = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2611"), b -> {
            boolean v = !"true".equalsIgnoreCase(target.method_1882());
            String nv = v ? "true" : "false";
            target.method_1852(nv);
            setter.accept(nv);
        }).method_46434(bx - 20, y, 18, h).method_46431();
        this.propertyWidgets.add((class_339)tog);
        this.widgetBaseY.put((class_339)tog, y);
    }

    private void addPresetColorButton(int x, int y, int w, int h, class_342 target) {
        int bx = x + 80;
        class_4185 cyc = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25a0"), b -> {
            String[] palette = new String[]{"#FFFFFFFF", "#FFAAAAAA", "#FF1B1D1E", "#FF000000", "#FFFFAA00", "#FF64DC64"};
            String cur = target.method_1882() == null ? "" : target.method_1882().trim();
            int idx = -1;
            for (int i = 0; i < palette.length; ++i) {
                if (!palette[i].equalsIgnoreCase(cur)) continue;
                idx = i;
                break;
            }
            idx = (idx + 1) % palette.length;
            target.method_1852(palette[idx]);
        }).method_46434(bx - 20, y, 18, h).method_46431();
        this.propertyWidgets.add((class_339)cyc);
        this.widgetBaseY.put((class_339)cyc, y);
    }

    private void addColorPickerButton(int x, int y, int w, int h, class_342 target, Consumer<String> setter) {
        int bx = x + 80;
        class_4185 cp = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83c\udfa8"), btn -> {
            this.showColorPicker = true;
            this.colorPickerTarget = target;
            this.colorPickerSetter = setter;
            try {
                String val = target.method_1882().replace("#", "");
                if (val.length() == 6) {
                    int color = Integer.parseInt(val, 16);
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color & 0xFF;
                    float[] hsv = NewThemeEditorScreen.rgbToHsv(r, g, b);
                    this.pickerHue = hsv[0];
                    this.pickerSat = hsv[1];
                    this.pickerVal = hsv[2];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).method_46434(bx - 20, y, 18, h).method_46431();
        this.propertyWidgets.add((class_339)cp);
        this.widgetBaseY.put((class_339)cp, y);
    }

    private void addThemeQuickButton(int x, int y, int w, int h, class_342 target, String defaultKey) {
        int bx = x + 80;
        class_4185 th = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Theme"), b -> this.openThemePicker(target, s -> target.method_1852(s), defaultKey)).method_46434(bx - 54, y, 50, h).method_46431();
        this.propertyWidgets.add((class_339)th);
        this.widgetBaseY.put((class_339)th, y);
    }

    private int safeInt(String s, int def) {
        try {
            return Integer.parseInt(s.trim().replace("px", ""));
        }
        catch (Exception e) {
            return def;
        }
    }

    private void validateField(String key, String value, Object currentValue) {
        ThemeValidator.ValidationResult r = ThemeValidator.validate(key == null ? "" : key, value == null ? "" : value, currentValue);
        this.validationIssues.put(key, r);
    }

    private void renderCanvas(class_332 g, int mouseX, int mouseY) {
        int x = 250;
        int y = 30;
        int w = this.field_22789 - 250 - 300;
        int h = this.field_22790 - 30;
        g.method_44379(x, y, x + w, y + h);
        this.drawGrid(g, x, y, w, h);
        g.method_51448().method_22903();
        g.method_51448().method_46416((float)x + (float)w / 2.0f + this.canvasOffsetX, (float)y + (float)h / 2.0f + this.canvasOffsetY, 0.0f);
        g.method_51448().method_22905(this.canvasScale, this.canvasScale, 1.0f);
        if (this.rootNode != null) {
            PanelRenderer.Rect bounds;
            int rootW = 400;
            int rootH = 300;
            g.method_25294(-rootW / 2, -rootH / 2, rootW / 2, rootH / 2, -16777216);
            g.method_49601(-rootW / 2, -rootH / 2, rootW, rootH, -12566464);
            PanelTemplate tempTemplate = new PanelTemplate("preview", this.rootNode);
            PanelNode hovered = this.getNodeAt(mouseX, mouseY);
            if (hovered == null) {
                hovered = this.selectedNode;
            }
            this.panelRenderer.setHoveredNode(hovered);
            int localMouseX = (int)(((float)(mouseX - 250) - (float)w / 2.0f - this.canvasOffsetX) / this.canvasScale);
            int localMouseY = (int)(((float)(mouseY - 30) - (float)h / 2.0f - this.canvasOffsetY) / this.canvasScale);
            this.panelRenderer.render(tempTemplate, this.editorContext, g, -rootW / 2, -rootH / 2, rootW, rootH, localMouseX, localMouseY);
            if (this.selectedNode != null && (bounds = this.panelRenderer.getNodeBounds(this.selectedNode)) != null) {
                g.method_49601(bounds.x(), bounds.y(), bounds.width(), bounds.height(), -12952934);
                g.method_49601(bounds.x() - 1, bounds.y() - 1, bounds.width() + 2, bounds.height() + 2, -2143659366);
                this.renderResizeHandles(g, bounds.x(), bounds.y(), bounds.width(), bounds.height());
            }
        }
        g.method_51448().method_22909();
        g.method_44380();
        g.method_25303(this.field_22793, String.format("Zoom: %.1fx", Float.valueOf(this.canvasScale)), x + 10, y + h - 20, -7829368);
    }

    private void drawGrid(class_332 g, int x, int y, int w, int h) {
        g.method_25294(x, y, x + w, y + h, -16448251);
        int gridSize = 20;
        for (int i = 0; i < w; i += gridSize) {
            g.method_25301(x + i, y, y + h, -15724528);
        }
        for (int j = 0; j < h; j += gridSize) {
            g.method_25292(x, x + w, y + j, -15724528);
        }
    }

    private void renderDraggedItem(class_332 g, int mouseX, int mouseY) {
        if (this.draggedNode == null) {
            return;
        }
        g.method_51448().method_22903();
        g.method_51448().method_46416(0.0f, 0.0f, 500.0f);
        g.method_25294(mouseX + 10, mouseY + 10, mouseX + 110, mouseY + 40, -872415232);
        g.method_49601(mouseX + 10, mouseY + 10, 100, 30, -1);
        g.method_25303(this.field_22793, this.draggedNode.getType(), mouseX + 15, mouseY + 20, -1);
        g.method_51448().method_22909();
    }

    private void drawButtonLike(class_332 g, int x, int y, int w, int h, int color, String text) {
        g.method_25294(x, y, x + w, y + h, color);
        g.method_49601(x, y, w, h, -16777216);
        int tw = this.field_22793.method_1727(text);
        g.method_25303(this.field_22793, text, x + (w - tw) / 2, y + 6, -1);
    }

    private boolean inRect(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int canvasY;
        int[] local;
        int canvasX;
        PanelNode clickedNode;
        if (mouseX > (double)(this.field_22789 - 300) && mouseY > 30.0) {
            int contentY = 70;
            int contentH = this.field_22790 - 30 - 40;
            if (mouseY >= (double)contentY && mouseY <= (double)(contentY + contentH)) {
                for (class_339 widget : this.propertyWidgets) {
                    if (!widget.field_22764 || !widget.method_25405(mouseX, mouseY) || !widget.method_25402(mouseX, mouseY, button)) continue;
                    this.method_25395((class_364)widget);
                    return true;
                }
            }
        }
        if (this.activeResizeHandle != ResizeHandle.NONE) {
            this.isResizing = true;
            return true;
        }
        if (this.namePromptOpen) {
            if (this.namePromptField != null && this.namePromptField.method_25402(mouseX, mouseY, button)) {
                this.method_25395((class_364)this.namePromptField);
                try {
                    this.namePromptField.method_25365(true);
                }
                catch (Throwable contentY) {
                    // empty catch block
                }
                return true;
            }
            this.handleNamePromptClick((int)mouseX, (int)mouseY);
            return true;
        }
        if (this.isSelectingPanel) {
            this.handlePanelSelectionClick(mouseX, mouseY);
            return true;
        }
        if (this.themePickerOpen) {
            this.handleThemePickerClick((int)mouseX, (int)mouseY);
            return true;
        }
        if (this.showColorPicker) {
            if (mouseX >= (double)this.pickerSVX && mouseX < (double)(this.pickerSVX + this.pickerSVSize) && mouseY >= (double)this.pickerSVY && mouseY < (double)(this.pickerSVY + this.pickerSVSize)) {
                this.dragPickerSV = true;
                this.updatePickerSV(mouseX, mouseY);
                return true;
            }
            if (mouseX >= (double)this.pickerHueX && mouseX < (double)(this.pickerHueX + this.pickerHueW) && mouseY >= (double)this.pickerHueY && mouseY < (double)(this.pickerHueY + this.pickerHueH)) {
                this.dragPickerHue = true;
                this.updatePickerHue(mouseY);
                return true;
            }
            int panelW = 460;
            int panelH = 340;
            int panelX = this.field_22789 / 2 - panelW / 2;
            int panelY = this.field_22790 / 2 - panelH / 2;
            int x = panelX + 8;
            int y = this.pickerSVY + this.pickerSVSize + 24;
            int swatchSize = 24;
            for (int i = 0; i < Math.min(16, COMMON_COLORS.length); ++i) {
                int sx = x + 4 + i % 8 * (swatchSize + 4);
                int sy = y + i / 8 * (swatchSize + 4);
                if (!(mouseX >= (double)sx) || !(mouseX < (double)(sx + swatchSize)) || !(mouseY >= (double)sy) || !(mouseY < (double)(sy + swatchSize))) continue;
                this.applyPresetColor(i);
                return true;
            }
            if (mouseX < (double)panelX || mouseX > (double)(panelX + panelW) || mouseY < (double)panelY || mouseY > (double)(panelY + panelH)) {
                this.showColorPicker = false;
            }
            return true;
        }
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (mx < 250 && my > 30) {
            int paletteH = (int)((double)(this.field_22790 - 30) * 0.5);
            if (my < 30 + paletteH) {
                int headerHeight = 30;
                int contentTop = 30 + headerHeight;
                int itemY = contentTop + (int)this.paletteScrollY;
                int itemH = 24;
                int gap = 2;
                for (PanelNode item : this.paletteItems) {
                    if (my >= contentTop && my >= itemY && my < itemY + itemH) {
                        this.draggedNode = item.deepCopy();
                        this.isDraggingFromPalette = true;
                        return true;
                    }
                    itemY += itemH + gap;
                }
            } else {
                PanelNode clickedNode2;
                int sidebarX = 0;
                int sidebarY = 30;
                int sidebarW = 250;
                int hierarchyStartY = sidebarY + paletteH;
                int treeX = sidebarX + 10;
                int treeY = hierarchyStartY + 30 + (int)this.hierarchyScrollY;
                int treeW = sidebarW - 20;
                PanelNode panelNode = clickedNode2 = this.rootNode != null ? this.findNodeAtRecursive(this.rootNode, treeX, treeY, treeW, 0, mx, my) : null;
                if (clickedNode2 != null) {
                    this.selectedNode = clickedNode2;
                    this.rebuildPropertyWidgets();
                    return true;
                }
            }
        }
        if (mx > 250 && mx < this.field_22789 - 300 && my > 30 && (clickedNode = this.panelRenderer.findTopmostNodeAtPoint(canvasX = (local = this.toLocalCanvas(mx, my))[0], canvasY = local[1])) != null) {
            this.selectedNode = clickedNode;
            this.rebuildPropertyWidgets();
            if (this.selectedNode != null) {
                this.activeResizeHandle = this.getResizeHandleAt(this.selectedNode, canvasX, canvasY);
                if (this.activeResizeHandle != ResizeHandle.NONE) {
                    this.isResizing = true;
                    this.dragStartX = canvasX;
                    this.dragStartY = canvasY;
                    this.originalWidth = this.selectedNode.getWidth();
                    this.originalHeight = this.selectedNode.getHeight();
                    this.originalParsedWidth = this.parseSize(this.originalWidth, 100);
                    this.originalParsedHeight = this.parseSize(this.originalHeight, 100);
                } else {
                    this.isDraggingElement = true;
                    this.dragStartX = canvasX;
                    this.dragStartY = canvasY;
                    this.originalWidth = this.selectedNode.getWidth();
                    this.originalHeight = this.selectedNode.getHeight();
                    this.originalParsedWidth = this.parseSize(this.originalWidth, 100);
                    this.originalParsedHeight = this.parseSize(this.originalHeight, 100);
                }
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.dragPickerSV = false;
        this.dragPickerHue = false;
        if (this.namePromptOpen) {
            return true;
        }
        if (this.draggedNode != null) {
            int canvasY;
            int[] local;
            int canvasX;
            PanelNode target;
            if (this.rootNode != null && !this.addChildToContainer(target = this.panelRenderer.findTopmostNodeAtPoint(canvasX = (local = this.toLocalCanvas((int)mouseX, (int)mouseY))[0], canvasY = local[1]), this.draggedNode)) {
                this.addChildToContainer(this.rootNode, this.draggedNode);
            }
            this.draggedNode = null;
            this.isDraggingFromPalette = false;
            return true;
        }
        if (this.isDraggingElement || this.isResizing) {
            this.isDraggingElement = false;
            this.isResizing = false;
            this.activeResizeHandle = ResizeHandle.NONE;
            if (this.selectedNode != null) {
                int[] local = this.toLocalCanvas((int)mouseX, (int)mouseY);
                int canvasX = local[0];
                int canvasY = local[1];
                PanelNode target = this.panelRenderer.findTopmostNodeAtPoint(canvasX, canvasY);
                if (this.reorderWithinParent(this.selectedNode, canvasX, canvasY) || target == null || target == this.selectedNode || this.moveNodeToContainer(this.selectedNode, target)) {
                    // empty if block
                }
            }
            this.rebuildPropertyWidgets();
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragPickerSV) {
            this.updatePickerSV(mouseX, mouseY);
            return true;
        }
        if (this.dragPickerHue) {
            this.updatePickerHue(mouseY);
            return true;
        }
        if (this.namePromptOpen) {
            return true;
        }
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (this.isDraggingElement && this.selectedNode != null) {
            int[] local = this.toLocalCanvas(mx, my);
            int canvasX = local[0];
            int canvasY = local[1];
            return true;
        }
        if (this.isResizing && this.selectedNode != null) {
            int[] local = this.toLocalCanvas(mx, my);
            int canvasX = local[0];
            int canvasY = local[1];
            int deltaX = canvasX - this.dragStartX;
            int deltaY = canvasY - this.dragStartY;
            switch (this.activeResizeHandle.ordinal()) {
                case 3: 
                case 4: 
                case 5: {
                    int newWidth = this.originalParsedWidth + deltaX;
                    this.selectedNode.setWidth(String.valueOf(Math.max(10, newWidth)));
                    break;
                }
                case 1: 
                case 7: 
                case 8: {
                    int newWidth = this.originalParsedWidth - deltaX;
                    this.selectedNode.setWidth(String.valueOf(Math.max(10, newWidth)));
                }
            }
            switch (this.activeResizeHandle.ordinal()) {
                case 5: 
                case 6: 
                case 7: {
                    int newHeight = this.originalParsedHeight + deltaY;
                    this.selectedNode.setHeight(String.valueOf(Math.max(10, newHeight)));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    int newHeight = this.originalParsedHeight - deltaY;
                    this.selectedNode.setHeight(String.valueOf(Math.max(10, newHeight)));
                }
            }
            return true;
        }
        if (button == 2 || button == 0 && class_437.method_25442()) {
            this.canvasOffsetX = (float)((double)this.canvasOffsetX + dragX);
            this.canvasOffsetY = (float)((double)this.canvasOffsetY + dragY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int contentH;
        if (mouseX > (double)(this.field_22789 - 300) && mouseY > 30.0 && this.totalPropertyHeight > (contentH = this.field_22790 - 30 - 40)) {
            this.rightSidebarScroll = (int)((double)this.rightSidebarScroll - delta * 20.0);
            this.rightSidebarScroll = Math.max(0, Math.min(this.rightSidebarScroll, this.totalPropertyHeight - contentH));
            return true;
        }
        if (mouseX < 250.0) {
            if (mouseY < (double)this.field_22790 * 0.5) {
                if (this.maxPaletteScroll > 0.0f) {
                    this.paletteScrollY = (float)((double)this.paletteScrollY - delta * 20.0);
                    this.paletteScrollY = Math.max(0.0f, Math.min(this.paletteScrollY, this.maxPaletteScroll));
                    return true;
                }
            } else if (this.maxHierarchyScroll > 0.0f) {
                this.hierarchyScrollY = (float)((double)this.hierarchyScrollY - delta * 20.0);
                this.hierarchyScrollY = Math.max(0.0f, Math.min(this.hierarchyScrollY, this.maxHierarchyScroll));
                return true;
            }
        }
        if (mouseX > 250.0 && mouseX < (double)(this.field_22789 - 300) && mouseY > 30.0) {
            this.canvasScale = delta > 0.0 ? (this.canvasScale *= 1.1f) : (this.canvasScale /= 1.1f);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private void renderResizeHandles(class_332 g, int x, int y, int width, int height) {
        int handleSize = 6;
        int halfHandle = handleSize / 2;
        int handleColor = -1;
        g.method_25294(x - halfHandle, y - halfHandle, x - halfHandle + handleSize, y - halfHandle + handleSize, handleColor);
        g.method_25294(x + width - halfHandle, y - halfHandle, x + width - halfHandle + handleSize, y - halfHandle + handleSize, handleColor);
        g.method_25294(x - halfHandle, y + height - halfHandle, x - halfHandle + handleSize, y + height - halfHandle + handleSize, handleColor);
        g.method_25294(x + width - halfHandle, y + height - halfHandle, x + width - halfHandle + handleSize, y + height - halfHandle + handleSize, handleColor);
        g.method_25294(x + width / 2 - halfHandle, y - halfHandle, x + width / 2 - halfHandle + handleSize, y - halfHandle + handleSize, handleColor);
        g.method_25294(x + width / 2 - halfHandle, y + height - halfHandle, x + width / 2 - halfHandle + handleSize, y + height - halfHandle + handleSize, handleColor);
        g.method_25294(x - halfHandle, y + height / 2 - halfHandle, x - halfHandle + handleSize, y + height / 2 - halfHandle + handleSize, handleColor);
        g.method_25294(x + width - halfHandle, y + height / 2 - halfHandle, x + width - halfHandle + handleSize, y + height / 2 - halfHandle + handleSize, handleColor);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.showColorPicker) {
            if (keyCode == 256) {
                this.showColorPicker = false;
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.applyColorPickerSelection();
                return true;
            }
        }
        if (this.namePromptOpen) {
            if (keyCode == 257 || keyCode == 335) {
                this.confirmNamePrompt();
                return true;
            }
            if (keyCode == 256) {
                this.closeNamePrompt();
                return true;
            }
            if (this.namePromptField != null && this.namePromptField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (keyCode == 261 && this.selectedNode != null) {
            this.removeSelectedNode();
            return true;
        }
        boolean isCtrlDown = class_437.method_25441();
        if (isCtrlDown && keyCode == 90) {
            if (this.undoManager.undo()) {
                this.rebuildPropertyWidgets();
            }
            return true;
        }
        if (isCtrlDown && keyCode == 89) {
            if (this.undoManager.redo()) {
                this.rebuildPropertyWidgets();
            }
            return true;
        }
        if (this.selectedNode != null && this.selectedNode != this.rootNode) {
            int nudgeAmount = class_437.method_25442() ? 10 : 1;
            Integer currentMargin = this.selectedNode.getMargin();
            int margin = currentMargin != null ? currentMargin : 0;
            switch (keyCode) {
                case 265: {
                    this.selectedNode.setMargin(Math.max(0, margin - nudgeAmount));
                    this.rebuildPropertyWidgets();
                    return true;
                }
                case 264: {
                    this.selectedNode.setMargin(margin + nudgeAmount);
                    this.rebuildPropertyWidgets();
                    return true;
                }
                case 263: {
                    Integer currentPadding = this.selectedNode.getPadding();
                    int padding = currentPadding != null ? currentPadding : 0;
                    this.selectedNode.setPadding(Math.max(0, padding - nudgeAmount));
                    this.rebuildPropertyWidgets();
                    return true;
                }
                case 262: {
                    Integer currentPadding = this.selectedNode.getPadding();
                    int padding = currentPadding != null ? currentPadding : 0;
                    this.selectedNode.setPadding(padding + nudgeAmount);
                    this.rebuildPropertyWidgets();
                    return true;
                }
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void removeSelectedNode() {
        if (this.selectedNode == null || this.selectedNode == this.rootNode) {
            return;
        }
        boolean removed = this.removeNodeRecursive(this.rootNode);
        if (removed) {
            this.selectedNode = null;
            this.rebuildPropertyWidgets();
        }
    }

    private boolean removeNodeRecursive(PanelNode parent) {
        List<PanelNode> children = this.getChildren(parent);
        if (children != null && children.remove(this.selectedNode)) {
            return true;
        }
        if (children != null) {
            for (PanelNode child : children) {
                if (!this.removeNodeRecursive(child)) continue;
                return true;
            }
        }
        return false;
    }

    private List<PanelNode> getChildren(PanelNode node) {
        if (node instanceof VStackNode) {
            VStackNode n = (VStackNode)node;
            return n.getChildren();
        }
        if (node instanceof HStackNode) {
            HStackNode n = (HStackNode)node;
            return n.getChildren();
        }
        if (node instanceof StackNode) {
            StackNode n = (StackNode)node;
            return n.getChildren();
        }
        if (node instanceof ScrollNode) {
            ScrollNode n = (ScrollNode)node;
            return n.getChild() != null ? List.of(n.getChild()) : null;
        }
        if (node instanceof ConditionalNode) {
            ConditionalNode n = (ConditionalNode)node;
            return n.getChild() != null ? List.of(n.getChild()) : null;
        }
        if (node instanceof ListNode) {
            ListNode n = (ListNode)node;
            return n.getItemTemplate() != null ? List.of(n.getItemTemplate()) : null;
        }
        if (node instanceof TabContainerNode) {
            TabContainerNode n = (TabContainerNode)node;
            ArrayList<PanelNode> res = new ArrayList<PanelNode>();
            for (TabContainerNode.Tab t : n.getTabs()) {
                if (t.content == null) continue;
                res.add(t.content);
            }
            return res.isEmpty() ? null : res;
        }
        return null;
    }

    private boolean isContainer(PanelNode node) {
        return node instanceof VStackNode || node instanceof HStackNode || node instanceof StackNode || node instanceof ScrollNode || node instanceof ConditionalNode || node instanceof ListNode || node instanceof TabContainerNode;
    }

    private boolean addChildToContainer(PanelNode container, PanelNode child) {
        if (container == null) {
            return false;
        }
        if (container instanceof ScrollNode) {
            ScrollNode s = (ScrollNode)container;
            if (s.getChild() == null) {
                s.setChild(child);
                return true;
            }
            if (this.isContainer(s.getChild())) {
                return this.addChildToContainer(s.getChild(), child);
            }
            return false;
        }
        if (container instanceof ConditionalNode) {
            ConditionalNode c = (ConditionalNode)container;
            if (c.getChild() == null) {
                c.setChild(child);
                return true;
            }
            if (this.isContainer(c.getChild())) {
                return this.addChildToContainer(c.getChild(), child);
            }
            return false;
        }
        if (container instanceof ListNode) {
            ListNode l = (ListNode)container;
            if (l.getItemTemplate() == null) {
                l.setItemTemplate(child);
                return true;
            }
            if (this.isContainer(l.getItemTemplate())) {
                return this.addChildToContainer(l.getItemTemplate(), child);
            }
            return false;
        }
        if (container instanceof VStackNode) {
            VStackNode v = (VStackNode)container;
            v.getChildren().add(child);
            return true;
        }
        if (container instanceof HStackNode) {
            HStackNode h = (HStackNode)container;
            h.getChildren().add(child);
            return true;
        }
        if (container instanceof StackNode) {
            StackNode st = (StackNode)container;
            st.getChildren().add(child);
            return true;
        }
        if (container instanceof TabContainerNode) {
            TabContainerNode t = (TabContainerNode)container;
            TabContainerNode.Tab target = null;
            if (!t.getTabs().isEmpty()) {
                target = t.getTabs().get(0);
            }
            if (target == null) {
                target = new TabContainerNode.Tab("tab1", "Tab 1", null);
                t.getTabs().add(target);
            }
            if (target.content == null) {
                target.content = child;
                return true;
            }
            if (this.isContainer(target.content)) {
                return this.addChildToContainer(target.content, child);
            }
            return false;
        }
        return false;
    }

    private boolean moveNodeToContainer(PanelNode node, PanelNode target) {
        PanelNode container;
        block7: {
            PanelNode parent;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    if (node == null || target == null || node == this.rootNode) {
                                        return false;
                                    }
                                    container = target;
                                    if (!this.isContainer(container) && (container = this.findParent(this.rootNode, target)) == null) {
                                        return false;
                                    }
                                    parent = this.findParent(this.rootNode, node);
                                    if (parent == null) {
                                        return false;
                                    }
                                    if (parent == container) {
                                        return false;
                                    }
                                    if (!(parent instanceof VStackNode)) break block6;
                                    VStackNode v = (VStackNode)parent;
                                    v.getChildren().remove(node);
                                    break block7;
                                }
                                if (!(parent instanceof HStackNode)) break block8;
                                HStackNode h = (HStackNode)parent;
                                h.getChildren().remove(node);
                                break block7;
                            }
                            if (!(parent instanceof StackNode)) break block9;
                            StackNode st = (StackNode)parent;
                            st.getChildren().remove(node);
                            break block7;
                        }
                        if (!(parent instanceof ScrollNode)) break block10;
                        ScrollNode sc = (ScrollNode)parent;
                        if (sc.getChild() != node) break block7;
                        sc.setChild(null);
                        break block7;
                    }
                    if (!(parent instanceof ConditionalNode)) break block11;
                    ConditionalNode c = (ConditionalNode)parent;
                    if (c.getChild() != node) break block7;
                    c.setChild(null);
                    break block7;
                }
                if (!(parent instanceof ListNode)) break block12;
                ListNode l = (ListNode)parent;
                if (l.getItemTemplate() != node) break block7;
                l.setItemTemplate(null);
                break block7;
            }
            if (parent instanceof TabContainerNode) {
                TabContainerNode t = (TabContainerNode)parent;
                for (TabContainerNode.Tab tab : t.getTabs()) {
                    if (tab.content != node) continue;
                    tab.content = null;
                    break;
                }
            }
        }
        return this.addChildToContainer(container, node);
    }

    private PanelNode findParent(PanelNode parent, PanelNode target) {
        List<PanelNode> children = this.getChildren(parent);
        if (children != null) {
            for (PanelNode c : children) {
                if (c == target) {
                    return parent;
                }
                PanelNode deeper = this.findParent(c, target);
                if (deeper == null) continue;
                return deeper;
            }
        }
        return null;
    }

    private PanelNode findNodeAtCanvasPosition(PanelNode node, int x, int y) {
        boolean withinBounds;
        if (node == null) {
            return null;
        }
        LayeredBounds bounds = this.getNodeBounds(node, 0, 0);
        if (bounds == null) {
            return null;
        }
        boolean bl = withinBounds = x >= bounds.x && x < bounds.x + bounds.width && y >= bounds.y && y < bounds.y + bounds.height;
        if (!withinBounds) {
            return null;
        }
        List<PanelNode> children = this.getChildren(node);
        if (children != null) {
            int childY = 0;
            for (int i = children.size() - 1; i >= 0; --i) {
                PanelNode child = children.get(i);
                PanelNode hit = this.findNodeAtCanvasPositionRecursive(child, x, y, 0, i == 0 ? 0 : childY);
                if (hit != null) {
                    return hit;
                }
                LayeredBounds childBounds = this.getNodeBounds(child, 0, 0);
                if (childBounds == null) continue;
                childY += childBounds.height;
            }
        }
        return node;
    }

    private PanelNode findNodeAtCanvasPositionRecursive(PanelNode node, int x, int y, int offsetX, int offsetY) {
        boolean withinBounds;
        if (node == null) {
            return null;
        }
        LayeredBounds bounds = this.getNodeBounds(node, offsetX, offsetY);
        if (bounds == null) {
            return null;
        }
        boolean bl = withinBounds = x >= bounds.x && x < bounds.x + bounds.width && y >= bounds.y && y < bounds.y + bounds.height;
        if (!withinBounds) {
            return null;
        }
        List<PanelNode> children = this.getChildren(node);
        if (children != null) {
            int childY = offsetY;
            for (int i = children.size() - 1; i >= 0; --i) {
                PanelNode child = children.get(i);
                PanelNode hit = this.findNodeAtCanvasPositionRecursive(child, x, y, offsetX, childY);
                if (hit != null) {
                    return hit;
                }
                LayeredBounds childBounds = this.getNodeBounds(child, offsetX, childY);
                if (childBounds == null || !(node instanceof VStackNode)) continue;
                childY += childBounds.height;
            }
        }
        return node;
    }

    private LayeredBounds getNodeBounds(PanelNode node, int parentX, int parentY) {
        if (node == null) {
            return null;
        }
        int width = this.parseSize(node.getWidth(), 100);
        int height = this.parseSize(node.getHeight(), 50);
        return new LayeredBounds(parentX, parentY, width, height);
    }

    private int parseSize(String size, int defaultValue) {
        if (size == null || size.isEmpty()) {
            return defaultValue;
        }
        try {
            String cleaned = size.replace("px", "").trim();
            return Integer.parseInt(cleaned);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private ResizeHandle getResizeHandleAt(PanelNode node, int canvasX, int canvasY) {
        if (node == null) {
            return ResizeHandle.NONE;
        }
        PanelRenderer.Rect b = this.panelRenderer.getNodeBounds(node);
        if (b == null) {
            return ResizeHandle.NONE;
        }
        int handleSize = 6;
        int x = b.x();
        int y = b.y();
        int w = b.width();
        int h = b.height();
        if (this.within(canvasX, canvasY, x, y, handleSize)) {
            return ResizeHandle.TOP_LEFT;
        }
        if (this.within(canvasX, canvasY, x + w, y, handleSize)) {
            return ResizeHandle.TOP_RIGHT;
        }
        if (this.within(canvasX, canvasY, x, y + h, handleSize)) {
            return ResizeHandle.BOTTOM_LEFT;
        }
        if (this.within(canvasX, canvasY, x + w, y + h, handleSize)) {
            return ResizeHandle.BOTTOM_RIGHT;
        }
        if (this.within(canvasX, canvasY, x + w / 2, y, handleSize)) {
            return ResizeHandle.TOP;
        }
        if (this.within(canvasX, canvasY, x + w / 2, y + h, handleSize)) {
            return ResizeHandle.BOTTOM;
        }
        if (this.within(canvasX, canvasY, x, y + h / 2, handleSize)) {
            return ResizeHandle.LEFT;
        }
        if (this.within(canvasX, canvasY, x + w, y + h / 2, handleSize)) {
            return ResizeHandle.RIGHT;
        }
        return ResizeHandle.NONE;
    }

    private boolean within(int px, int py, int cx, int cy, int half) {
        return px >= cx - half && px <= cx + half && py >= cy - half && py <= cy + half;
    }

    private void renderColorPicker(class_332 g) {
        int panelW = 460;
        int panelH = 340;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        g.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -268435456);
        g.method_25294(panelX, panelY, panelX + panelW, panelY + 1, -7829368);
        g.method_25294(panelX, panelY + panelH - 1, panelX + panelW, panelY + panelH, -7829368);
        g.method_25294(panelX, panelY, panelX + 1, panelY + panelH, -7829368);
        g.method_25294(panelX + panelW - 1, panelY, panelX + panelW, panelY + panelH, -7829368);
        int x = panelX + 8;
        int y = panelY + 8;
        g.method_25303(this.field_22793, "\u00a7l\u00a7eColor Picker", x, y, -1);
        this.pickerSVSize = 180;
        this.pickerSVX = panelX + 12;
        this.pickerSVY = y += 14;
        this.drawColorPickerSVSquare(g, this.pickerSVX, this.pickerSVY, this.pickerSVSize);
        this.pickerHueW = 18;
        this.pickerHueH = this.pickerSVSize;
        this.pickerHueX = this.pickerSVX + this.pickerSVSize + 12;
        this.pickerHueY = this.pickerSVY;
        this.drawColorPickerHueSlider(g, this.pickerHueX, this.pickerHueY, this.pickerHueW, this.pickerHueH);
        int previewX = this.pickerHueX + this.pickerHueW + 16;
        int previewY = this.pickerSVY;
        int previewSize = 60;
        int[] rgb = NewThemeEditorScreen.hsvToRgb(this.pickerHue, this.pickerSat, this.pickerVal);
        int color = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
        g.method_25294(previewX + 2, previewY + 2, previewX + previewSize + 2, previewY + previewSize + 2, Integer.MIN_VALUE);
        this.drawCheckerboard(g, previewX, previewY, previewSize, previewSize);
        g.method_25294(previewX, previewY, previewX + previewSize, previewY + previewSize, color);
        this.drawBorder(g, previewX, previewY, previewSize, previewSize);
        g.method_25303(this.field_22793, String.format("#%02X%02X%02X", rgb[0], rgb[1], rgb[2]), previewX, previewY + previewSize + 6, -1);
        g.method_25303(this.field_22793, String.format("RGB: %d,%d,%d", rgb[0], rgb[1], rgb[2]), previewX, previewY + previewSize + 18, -3355444);
        g.method_25303(this.field_22793, String.format("HSV: %.0f\u00b0,%.0f%%,%.0f%%", Float.valueOf(this.pickerHue * 360.0f), Float.valueOf(this.pickerSat * 100.0f), Float.valueOf(this.pickerVal * 100.0f)), previewX, previewY + previewSize + 30, -3355444);
        int svCX = (int)((float)this.pickerSVX + this.pickerSat * (float)this.pickerSVSize);
        int svCY = (int)((float)this.pickerSVY + (1.0f - this.pickerVal) * (float)this.pickerSVSize);
        g.method_25294(svCX - 4, svCY - 4, svCX + 5, svCY + 5, -16777216);
        g.method_25294(svCX - 3, svCY - 3, svCX + 4, svCY + 4, -1);
        g.method_25294(svCX - 1, svCY - 1, svCX + 2, svCY + 2, -16777216);
        int hueCY = (int)((float)this.pickerHueY + this.pickerHue * (float)this.pickerHueH);
        g.method_25294(this.pickerHueX - 3, hueCY - 2, this.pickerHueX + this.pickerHueW + 3, hueCY + 3, -16777216);
        g.method_25294(this.pickerHueX - 2, hueCY - 1, this.pickerHueX + this.pickerHueW + 2, hueCY + 2, -1);
        y = this.pickerSVY + this.pickerSVSize + 12;
        g.method_25303(this.field_22793, "\u00a77Presets:", x, y, -3355444);
        y += 12;
        int swatchSize = 24;
        for (int i = 0; i < Math.min(16, COMMON_COLORS.length); ++i) {
            int sx = x + 4 + i % 8 * (swatchSize + 4);
            int sy = y + i / 8 * (swatchSize + 4);
            int presetColor = NewThemeEditorScreen.COMMON_COLORS[i].color | 0xFF000000;
            g.method_25294(sx, sy, sx + swatchSize, sy + swatchSize, presetColor);
            g.method_25294(sx, sy, sx + swatchSize, sy + 1, -10066330);
            g.method_25294(sx, sy + swatchSize - 1, sx + swatchSize, sy + swatchSize, -10066330);
            g.method_25294(sx, sy, sx + 1, sy + swatchSize, -10066330);
            g.method_25294(sx + swatchSize - 1, sy, sx + swatchSize, sy + swatchSize, -10066330);
        }
        g.method_25303(this.field_22793, "\u00a77Click color wheel or presets | Enter to insert | ESC to close", x, y += swatchSize * 2 + 16, -7829368);
    }

    private void drawColorPickerSVSquare(class_332 g, int x, int y, int size) {
        int stepsX = size / 2;
        for (int i = 0; i < stepsX; ++i) {
            float s = (float)i / (float)(stepsX - 1);
            int[] top = NewThemeEditorScreen.hsvToRgb(this.pickerHue, s, 1.0f);
            int[] bottom = NewThemeEditorScreen.hsvToRgb(this.pickerHue, s, 0.0f);
            int colTop = 0xFF000000 | top[0] << 16 | top[1] << 8 | top[2];
            int colBottom = 0xFF000000 | bottom[0] << 16 | bottom[1] << 8 | bottom[2];
            int x1 = x + i * size / stepsX;
            int x2 = x + (i + 1) * size / stepsX;
            for (int j = 0; j < size; ++j) {
                float t = 1.0f - (float)j / (float)(size - 1);
                int r = (int)((float)(colTop >> 16 & 0xFF) * t + (float)(colBottom >> 16 & 0xFF) * (1.0f - t));
                int gg = (int)((float)(colTop >> 8 & 0xFF) * t + (float)(colBottom >> 8 & 0xFF) * (1.0f - t));
                int b = (int)((float)(colTop & 0xFF) * t + (float)(colBottom & 0xFF) * (1.0f - t));
                g.method_25294(x1, y + j, x2, y + j + 1, 0xFF000000 | r << 16 | gg << 8 | b);
            }
        }
        this.drawBorder(g, x, y, size, size);
    }

    private void drawColorPickerHueSlider(class_332 g, int x, int y, int w, int h) {
        for (int j = 0; j < h; ++j) {
            float hue = (float)j / (float)(h - 1);
            int[] rgb = NewThemeEditorScreen.hsvToRgb(hue, 1.0f, 1.0f);
            int col = 0xFF000000 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
            g.method_25294(x, y + j, x + w, y + j + 1, col);
        }
        this.drawBorder(g, x, y, w, h);
    }

    private void drawBorder(class_332 g, int x, int y, int w, int h) {
        g.method_25294(x - 2, y - 2, x + w + 2, y - 1, -7829368);
        g.method_25294(x - 2, y + h + 1, x + w + 2, y + h + 2, -7829368);
        g.method_25294(x - 2, y - 1, x - 1, y + h + 1, -7829368);
        g.method_25294(x + w + 1, y - 1, x + w + 2, y + h + 1, -7829368);
    }

    private void drawCheckerboard(class_332 g, int x, int y, int w, int h) {
        int s = 4;
        for (int yy = 0; yy < h; yy += s) {
            for (int xx = 0; xx < w; xx += s) {
                boolean dark = (xx / s + yy / s) % 2 == 0;
                g.method_25294(x + xx, y + yy, x + Math.min(xx + s, w), y + Math.min(yy + s, h), dark ? -5592406 : -2236963);
            }
        }
    }

    private static int[] hsvToRgb(float h, float s, float v) {
        h = (h % 1.0f + 1.0f) % 1.0f;
        int i = (int)(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (i % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new int[]{(int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f)};
    }

    private static float[] rgbToHsv(int r, int g, int b) {
        float h;
        float s;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float v = max;
        float d = max - min;
        float f = s = max == 0.0f ? 0.0f : d / max;
        if (max == min) {
            h = 0.0f;
        } else {
            h = max == rf ? (gf - bf) / d + (float)(gf < bf ? 6 : 0) : (max == gf ? (bf - rf) / d + 2.0f : (rf - gf) / d + 4.0f);
            h /= 6.0f;
        }
        return new float[]{h, s, v};
    }

    private void updatePickerSV(double mx, double my) {
        this.pickerSat = (float)Math.max(0.0, Math.min(1.0, (mx - (double)this.pickerSVX) / (double)this.pickerSVSize));
        this.pickerVal = 1.0f - (float)Math.max(0.0, Math.min(1.0, (my - (double)this.pickerSVY) / (double)this.pickerSVSize));
    }

    private void updatePickerHue(double my) {
        this.pickerHue = (float)Math.max(0.0, Math.min(1.0, (my - (double)this.pickerHueY) / (double)this.pickerHueH));
    }

    private void applyColorPickerSelection() {
        int[] rgb = NewThemeEditorScreen.hsvToRgb(this.pickerHue, this.pickerSat, this.pickerVal);
        String hex = String.format("#%02X%02X%02X", rgb[0], rgb[1], rgb[2]);
        if (this.colorPickerSetter != null) {
            this.colorPickerSetter.accept(hex);
        }
        if (this.colorPickerTarget != null) {
            this.colorPickerTarget.method_1852(hex);
        }
        this.showColorPicker = false;
    }

    private void applyPresetColor(int colorIndex) {
        if (colorIndex < 0 || colorIndex >= COMMON_COLORS.length) {
            return;
        }
        int color = NewThemeEditorScreen.COMMON_COLORS[colorIndex].color;
        String hex = String.format("#%06X", color);
        if (this.colorPickerSetter != null) {
            this.colorPickerSetter.accept(hex);
        }
        if (this.colorPickerTarget != null) {
            this.colorPickerTarget.method_1852(hex);
        }
        this.showColorPicker = false;
    }

    private static /* synthetic */ void lambda$rebuildPropertyWidgets$56(class_342 srcBox, class_4185 b) {
        String cur;
        String string = cur = srcBox.method_1882() == null ? "" : srcBox.method_1882();
        if (!cur.startsWith("texture:")) {
            srcBox.method_1852("texture:" + cur);
        }
    }

    private static enum ResizeHandle {
        NONE,
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        RIGHT,
        BOTTOM_RIGHT,
        BOTTOM,
        BOTTOM_LEFT,
        LEFT;

    }

    private static enum NameAction {
        CREATE,
        RENAME,
        DUPLICATE;

    }

    private static class LabelEntry {
        String text;
        int x;
        int y;
        int color;
        boolean isHeader;

        LabelEntry(String text, int x, int y, int color, boolean isHeader) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.color = color;
            this.isHeader = isHeader;
        }
    }

    private static class ColorInfo {
        int color;
        String name;

        ColorInfo(int color, String name) {
            this.color = color;
            this.name = name;
        }
    }

    private static class LayeredBounds {
        int x;
        int y;
        int width;
        int height;

        LayeredBounds(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }
    }
}

