/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_898;
import org.texboobcat.questory.client.rendering.ThemeIconRenderer;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class QuestIconRenderer {
    private static final Map<class_2960, class_1297> ENTITY_CACHE = new HashMap<class_2960, class_1297>();
    private static class_1937 LAST_LEVEL = null;
    private static final Map<String, ParsedRotate> ROTATE_CACHE = new HashMap<String, ParsedRotate>();

    public static void render(class_332 graphics, String iconSpec, int x, int y, int size) {
        QuestIconRenderer.render(graphics, iconSpec, x, y, size, false, false);
    }

    public static void render(class_332 graphics, String iconSpec, int x, int y, int size, boolean hovered, boolean selected) {
        try {
            if ((Integer)ThemeProperties.FORCE_THEME_ICON.get() == 1) {
                ThemeIconRenderer.draw(graphics, ThemeProperties.ICON, x, y, size, size);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iconSpec == null || iconSpec.isEmpty()) {
            try {
                ThemeIconRenderer.draw(graphics, ThemeProperties.ICON, x, y, size, size);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        try {
            if (iconSpec.startsWith("rotate:")) {
                class_310 mc;
                ParsedRotate pr = ROTATE_CACHE.get(iconSpec);
                if (pr == null) {
                    String body = iconSpec.substring("rotate:".length());
                    int interval = 20;
                    int firstSep = body.indexOf(124);
                    ArrayList<String> children = new ArrayList<String>();
                    if (firstSep >= 0) {
                        try {
                            interval = Integer.parseInt(body.substring(0, firstSep).trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String rest = body.substring(firstSep + 1);
                        for (String part : rest.split("\\|")) {
                            String s = part.trim();
                            if (s.isEmpty()) continue;
                            children.add(s);
                        }
                    } else {
                        for (String part : body.split("\\|")) {
                            String s = part.trim();
                            if (s.isEmpty()) continue;
                            children.add(s);
                        }
                    }
                    if (children.isEmpty()) {
                        return;
                    }
                    pr = new ParsedRotate(Math.max(1, interval), children);
                    ROTATE_CACHE.put(iconSpec, pr);
                }
                long time = (mc = class_310.method_1551()) != null && mc.field_1687 != null ? mc.field_1687.method_8510() : 0L;
                int idx = (int)(time / (long)Math.max(1, pr.interval) % (long)pr.children.size());
                QuestIconRenderer.render(graphics, pr.children.get(idx), x, y, size, hovered, selected);
                return;
            }
            if (iconSpec.startsWith("entity:")) {
                String raw = iconSpec.substring("entity:".length()).trim();
                int semi = raw.indexOf(59);
                String idStr = semi >= 0 ? raw.substring(0, semi).trim() : raw;
                HashMap<String, String> mods = new HashMap<String, String>();
                if (semi >= 0) {
                    String rest = raw.substring(semi + 1);
                    for (String part : rest.split(";")) {
                        int eq;
                        String p = part.trim();
                        if (p.isEmpty() || (eq = p.indexOf(61)) <= 0) continue;
                        mods.put(p.substring(0, eq).trim().toLowerCase(Locale.ROOT), p.substring(eq + 1).trim());
                    }
                }
                QuestIconRenderer.renderEntityIcon(graphics, new class_2960(idStr), x, y, size, hovered, selected, mods);
                return;
            }
            if (iconSpec.startsWith("texture:")) {
                String rlStr = iconSpec.substring("texture:".length());
                String namespace = "minecraft";
                Object path = rlStr;
                if (rlStr.contains(":")) {
                    String[] parts = rlStr.split(":", 2);
                    namespace = parts[0];
                    path = parts[1];
                }
                if (!((String)path).startsWith("textures/")) {
                    path = "textures/" + (String)path;
                }
                if (!((String)path).endsWith(".png")) {
                    path = (String)path + ".png";
                }
                class_2960 rl = new class_2960(namespace, (String)path);
                graphics.method_25290(rl, x, y, 0.0f, 0.0f, size, size, size, size);
                return;
            }
            class_2960 itemId = new class_2960(iconSpec);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
            if (item != null) {
                class_1799 stack = new class_1799((class_1935)item);
                float scale = Math.max(0.125f, (float)size / 16.0f);
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
                graphics.method_51448().method_22905(scale, scale, 1.0f);
                graphics.method_51427(stack, 0, 0);
                graphics.method_51448().method_22909();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderEntityIcon(class_332 graphics, class_2960 entityId, int x, int y, int size, boolean hovered, boolean selected, Map<String, String> mods) {
        class_1297 entity;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        if (LAST_LEVEL != mc.field_1687) {
            ENTITY_CACHE.clear();
            LAST_LEVEL = mc.field_1687;
        }
        if ((entity = ENTITY_CACHE.get(entityId)) == null) {
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(entityId);
            if (type == null) {
                return;
            }
            try {
                entity = type.method_5883((class_1937)mc.field_1687);
            }
            catch (Throwable t) {
                return;
            }
            if (entity == null) {
                return;
            }
            ENTITY_CACHE.put(entityId, entity);
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            living.field_6283 = 180.0f;
            living.method_36456(180.0f);
            living.method_36457(0.0f);
        }
        double baseFit = (Double)ThemeProperties.ENTITY_ICON_BASE_FIT.get();
        double minScale = (Double)ThemeProperties.ENTITY_ICON_MIN_SCALE.get();
        double maxScale = (Double)ThemeProperties.ENTITY_ICON_MAX_SCALE.get();
        double spinSpeed = (Double)ThemeProperties.ENTITY_ICON_SPIN_SPEED.get();
        double bobAmp = (Double)ThemeProperties.ENTITY_ICON_BOB_AMPLITUDE.get();
        double bobSpeed = (Double)ThemeProperties.ENTITY_ICON_BOB_SPEED.get();
        if (mods != null && !mods.isEmpty()) {
            baseFit = QuestIconRenderer.getDoubleMod(mods, "fit", baseFit);
            minScale = QuestIconRenderer.getDoubleMod(mods, "min", minScale);
            maxScale = QuestIconRenderer.getDoubleMod(mods, "max", maxScale);
            spinSpeed = QuestIconRenderer.getDoubleMod(mods, "spin", spinSpeed);
            bobAmp = QuestIconRenderer.getDoubleMod(mods, "bob", bobAmp);
            bobSpeed = QuestIconRenderer.getDoubleMod(mods, "bob_speed", bobSpeed);
        }
        if (hovered) {
            spinSpeed *= 1.5;
            bobAmp *= 1.25;
        }
        if (selected) {
            spinSpeed *= 1.5;
            bobAmp *= 1.25;
        }
        float bw = Math.max(0.6f, entity.method_17681());
        float bh = Math.max(0.6f, entity.method_17682());
        float maxDim = Math.max(bw, bh);
        float scale = (float)((double)size * baseFit / (double)Math.max(0.1f, maxDim));
        scale = (float)class_3532.method_15350((double)scale, (double)minScale, (double)maxScale);
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        double t = (double)((float)mc.field_1687.method_8510() + mc.method_1488()) * bobSpeed;
        double bob = bobAmp > 0.0 ? Math.sin(t * 0.1) * bobAmp : 0.0;
        pose.method_22904((double)((float)x + (float)size / 2.0f), (double)((float)y + (float)size * 0.9f) - bob, 50.0);
        pose.method_22905(scale, scale, -scale);
        float spin = (float)(spinSpeed * (double)(mc.field_1687.method_8510() % 360L));
        if (spinSpeed != 0.0) {
            pose.method_22907(class_7833.field_40716.rotationDegrees(spin));
        }
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        class_898 dispatcher = mc.method_1561();
        try {
            dispatcher.method_3948(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_4597.class_4598 buffer = mc.method_22940().method_23000();
        try {
            dispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pose, (class_4597)buffer, 0xF000F0);
            buffer.method_22993();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            dispatcher.method_3948(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pose.method_22909();
    }

    private static double getDoubleMod(Map<String, String> mods, String key, double def) {
        try {
            String v = mods.get(key);
            if (v == null || v.isEmpty()) {
                return def;
            }
            double d = Double.parseDouble(v);
            switch (key) {
                case "fit": {
                    return class_3532.method_15350((double)d, (double)0.1, (double)2.0);
                }
                case "min": {
                    return class_3532.method_15350((double)d, (double)0.1, (double)200.0);
                }
                case "max": {
                    return class_3532.method_15350((double)d, (double)0.1, (double)200.0);
                }
                case "spin": {
                    return class_3532.method_15350((double)d, (double)0.0, (double)20.0);
                }
                case "bob": {
                    return class_3532.method_15350((double)d, (double)0.0, (double)16.0);
                }
                case "bob_speed": {
                    return class_3532.method_15350((double)d, (double)0.1, (double)10.0);
                }
            }
            return d;
        }
        catch (Exception ignored) {
            return def;
        }
    }

    private static class ParsedRotate {
        final int interval;
        final List<String> children;

        ParsedRotate(int interval, List<String> children) {
            this.interval = interval;
            this.children = children;
        }
    }
}

