/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.ClientRuntimeConfig;
import org.texboobcat.questory.client.gui.QuestHudOverlay;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;
import org.texboobcat.questory.config.QuestoryConfig;

public class QuestoryConfigScreen
extends class_437 {
    private final class_437 parent;
    private ConfigTab currentTab = ConfigTab.HUD;
    private class_4185 hudTabButton;
    private class_4185 notificationsTabButton;
    private class_4185 displayTabButton;
    private class_4185 generalTabButton;
    private class_4185 serverTabButton;
    private class_4185 environmentTabButton;
    private class_4185 teamsTabButton;
    private class_4185 dailyTabButton;
    private class_4185 scriptingTabButton;
    private final List<class_4185> tabButtons = new ArrayList<class_4185>();
    private class_4185 leftTabScrollBtn;
    private class_4185 rightTabScrollBtn;
    private int tabsScrollPx = 0;
    private int tabsViewportX = 0;
    private int tabsViewportW = 0;
    private int tabsBarY = 10;
    private int tabButtonW = 80;
    private int tabButtonH = 16;
    private int tabSpacingBar = 4;
    private String hudPosition;
    private float hudScale;
    private int hudOpacity;
    private boolean hudCompactMode;
    private boolean hudShowIcons;
    private boolean hudShowProgressBars;
    private int hudOffsetX;
    private int hudOffsetY;
    private boolean enableNotifications;
    private boolean enableSounds;
    private boolean enableTitles;
    private boolean enableChatMessages;
    private boolean notifyOnUnlock;
    private boolean notifyOnReady;
    private boolean notifyOnComplete;
    private boolean showProgressPercentage;
    private boolean useColoredMessages;
    private boolean showQuestIDInList;
    private boolean mapIntegrationEnabled;
    private boolean journeyMapEnabled;
    private boolean clientEnableAdvancedEditor;
    private int autoSaveIntervalTicks;
    private boolean saveOnEveryProgress;
    private boolean trackCompletionTime;
    private boolean allowQuestReset;
    private boolean allowQuestReload;
    private boolean requireOPForAdmin;
    private int adminPermissionLevel;
    private int maxQuestsPerPlayer;
    private int maxRequirementsPerQuest;
    private int maxRewardsPerQuest;
    private boolean enableAdvancedEditorServer;
    private boolean advancedEditorRequiresOp;
    private boolean enableEditorAutoSave;
    private boolean debugMode;
    private boolean logQuestProgress;
    private boolean logQuestCompletion;
    private boolean observationEnabled;
    private int observationScanIntervalTicks;
    private double observationMaxLookDistance;
    private boolean environmentOnlyVisibleQuests;
    private boolean autoCompleteWhenRequirementsMet;
    private boolean teamSystemEnabled;
    private boolean teamUseExternalProvider;
    private String teamPreferredProvider;
    private boolean teamFallbackToBuiltIn;
    private String teamDefaultProgressMode;
    private String teamDefaultRewardMode;
    private int teamMaxSize;
    private boolean teamAllowCreation;
    private boolean teamRequireAllOnlineDefault;
    private int teamSyncProgressDelay;
    private boolean dailyEnable;
    private boolean dailyFetchOnWorldLoad;
    private int dailyFetchIntervalMinutes;
    private int dailyCacheTtlMinutes;
    private String dailyOfflineFallback;
    private int dailyRolloverHour;
    private String dailyTimeZone;
    private String dailyGroupName;
    private String dailyTagKey;
    private String dailyPrefixQuestIds;
    private int dailyMaxActiveQuests;
    private String dailyCompletionMode;
    private int dailyMinQuestsToComplete;
    private boolean dailyStoreHistory;
    private String dailyRemoteUrl;
    private String dailyBackupUrlsCsv;
    private class_342 dailyRemoteUrlBox;
    private class_342 dailyBackupUrlsBox;
    private class_342 dailyTimeZoneBox;
    private class_342 dailyGroupNameBox;
    private class_342 dailyTagKeyBox;
    private class_342 dailyPrefixBox;
    private boolean scriptIntegrationEnabled;
    private boolean scriptAllowExternalHttp;
    private boolean scriptEmitOnUnlock;
    private boolean scriptEmitOnStarted;
    private boolean scriptEmitOnProgress;
    private boolean scriptEmitOnCompleted;
    private boolean scriptEmitOnRewardClaimed;
    private String scriptWebhookUrl;
    private int scriptHttpTimeoutMs;
    private String scriptCommandOnUnlock;
    private String scriptCommandOnStarted;
    private String scriptCommandOnProgress;
    private String scriptCommandOnComplete;
    private String scriptCommandOnRewardClaimed;
    private class_342 scriptWebhookUrlBox;
    private class_342 scriptCmdUnlockBox;
    private class_342 scriptCmdStartedBox;
    private class_342 scriptCmdProgressBox;
    private class_342 scriptCmdCompleteBox;
    private class_342 scriptCmdRewardBox;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private class_4185 resetButton;
    private boolean draggingHud = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int originalOffsetX = 0;
    private int originalOffsetY = 0;
    private List<TooltipArea> tooltipAreas = new ArrayList<TooltipArea>();

    public QuestoryConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Questify Configuration"));
        this.parent = parent;
        this.loadConfig();
    }

    private boolean canEditServer() {
        try {
            return ClientRuntimeConfig.isPlayerPermitted();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private void loadConfig() {
        this.hudPosition = ClientConfig.getHudPosition();
        this.hudScale = ClientConfig.getHudScale();
        this.hudOpacity = ClientConfig.getHudOpacity();
        this.hudCompactMode = ClientConfig.isHudCompactMode();
        this.hudShowIcons = ClientConfig.isHudShowIcons();
        this.hudShowProgressBars = ClientConfig.isHudShowProgressBars();
        this.hudOffsetX = ClientConfig.getHudOffsetX();
        this.hudOffsetY = ClientConfig.getHudOffsetY();
        QuestoryConfig config = QuestoryConfig.getInstance();
        this.enableNotifications = config.enableQuestNotifications;
        this.enableSounds = config.enableQuestSounds;
        this.enableTitles = config.enableQuestTitles;
        this.enableChatMessages = config.enableQuestChatMessages;
        this.notifyOnUnlock = config.notifyOnQuestUnlock;
        this.notifyOnReady = config.notifyOnQuestReady;
        this.notifyOnComplete = config.notifyOnQuestComplete;
        this.showProgressPercentage = config.showProgressPercentage;
        this.useColoredMessages = config.useColoredMessages;
        this.showQuestIDInList = config.showQuestIDInList;
        this.mapIntegrationEnabled = ClientConfig.isMapIntegrationEnabled();
        this.journeyMapEnabled = ClientConfig.isJourneyMapEnabled();
        this.clientEnableAdvancedEditor = ClientConfig.isClientEnableAdvancedEditor();
        this.autoSaveIntervalTicks = config.autoSaveIntervalTicks;
        this.saveOnEveryProgress = config.saveOnEveryProgress;
        this.trackCompletionTime = config.trackCompletionTime;
        this.allowQuestReset = config.allowQuestReset;
        this.allowQuestReload = config.allowQuestReload;
        this.requireOPForAdmin = config.requireOPForAdmin;
        this.adminPermissionLevel = config.adminPermissionLevel;
        this.maxQuestsPerPlayer = config.maxQuestsPerPlayer;
        this.maxRequirementsPerQuest = config.maxRequirementsPerQuest;
        this.maxRewardsPerQuest = config.maxRewardsPerQuest;
        this.enableAdvancedEditorServer = config.enableAdvancedEditor;
        this.advancedEditorRequiresOp = config.advancedEditorRequiresOp;
        this.enableEditorAutoSave = config.enableEditorAutoSave;
        this.debugMode = config.debugMode;
        this.logQuestProgress = config.logQuestProgress;
        this.logQuestCompletion = config.logQuestCompletion;
        this.observationEnabled = config.observationEnabled;
        this.observationScanIntervalTicks = config.observationScanIntervalTicks;
        this.observationMaxLookDistance = config.observationMaxLookDistance;
        this.environmentOnlyVisibleQuests = config.environmentOnlyVisibleQuests;
        this.autoCompleteWhenRequirementsMet = config.autoCompleteWhenRequirementsMet;
        this.teamSystemEnabled = config.teamSystemEnabled;
        this.teamUseExternalProvider = config.teamUseExternalProvider;
        this.teamPreferredProvider = config.teamPreferredProvider;
        this.teamFallbackToBuiltIn = config.teamFallbackToBuiltIn;
        this.teamDefaultProgressMode = config.teamDefaultProgressMode;
        this.teamDefaultRewardMode = config.teamDefaultRewardMode;
        this.teamMaxSize = config.teamMaxSize;
        this.teamAllowCreation = config.teamAllowCreation;
        this.teamRequireAllOnlineDefault = config.teamRequireAllOnlineDefault;
        this.teamSyncProgressDelay = config.teamSyncProgressDelay;
        this.dailyEnable = config.dailyEnable;
        this.dailyFetchOnWorldLoad = config.dailyFetchOnWorldLoad;
        this.dailyFetchIntervalMinutes = config.dailyFetchIntervalMinutes;
        this.dailyCacheTtlMinutes = config.dailyCacheTtlMinutes;
        this.dailyOfflineFallback = config.dailyOfflineFallback;
        this.dailyRolloverHour = config.dailyRolloverHour;
        this.dailyTimeZone = config.dailyTimeZone;
        this.dailyGroupName = config.dailyGroupName;
        this.dailyTagKey = config.dailyTagKey;
        this.dailyPrefixQuestIds = config.dailyPrefixQuestIds;
        this.dailyMaxActiveQuests = config.dailyMaxActiveQuests;
        this.dailyCompletionMode = config.dailyCompletionMode;
        this.dailyMinQuestsToComplete = config.dailyMinQuestsToComplete;
        this.dailyStoreHistory = config.dailyStoreHistory;
        this.dailyRemoteUrl = config.dailyRemoteUrl != null ? config.dailyRemoteUrl : "";
        ArrayList bu = config.dailyBackupUrls != null ? config.dailyBackupUrls : new ArrayList();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bu.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((String)bu.get(i));
        }
        this.dailyBackupUrlsCsv = sb.toString();
        this.scriptIntegrationEnabled = config.scriptIntegrationEnabled;
        this.scriptAllowExternalHttp = config.scriptAllowExternalHttp;
        this.scriptEmitOnUnlock = config.scriptEmitOnUnlock;
        this.scriptEmitOnStarted = config.scriptEmitOnStarted;
        this.scriptEmitOnProgress = config.scriptEmitOnProgress;
        this.scriptEmitOnCompleted = config.scriptEmitOnCompleted;
        this.scriptEmitOnRewardClaimed = config.scriptEmitOnRewardClaimed;
        this.scriptWebhookUrl = config.scriptWebhookUrl != null ? config.scriptWebhookUrl : "";
        this.scriptHttpTimeoutMs = config.scriptHttpTimeoutMs;
        this.scriptCommandOnUnlock = config.scriptCommandOnUnlock != null ? config.scriptCommandOnUnlock : "";
        this.scriptCommandOnStarted = config.scriptCommandOnStarted != null ? config.scriptCommandOnStarted : "";
        this.scriptCommandOnProgress = config.scriptCommandOnProgress != null ? config.scriptCommandOnProgress : "";
        this.scriptCommandOnComplete = config.scriptCommandOnComplete != null ? config.scriptCommandOnComplete : "";
        this.scriptCommandOnRewardClaimed = config.scriptCommandOnRewardClaimed != null ? config.scriptCommandOnRewardClaimed : "";
    }

    protected void method_25426() {
        super.method_25426();
        this.tooltipAreas = new ArrayList<TooltipArea>();
        this.tabsBarY = 10;
        int margin = 12;
        int arrowW = 14;
        int desiredViewportW = Math.min(this.field_22789 - 120, 520);
        int barTotalW = arrowW + 4 + desiredViewportW + 4 + arrowW;
        int leftX = (this.field_22789 - barTotalW) / 2;
        this.tabsViewportX = leftX + arrowW + 4;
        this.tabsViewportW = desiredViewportW;
        this.tabButtons.clear();
        this.leftTabScrollBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), b -> {
            this.tabsScrollPx = Math.max(0, this.tabsScrollPx - (this.tabButtonW + this.tabSpacingBar));
            this.reflowTabs();
        }).method_46434(leftX, this.tabsBarY, arrowW, this.tabButtonH).method_46431());
        this.rightTabScrollBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), b -> {
            this.tabsScrollPx += this.tabButtonW + this.tabSpacingBar;
            this.reflowTabs();
        }).method_46434(leftX + barTotalW - arrowW, this.tabsBarY, arrowW, this.tabButtonH).method_46431());
        int idx = 0;
        ConfigTab[] configTabArray = ConfigTab.values();
        int n = configTabArray.length;
        for (int i = 0; i < n; ++i) {
            ConfigTab t;
            ConfigTab tabRef = t = configTabArray[i];
            class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43470((String)t.label), b -> {
                if (this.currentTab != tabRef) {
                    this.switchTab(tabRef);
                }
            }).method_46434(0, this.tabsBarY, this.tabButtonW, this.tabButtonH).method_46431();
            this.method_37063((class_364)btn);
            this.tabButtons.add(btn);
            ++idx;
        }
        this.centerOnCurrentTab();
        this.reflowTabs();
        int bottomY = this.field_22790 - 30;
        int bottomButtonWidth = 70;
        int centerX = this.field_22789 / 2;
        this.resetButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> this.resetCurrentTab()).method_46434(centerX - bottomButtonWidth * 2 - 10, bottomY, bottomButtonWidth, 20).method_46431());
        this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            this.saveAllConfig();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX - bottomButtonWidth / 2, bottomY, bottomButtonWidth, 20).method_46431());
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX + bottomButtonWidth + 10, bottomY, bottomButtonWidth, 20).method_46431());
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.initHudTab();
                break;
            }
            case 1: {
                this.initNotificationsTab();
                break;
            }
            case 2: {
                this.initDisplayTab();
                break;
            }
            case 3: {
                this.initGeneralTab();
                break;
            }
            case 4: {
                this.initServerTab();
                break;
            }
            case 5: {
                this.initEnvironmentTab();
                break;
            }
            case 6: {
                this.initTeamsTab();
                break;
            }
            case 7: {
                this.initDailyTab();
                break;
            }
            case 8: {
                this.initScriptingTab();
            }
        }
    }

    private void reflowTabs() {
        int total = ConfigTab.values().length * (this.tabButtonW + this.tabSpacingBar) - this.tabSpacingBar;
        int maxScroll = Math.max(0, total - this.tabsViewportW);
        if (this.tabsScrollPx < 0) {
            this.tabsScrollPx = 0;
        }
        if (this.tabsScrollPx > maxScroll) {
            this.tabsScrollPx = maxScroll;
        }
        int x = this.tabsViewportX - this.tabsScrollPx;
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            class_4185 btn = this.tabButtons.get(i);
            int bx = x + i * (this.tabButtonW + this.tabSpacingBar);
            btn.method_46421(bx);
            btn.method_46419(this.tabsBarY);
            btn.method_25358(this.tabButtonW);
            btn.field_22764 = bx >= this.tabsViewportX && bx + this.tabButtonW <= this.tabsViewportX + this.tabsViewportW;
            boolean isCurrent = this.currentTab == ConfigTab.values()[i];
            btn.field_22763 = !isCurrent;
            String base = ConfigTab.values()[i].label;
            btn.method_25355((class_2561)class_2561.method_43470((String)(isCurrent ? "\u00bb " + base + " \u00ab" : base)));
        }
        if (this.leftTabScrollBtn != null) {
            boolean bl = this.leftTabScrollBtn.field_22763 = this.tabsScrollPx > 0;
        }
        if (this.rightTabScrollBtn != null) {
            this.rightTabScrollBtn.field_22763 = this.tabsScrollPx < maxScroll;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (mouseY >= (double)this.tabsBarY && mouseY <= (double)(this.tabsBarY + this.tabButtonH + 2)) {
            this.tabsScrollPx -= (int)Math.signum(delta) * (this.tabButtonW + this.tabSpacingBar);
            this.reflowTabs();
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private void switchTab(ConfigTab tab) {
        this.currentTab = tab;
        this.centerOnCurrentTab();
        this.method_37067();
        this.method_25426();
    }

    private void centerOnCurrentTab() {
        int total = ConfigTab.values().length * (this.tabButtonW + this.tabSpacingBar) - this.tabSpacingBar;
        int maxScroll = Math.max(0, total - this.tabsViewportW);
        int idx = this.currentTab.ordinal();
        int tabCenterPx = idx * (this.tabButtonW + this.tabSpacingBar) + this.tabButtonW / 2;
        int desiredScroll = tabCenterPx - this.tabsViewportW / 2;
        if (desiredScroll < 0) {
            desiredScroll = 0;
        }
        if (desiredScroll > maxScroll) {
            desiredScroll = maxScroll;
        }
        this.tabsScrollPx = desiredScroll;
    }

    private void initHudTab() {
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 25;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Position: " + this.hudPosition)), b -> {
            this.hudPosition = switch (this.hudPosition) {
                case "TOP_LEFT" -> "TOP_RIGHT";
                case "TOP_RIGHT" -> "BOTTOM_RIGHT";
                case "BOTTOM_RIGHT" -> "BOTTOM_LEFT";
                default -> "TOP_LEFT";
            };
            b.method_25355((class_2561)class_2561.method_43470((String)("Position: " + this.hudPosition)));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        int scaleY = startY + spacing;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
            this.hudScale = Math.max(0.5f, this.hudScale - 0.1f);
        }).method_46434(centerX - 60, scaleY, 20, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
            this.hudScale = Math.min(2.0f, this.hudScale + 0.1f);
        }).method_46434(centerX + 40, scaleY, 20, buttonHeight).method_46431());
        int opacityY = startY + spacing * 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
            this.hudOpacity = Math.max(0, this.hudOpacity - 10);
        }).method_46434(centerX - 60, opacityY, 20, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
            this.hudOpacity = Math.min(100, this.hudOpacity + 10);
        }).method_46434(centerX + 40, opacityY, 20, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Compact: " + (this.hudCompactMode ? "ON" : "OFF"))), b -> {
            this.hudCompactMode = !this.hudCompactMode;
            b.method_25355((class_2561)class_2561.method_43470((String)("Compact: " + (this.hudCompactMode ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Icons: " + (this.hudShowIcons ? "ON" : "OFF"))), b -> {
            this.hudShowIcons = !this.hudShowIcons;
            b.method_25355((class_2561)class_2561.method_43470((String)("Icons: " + (this.hudShowIcons ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Progress Bars: " + (this.hudShowProgressBars ? "ON" : "OFF"))), b -> {
            this.hudShowProgressBars = !this.hudShowProgressBars;
            b.method_25355((class_2561)class_2561.method_43470((String)("Progress Bars: " + (this.hudShowProgressBars ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).method_46431());
    }

    private void initNotificationsTab() {
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        boolean permitted = this.canEditServer();
        class_4185 b1 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Enable Notifications: " + (this.enableNotifications ? "ON" : "OFF"))), b -> {
            this.enableNotifications = !this.enableNotifications;
            b.method_25355((class_2561)class_2561.method_43470((String)("Enable Notifications: " + (this.enableNotifications ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        b1.field_22763 = permitted;
        class_4185 b2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Sounds: " + (this.enableSounds ? "ON" : "OFF"))), b -> {
            this.enableSounds = !this.enableSounds;
            b.method_25355((class_2561)class_2561.method_43470((String)("Sounds: " + (this.enableSounds ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        b2.field_22763 = permitted;
        class_4185 b3 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Title Popups: " + (this.enableTitles ? "ON" : "OFF"))), b -> {
            this.enableTitles = !this.enableTitles;
            b.method_25355((class_2561)class_2561.method_43470((String)("Title Popups: " + (this.enableTitles ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
        b3.field_22763 = permitted;
        class_4185 b4 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Chat Messages: " + (this.enableChatMessages ? "ON" : "OFF"))), b -> {
            this.enableChatMessages = !this.enableChatMessages;
            b.method_25355((class_2561)class_2561.method_43470((String)("Chat Messages: " + (this.enableChatMessages ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).method_46431());
        b4.field_22763 = permitted;
        class_4185 b5 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notify on Unlock: " + (this.notifyOnUnlock ? "ON" : "OFF"))), b -> {
            this.notifyOnUnlock = !this.notifyOnUnlock;
            b.method_25355((class_2561)class_2561.method_43470((String)("Notify on Unlock: " + (this.notifyOnUnlock ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
        b5.field_22763 = permitted;
        class_4185 b6 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notify on Ready: " + (this.notifyOnReady ? "ON" : "OFF"))), b -> {
            this.notifyOnReady = !this.notifyOnReady;
            b.method_25355((class_2561)class_2561.method_43470((String)("Notify on Ready: " + (this.notifyOnReady ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).method_46431());
        b6.field_22763 = permitted;
        class_4185 b7 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notify on Complete: " + (this.notifyOnComplete ? "ON" : "OFF"))), b -> {
            this.notifyOnComplete = !this.notifyOnComplete;
            b.method_25355((class_2561)class_2561.method_43470((String)("Notify on Complete: " + (this.notifyOnComplete ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight).method_46431());
        b7.field_22763 = permitted;
    }

    private void initDisplayTab() {
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        boolean permitted = this.canEditServer();
        class_4185 d1 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Show Progress Percentage: " + (this.showProgressPercentage ? "ON" : "OFF"))), b -> {
            this.showProgressPercentage = !this.showProgressPercentage;
            b.method_25355((class_2561)class_2561.method_43470((String)("Show Progress Percentage: " + (this.showProgressPercentage ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        d1.field_22763 = permitted;
        class_4185 d2 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Colored Messages: " + (this.useColoredMessages ? "ON" : "OFF"))), b -> {
            this.useColoredMessages = !this.useColoredMessages;
            b.method_25355((class_2561)class_2561.method_43470((String)("Colored Messages: " + (this.useColoredMessages ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        d2.field_22763 = permitted;
        class_4185 d3 = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Show Quest IDs: " + (this.showQuestIDInList ? "ON" : "OFF"))), b -> {
            this.showQuestIDInList = !this.showQuestIDInList;
            b.method_25355((class_2561)class_2561.method_43470((String)("Show Quest IDs: " + (this.showQuestIDInList ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
        d3.field_22763 = permitted;
    }

    private void initGeneralTab() {
        int centerX = this.field_22789 / 2;
        int startY = 60;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        class_4185 mapBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Map Integration: " + (this.mapIntegrationEnabled ? "ON" : "OFF"))), b -> {
            this.mapIntegrationEnabled = !this.mapIntegrationEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)("Map Integration: " + (this.mapIntegrationEnabled ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        this.addTooltipArea(mapBtn.method_46426(), mapBtn.method_46427(), buttonWidth, buttonHeight, "Enable Questory's client map integration layer.", "When ON, supported map mods (e.g., JourneyMap) get waypoints for tracked quests.");
        boolean jmPresent = false;
        try {
            jmPresent = Platform.isModLoaded((String)"journeymap");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_4185 jmBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("JourneyMap Support: " + (this.journeyMapEnabled ? "ON" : "OFF"))), b -> {
            this.journeyMapEnabled = !this.journeyMapEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)("JourneyMap Support: " + (this.journeyMapEnabled ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        jmBtn.field_22763 = jmPresent;
        this.addTooltipArea(jmBtn.method_46426(), jmBtn.method_46427(), buttonWidth, buttonHeight, jmPresent ? "Toggle per-client export of waypoints to JourneyMap." : "JourneyMap not detected. This toggle is disabled.");
        class_4185 edBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Advanced Editor: " + (this.clientEnableAdvancedEditor ? "ON" : "OFF"))), b -> {
            this.clientEnableAdvancedEditor = !this.clientEnableAdvancedEditor;
            b.method_25355((class_2561)class_2561.method_43470((String)("Advanced Editor: " + (this.clientEnableAdvancedEditor ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
        this.addTooltipArea(edBtn.method_46426(), edBtn.method_46427(), buttonWidth, buttonHeight, "Locally show/hide Advanced Editor entry points on this client.");
    }

    private void initServerTab() {
        int centerX = this.field_22789 / 2;
        int startY = 60;
        int buttonWidth = 220;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            class_4185 info = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Server settings require OP"), b -> {}).method_46434(centerX - 140, startY, 280, buttonHeight).method_46431();
            info.field_22763 = false;
            this.method_37063((class_364)info);
            return;
        }
        IntSlider autoSaveSlider = new IntSlider(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight, "AutoSave Interval: ", 600, 24000, 600, this.autoSaveIntervalTicks, v -> {
            this.autoSaveIntervalTicks = v;
        });
        this.method_37063((class_364)autoSaveSlider);
        this.addTooltipArea(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight, "How often to auto-save progress (in ticks).", "20 ticks = 1 second.");
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Save On Every Progress: " + (this.saveOnEveryProgress ? "ON" : "OFF"))), b -> {
            this.saveOnEveryProgress = !this.saveOnEveryProgress;
            b.method_25355((class_2561)class_2561.method_43470((String)("Save On Every Progress: " + (this.saveOnEveryProgress ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Track Completion Time: " + (this.trackCompletionTime ? "ON" : "OFF"))), b -> {
            this.trackCompletionTime = !this.trackCompletionTime;
            b.method_25355((class_2561)class_2561.method_43470((String)("Track Completion Time: " + (this.trackCompletionTime ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Allow Quest Reset: " + (this.allowQuestReset ? "ON" : "OFF"))), b -> {
            this.allowQuestReset = !this.allowQuestReset;
            b.method_25355((class_2561)class_2561.method_43470((String)("Allow Quest Reset: " + (this.allowQuestReset ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Allow Quest Reload: " + (this.allowQuestReload ? "ON" : "OFF"))), b -> {
            this.allowQuestReload = !this.allowQuestReload;
            b.method_25355((class_2561)class_2561.method_43470((String)("Allow Quest Reload: " + (this.allowQuestReload ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Require OP For Admin: " + (this.requireOPForAdmin ? "YES" : "NO"))), b -> {
            this.requireOPForAdmin = !this.requireOPForAdmin;
            b.method_25355((class_2561)class_2561.method_43470((String)("Require OP For Admin: " + (this.requireOPForAdmin ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).method_46431());
        IntSlider permSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight, "Admin Permission Level: ", 0, 4, 1, this.adminPermissionLevel, v -> {
            this.adminPermissionLevel = v;
        });
        this.method_37063((class_364)permSlider);
        this.method_37063((class_364)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 7, buttonWidth, buttonHeight, "Max Quests Per Player: ", 100, 5000, 100, this.maxQuestsPerPlayer, v -> {
            this.maxQuestsPerPlayer = v;
        }));
        this.method_37063((class_364)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 8, buttonWidth, buttonHeight, "Max Requirements Per Quest: ", 10, 200, 5, this.maxRequirementsPerQuest, v -> {
            this.maxRequirementsPerQuest = v;
        }));
        this.method_37063((class_364)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 9, buttonWidth, buttonHeight, "Max Rewards Per Quest: ", 5, 100, 5, this.maxRewardsPerQuest, v -> {
            this.maxRewardsPerQuest = v;
        }));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Advanced Editor (Server): " + (this.enableAdvancedEditorServer ? "ON" : "OFF"))), b -> {
            this.enableAdvancedEditorServer = !this.enableAdvancedEditorServer;
            b.method_25355((class_2561)class_2561.method_43470((String)("Advanced Editor (Server): " + (this.enableAdvancedEditorServer ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 10, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Editor Requires OP: " + (this.advancedEditorRequiresOp ? "YES" : "NO"))), b -> {
            this.advancedEditorRequiresOp = !this.advancedEditorRequiresOp;
            b.method_25355((class_2561)class_2561.method_43470((String)("Editor Requires OP: " + (this.advancedEditorRequiresOp ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 11, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Editor Auto-Save: " + (this.enableEditorAutoSave ? "ON" : "OFF"))), b -> {
            this.enableEditorAutoSave = !this.enableEditorAutoSave;
            b.method_25355((class_2561)class_2561.method_43470((String)("Editor Auto-Save: " + (this.enableEditorAutoSave ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 12, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Debug Mode: " + (this.debugMode ? "ON" : "OFF"))), b -> {
            this.debugMode = !this.debugMode;
            b.method_25355((class_2561)class_2561.method_43470((String)("Debug Mode: " + (this.debugMode ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 12, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Log Quest Progress: " + (this.logQuestProgress ? "ON" : "OFF"))), b -> {
            this.logQuestProgress = !this.logQuestProgress;
            b.method_25355((class_2561)class_2561.method_43470((String)("Log Quest Progress: " + (this.logQuestProgress ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 13, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Log Quest Completion: " + (this.logQuestCompletion ? "ON" : "OFF"))), b -> {
            this.logQuestCompletion = !this.logQuestCompletion;
            b.method_25355((class_2561)class_2561.method_43470((String)("Log Quest Completion: " + (this.logQuestCompletion ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 14, buttonWidth, buttonHeight).method_46431());
    }

    private void initEnvironmentTab() {
        int centerX = this.field_22789 / 2;
        int startY = 60;
        int buttonWidth = 260;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            class_4185 info = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Server settings require OP"), b -> {}).method_46434(centerX - 140, startY, 280, buttonHeight).method_46431();
            info.field_22763 = false;
            this.method_37063((class_364)info);
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Observation Enabled: " + (this.observationEnabled ? "ON" : "OFF"))), b -> {
            this.observationEnabled = !this.observationEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)("Observation Enabled: " + (this.observationEnabled ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)new IntSlider(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight, "Scan Interval: ", 1, 60, 1, this.observationScanIntervalTicks, v -> {
            this.observationScanIntervalTicks = v;
        }));
        this.addTooltipArea(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight, "Environment scan cadence in ticks (1-60).", "Lower = more frequent checks.");
        this.method_37063((class_364)new DoubleSlider(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight, "Max Look Distance: ", 1.0, 64.0, 0.5, this.observationMaxLookDistance, v -> {
            this.observationMaxLookDistance = v;
        }));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Only Visible Quests: " + (this.environmentOnlyVisibleQuests ? "YES" : "NO"))), b -> {
            this.environmentOnlyVisibleQuests = !this.environmentOnlyVisibleQuests;
            b.method_25355((class_2561)class_2561.method_43470((String)("Only Visible Quests: " + (this.environmentOnlyVisibleQuests ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Auto-Complete On Requirements Met: " + (this.autoCompleteWhenRequirementsMet ? "ON" : "OFF"))), b -> {
            this.autoCompleteWhenRequirementsMet = !this.autoCompleteWhenRequirementsMet;
            b.method_25355((class_2561)class_2561.method_43470((String)("Auto-Complete On Requirements Met: " + (this.autoCompleteWhenRequirementsMet ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
    }

    private void initTeamsTab() {
        int centerX = this.field_22789 / 2;
        int startY = 60;
        int buttonWidth = 280;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            class_4185 info = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Server settings require OP"), b -> {}).method_46434(centerX - 140, startY, 280, buttonHeight).method_46431();
            info.field_22763 = false;
            this.method_37063((class_364)info);
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Team System Enabled: " + (this.teamSystemEnabled ? "ON" : "OFF"))), b -> {
            this.teamSystemEnabled = !this.teamSystemEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)("Team System Enabled: " + (this.teamSystemEnabled ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Use External Provider: " + (this.teamUseExternalProvider ? "YES" : "NO"))), b -> {
            this.teamUseExternalProvider = !this.teamUseExternalProvider;
            b.method_25355((class_2561)class_2561.method_43470((String)("Use External Provider: " + (this.teamUseExternalProvider ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Preferred Provider: " + this.teamPreferredProvider)), b -> {
            String[] opts = new String[]{"ftbteams", "simpleteams"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.teamPreferredProvider)) continue;
                i = k;
                break;
            }
            this.teamPreferredProvider = opts[(i + 1) % opts.length];
            b.method_25355((class_2561)class_2561.method_43470((String)("Preferred Provider: " + this.teamPreferredProvider)));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Fallback To Built-In: " + (this.teamFallbackToBuiltIn ? "YES" : "NO"))), b -> {
            this.teamFallbackToBuiltIn = !this.teamFallbackToBuiltIn;
            b.method_25355((class_2561)class_2561.method_43470((String)("Fallback To Built-In: " + (this.teamFallbackToBuiltIn ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Default Progress Mode: " + this.teamDefaultProgressMode)), b -> {
            String[] opts = new String[]{"SHARED", "INDIVIDUAL", "COMBINED", "PARALLEL"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.teamDefaultProgressMode)) continue;
                i = k;
                break;
            }
            this.teamDefaultProgressMode = opts[(i + 1) % opts.length];
            b.method_25355((class_2561)class_2561.method_43470((String)("Default Progress Mode: " + this.teamDefaultProgressMode)));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Default Reward Mode: " + this.teamDefaultRewardMode)), b -> {
            String[] opts = new String[]{"SHARED", "COMPLETER_ONLY", "DISTRIBUTED", "ALL_MEMBERS"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.teamDefaultRewardMode)) continue;
                i = k;
                break;
            }
            this.teamDefaultRewardMode = opts[(i + 1) % opts.length];
            b.method_25355((class_2561)class_2561.method_43470((String)("Default Reward Mode: " + this.teamDefaultRewardMode)));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight, "Team Max Size: ", 2, 100, 1, this.teamMaxSize, v -> {
            this.teamMaxSize = v;
        }));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Allow Team Creation: " + (this.teamAllowCreation ? "YES" : "NO"))), b -> {
            this.teamAllowCreation = !this.teamAllowCreation;
            b.method_25355((class_2561)class_2561.method_43470((String)("Allow Team Creation: " + (this.teamAllowCreation ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 7, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Require All Online: " + (this.teamRequireAllOnlineDefault ? "YES" : "NO"))), b -> {
            this.teamRequireAllOnlineDefault = !this.teamRequireAllOnlineDefault;
            b.method_25355((class_2561)class_2561.method_43470((String)("Require All Online: " + (this.teamRequireAllOnlineDefault ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 8, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)new IntSlider(centerX - buttonWidth / 2, startY + spacing * 9, buttonWidth, buttonHeight, "Progress Sync Delay: ", 1, 120, 1, this.teamSyncProgressDelay, v -> {
            this.teamSyncProgressDelay = v;
        }));
    }

    private void initDailyTab() {
        int centerX = this.field_22789 / 2;
        int startY = 60;
        int buttonWidth = 280;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            class_4185 info = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Server settings require OP"), b -> {}).method_46434(centerX - 140, startY, 280, buttonHeight).method_46431();
            info.field_22763 = false;
            this.method_37063((class_364)info);
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Daily System: " + (this.dailyEnable ? "ON" : "OFF"))), b -> {
            this.dailyEnable = !this.dailyEnable;
            b.method_25355((class_2561)class_2561.method_43470((String)("Daily System: " + (this.dailyEnable ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Fetch On World Load: " + (this.dailyFetchOnWorldLoad ? "ON" : "OFF"))), b -> {
            this.dailyFetchOnWorldLoad = !this.dailyFetchOnWorldLoad;
            b.method_25355((class_2561)class_2561.method_43470((String)("Fetch On World Load: " + (this.dailyFetchOnWorldLoad ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        IntSlider fetchIntSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight, "Fetch Interval (min): ", 0, 1440, 15, this.dailyFetchIntervalMinutes, v -> {
            this.dailyFetchIntervalMinutes = v;
        });
        this.method_37063((class_364)fetchIntSlider);
        IntSlider ttlSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight, "Cache TTL (min): ", 60, 4320, 60, this.dailyCacheTtlMinutes, v -> {
            this.dailyCacheTtlMinutes = v;
        });
        this.method_37063((class_364)ttlSlider);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Offline Fallback: " + this.dailyOfflineFallback)), b -> {
            String[] opts = new String[]{"use_cache", "keep_previous", "disable"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.dailyOfflineFallback)) continue;
                i = k;
                break;
            }
            this.dailyOfflineFallback = opts[(i + 1) % opts.length];
            b.method_25355((class_2561)class_2561.method_43470((String)("Offline Fallback: " + this.dailyOfflineFallback)));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
        IntSlider hourSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight, "Rollover Hour: ", 0, 23, 1, this.dailyRolloverHour, v -> {
            this.dailyRolloverHour = v;
        });
        this.method_37063((class_364)hourSlider);
        IntSlider maxActiveSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight, "Max Active Quests: ", 0, 50, 1, this.dailyMaxActiveQuests, v -> {
            this.dailyMaxActiveQuests = v;
        });
        this.method_37063((class_364)maxActiveSlider);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Completion Mode: " + this.dailyCompletionMode)), b -> {
            String[] opts = new String[]{"ALL", "ANY"};
            int i = 0;
            for (int k = 0; k < opts.length; ++k) {
                if (!opts[k].equalsIgnoreCase(this.dailyCompletionMode)) continue;
                i = k;
                break;
            }
            this.dailyCompletionMode = opts[(i + 1) % opts.length];
            b.method_25355((class_2561)class_2561.method_43470((String)("Completion Mode: " + this.dailyCompletionMode)));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 7, buttonWidth, buttonHeight).method_46431());
        IntSlider minCompSlider = new IntSlider(centerX - buttonWidth / 2, startY + spacing * 8, buttonWidth, buttonHeight, "Min Quests To Complete: ", 0, 10, 1, this.dailyMinQuestsToComplete, v -> {
            this.dailyMinQuestsToComplete = v;
        });
        this.method_37063((class_364)minCompSlider);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Store History: " + (this.dailyStoreHistory ? "YES" : "NO"))), b -> {
            this.dailyStoreHistory = !this.dailyStoreHistory;
            b.method_25355((class_2561)class_2561.method_43470((String)("Store History: " + (this.dailyStoreHistory ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 9, buttonWidth, buttonHeight).method_46431());
        int fieldW = buttonWidth;
        int fieldX = centerX - fieldW / 2;
        int fy = startY + spacing * 10;
        this.dailyRemoteUrlBox = new class_342(this.field_22793, fieldX, fy, fieldW, 18, (class_2561)class_2561.method_43470((String)"Remote URL"));
        this.dailyRemoteUrlBox.method_1852(this.dailyRemoteUrl);
        this.dailyRemoteUrlBox.method_47404((class_2561)class_2561.method_43470((String)"dailyRemoteUrl (http/https)"));
        this.dailyRemoteUrlBox.method_1888(true);
        this.dailyRemoteUrlBox.method_1863(s -> {
            this.dailyRemoteUrl = s;
        });
        this.method_37063((class_364)this.dailyRemoteUrlBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Primary source for Daily payload JSON (http/https).", "Leave blank to disable remote fetching.");
        this.dailyBackupUrlsBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Backup URLs (CSV)"));
        this.dailyBackupUrlsBox.method_1852(this.dailyBackupUrlsCsv);
        this.dailyBackupUrlsBox.method_47404((class_2561)class_2561.method_43470((String)"url1, url2, ..."));
        this.dailyBackupUrlsBox.method_1863(s -> {
            this.dailyBackupUrlsCsv = s;
        });
        this.method_37063((class_364)this.dailyBackupUrlsBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Comma-separated fallback URLs if primary fails.");
        this.dailyTimeZoneBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Time Zone"));
        this.dailyTimeZoneBox.method_1852(this.dailyTimeZone);
        this.dailyTimeZoneBox.method_47404((class_2561)class_2561.method_43470((String)"IANA TZ, e.g. UTC"));
        this.dailyTimeZoneBox.method_1863(s -> {
            this.dailyTimeZone = s;
        });
        this.method_37063((class_364)this.dailyTimeZoneBox);
        this.dailyGroupNameBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Group Name"));
        this.dailyGroupNameBox.method_1852(this.dailyGroupName);
        this.dailyGroupNameBox.method_1863(s -> {
            this.dailyGroupName = s;
        });
        this.method_37063((class_364)this.dailyGroupNameBox);
        this.dailyTagKeyBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Tag Key"));
        this.dailyTagKeyBox.method_1852(this.dailyTagKey);
        this.dailyTagKeyBox.method_1863(s -> {
            this.dailyTagKey = s;
        });
        this.method_37063((class_364)this.dailyTagKeyBox);
        this.dailyPrefixBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"ID Prefix"));
        this.dailyPrefixBox.method_1852(this.dailyPrefixQuestIds);
        this.dailyPrefixBox.method_1863(s -> {
            this.dailyPrefixQuestIds = s;
        });
        this.method_37063((class_364)this.dailyPrefixBox);
    }

    private void initScriptingTab() {
        int centerX = this.field_22789 / 2;
        int startY = 60;
        int buttonWidth = 280;
        int buttonHeight = 20;
        int spacing = 22;
        boolean permitted = this.canEditServer();
        if (!permitted) {
            class_4185 info = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Server settings require OP"), b -> {}).method_46434(centerX - 140, startY, 280, buttonHeight).method_46431();
            info.field_22763 = false;
            this.method_37063((class_364)info);
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Scripting Bridge: " + (this.scriptIntegrationEnabled ? "ON" : "OFF"))), b -> {
            this.scriptIntegrationEnabled = !this.scriptIntegrationEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)("Scripting Bridge: " + (this.scriptIntegrationEnabled ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Allow External HTTP: " + (this.scriptAllowExternalHttp ? "YES" : "NO"))), b -> {
            this.scriptAllowExternalHttp = !this.scriptAllowExternalHttp;
            b.method_25355((class_2561)class_2561.method_43470((String)("Allow External HTTP: " + (this.scriptAllowExternalHttp ? "YES" : "NO"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Emit On Unlock: " + (this.scriptEmitOnUnlock ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnUnlock = !this.scriptEmitOnUnlock;
            b.method_25355((class_2561)class_2561.method_43470((String)("Emit On Unlock: " + (this.scriptEmitOnUnlock ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Emit On Started: " + (this.scriptEmitOnStarted ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnStarted = !this.scriptEmitOnStarted;
            b.method_25355((class_2561)class_2561.method_43470((String)("Emit On Started: " + (this.scriptEmitOnStarted ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Emit On Progress: " + (this.scriptEmitOnProgress ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnProgress = !this.scriptEmitOnProgress;
            b.method_25355((class_2561)class_2561.method_43470((String)("Emit On Progress: " + (this.scriptEmitOnProgress ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Emit On Completed: " + (this.scriptEmitOnCompleted ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnCompleted = !this.scriptEmitOnCompleted;
            b.method_25355((class_2561)class_2561.method_43470((String)("Emit On Completed: " + (this.scriptEmitOnCompleted ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Emit On Reward Claimed: " + (this.scriptEmitOnRewardClaimed ? "ON" : "OFF"))), b -> {
            this.scriptEmitOnRewardClaimed = !this.scriptEmitOnRewardClaimed;
            b.method_25355((class_2561)class_2561.method_43470((String)("Emit On Reward Claimed: " + (this.scriptEmitOnRewardClaimed ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight).method_46431());
        int fieldW = buttonWidth;
        int fieldX = centerX - fieldW / 2;
        int fy = startY + spacing * 7;
        this.scriptWebhookUrlBox = new class_342(this.field_22793, fieldX, fy, fieldW, 18, (class_2561)class_2561.method_43470((String)"Webhook URL"));
        this.scriptWebhookUrlBox.method_1852(this.scriptWebhookUrl);
        this.scriptWebhookUrlBox.method_47404((class_2561)class_2561.method_43470((String)"http/https webhook URL"));
        this.scriptWebhookUrlBox.method_1863(s -> {
            this.scriptWebhookUrl = s;
        });
        this.method_37063((class_364)this.scriptWebhookUrlBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "HTTP endpoint to receive quest events as JSON.", "Use http/https. Leave blank to disable webhooks.");
        IntSlider httpTimeoutSlider = new IntSlider(fieldX, fy += spacing, fieldW, buttonHeight, "HTTP Timeout: ", 1000, 30000, 1000, this.scriptHttpTimeoutMs, val -> {
            this.scriptHttpTimeoutMs = val;
        });
        this.method_37063((class_364)httpTimeoutSlider);
        this.addTooltipArea(fieldX, fy, fieldW, buttonHeight, "Request timeout for webhook POST/commands (milliseconds).", "Typical: 5000\u201310000 ms");
        this.scriptCmdUnlockBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Command On Unlock"));
        this.scriptCmdUnlockBox.method_1852(this.scriptCommandOnUnlock);
        this.scriptCmdUnlockBox.method_47404((class_2561)class_2561.method_43470((String)"/cmd {player} {quest_title}"));
        this.scriptCmdUnlockBox.method_1863(s -> {
            this.scriptCommandOnUnlock = s;
        });
        this.method_37063((class_364)this.scriptCmdUnlockBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Server command executed when a quest is unlocked.", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
        this.scriptCmdStartedBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Command On Started"));
        this.scriptCmdStartedBox.method_1852(this.scriptCommandOnStarted);
        this.scriptCmdStartedBox.method_47404((class_2561)class_2561.method_43470((String)"/cmd {player} {quest_id}"));
        this.scriptCmdStartedBox.method_1863(s -> {
            this.scriptCommandOnStarted = s;
        });
        this.method_37063((class_364)this.scriptCmdStartedBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Command when a quest is first started.", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
        this.scriptCmdProgressBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Command On Progress"));
        this.scriptCmdProgressBox.method_1852(this.scriptCommandOnProgress);
        this.scriptCmdProgressBox.method_47404((class_2561)class_2561.method_43470((String)"/cmd {player} {quest_id} progress"));
        this.scriptCmdProgressBox.method_1863(s -> {
            this.scriptCommandOnProgress = s;
        });
        this.method_37063((class_364)this.scriptCmdProgressBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Command on progress updates (can be noisy).", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
        this.scriptCmdCompleteBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Command On Complete"));
        this.scriptCmdCompleteBox.method_1852(this.scriptCommandOnComplete);
        this.scriptCmdCompleteBox.method_47404((class_2561)class_2561.method_43470((String)"/cmd {player} completed {quest_title}"));
        this.scriptCmdCompleteBox.method_1863(s -> {
            this.scriptCommandOnComplete = s;
        });
        this.method_37063((class_364)this.scriptCmdCompleteBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Command when a quest is completed.", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
        this.scriptCmdRewardBox = new class_342(this.field_22793, fieldX, fy += spacing, fieldW, 18, (class_2561)class_2561.method_43470((String)"Command On Reward Claimed"));
        this.scriptCmdRewardBox.method_1852(this.scriptCommandOnRewardClaimed);
        this.scriptCmdRewardBox.method_47404((class_2561)class_2561.method_43470((String)"/cmd {player} reward {quest_id}"));
        this.scriptCmdRewardBox.method_1863(s -> {
            this.scriptCommandOnRewardClaimed = s;
        });
        this.method_37063((class_364)this.scriptCmdRewardBox);
        this.addTooltipArea(fieldX, fy, fieldW, 18, "Command when a reward is claimed.", "Placeholders: {player} {uuid} {quest_id} {quest_title} {group} {timestamp}");
    }

    private void resetCurrentTab() {
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.hudPosition = "TOP_LEFT";
                this.hudScale = 1.0f;
                this.hudOpacity = 80;
                this.hudCompactMode = false;
                this.hudShowIcons = true;
                this.hudShowProgressBars = true;
                this.hudOffsetX = 10;
                this.hudOffsetY = 10;
                break;
            }
            case 1: {
                this.enableNotifications = true;
                this.enableSounds = true;
                this.enableTitles = true;
                this.enableChatMessages = true;
                this.notifyOnUnlock = true;
                this.notifyOnReady = true;
                this.notifyOnComplete = true;
                break;
            }
            case 2: {
                this.showProgressPercentage = true;
                this.useColoredMessages = true;
                this.showQuestIDInList = false;
                break;
            }
            case 3: {
                this.mapIntegrationEnabled = true;
                this.journeyMapEnabled = true;
                this.clientEnableAdvancedEditor = true;
                break;
            }
            case 4: {
                this.autoSaveIntervalTicks = 6000;
                this.saveOnEveryProgress = false;
                this.trackCompletionTime = true;
                this.allowQuestReset = true;
                this.allowQuestReload = true;
                this.requireOPForAdmin = true;
                this.adminPermissionLevel = 2;
                this.maxQuestsPerPlayer = 1000;
                this.maxRequirementsPerQuest = 50;
                this.maxRewardsPerQuest = 20;
                this.enableAdvancedEditorServer = false;
                this.advancedEditorRequiresOp = true;
                this.debugMode = false;
                this.logQuestProgress = false;
                this.logQuestCompletion = true;
                break;
            }
            case 5: {
                this.observationEnabled = true;
                this.observationScanIntervalTicks = 10;
                this.observationMaxLookDistance = 5.0;
                this.environmentOnlyVisibleQuests = false;
                this.autoCompleteWhenRequirementsMet = false;
                break;
            }
            case 6: {
                this.teamSystemEnabled = true;
                this.teamUseExternalProvider = true;
                this.teamPreferredProvider = "ftbteams";
                this.teamFallbackToBuiltIn = true;
                this.teamDefaultProgressMode = "SHARED";
                this.teamDefaultRewardMode = "SHARED";
                this.teamMaxSize = 10;
                this.teamAllowCreation = true;
                this.teamRequireAllOnlineDefault = false;
                this.teamSyncProgressDelay = 20;
                break;
            }
            case 7: {
                this.dailyEnable = false;
                this.dailyFetchOnWorldLoad = true;
                this.dailyFetchIntervalMinutes = 0;
                this.dailyCacheTtlMinutes = 1440;
                this.dailyOfflineFallback = "use_cache";
                this.dailyRolloverHour = 0;
                this.dailyTimeZone = "UTC";
                this.dailyGroupName = "Daily";
                this.dailyTagKey = "daily";
                this.dailyPrefixQuestIds = "daily_";
                this.dailyMaxActiveQuests = 0;
                this.dailyCompletionMode = "ALL";
                this.dailyMinQuestsToComplete = 0;
                this.dailyStoreHistory = true;
                this.dailyRemoteUrl = "";
                this.dailyBackupUrlsCsv = "";
                break;
            }
            case 8: {
                this.scriptIntegrationEnabled = false;
                this.scriptAllowExternalHttp = false;
                this.scriptEmitOnUnlock = true;
                this.scriptEmitOnStarted = true;
                this.scriptEmitOnProgress = false;
                this.scriptEmitOnCompleted = true;
                this.scriptEmitOnRewardClaimed = true;
                this.scriptWebhookUrl = "";
                this.scriptHttpTimeoutMs = 5000;
                this.scriptCommandOnUnlock = "";
                this.scriptCommandOnStarted = "";
                this.scriptCommandOnProgress = "";
                this.scriptCommandOnComplete = "";
                this.scriptCommandOnRewardClaimed = "";
            }
        }
        this.method_37067();
        this.method_25426();
    }

    private void saveAllConfig() {
        ClientConfig.setHudPosition(this.hudPosition);
        ClientConfig.setHudScale(this.hudScale);
        ClientConfig.setHudOpacity(this.hudOpacity);
        ClientConfig.setHudCompactMode(this.hudCompactMode);
        ClientConfig.setHudShowIcons(this.hudShowIcons);
        ClientConfig.setHudShowProgressBars(this.hudShowProgressBars);
        ClientConfig.setHudOffsetX(this.hudOffsetX);
        ClientConfig.setHudOffsetY(this.hudOffsetY);
        QuestoryConfig config = QuestoryConfig.getInstance();
        boolean permitted = this.canEditServer();
        if (permitted) {
            config.enableQuestNotifications = this.enableNotifications;
            config.enableQuestSounds = this.enableSounds;
            config.enableQuestTitles = this.enableTitles;
            config.enableQuestChatMessages = this.enableChatMessages;
            config.notifyOnQuestUnlock = this.notifyOnUnlock;
            config.notifyOnQuestReady = this.notifyOnReady;
            config.notifyOnQuestComplete = this.notifyOnComplete;
            config.showProgressPercentage = this.showProgressPercentage;
            config.useColoredMessages = this.useColoredMessages;
            config.showQuestIDInList = this.showQuestIDInList;
        }
        ClientConfig.setMapIntegrationEnabled(this.mapIntegrationEnabled);
        ClientConfig.setJourneyMapEnabled(this.journeyMapEnabled);
        ClientConfig.setClientEnableAdvancedEditor(this.clientEnableAdvancedEditor);
        if (permitted) {
            config.autoSaveIntervalTicks = this.autoSaveIntervalTicks;
            config.saveOnEveryProgress = this.saveOnEveryProgress;
            config.trackCompletionTime = this.trackCompletionTime;
            config.allowQuestReset = this.allowQuestReset;
            config.allowQuestReload = this.allowQuestReload;
            config.requireOPForAdmin = this.requireOPForAdmin;
            config.adminPermissionLevel = this.adminPermissionLevel;
            config.maxQuestsPerPlayer = this.maxQuestsPerPlayer;
            config.maxRequirementsPerQuest = this.maxRequirementsPerQuest;
            config.maxRewardsPerQuest = this.maxRewardsPerQuest;
            config.enableAdvancedEditor = this.enableAdvancedEditorServer;
            config.advancedEditorRequiresOp = this.advancedEditorRequiresOp;
            config.enableEditorAutoSave = this.enableEditorAutoSave;
            config.debugMode = this.debugMode;
            config.logQuestProgress = this.logQuestProgress;
            config.logQuestCompletion = this.logQuestCompletion;
            config.observationEnabled = this.observationEnabled;
            config.observationScanIntervalTicks = this.observationScanIntervalTicks;
            config.observationMaxLookDistance = this.observationMaxLookDistance;
            config.environmentOnlyVisibleQuests = this.environmentOnlyVisibleQuests;
            config.autoCompleteWhenRequirementsMet = this.autoCompleteWhenRequirementsMet;
            config.teamSystemEnabled = this.teamSystemEnabled;
            config.teamUseExternalProvider = this.teamUseExternalProvider;
            config.teamPreferredProvider = this.teamPreferredProvider;
            config.teamFallbackToBuiltIn = this.teamFallbackToBuiltIn;
            config.teamDefaultProgressMode = this.teamDefaultProgressMode;
            config.teamDefaultRewardMode = this.teamDefaultRewardMode;
            config.teamMaxSize = this.teamMaxSize;
            config.teamAllowCreation = this.teamAllowCreation;
            config.teamRequireAllOnlineDefault = this.teamRequireAllOnlineDefault;
            config.teamSyncProgressDelay = this.teamSyncProgressDelay;
            config.dailyEnable = this.dailyEnable;
            config.dailyFetchOnWorldLoad = this.dailyFetchOnWorldLoad;
            config.dailyFetchIntervalMinutes = this.dailyFetchIntervalMinutes;
            config.dailyCacheTtlMinutes = this.dailyCacheTtlMinutes;
            config.dailyOfflineFallback = this.dailyOfflineFallback;
            config.dailyRolloverHour = this.dailyRolloverHour;
            String tz = this.dailyTimeZone == null ? "" : this.dailyTimeZone.trim();
            try {
                ZoneId.of(tz);
            }
            catch (Throwable t) {
                tz = "UTC";
            }
            config.dailyTimeZone = tz;
            config.dailyGroupName = this.dailyGroupName;
            config.dailyTagKey = this.dailyTagKey;
            config.dailyPrefixQuestIds = this.dailyPrefixQuestIds;
            config.dailyMaxActiveQuests = this.dailyMaxActiveQuests;
            config.dailyCompletionMode = this.dailyCompletionMode;
            config.dailyMinQuestsToComplete = this.dailyMinQuestsToComplete;
            config.dailyStoreHistory = this.dailyStoreHistory;
            Predicate<String> urlOk = s -> {
                if (s == null) {
                    return false;
                }
                String u = s.trim().toLowerCase(Locale.ROOT);
                return u.startsWith("http://") || u.startsWith("https://");
            };
            config.dailyRemoteUrl = urlOk.test(this.dailyRemoteUrl) ? this.dailyRemoteUrl.trim() : "";
            ArrayList<String> list = new ArrayList<String>();
            if (this.dailyBackupUrlsCsv != null && !this.dailyBackupUrlsCsv.isBlank()) {
                for (String s2 : this.dailyBackupUrlsCsv.split(",")) {
                    String t = s2.trim();
                    if (t.isEmpty() || !urlOk.test(t)) continue;
                    list.add(t);
                }
            }
            config.dailyBackupUrls = list;
            config.scriptIntegrationEnabled = this.scriptIntegrationEnabled;
            config.scriptAllowExternalHttp = this.scriptAllowExternalHttp;
            config.scriptEmitOnUnlock = this.scriptEmitOnUnlock;
            config.scriptEmitOnStarted = this.scriptEmitOnStarted;
            config.scriptEmitOnProgress = this.scriptEmitOnProgress;
            config.scriptEmitOnCompleted = this.scriptEmitOnCompleted;
            config.scriptEmitOnRewardClaimed = this.scriptEmitOnRewardClaimed;
            config.scriptWebhookUrl = this.scriptWebhookUrl;
            config.scriptHttpTimeoutMs = this.scriptHttpTimeoutMs;
            config.scriptCommandOnUnlock = this.scriptCommandOnUnlock;
            config.scriptCommandOnStarted = this.scriptCommandOnStarted;
            config.scriptCommandOnProgress = this.scriptCommandOnProgress;
            config.scriptCommandOnComplete = this.scriptCommandOnComplete;
            config.scriptCommandOnRewardClaimed = this.scriptCommandOnRewardClaimed;
        }
        try {
            Path configPath = this.field_22787.field_1697.toPath().resolve("config");
            QuestoryConfig.save(configPath);
            AutoSaveManager.getInstance().refreshConfigFromQuestoryConfig();
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to save config: " + e.getMessage());
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -1072689136);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 40, 0xFFFFFF);
        if (this.currentTab == ConfigTab.HUD) {
            this.renderHudTabContent(graphics, mouseX, mouseY, partialTick);
        } else if (this.currentTab == ConfigTab.GENERAL) {
            this.renderGeneralTabContent(graphics);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.tooltipAreas != null) {
            for (TooltipArea ta : this.tooltipAreas) {
                if (mouseX < ta.x() || mouseX > ta.x() + ta.w() || mouseY < ta.y() || mouseY > ta.y() + ta.h()) continue;
                this.drawSimpleTooltip(graphics, mouseX + 12, mouseY + 12, ta.lines());
            }
        }
    }

    private void addTooltipArea(int x, int y, int w, int h, String ... lines) {
        if (lines == null || lines.length == 0) {
            return;
        }
        this.tooltipAreas.add(new TooltipArea(x, y, w, h, Arrays.asList(lines)));
    }

    private void drawSimpleTooltip(class_332 g, int x, int y, List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        int maxW = 0;
        for (String s : lines) {
            maxW = Math.max(maxW, this.field_22793.method_1727(s));
        }
        int pad = 5;
        int w = maxW + pad * 2;
        int h = lines.size() * 10 + pad * 2;
        g.method_25294(x, y, x + w, y + h, -535489259);
        g.method_25294(x, y, x + w, y + 1, -12566464);
        g.method_25294(x, y + h - 1, x + w, y + h, -12566464);
        g.method_25294(x, y, x + 1, y + h, -12566464);
        g.method_25294(x + w - 1, y, x + w, y + h, -12566464);
        int ty = y + pad;
        for (String s : lines) {
            g.method_25303(this.field_22793, s, x + pad, ty, -1);
            ty += 10;
        }
    }

    private void renderHudTabContent(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.field_22789 / 2;
        String instruction = "Click and drag the HUD preview to reposition it";
        graphics.method_25300(this.field_22793, instruction, centerX, this.field_22790 - 50, 0xAAAAFF);
        String scaleText = String.format("Scale: %.1fx", Float.valueOf(this.hudScale));
        graphics.method_25300(this.field_22793, scaleText, centerX, 78, 0xFFFFFF);
        String opacityText = String.format("Opacity: %d%%", this.hudOpacity);
        graphics.method_25300(this.field_22793, opacityText, centerX, 103, 0xFFFFFF);
        this.renderHudPreview(graphics, partialTick);
    }

    private void renderGeneralTabContent(class_332 graphics) {
        int centerX = this.field_22789 / 2;
        int startY = 200;
        graphics.method_25300(this.field_22793, "Additional settings can be configured in:", centerX, startY, 0xCCCCCC);
        graphics.method_25300(this.field_22793, "config/questory-common.json", centerX, startY + 15, 0xFFAA00);
        graphics.method_25300(this.field_22793, "Use /quest reload to apply changes", centerX, startY + 35, 0x88FF88);
    }

    private void renderHudPreview(class_332 graphics, float partialTick) {
        String oldPos = ClientConfig.getHudPosition();
        float oldScale = ClientConfig.getHudScale();
        int oldOpacity = ClientConfig.getHudOpacity();
        boolean oldCompact = ClientConfig.isHudCompactMode();
        boolean oldIcons = ClientConfig.isHudShowIcons();
        boolean oldBars = ClientConfig.isHudShowProgressBars();
        int oldOffsetX = ClientConfig.getHudOffsetX();
        int oldOffsetY = ClientConfig.getHudOffsetY();
        ClientConfig.setHudPosition(this.hudPosition);
        ClientConfig.setHudScale(this.hudScale);
        ClientConfig.setHudOpacity(this.hudOpacity);
        ClientConfig.setHudCompactMode(this.hudCompactMode);
        ClientConfig.setHudShowIcons(this.hudShowIcons);
        ClientConfig.setHudShowProgressBars(this.hudShowProgressBars);
        ClientConfig.setHudOffsetX(this.hudOffsetX);
        ClientConfig.setHudOffsetY(this.hudOffsetY);
        QuestHudOverlay.render(graphics, partialTick);
        ClientConfig.setHudPosition(oldPos);
        ClientConfig.setHudScale(oldScale);
        ClientConfig.setHudOpacity(oldOpacity);
        ClientConfig.setHudCompactMode(oldCompact);
        ClientConfig.setHudShowIcons(oldIcons);
        ClientConfig.setHudShowProgressBars(oldBars);
        ClientConfig.setHudOffsetX(oldOffsetX);
        ClientConfig.setHudOffsetY(oldOffsetY);
        if (this.draggingHud) {
            this.drawDragIndicator(graphics);
        }
    }

    private void drawDragIndicator(class_332 graphics) {
        int hudX;
        int panelWidth = this.hudCompactMode ? 200 : 240;
        int panelHeight = 100;
        int hudY = switch (this.hudPosition) {
            case "TOP_RIGHT" -> {
                hudX = this.field_22789 - panelWidth - this.hudOffsetX;
                yield this.hudOffsetY;
            }
            case "BOTTOM_LEFT" -> {
                hudX = this.hudOffsetX;
                yield this.field_22790 - panelHeight - this.hudOffsetY;
            }
            case "BOTTOM_RIGHT" -> {
                hudX = this.field_22789 - panelWidth - this.hudOffsetX;
                yield this.field_22790 - panelHeight - this.hudOffsetY;
            }
            default -> {
                hudX = this.hudOffsetX;
                yield this.hudOffsetY;
            }
        };
        graphics.method_25294(hudX - 2, hudY - 2, hudX + panelWidth + 2, hudY, -2013200640);
        graphics.method_25294(hudX - 2, hudY + panelHeight, hudX + panelWidth + 2, hudY + panelHeight + 2, -2013200640);
        graphics.method_25294(hudX - 2, hudY, hudX, hudY + panelHeight, -2013200640);
        graphics.method_25294(hudX + panelWidth, hudY, hudX + panelWidth + 2, hudY + panelHeight, -2013200640);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.currentTab == ConfigTab.HUD && button == 0) {
            int hudX;
            int panelWidth = this.hudCompactMode ? 200 : 240;
            int panelHeight = 100;
            int hudY = switch (this.hudPosition) {
                case "TOP_RIGHT" -> {
                    hudX = this.field_22789 - panelWidth - this.hudOffsetX;
                    yield this.hudOffsetY;
                }
                case "BOTTOM_LEFT" -> {
                    hudX = this.hudOffsetX;
                    yield this.field_22790 - panelHeight - this.hudOffsetY;
                }
                case "BOTTOM_RIGHT" -> {
                    hudX = this.field_22789 - panelWidth - this.hudOffsetX;
                    yield this.field_22790 - panelHeight - this.hudOffsetY;
                }
                default -> {
                    hudX = this.hudOffsetX;
                    yield this.hudOffsetY;
                }
            };
            if (mouseX >= (double)hudX && mouseX <= (double)(hudX + panelWidth) && mouseY >= (double)hudY && mouseY <= (double)(hudY + panelHeight)) {
                this.draggingHud = true;
                this.dragStartX = (int)mouseX;
                this.dragStartY = (int)mouseY;
                this.originalOffsetX = this.hudOffsetX;
                this.originalOffsetY = this.hudOffsetY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingHud) {
            this.draggingHud = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingHud) {
            int deltaX = (int)(mouseX - (double)this.dragStartX);
            int deltaY = (int)(mouseY - (double)this.dragStartY);
            this.hudOffsetX = this.hudPosition.contains("RIGHT") ? Math.max(0, Math.min(this.field_22789 / 2, this.originalOffsetX - deltaX)) : Math.max(0, Math.min(this.field_22789 / 2, this.originalOffsetX + deltaX));
            this.hudOffsetY = this.hudPosition.contains("BOTTOM") ? Math.max(0, Math.min(this.field_22790 / 2, this.originalOffsetY - deltaY)) : Math.max(0, Math.min(this.field_22790 / 2, this.originalOffsetY + deltaY));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private static enum ConfigTab {
        HUD("HUD"),
        NOTIFICATIONS("Notifications"),
        DISPLAY("Display"),
        GENERAL("General"),
        SERVER("Server"),
        ENVIRONMENT("Environment"),
        TEAMS("Teams"),
        DAILY("Daily"),
        SCRIPTING("Scripting");

        final String label;

        private ConfigTab(String label) {
            this.label = label;
        }
    }

    private static class IntSlider
    extends class_357 {
        private final int min;
        private final int max;
        private final int step;
        private final String prefix;
        private final IntConsumer onChange;
        private int current;

        public IntSlider(int x, int y, int w, int h, String prefix, int min, int max, int step, int initial, IntConsumer onChange) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), 0.0);
            this.prefix = prefix;
            this.min = min;
            this.max = Math.max(min + step, max);
            this.step = Math.max(1, step);
            this.onChange = onChange;
            this.setInt(initial);
        }

        private void setInt(int v) {
            int snapped;
            v = Math.max(this.min, Math.min(this.max, v));
            this.current = snapped = this.min + (v - this.min) / this.step * this.step;
            this.field_22753 = (double)(snapped - this.min) / (double)(this.max - this.min);
            this.method_25346();
        }

        private int getInt() {
            return this.min + (int)Math.round(this.field_22753 * (double)(this.max - this.min));
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.prefix + this.getInt())));
        }

        protected void method_25344() {
            int snapped;
            int raw = this.getInt();
            this.current = snapped = this.min + (raw - this.min) / this.step * this.step;
            this.field_22753 = (double)(snapped - this.min) / (double)(this.max - this.min);
            if (this.onChange != null) {
                this.onChange.accept(snapped);
            }
        }
    }

    private static class DoubleSlider
    extends class_357 {
        private final double min;
        private final double max;
        private final double step;
        private final String prefix;
        private final DoubleConsumer onChange;

        public DoubleSlider(int x, int y, int w, int h, String prefix, double min, double max, double step, double initial, DoubleConsumer onChange) {
            super(x, y, w, h, (class_2561)class_2561.method_43473(), 0.0);
            this.prefix = prefix;
            this.min = min;
            this.max = Math.max(min + step, max);
            this.step = step <= 0.0 ? 0.1 : step;
            this.onChange = onChange;
            this.setDouble(initial);
        }

        private void setDouble(double v) {
            v = Math.max(this.min, Math.min(this.max, v));
            double snapped = this.min + (double)Math.round((v - this.min) / this.step) * this.step;
            this.field_22753 = (snapped - this.min) / (this.max - this.min);
            this.method_25346();
        }

        private double getDouble() {
            return this.min + this.field_22753 * (this.max - this.min);
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)(this.prefix + String.format(Locale.ROOT, "%.1f", this.getDouble()))));
        }

        protected void method_25344() {
            double raw = this.getDouble();
            double snapped = this.min + (double)Math.round((raw - this.min) / this.step) * this.step;
            this.field_22753 = (snapped - this.min) / (this.max - this.min);
            if (this.onChange != null) {
                this.onChange.accept(snapped);
            }
        }
    }

    private record TooltipArea(int x, int y, int w, int h, List<String> lines) {
    }
}

