/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.texboobcat.questory.api.RewardRegistry;

public class RewardTypePickerScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<String> onSelect;
    private final String[] types;
    private final String[] typeLabels;
    private static final String[] BUILTIN_TYPES = new String[]{"item", "xp", "command", "script", "loot", "choice", "random", "currency", "advancement", "stage", "title", "toast", "xp_levels"};
    private static final String[] BUILTIN_LABELS = new String[]{"Item Reward", "Experience", "Command Execution", "KubeJS Script", "Loot Table", "Choice Reward", "Random Reward", "Currency", "Advancement", "GameStage", "Title Message", "Toast Notification", "XP Levels"};
    private static final Map<String, String> KEYWORDS = new HashMap<String, String>();
    private class_342 searchBox;
    private List<String> filteredTypes = new ArrayList<String>();
    private int scroll = 0;
    private boolean draggingScrollbar = false;

    public RewardTypePickerScreen(class_437 parent, Consumer<String> onSelect) {
        super((class_2561)class_2561.method_43470((String)"Select Reward Type"));
        int i;
        this.parent = parent;
        this.onSelect = onSelect;
        LinkedHashSet<String> allTypes = new LinkedHashSet<String>();
        for (String type : BUILTIN_TYPES) {
            allTypes.add(type);
        }
        try {
            allTypes.addAll(RewardRegistry.getRegisteredTypes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.types = allTypes.toArray(new String[0]);
        this.typeLabels = new String[this.types.length];
        HashMap<String, String> labelMap = new HashMap<String, String>();
        for (i = 0; i < BUILTIN_TYPES.length; ++i) {
            labelMap.put(BUILTIN_TYPES[i], BUILTIN_LABELS[i]);
        }
        for (i = 0; i < this.types.length; ++i) {
            String type = this.types[i];
            this.typeLabels[i] = labelMap.getOrDefault(type, RewardTypePickerScreen.generateLabel(type));
        }
        this.updateFilter();
    }

    protected void method_25426() {
        super.method_25426();
        int panelW = 300;
        int panelH = 350;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        this.searchBox = new class_342(this.field_22793, panelX + 12, panelY + 32, panelW - 24, 16, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(true);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1863(s -> {
            this.scroll = 0;
            this.updateFilter();
        });
        this.method_37063((class_364)this.searchBox);
    }

    private void updateFilter() {
        String query = this.searchBox != null ? this.searchBox.method_1882().toLowerCase().trim() : "";
        this.filteredTypes.clear();
        if (query.isEmpty()) {
            for (String type : this.types) {
                this.filteredTypes.add(type);
            }
        } else {
            for (int i = 0; i < this.types.length; ++i) {
                String type = this.types[i];
                String label = this.typeLabels[i].toLowerCase();
                String keywords = KEYWORDS.getOrDefault(type, "").toLowerCase();
                if (!type.toLowerCase().contains(query) && !label.contains(query) && !keywords.contains(query)) continue;
                this.filteredTypes.add(type);
            }
        }
    }

    private static String generateLabel(String typeId) {
        if (typeId == null || typeId.isEmpty()) {
            return "Unknown";
        }
        String[] parts = typeId.split(":");
        String name = parts.length > 1 ? parts[1] : parts[0];
        String namespace = parts.length > 1 ? parts[0] : null;
        String[] words = name.split("_");
        StringBuilder label = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            label.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() > 1) {
                label.append(word.substring(1).toLowerCase(Locale.ROOT));
            }
            label.append(" ");
        }
        if (namespace != null && !namespace.equals("questory") && !namespace.equals("minecraft")) {
            label.append("(");
            label.append(Character.toUpperCase(namespace.charAt(0)));
            if (namespace.length() > 1) {
                label.append(namespace.substring(1));
            }
            label.append(")");
        } else if (label.length() > 0 && label.charAt(label.length() - 1) == ' ') {
            label.setLength(label.length() - 1);
        }
        return label.toString();
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        int index;
        this.method_25420(g);
        int panelW = 300;
        int panelH = 350;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        g.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -535818224);
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, panelY + 12, -1);
        int listY = panelY + 56;
        int listH = panelH - 88;
        int lineH = 20;
        g.method_44379(panelX, listY, panelX + panelW, listY + listH);
        int total = this.filteredTypes.size();
        int maxVisible = listH / lineH;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, total - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, total - this.scroll) && (index = this.scroll + i) < total; ++i) {
            boolean hover;
            String typeId = this.filteredTypes.get(index);
            int originalIndex = -1;
            for (int k = 0; k < this.types.length; ++k) {
                if (!this.types[k].equals(typeId)) continue;
                originalIndex = k;
                break;
            }
            String label = originalIndex >= 0 ? this.typeLabels[originalIndex] : typeId;
            int itemY = listY + i * lineH;
            boolean bl = hover = mouseX >= panelX + 8 && mouseX <= panelX + panelW - 8 && mouseY >= itemY && mouseY < itemY + lineH;
            if (hover) {
                g.method_25294(panelX + 8, itemY, panelX + panelW - 8, itemY + lineH, -12952966);
            }
            g.method_25303(this.field_22793, label, panelX + 12, itemY + 6, -1);
        }
        g.method_44380();
        if (total > maxVisible) {
            int barW = 6;
            int trackX = panelX + panelW - 8 - barW;
            int trackY = listY;
            int trackH = listH;
            g.method_25294(trackX, trackY, trackX + barW, trackY + trackH, 0x40222222);
            int thumbH = Math.max(12, (int)((float)trackH * (float)maxVisible / (float)total));
            int maxScroll = total - maxVisible;
            int thumbMax = trackH - thumbH;
            int thumbY = trackY + (maxScroll == 0 ? 0 : (int)((float)this.scroll / (float)maxScroll * (float)thumbMax));
            g.method_25294(trackX + 1, thumbY, trackX + barW - 1, thumbY + thumbH, this.draggingScrollbar ? -9787695 : -7829368);
        }
        int btnW = 80;
        int btnX = this.field_22789 / 2 - btnW / 2;
        int btnY = panelY + panelH - 28;
        g.method_25294(btnX, btnY, btnX + btnW, btnY + 20, -12303292);
        g.method_25300(this.field_22793, "Cancel", this.field_22789 / 2, btnY + 6, -1);
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int total;
        int index;
        int panelW = 300;
        int panelH = 350;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        int listY = panelY + 56;
        int listH = panelH - 88;
        int lineH = 20;
        int maxVisible = listH / lineH;
        if (mouseX >= (double)(panelX + 8) && mouseX <= (double)(panelX + panelW - 8) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (index = this.scroll + ((int)mouseY - listY) / lineH) >= 0 && index < this.filteredTypes.size()) {
            this.onSelect.accept(this.filteredTypes.get(index));
            return true;
        }
        int barW = 6;
        int trackX = panelX + panelW - 8 - barW;
        if (mouseX >= (double)trackX && mouseX <= (double)(trackX + barW) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (total = this.filteredTypes.size()) > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            this.draggingScrollbar = true;
            return true;
        }
        int btnW = 80;
        int btnX = this.field_22789 / 2 - btnW / 2;
        int btnY = panelY + panelH - 28;
        if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnW) && mouseY >= (double)btnY && mouseY < (double)(btnY + 20)) {
            this.field_22787.method_1507(this.parent);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int panelW = 300;
        int panelX = this.field_22789 / 2 - panelW / 2;
        if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW)) {
            this.scroll = (int)Math.max(0.0, (double)this.scroll - Math.signum(delta));
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScrollbar) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        int panelW = 300;
        int panelH = 350;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        int listY = panelY + 56;
        int listH = panelH - 88;
        int lineH = 20;
        int maxVisible = Math.max(1, listH / lineH);
        int total = this.filteredTypes.size();
        if (total > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return false;
    }

    static {
        KEYWORDS.put("item", "give grant reward loot");
        KEYWORDS.put("xp", "experience level levels");
        KEYWORDS.put("command", "run execute console");
        KEYWORDS.put("script", "kubejs js code javascript");
        KEYWORDS.put("loot", "table chest drop");
        KEYWORDS.put("choice", "select pick option");
        KEYWORDS.put("random", "chance luck rng");
        KEYWORDS.put("currency", "money coins cash economy");
        KEYWORDS.put("advancement", "unlock grant achievement");
        KEYWORDS.put("stage", "gamestage unlock");
        KEYWORDS.put("title", "message screen display");
        KEYWORDS.put("toast", "notification popup");
        KEYWORDS.put("xp_levels", "levels experience");
    }
}

