/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.texboobcat.questory.client.gui.FormattedTextWithImages;

public class TextFormatter {
    private static final Pattern TAG_PATTERN = Pattern.compile("<(/?)([a-zA-Z_#][a-zA-Z0-9_]*)(\\s+[^>]*)?>");
    private static final Pattern LINK_PATTERN = Pattern.compile("<link\\s+href=\"([^\"]+)\">([^<]+)</link>");
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("<a\\s+href=\"([^\"]+)\">([^<]+)</a>");
    private static final Pattern MARKDOWN_HEADER = Pattern.compile("^##\\s+(.+)$", 8);
    private static final Pattern MARKDOWN_BOLD = Pattern.compile("\\*\\*([^*]+)\\*\\*");
    private static final Pattern SLASH_E_PATTERN = Pattern.compile("/e/([^/]+)/e/");
    private static final Pattern SLASH_9_PATTERN = Pattern.compile("/9/([^/]+)/9/");
    private static final Pattern FTB_IMAGE_PATTERN = Pattern.compile("\\{image:([^\\s}]+)(?:\\s+width:([0-9]+))?(?:\\s+height:([0-9]+))?(?:\\s+align:(\\w+))?[^}]*}");
    private static final Pattern IMG_TAG_PATTERN = Pattern.compile("<img\\s+src=\"([^\"]+)\"(?:\\s+width=\"([0-9]+)\")?(?:\\s+height=\"([0-9]+)\")?(?:\\s+align=\"(\\w+)\")?\\s*/>");

    public static class_2561 parse(String text) {
        if (text == null || text.isEmpty()) {
            return class_2561.method_43473();
        }
        text = TextFormatter.preprocessMarkdown(text);
        text = TextFormatter.processLinks(text, new ArrayList<String>());
        class_5250 root = class_2561.method_43473();
        StyleStack styleStack = new StyleStack();
        Matcher matcher = TAG_PATTERN.matcher(text);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String content = text.substring(lastEnd, matcher.start());
                root.method_10852((class_2561)class_2561.method_43470((String)content).method_10862(styleStack.current()));
            }
            boolean isClosing = matcher.group(1).equals("/");
            String tagName = matcher.group(2).toLowerCase();
            String attributes = matcher.group(3);
            if (isClosing) {
                styleStack.pop(tagName);
            } else if (tagName.equals("reset")) {
                styleStack.reset();
            } else if (tagName.equals("__link__")) {
                if (attributes != null) {
                    String url = attributes.trim();
                    styleStack.pushLink(tagName, url);
                }
            } else if (tagName.startsWith("#")) {
                styleStack.pushColor(tagName, TextFormatter.parseHexColor(tagName));
            } else {
                TextFormatter.applyTag(styleStack, tagName);
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < text.length()) {
            String content = text.substring(lastEnd);
            root.method_10852((class_2561)class_2561.method_43470((String)content).method_10862(styleStack.current()));
        }
        return root;
    }

    public static class_2561 parseToComponent(String text) {
        return TextFormatter.parse(text);
    }

    private static String preprocessMarkdown(String text) {
        StringBuffer sb = new StringBuffer();
        Matcher imageMatcher = FTB_IMAGE_PATTERN.matcher(text);
        while (imageMatcher.find()) {
            String path = imageMatcher.group(1);
            String width = imageMatcher.group(2);
            String height = imageMatcher.group(3);
            String align = imageMatcher.group(4);
            StringBuilder imgTag = new StringBuilder("<img src=\"");
            imgTag.append(path).append("\"");
            if (width != null) {
                imgTag.append(" width=\"").append(width).append("\"");
            }
            if (height != null) {
                imgTag.append(" height=\"").append(height).append("\"");
            }
            if (align != null) {
                imgTag.append(" align=\"").append(align).append("\"");
            }
            imgTag.append("/>");
            imageMatcher.appendReplacement(sb, Matcher.quoteReplacement(imgTag.toString()));
        }
        imageMatcher.appendTail(sb);
        text = sb.toString();
        text = MARKDOWN_HEADER.matcher(text).replaceAll("<gold><bold>$1</bold></gold>");
        text = MARKDOWN_BOLD.matcher(text).replaceAll("<bold>$1</bold>");
        text = SLASH_E_PATTERN.matcher(text).replaceAll("<italic>$1</italic>");
        text = SLASH_9_PATTERN.matcher(text).replaceAll("<aqua>$1</aqua>");
        return text;
    }

    private static String processLinks(String text, List<String> urls) {
        StringBuffer result = new StringBuffer();
        Matcher linkMatcher = LINK_PATTERN.matcher(text);
        while (linkMatcher.find()) {
            String url = linkMatcher.group(1);
            String linkText = linkMatcher.group(2);
            String replacement = "<__link__ " + url + ">" + linkText + "</__link__>";
            linkMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        linkMatcher.appendTail(result);
        text = result.toString();
        result = new StringBuffer();
        Matcher anchorMatcher = ANCHOR_PATTERN.matcher(text);
        while (anchorMatcher.find()) {
            String url = anchorMatcher.group(1);
            String linkText = anchorMatcher.group(2);
            String replacement = "<__link__ " + url + ">" + linkText + "</__link__>";
            anchorMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        anchorMatcher.appendTail(result);
        return result.toString();
    }

    public static String stripTags(String text) {
        if (text == null) {
            return "";
        }
        return TAG_PATTERN.matcher(text).replaceAll("");
    }

    public static String getPreview(String text, int maxLength) {
        String plain = TextFormatter.stripTags(text);
        if (plain.length() <= maxLength) {
            return plain;
        }
        return plain.substring(0, maxLength - 3) + "...";
    }

    private static void applyTag(StyleStack stack, String tag) {
        switch (tag) {
            case "black": {
                stack.pushColor(tag, class_124.field_1074);
                break;
            }
            case "dark_blue": {
                stack.pushColor(tag, class_124.field_1058);
                break;
            }
            case "dark_green": {
                stack.pushColor(tag, class_124.field_1077);
                break;
            }
            case "dark_aqua": 
            case "dark_cyan": {
                stack.pushColor(tag, class_124.field_1062);
                break;
            }
            case "dark_red": {
                stack.pushColor(tag, class_124.field_1079);
                break;
            }
            case "dark_purple": 
            case "purple": {
                stack.pushColor(tag, class_124.field_1064);
                break;
            }
            case "gold": 
            case "orange": {
                stack.pushColor(tag, class_124.field_1065);
                break;
            }
            case "gray": 
            case "grey": {
                stack.pushColor(tag, class_124.field_1080);
                break;
            }
            case "dark_gray": 
            case "dark_grey": {
                stack.pushColor(tag, class_124.field_1063);
                break;
            }
            case "blue": {
                stack.pushColor(tag, class_124.field_1078);
                break;
            }
            case "green": 
            case "lime": {
                stack.pushColor(tag, class_124.field_1060);
                break;
            }
            case "aqua": 
            case "cyan": {
                stack.pushColor(tag, class_124.field_1075);
                break;
            }
            case "red": {
                stack.pushColor(tag, class_124.field_1061);
                break;
            }
            case "light_purple": 
            case "pink": 
            case "magenta": {
                stack.pushColor(tag, class_124.field_1076);
                break;
            }
            case "yellow": {
                stack.pushColor(tag, class_124.field_1054);
                break;
            }
            case "white": {
                stack.pushColor(tag, class_124.field_1068);
                break;
            }
            case "bold": 
            case "b": {
                stack.pushFormat(tag, "bold");
                break;
            }
            case "italic": 
            case "i": 
            case "em": {
                stack.pushFormat(tag, "italic");
                break;
            }
            case "underline": 
            case "u": {
                stack.pushFormat(tag, "underline");
                break;
            }
            case "strikethrough": 
            case "strike": 
            case "s": {
                stack.pushFormat(tag, "strikethrough");
                break;
            }
            case "obfuscated": 
            case "obf": {
                stack.pushFormat(tag, "obfuscated");
            }
        }
    }

    private static class_5251 parseHexColor(String hex) {
        try {
            String color = hex.startsWith("#") ? hex.substring(1) : hex;
            int rgb = Integer.parseInt(color, 16);
            return class_5251.method_27717((int)rgb);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FormattedTextWithImages parseWithImages(String text) {
        if (text == null || text.isEmpty()) {
            return new FormattedTextWithImages((class_2561)class_2561.method_43473(), new ArrayList<FormattedTextWithImages.ImageElement>());
        }
        text = TextFormatter.preprocessMarkdown(text);
        ArrayList<FormattedTextWithImages.ImageElement> images = new ArrayList<FormattedTextWithImages.ImageElement>();
        StringBuffer textWithoutImages = new StringBuffer();
        Matcher imgMatcher = IMG_TAG_PATTERN.matcher(text);
        int currentLineIndex = 0;
        while (imgMatcher.find()) {
            String path = imgMatcher.group(1);
            String widthStr = imgMatcher.group(2);
            String heightStr = imgMatcher.group(3);
            String align = imgMatcher.group(4);
            int width = widthStr != null ? Integer.parseInt(widthStr) : 100;
            int height = heightStr != null ? Integer.parseInt(heightStr) : 100;
            String textBefore = text.substring(0, imgMatcher.start());
            currentLineIndex = textBefore.split("\n", -1).length - 1;
            images.add(new FormattedTextWithImages.ImageElement(path, width, height, align, currentLineIndex));
            imgMatcher.appendReplacement(textWithoutImages, Matcher.quoteReplacement("\n"));
        }
        imgMatcher.appendTail(textWithoutImages);
        class_2561 textComponent = TextFormatter.parse(textWithoutImages.toString());
        return new FormattedTextWithImages(textComponent, images);
    }

    public static String convertMinecraftCodesToTags(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replace('\u00a7', '&');
        StringBuilder out = new StringBuilder();
        Stack<String> open = new Stack<String>();
        for (int i = 0; i < text.length(); ++i) {
            char code;
            String tag;
            char c = text.charAt(i);
            if (c == '&' && i + 1 < text.length() && (tag = TextFormatter.getTagForCode(code = Character.toLowerCase(text.charAt(i + 1)))) != null) {
                if ("reset".equals(tag)) {
                    while (!open.isEmpty()) {
                        out.append("</").append((String)open.pop()).append(">");
                    }
                } else if (TextFormatter.isColorCode(code)) {
                    Stack<String> fmt = new Stack<String>();
                    while (!open.isEmpty()) {
                        String top = (String)open.peek();
                        if (TextFormatter.isFormattingTag(top)) {
                            fmt.push((String)open.pop());
                            continue;
                        }
                        out.append("</").append((String)open.pop()).append(">");
                    }
                    out.append('<').append(tag).append('>');
                    open.push(tag);
                    while (!fmt.isEmpty()) {
                        String t = (String)fmt.pop();
                        open.push(t);
                    }
                } else {
                    out.append('<').append(tag).append('>');
                    open.push(tag);
                }
                ++i;
                continue;
            }
            out.append(c);
        }
        while (!open.isEmpty()) {
            out.append("</").append((String)open.pop()).append(">");
        }
        return out.toString();
    }

    public static Integer firstArgbFromMinecraftCodes(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace('\u00a7', '&');
        for (int i = 0; i < text.length() - 1; ++i) {
            class_124 fmt;
            char code;
            if (text.charAt(i) != '&' || !TextFormatter.isColorCode(code = Character.toLowerCase(text.charAt(i + 1))) || (fmt = TextFormatter.colorForCode(code)) == null || fmt.method_532() == null) continue;
            return 0xFF000000 | fmt.method_532();
        }
        return null;
    }

    private static String getTagForCode(char code) {
        return switch (code) {
            case '0' -> "black";
            case '1' -> "dark_blue";
            case '2' -> "dark_green";
            case '3' -> "dark_aqua";
            case '4' -> "dark_red";
            case '5' -> "dark_purple";
            case '6' -> "gold";
            case '7' -> "gray";
            case '8' -> "dark_gray";
            case '9' -> "blue";
            case 'a' -> "green";
            case 'b' -> "aqua";
            case 'c' -> "red";
            case 'd' -> "light_purple";
            case 'e' -> "yellow";
            case 'f' -> "white";
            case 'k' -> "obfuscated";
            case 'l' -> "bold";
            case 'm' -> "strikethrough";
            case 'n' -> "underline";
            case 'o' -> "italic";
            case 'r' -> "reset";
            default -> null;
        };
    }

    private static boolean isColorCode(char code) {
        return "0123456789abcdef".indexOf(code) >= 0;
    }

    private static boolean isFormattingTag(String tag) {
        return tag.equals("bold") || tag.equals("italic") || tag.equals("underline") || tag.equals("strikethrough") || tag.equals("obfuscated");
    }

    private static class_124 colorForCode(char code) {
        return switch (code) {
            case '0' -> class_124.field_1074;
            case '1' -> class_124.field_1058;
            case '2' -> class_124.field_1077;
            case '3' -> class_124.field_1062;
            case '4' -> class_124.field_1079;
            case '5' -> class_124.field_1064;
            case '6' -> class_124.field_1065;
            case '7' -> class_124.field_1080;
            case '8' -> class_124.field_1063;
            case '9' -> class_124.field_1078;
            case 'a' -> class_124.field_1060;
            case 'b' -> class_124.field_1075;
            case 'c' -> class_124.field_1061;
            case 'd' -> class_124.field_1076;
            case 'e' -> class_124.field_1054;
            case 'f' -> class_124.field_1068;
            default -> null;
        };
    }

    private static class StyleStack {
        private final List<StyleLayer> stack = new ArrayList<StyleLayer>();

        private StyleStack() {
        }

        public class_2583 current() {
            class_2583 style = class_2583.field_24360;
            for (StyleLayer layer : this.stack) {
                style = layer.apply(style);
            }
            return style;
        }

        public void pushColor(String tag, class_124 formatting) {
            Integer color = formatting.method_532();
            if (color != null) {
                this.stack.add(new StyleLayer(tag, "color", class_5251.method_27717((int)color), null));
            }
        }

        public void pushColor(String tag, class_5251 color) {
            if (color != null) {
                this.stack.add(new StyleLayer(tag, "color", color, null));
            }
        }

        public void pushFormat(String tag, String formatType) {
            this.stack.add(new StyleLayer(tag, formatType, null, null));
        }

        public void pushLink(String tag, String url) {
            this.stack.add(new StyleLayer(tag, "link", null, url));
        }

        public void pop(String tag) {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                if (!this.stack.get((int)i).tag.equals(tag)) continue;
                this.stack.remove(i);
                break;
            }
        }

        public void reset() {
            this.stack.clear();
        }
    }

    private static class StyleLayer {
        final String tag;
        final String type;
        final class_5251 color;
        final String url;

        StyleLayer(String tag, String type, class_5251 color, String url) {
            this.tag = tag;
            this.type = type;
            this.color = color;
            this.url = url;
        }

        class_2583 apply(class_2583 base) {
            class_2583 result;
            switch (this.type) {
                case "color": {
                    class_2583 class_25832 = base.method_27703(this.color);
                    break;
                }
                case "bold": {
                    class_2583 class_25832 = base.method_10982(Boolean.valueOf(true));
                    break;
                }
                case "italic": {
                    class_2583 class_25832 = base.method_10978(Boolean.valueOf(true));
                    break;
                }
                case "underline": {
                    class_2583 class_25832 = base.method_30938(Boolean.valueOf(true));
                    break;
                }
                case "strikethrough": {
                    class_2583 class_25832 = base.method_36140(Boolean.valueOf(true));
                    break;
                }
                case "obfuscated": {
                    class_2583 class_25832 = base.method_36141(Boolean.valueOf(true));
                    break;
                }
                case "link": {
                    class_2583 class_25832 = base.method_27703(class_5251.method_27717((int)0x55FFFF)).method_30938(Boolean.valueOf(true));
                    break;
                }
                default: {
                    class_2583 class_25832 = result = base;
                }
            }
            if (this.type.equals("link") && this.url != null && !this.url.isEmpty()) {
                try {
                    result = result.method_10958(new class_2558(class_2558.class_2559.field_11749, this.url)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Click to open: " + this.url))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

