/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.integration.OPACClaimHelper;
import org.texboobcat.questory.integration.OPACTeamsProvider;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.team.ITeamProvider;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;

public class OPACIntegration {
    private static boolean initialized = false;
    private static final Map<UUID, UUID> lastKnownParty = new ConcurrentHashMap<UUID, UUID>();
    private static final Map<UUID, Integer> lastKnownMemberCount = new ConcurrentHashMap<UUID, Integer>();
    private static int tickCounter = 0;
    private static int syncIntervalTicks = 100;
    private static long lastProviderNullWarning = 0L;
    private static final long WARNING_COOLDOWN_MS = 30000L;
    private static OPACTeamsProvider cachedProvider = null;
    private static boolean providerSearched = false;

    public static void init() {
        if (initialized) {
            return;
        }
        try {
            if (!OPACClaimHelper.isAvailable()) {
                Questory.LOGGER.debug("OPAC not available, skipping integration init");
                return;
            }
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                syncIntervalTicks = Math.max(20, cfg.opacSyncIntervalTicks);
            }
            catch (Throwable ignored) {
                syncIntervalTicks = 100;
            }
            initialized = true;
            Questory.LOGGER.info("OPAC integration initialized (poll interval: {} ticks)", (Object)syncIntervalTicks);
        }
        catch (Throwable t) {
            Questory.LOGGER.warn("Failed to init OPAC integration: {}", (Object)t.getMessage());
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void onServerTick(MinecraftServer server) {
        if (!initialized || server == null) {
            return;
        }
        if (++tickCounter < syncIntervalTicks) {
            return;
        }
        tickCounter = 0;
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (!cfg.opacIntegrationEnabled || !cfg.opacSyncOnPartyChange) {
                return;
            }
        }
        catch (Throwable cfg) {
            // empty catch block
        }
        OPACTeamsProvider provider = OPACIntegration.getOPACProvider();
        if (provider == null) {
            long now = System.currentTimeMillis();
            if (now - lastProviderNullWarning > 30000L) {
                lastProviderNullWarning = now;
                Questory.LOGGER.warn("[OPAC] Polling: Provider is null, cannot check parties");
            }
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            try {
                OPACIntegration.checkPlayerPartyChange(player, provider);
            }
            catch (Throwable t) {
                Questory.LOGGER.warn("[OPAC] Error checking party for {}: {}", (Object)player.method_5477().getString(), (Object)t.getMessage());
            }
        }
    }

    private static void checkPlayerPartyChange(class_3222 player, OPACTeamsProvider provider) {
        boolean memberCountChanged;
        UUID playerId = player.method_5667();
        UUID currentPartyId = null;
        int currentMemberCount = 0;
        try {
            currentPartyId = provider.getTeamId(playerId);
            if (currentPartyId != null) {
                currentMemberCount = provider.getTeamMembers(currentPartyId).size();
            }
        }
        catch (Throwable t) {
            Questory.LOGGER.warn("[OPAC] Error getting party for {}: {}", (Object)player.method_5477().getString(), (Object)t.getMessage());
            return;
        }
        UUID lastPartyId = lastKnownParty.get(playerId);
        Integer lastCount = lastKnownMemberCount.get(playerId);
        boolean partyChanged = !Objects.equals(currentPartyId, lastPartyId);
        boolean bl = memberCountChanged = currentPartyId != null && lastCount != null && currentMemberCount != lastCount;
        if (partyChanged || memberCountChanged) {
            if (partyChanged) {
                Questory.LOGGER.info("[OPAC] Party changed for {}: {} -> {}", (Object)player.method_5477().getString(), (Object)lastPartyId, (Object)currentPartyId);
            } else {
                Questory.LOGGER.debug("[OPAC] Member count changed for {}: {} -> {}", (Object)player.method_5477().getString(), (Object)lastCount, (Object)currentMemberCount);
            }
            if (currentPartyId != null) {
                lastKnownParty.put(playerId, currentPartyId);
                lastKnownMemberCount.put(playerId, currentMemberCount);
            } else {
                lastKnownParty.remove(playerId);
                lastKnownMemberCount.remove(playerId);
            }
            OPACIntegration.syncTeamToPlayer(player);
            if (partyChanged) {
                if (currentPartyId != null) {
                    OPACIntegration.syncPartyMembers(player.method_5682(), currentPartyId, playerId);
                }
                if (lastPartyId != null) {
                    OPACIntegration.syncPartyMembers(player.method_5682(), lastPartyId, playerId);
                }
            }
        }
    }

    private static void syncPartyMembers(MinecraftServer server, UUID partyId, UUID excludePlayer) {
        try {
            OPACTeamsProvider provider = OPACIntegration.getOPACProvider();
            if (provider == null) {
                return;
            }
            Set<UUID> members = provider.getTeamMembers(partyId);
            for (UUID memberId : members) {
                class_3222 member;
                if (memberId.equals(excludePlayer) || (member = server.method_3760().method_14602(memberId)) == null) continue;
                OPACIntegration.syncTeamToPlayer(member);
            }
        }
        catch (Throwable t) {
            Questory.LOGGER.debug("Error syncing party members: {}", (Object)t.getMessage());
        }
    }

    private static OPACTeamsProvider getOPACProvider() {
        if (providerSearched) {
            return cachedProvider;
        }
        try {
            List<ITeamProvider> providers = TeamManager.getInstance().getProviders();
            for (ITeamProvider provider : providers) {
                if (!(provider instanceof OPACTeamsProvider)) continue;
                cachedProvider = (OPACTeamsProvider)provider;
                providerSearched = true;
                Questory.LOGGER.info("[OPAC] Found OPACTeamsProvider in registered providers");
                return cachedProvider;
            }
            providerSearched = true;
            Questory.LOGGER.warn("[OPAC] OPACTeamsProvider not found in {} registered providers", (Object)providers.size());
        }
        catch (Throwable t) {
            Questory.LOGGER.warn("[OPAC] Error getting provider: {}", (Object)t.getMessage());
        }
        return null;
    }

    public static void syncPlayer(class_3222 player) {
        if (!initialized || player == null) {
            return;
        }
        OPACIntegration.syncTeamToPlayer(player);
        UUID playerId = player.method_5667();
        try {
            OPACTeamsProvider provider = OPACIntegration.getOPACProvider();
            if (provider != null) {
                UUID partyId = provider.getTeamId(playerId);
                if (partyId != null) {
                    lastKnownParty.put(playerId, partyId);
                    lastKnownMemberCount.put(playerId, provider.getTeamMembers(partyId).size());
                } else {
                    lastKnownParty.remove(playerId);
                    lastKnownMemberCount.remove(playerId);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void syncTeamToPlayer(class_3222 player) {
        try {
            TeamManager teamMgr = TeamManager.getInstance();
            PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
            UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
            QuestTeam team = null;
            if (teamId != null && (team = teamMgr.getTeam(teamId)) == null) {
                team = teamMgr.buildExternalTeamSnapshot(teamId);
            }
            ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
            int rewardCount = pendingMgr.getPendingRewardCount(player.method_5667());
            TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.method_5667(), inviteInfos, rewardCount);
            NetworkManager.sendToClient(player, syncPacket);
            Questory.LOGGER.info("[OPAC] Synced team to {}: teamId={}, teamName={}", (Object)player.method_5477().getString(), (Object)teamId, (Object)(team != null ? team.getTeamName() : "none"));
        }
        catch (Throwable t) {
            Questory.LOGGER.debug("Error syncing team to player {}: {}", (Object)player.method_5477().getString(), (Object)t.getMessage());
        }
    }

    public static void onPlayerLogin(class_3222 player) {
        if (!initialized || player == null) {
            return;
        }
        try {
            UUID partyId;
            UUID playerId = player.method_5667();
            OPACTeamsProvider provider = OPACIntegration.getOPACProvider();
            if (provider != null && (partyId = provider.getTeamId(playerId)) != null) {
                lastKnownParty.put(playerId, partyId);
                lastKnownMemberCount.put(playerId, provider.getTeamMembers(partyId).size());
            }
            OPACIntegration.syncTeamToPlayer(player);
        }
        catch (Throwable t) {
            Questory.LOGGER.debug("Error on OPAC player login: {}", (Object)t.getMessage());
        }
    }

    public static void onPlayerLogout(class_3222 player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.method_5667();
        lastKnownParty.remove(playerId);
        lastKnownMemberCount.remove(playerId);
    }

    public static void clearCache() {
        lastKnownParty.clear();
        lastKnownMemberCount.clear();
        cachedProvider = null;
        providerSearched = false;
    }

    public static void setSyncInterval(int ticks) {
        syncIntervalTicks = Math.max(20, ticks);
    }

    public static Map<String, Object> getPartyInfoForPlaceholders(class_3222 player) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("party_name", "");
        info.put("party_size", 0);
        info.put("party_owner", "");
        info.put("in_party", false);
        info.put("is_party_owner", false);
        if (!initialized || player == null) {
            return info;
        }
        try {
            OPACTeamsProvider provider = OPACIntegration.getOPACProvider();
            if (provider == null) {
                return info;
            }
            Map<String, Object> partyInfo = provider.getPartyInfo(player.method_5667());
            if (partyInfo.isEmpty()) {
                return info;
            }
            UUID partyId = (UUID)partyInfo.get("id");
            if (partyId == null) {
                return info;
            }
            info.put("in_party", true);
            info.put("party_name", partyInfo.getOrDefault("name", ""));
            info.put("party_size", partyInfo.getOrDefault("memberCount", 0));
            info.put("party_owner", partyInfo.getOrDefault("ownerName", ""));
            info.put("is_party_owner", partyInfo.getOrDefault("isOwner", false));
        }
        catch (Throwable t) {
            Questory.LOGGER.debug("Error getting party info: {}", (Object)t.getMessage());
        }
        return info;
    }
}

