/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.team.ITeamProvider;

public class OPACTeamsProvider
implements ITeamProvider {
    private int priority = 90;
    private static long lastServerNullWarning = 0L;
    private static long lastApiNullWarning = 0L;
    private static final long WARNING_COOLDOWN_MS = 30000L;

    public OPACTeamsProvider() {
    }

    public OPACTeamsProvider(int priority) {
        this.priority = priority;
    }

    @Override
    public UUID getTeamId(UUID playerId) {
        try {
            String[] methodsToTry;
            Object server = this.getServerInstance();
            if (server == null) {
                long now = System.currentTimeMillis();
                if (now - lastServerNullWarning > 30000L) {
                    lastServerNullWarning = now;
                    Questory.LOGGER.warn("[OPAC] getTeamId: server is null - Questory.getServer() not available");
                }
                return null;
            }
            Class<?> apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
            Object api = apiClass.getMethod("get", Class.forName("net.minecraft.server.MinecraftServer")).invoke(null, server);
            if (api == null) {
                long now = System.currentTimeMillis();
                if (now - lastApiNullWarning > 30000L) {
                    lastApiNullWarning = now;
                    Questory.LOGGER.warn("[OPAC] getTeamId: OpenPACServerAPI.get() returned null");
                }
                return null;
            }
            Object partiesManager = null;
            for (String methodName : methodsToTry = new String[]{"getPartyManager", "getServerPartyManager", "getPartyManagerAPI", "getPlayerPartySystemManager"}) {
                try {
                    partiesManager = api.getClass().getMethod(methodName, new Class[0]).invoke(api, new Object[0]);
                    if (partiesManager == null) continue;
                    Questory.LOGGER.info("[OPAC] Found parties manager via method: {}", (Object)methodName);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (partiesManager == null) {
                long now = System.currentTimeMillis();
                if (now - lastApiNullWarning > 30000L) {
                    lastApiNullWarning = now;
                    StringBuilder availableMethods = new StringBuilder();
                    for (Method m : api.getClass().getMethods()) {
                        if (!m.getName().toLowerCase().contains("part") && !m.getName().toLowerCase().contains("manager")) continue;
                        availableMethods.append(m.getName()).append("(), ");
                    }
                    Questory.LOGGER.warn("[OPAC] Could not find parties manager. Available methods containing 'part' or 'manager': {}", (Object)(availableMethods.length() > 0 ? availableMethods.toString() : "none found"));
                }
                return null;
            }
            Object party = partiesManager.getClass().getMethod("getPartyByMember", UUID.class).invoke(partiesManager, playerId);
            if (party == null) {
                return null;
            }
            Object partyId = party.getClass().getMethod("getId", new Class[0]).invoke(party, new Object[0]);
            if (partyId instanceof UUID) {
                Questory.LOGGER.info("[OPAC] Found party {} for player {}", partyId, (Object)playerId);
                return (UUID)partyId;
            }
            return null;
        }
        catch (Throwable t) {
            Questory.LOGGER.warn("[OPAC] getTeamId error: {} - {}", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
            return null;
        }
    }

    @Override
    public Set<UUID> getTeamMembers(UUID teamId) {
        try {
            String[] methodsToTry;
            Object server = this.getServerInstance();
            if (server == null) {
                return Collections.emptySet();
            }
            Class<?> apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
            Object api = apiClass.getMethod("get", Class.forName("net.minecraft.server.MinecraftServer")).invoke(null, server);
            if (api == null) {
                return Collections.emptySet();
            }
            Object partiesManager = null;
            for (String methodName : methodsToTry = new String[]{"getPartyManager", "getServerPartyManager", "getPartyManagerAPI", "getPlayerPartySystemManager"}) {
                try {
                    partiesManager = api.getClass().getMethod(methodName, new Class[0]).invoke(api, new Object[0]);
                    if (partiesManager == null) continue;
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (partiesManager == null) {
                return Collections.emptySet();
            }
            Object party = partiesManager.getClass().getMethod("getPartyById", UUID.class).invoke(partiesManager, teamId);
            if (party == null) {
                return Collections.emptySet();
            }
            Object memberStream = party.getClass().getMethod("getMemberInfoStream", new Class[0]).invoke(party, new Object[0]);
            if (memberStream == null) {
                return Collections.emptySet();
            }
            HashSet<UUID> members = new HashSet<UUID>();
            try (Stream stream = (Stream)memberStream;){
                stream.forEach(member -> {
                    try {
                        Object uuid = member.getClass().getMethod("getUUID", new Class[0]).invoke(member, new Object[0]);
                        if (uuid instanceof UUID) {
                            members.add((UUID)uuid);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            return members;
        }
        catch (Throwable t) {
            return Collections.emptySet();
        }
    }

    @Override
    public String getTeamName(UUID teamId) {
        try {
            block21: {
                String[] nameMethods;
                String[] methodsToTry;
                Object server = this.getServerInstance();
                if (server == null) {
                    return null;
                }
                Class<?> apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
                Object api = apiClass.getMethod("get", Class.forName("net.minecraft.server.MinecraftServer")).invoke(null, server);
                if (api == null) {
                    return null;
                }
                Object partiesManager = null;
                for (String methodName : methodsToTry = new String[]{"getPartyManager", "getServerPartyManager", "getPartyManagerAPI", "getPlayerPartySystemManager"}) {
                    try {
                        partiesManager = api.getClass().getMethod(methodName, new Class[0]).invoke(api, new Object[0]);
                        if (partiesManager == null) continue;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (partiesManager == null) {
                    return null;
                }
                Object party = partiesManager.getClass().getMethod("getPartyById", UUID.class).invoke(partiesManager, teamId);
                if (party == null) {
                    return null;
                }
                for (String methodName : nameMethods = new String[]{"getDefaultName", "getName", "getDisplayName", "getPartyName", "getFormattedName"}) {
                    try {
                        String nameStr;
                        Object name = party.getClass().getMethod(methodName, new Class[0]).invoke(party, new Object[0]);
                        if (name == null || (nameStr = name.toString()).isEmpty()) continue;
                        return nameStr;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    Object ownerName2;
                    Object owner = party.getClass().getMethod("getOwner", new Class[0]).invoke(party, new Object[0]);
                    if (owner == null) break block21;
                    try {
                        ownerName2 = owner.getClass().getMethod("getUsername", new Class[0]).invoke(owner, new Object[0]);
                        if (ownerName2 != null) {
                            return ownerName2.toString() + "'s Party";
                        }
                    }
                    catch (Throwable ownerName2) {
                        // empty catch block
                    }
                    try {
                        ownerName2 = owner.getClass().getMethod("getPlayerName", new Class[0]).invoke(owner, new Object[0]);
                        if (ownerName2 != null) {
                            return ownerName2.toString() + "'s Party";
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return "Team " + teamId.toString().substring(0, 8);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public boolean isTeamOwner(UUID playerId, UUID teamId) {
        try {
            String[] methodsToTry;
            Object server = this.getServerInstance();
            if (server == null) {
                return false;
            }
            Class<?> apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
            Object api = apiClass.getMethod("get", Class.forName("net.minecraft.server.MinecraftServer")).invoke(null, server);
            if (api == null) {
                return false;
            }
            Object partiesManager = null;
            for (String methodName : methodsToTry = new String[]{"getPartyManager", "getServerPartyManager", "getPartyManagerAPI", "getPlayerPartySystemManager"}) {
                try {
                    partiesManager = api.getClass().getMethod(methodName, new Class[0]).invoke(api, new Object[0]);
                    if (partiesManager == null) continue;
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (partiesManager == null) {
                return false;
            }
            Object party = partiesManager.getClass().getMethod("getPartyById", UUID.class).invoke(partiesManager, teamId);
            if (party == null) {
                return false;
            }
            Object owner = party.getClass().getMethod("getOwner", new Class[0]).invoke(party, new Object[0]);
            if (owner == null) {
                return false;
            }
            Object ownerUuid = owner.getClass().getMethod("getUUID", new Class[0]).invoke(owner, new Object[0]);
            return playerId.equals(ownerUuid);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public String getProviderId() {
        return "opac";
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private Object getServerInstance() {
        try {
            Class<?> questoryClass = Class.forName("org.texboobcat.questory.Questory");
            return questoryClass.getMethod("getServer", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Map<String, Object> getPartyInfo(UUID playerId) {
        HashMap<String, Object> info;
        block10: {
            info = new HashMap<String, Object>();
            try {
                String[] ownerNameMethods;
                Object owner;
                Object party;
                String[] methodsToTry;
                Class<?> apiClass;
                Object api;
                UUID teamId = this.getTeamId(playerId);
                if (teamId == null) {
                    return info;
                }
                info.put("id", teamId);
                info.put("name", this.getTeamName(teamId));
                info.put("members", this.getTeamMembers(teamId));
                info.put("isOwner", this.isTeamOwner(playerId, teamId));
                info.put("memberCount", this.getTeamMembers(teamId).size());
                Object server = this.getServerInstance();
                if (server == null || (api = (apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI")).getMethod("get", Class.forName("net.minecraft.server.MinecraftServer")).invoke(null, server)) == null) break block10;
                Object partiesManager = null;
                for (String methodName : methodsToTry = new String[]{"getPartyManager", "getServerPartyManager", "getPartyManagerAPI", "getPlayerPartySystemManager"}) {
                    try {
                        partiesManager = api.getClass().getMethod(methodName, new Class[0]).invoke(api, new Object[0]);
                        if (partiesManager == null) continue;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (partiesManager == null || (party = partiesManager.getClass().getMethod("getPartyById", UUID.class).invoke(partiesManager, teamId)) == null || (owner = party.getClass().getMethod("getOwner", new Class[0]).invoke(party, new Object[0])) == null) break block10;
                for (String methodName : ownerNameMethods = new String[]{"getUsername", "getPlayerName", "getName"}) {
                    try {
                        Object ownerName = owner.getClass().getMethod(methodName, new Class[0]).invoke(owner, new Object[0]);
                        if (ownerName == null) continue;
                        info.put("ownerName", ownerName.toString());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return info;
    }
}

