/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.manager;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.api.events.QuestCompletedEvent;
import org.texboobcat.questory.api.events.QuestEventBus;
import org.texboobcat.questory.api.events.QuestPreCompleteEvent;
import org.texboobcat.questory.api.events.QuestPreStartEvent;
import org.texboobcat.questory.api.events.QuestProgressEvent;
import org.texboobcat.questory.api.events.QuestRequirementPreProgressEvent;
import org.texboobcat.questory.api.events.QuestStartedEvent;
import org.texboobcat.questory.api.events.QuestUnlockedEvent;
import org.texboobcat.questory.api.events.RewardClaimedEvent;
import org.texboobcat.questory.api.events.RewardPreGrantEvent;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.events.QuestNotifications;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.network.ChapterDataSyncPacket;
import org.texboobcat.questory.network.ConfigSyncPacket;
import org.texboobcat.questory.network.DailyDataSyncPacket;
import org.texboobcat.questory.network.GroupTreeSyncPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.network.QuestSyncPacket;
import org.texboobcat.questory.network.QuestTelemetryPacket;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CurrencyRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.GroupNode;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.storage.PlayerProgressStorage;
import org.texboobcat.questory.storage.QuestStorage;
import org.texboobcat.questory.storage.StorageBackendFactory;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;
import org.texboobcat.questory.team.TeamQuestHelper;

public class QuestManager {
    private static final long THREE_DAYS_MS = 259200000L;
    private static QuestManager instance;
    private final Map<String, Quest> quests;
    private final QuestStorage questStorage;
    private PlayerProgressStorage progressStorage;
    private final Map<String, Set<String>> questGroups;
    private Map<String, ChapterData> chaptersByGroup;
    private GroupNode groupTree;
    private final Map<UUID, Set<String>> notifiedCompletableQuests;
    private final Set<UUID> initialSyncCompleted;
    private Set<String> cachedRequiredStatistics = null;
    private List<QuestRequirementRef> observationReqs = new CopyOnWriteArrayList<QuestRequirementRef>();
    private boolean hasObservationRequirements = false;
    private final Map<String, List<QuestRequirementRef>> itemReqIndex = new ConcurrentHashMap<String, List<QuestRequirementRef>>();
    private final Map<String, List<QuestRequirementRef>> fluidReqIndex = new ConcurrentHashMap<String, List<QuestRequirementRef>>();
    private final List<QuestRequirementRef> energyReqs = new CopyOnWriteArrayList<QuestRequirementRef>();
    private final Map<String, Set<String>> questDependents = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, List<QuestRequirementRef>> craftingReqIndex = new ConcurrentHashMap<String, List<QuestRequirementRef>>();
    private final Map<String, List<QuestRequirementRef>> itemTagReqIndex = new ConcurrentHashMap<String, List<QuestRequirementRef>>();
    private final Map<String, List<QuestRequirementRef>> statisticReqIndex = new ConcurrentHashMap<String, List<QuestRequirementRef>>();
    private final Set<String> deletedQuestIds = ConcurrentHashMap.newKeySet();
    private final Map<UUID, CachedQuestFilters> playerFilterCache = new ConcurrentHashMap<UUID, CachedQuestFilters>();

    private QuestManager(Path dataPath) {
        this.quests = new ConcurrentHashMap<String, Quest>();
        this.questStorage = new QuestStorage(dataPath);
        IPlayerProgressBackend backend = StorageBackendFactory.createPlayerProgressBackend(QuestoryConfig.getInstance(), dataPath);
        this.progressStorage = new PlayerProgressStorage(backend);
        this.questGroups = new ConcurrentHashMap<String, Set<String>>();
        this.notifiedCompletableQuests = new ConcurrentHashMap<UUID, Set<String>>();
        this.initialSyncCompleted = ConcurrentHashMap.newKeySet();
        this.chaptersByGroup = new ConcurrentHashMap<String, ChapterData>();
        this.groupTree = null;
    }

    public void trackFluidProgress(UUID playerId, String fluidId, long amount) {
        this.trackFluidProgress(playerId, fluidId, amount, null);
    }

    public void trackFluidProgress(UUID playerId, String fluidId, long amount, class_3222 player) {
        if (amount <= 0L) {
            return;
        }
        HashSet<String> updatedQuests = new HashSet<String>();
        List<QuestRequirementRef> refs = this.fluidReqIndex.get(fluidId);
        if (refs == null) {
            return;
        }
        for (QuestRequirementRef ref : refs) {
            QuestProgress progress;
            Quest quest = ref.quest;
            Requirement req = ref.requirement;
            if (!(req instanceof FluidRequirement)) continue;
            FluidRequirement fr = (FluidRequirement)req;
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            int old = progress.getRequirementProgress(quest.getId(), req);
            boolean anyBefore = this.hasAnyProgress(progress, quest);
            long cap = Math.min(Integer.MAX_VALUE, Math.max(0L, fr.getAmount()));
            long proposed = Math.min(cap, (long)old + Math.max(1L, amount));
            int delta = (int)Math.max(0L, proposed - (long)old);
            if (player != null && delta > 0) {
                QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, delta);
                QuestEventBus.post(pre);
                if (pre.isCanceled()) continue;
                delta = Math.max(0, pre.getDelta());
                proposed = Math.min(cap, (long)old + (long)delta);
            }
            progress.setRequirementProgress(quest.getId(), req, (int)proposed);
            int now = progress.getRequirementProgress(quest.getId(), req);
            updatedQuests.add(quest.getId());
            if (isTeamQuest && player != null) {
                try {
                    UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                    if (teamId != null) {
                        TeamManager.getInstance().saveTeamProgress(teamId);
                    }
                }
                catch (Throwable throwable) {}
            } else {
                this.progressStorage.saveProgress(progress);
            }
            if (player == null || now == old) continue;
            QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
            if (anyBefore || now <= 0) continue;
            QuestEventBus.post(new QuestStartedEvent(player, quest));
        }
        if (player != null && !updatedQuests.isEmpty()) {
            for (String qid : updatedQuests) {
                QuestProgress toSync;
                Quest q = this.getQuest(qid);
                if (q == null) continue;
                boolean isTeamQuest = false;
                try {
                    QuestoryConfig cfg = QuestoryConfig.getInstance();
                    isTeamQuest = cfg.teamSystemEnabled && q.getTeamSettings() != null && q.getTeamSettings().isTeamEnabled();
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
                if ((toSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), q) : this.getProgress(player.method_5667())) == null) continue;
                NetworkManager.sendToClient(player, new ProgressSyncPacket(toSync));
            }
            this.checkAndNotifyCompletableQuests(player, this.getProgress(player.method_5667()), updatedQuests);
        }
    }

    public void trackEnergyProgress(UUID playerId, long amount) {
        this.trackEnergyProgress(playerId, amount, null);
    }

    public void trackEnergyProgress(UUID playerId, long amount, class_3222 player) {
        if (amount <= 0L) {
            return;
        }
        HashSet<String> updatedQuests = new HashSet<String>();
        if (this.energyReqs.isEmpty()) {
            return;
        }
        for (QuestRequirementRef ref : this.energyReqs) {
            QuestProgress progress;
            Quest quest = ref.quest;
            Requirement req = ref.requirement;
            if (!(req instanceof EnergyRequirement)) continue;
            EnergyRequirement er = (EnergyRequirement)req;
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            int old = progress.getRequirementProgress(quest.getId(), req);
            boolean anyBefore = this.hasAnyProgress(progress, quest);
            long cap = Math.min(Integer.MAX_VALUE, Math.max(0L, er.getAmount()));
            long proposed = Math.min(cap, (long)old + Math.max(1L, amount));
            int delta = (int)Math.max(0L, proposed - (long)old);
            if (player != null && delta > 0) {
                QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, delta);
                QuestEventBus.post(pre);
                if (pre.isCanceled()) continue;
                delta = Math.max(0, pre.getDelta());
                proposed = Math.min(cap, (long)old + (long)delta);
            }
            progress.setRequirementProgress(quest.getId(), req, (int)proposed);
            int now = progress.getRequirementProgress(quest.getId(), req);
            updatedQuests.add(quest.getId());
            if (isTeamQuest && player != null) {
                try {
                    UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                    if (teamId != null) {
                        TeamManager.getInstance().saveTeamProgress(teamId);
                    }
                }
                catch (Throwable throwable) {}
            } else {
                this.progressStorage.saveProgress(progress);
            }
            if (player == null || now == old) continue;
            QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
            if (anyBefore || now <= 0) continue;
            QuestEventBus.post(new QuestStartedEvent(player, quest));
        }
        if (player != null && !updatedQuests.isEmpty()) {
            for (String qid : updatedQuests) {
                QuestProgress toSync;
                Quest q = this.getQuest(qid);
                if (q == null) continue;
                boolean isTeamQuest = false;
                try {
                    QuestoryConfig cfg = QuestoryConfig.getInstance();
                    isTeamQuest = cfg.teamSystemEnabled && q.getTeamSettings() != null && q.getTeamSettings().isTeamEnabled();
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
                if ((toSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), q) : this.getProgress(player.method_5667())) == null) continue;
                NetworkManager.sendToClient(player, new ProgressSyncPacket(toSync));
            }
            this.checkAndNotifyCompletableQuests(player, this.getProgress(player.method_5667()), updatedQuests);
        }
    }

    private boolean hasAnyProgress(QuestProgress progress, Quest quest) {
        if (quest == null) {
            return false;
        }
        for (Requirement r : quest.getRequirements()) {
            if (progress.getRequirementProgress(quest.getId(), r) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void initialize(Path dataPath) {
        if (instance == null) {
            instance = new QuestManager(dataPath);
            instance.loadAll();
        }
    }

    private static String normalizeStatId(String id) {
        if (id == null) {
            return "";
        }
        Object s = id.trim().toLowerCase(Locale.ROOT);
        if (((String)s).isEmpty()) {
            return s;
        }
        if (!((String)s).contains(":")) {
            s = "minecraft:" + (String)s;
        }
        return s;
    }

    public static QuestManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("QuestManager not initialized!");
        }
        return instance;
    }

    public void reinitializeProgressStorage(Path worldDataPath) {
        Questory.LOGGER.info("Reinitializing progress storage for world: {}", (Object)worldDataPath);
        if (this.progressStorage != null) {
            this.progressStorage.saveAll();
            this.progressStorage.clearCache();
            this.progressStorage.disconnect();
        }
        IPlayerProgressBackend backend = StorageBackendFactory.createPlayerProgressBackend(QuestoryConfig.getInstance(), worldDataPath);
        this.progressStorage = new PlayerProgressStorage(backend);
        this.notifiedCompletableQuests.clear();
        this.initialSyncCompleted.clear();
        Questory.LOGGER.info("Progress storage reinitialized successfully");
    }

    public void loadAll() {
        this.quests.clear();
        this.questGroups.clear();
        this.cachedRequiredStatistics = null;
        Map<String, Quest> loadedQuests = this.questStorage.loadAllQuests();
        this.quests.putAll(loadedQuests);
        for (Quest quest : this.quests.values()) {
            String group = quest.getGroup();
            this.questGroups.computeIfAbsent(group, k -> ConcurrentHashMap.newKeySet()).add(quest.getId());
        }
        this.chaptersByGroup.clear();
        Map<String, ChapterData> loadedChapters = this.questStorage.loadAllChapters();
        this.chaptersByGroup.putAll(loadedChapters);
        try {
            GroupNode gt;
            this.groupTree = gt = this.questStorage.loadGroupTree();
            if (gt != null) {
                Questory.LOGGER.info("Loaded group tree with {} top-level sections", (Object)gt.getChildren().size());
            }
        }
        catch (Throwable t) {
            Questory.LOGGER.error("Failed to load group tree: {}", (Object)t.getMessage());
        }
        if (this.quests.isEmpty()) {
            Questory.LOGGER.info("No quests found, creating example quest...");
            this.questStorage.createExampleQuest();
            this.loadAll();
        }
        Questory.LOGGER.info("Quest system loaded: {} quests in {} groups", (Object)this.quests.size(), (Object)this.questGroups.size());
        this.rebuildRequirementIndices();
        this.cleanupOldDeletedQuests();
    }

    public Set<String> getRequiredStatistics() {
        if (this.cachedRequiredStatistics == null) {
            this.cachedRequiredStatistics = new HashSet<String>();
            for (Quest quest : this.quests.values()) {
                for (Requirement req : quest.getRequirements()) {
                    if (!(req instanceof StatisticRequirement)) continue;
                    StatisticRequirement statReq = (StatisticRequirement)req;
                    this.cachedRequiredStatistics.add(QuestManager.normalizeStatId(statReq.getStatistic()));
                }
            }
            Questory.LOGGER.debug("Cached {} required statistics from quests", (Object)this.cachedRequiredStatistics.size());
        }
        return this.cachedRequiredStatistics;
    }

    public void saveAll() {
        this.questStorage.saveAllQuests(this.quests.values());
        this.progressStorage.saveAll();
    }

    public void savePlayerProgress(QuestProgress progress) {
        if (progress != null) {
            this.progressStorage.saveProgress(progress);
        }
    }

    public void reload() {
        this.saveAll();
        this.loadAll();
    }

    public Quest getQuest(String questId) {
        return this.quests.get(questId);
    }

    public Collection<Quest> getAllQuests() {
        return new ArrayList<Quest>(this.quests.values());
    }

    public void updateQuestPosition(String questId, int x, int y) {
        Quest quest = this.quests.get(questId);
        if (quest == null) {
            return;
        }
        quest.setX(x);
        quest.setY(y);
        this.questStorage.saveQuest(quest);
    }

    public List<Quest> getQuestsByGroup(String group) {
        Set<String> questIds = this.questGroups.get(group);
        if (questIds == null) {
            return Collections.emptyList();
        }
        return questIds.stream().map(this.quests::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Collection<ChapterData> getAllChapters() {
        return this.chaptersByGroup == null ? Collections.emptyList() : new ArrayList<ChapterData>(this.chaptersByGroup.values());
    }

    public GroupNode getGroupTree() {
        return this.groupTree;
    }

    public void updateChapterData(ChapterData chapter) {
        if (chapter == null || chapter.getTitle() == null || chapter.getTitle().isBlank()) {
            return;
        }
        if (this.chaptersByGroup == null) {
            this.chaptersByGroup = new HashMap<String, ChapterData>();
        }
        this.chaptersByGroup.put(chapter.getTitle(), chapter);
        this.questStorage.saveChapter(chapter);
    }

    public Set<String> getQuestGroups() {
        return new HashSet<String>(this.questGroups.keySet());
    }

    public void registerQuest(Quest quest) {
        if (quest == null) {
            return;
        }
        this.quests.put(quest.getId(), quest);
        this.questGroups.computeIfAbsent(quest.getGroup(), k -> ConcurrentHashMap.newKeySet()).add(quest.getId());
        this.questStorage.saveQuest(quest);
        this.rebuildRequirementIndices();
    }

    public void unregisterQuest(String questId) {
        Quest quest = this.quests.get(questId);
        if (quest != null) {
            quest.setHidden(true);
            quest.setDeletedTimestamp(System.currentTimeMillis());
            this.questStorage.saveQuest(quest);
            this.deletedQuestIds.add(questId);
        }
        this.rebuildRequirementIndices();
    }

    public void cleanupOldDeletedQuests() {
        Quest quest;
        long now = System.currentTimeMillis();
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String questId : this.deletedQuestIds) {
            long age;
            quest = this.quests.get(questId);
            if (quest == null || !quest.isHidden() || quest.getDeletedTimestamp() <= 0L || (age = now - quest.getDeletedTimestamp()) < 259200000L) continue;
            toDelete.add(questId);
            Questory.LOGGER.info("Auto-deleting quest '{}' (hidden for {} days)", (Object)questId, (Object)(age / 86400000L));
        }
        for (String questId : toDelete) {
            quest = this.quests.remove(questId);
            if (quest == null) continue;
            String group = quest.getGroup();
            Set<String> groupQuests = this.questGroups.get(group);
            if (groupQuests != null) {
                groupQuests.remove(questId);
            }
            this.questStorage.deleteQuest(questId);
            this.deletedQuestIds.remove(questId);
        }
        if (!toDelete.isEmpty()) {
            Questory.LOGGER.info("Cleaned up {} old deleted quest(s)", (Object)toDelete.size());
        }
    }

    public void rebuildRequirementIndices() {
        ArrayList<QuestRequirementRef> obs = new ArrayList<QuestRequirementRef>();
        this.itemReqIndex.clear();
        this.fluidReqIndex.clear();
        this.energyReqs.clear();
        this.questDependents.clear();
        this.craftingReqIndex.clear();
        this.itemTagReqIndex.clear();
        this.itemTagReqIndex.clear();
        this.statisticReqIndex.clear();
        this.cachedRequiredStatistics = null;
        for (Quest q : this.quests.values()) {
            if (q == null || q.getRequirements() == null) continue;
            for (String depId : q.getDependencies()) {
                this.questDependents.computeIfAbsent(depId, k -> ConcurrentHashMap.newKeySet()).add(q.getId());
            }
            for (Requirement r : q.getRequirements()) {
                String key;
                if (r instanceof ObservationRequirement) {
                    obs.add(new QuestRequirementRef(q, r));
                    continue;
                }
                if (r instanceof ItemRequirement) {
                    ItemRequirement ir = (ItemRequirement)r;
                    key = QuestManager.normalizeId(ir.getItem());
                    this.itemReqIndex.computeIfAbsent(key, k -> new CopyOnWriteArrayList()).add(new QuestRequirementRef(q, r));
                    if (!QuestoryConfig.getInstance().debugMode) continue;
                    Questory.LOGGER.debug("[Index] Added ItemRequirement: quest={}, item={}, normalized={}", (Object)q.getId(), (Object)ir.getItem(), (Object)key);
                    continue;
                }
                if (r instanceof FluidRequirement) {
                    FluidRequirement fr = (FluidRequirement)r;
                    key = fr.getFluidId();
                    this.fluidReqIndex.computeIfAbsent(key, k -> new CopyOnWriteArrayList()).add(new QuestRequirementRef(q, r));
                    continue;
                }
                if (r instanceof EnergyRequirement) {
                    this.energyReqs.add(new QuestRequirementRef(q, r));
                    continue;
                }
                if (r instanceof CraftingRequirement) {
                    CraftingRequirement cr = (CraftingRequirement)r;
                    key = QuestManager.normalizeId(cr.getItem());
                    this.craftingReqIndex.computeIfAbsent(key, k -> new CopyOnWriteArrayList()).add(new QuestRequirementRef(q, r));
                    Questory.LOGGER.info("[Questory Debug] Indexed CraftingReq: Key={}, Quest={}", (Object)key, (Object)q.getId());
                    if (!QuestoryConfig.getInstance().debugMode) continue;
                    Questory.LOGGER.debug("[Index] Added CraftingRequirement: quest={}, item={}, normalized={}", (Object)q.getId(), (Object)cr.getItem(), (Object)key);
                    continue;
                }
                if (r instanceof ItemTagRequirement) {
                    ItemTagRequirement itr = (ItemTagRequirement)r;
                    String tagId = itr.getTag();
                    this.itemTagReqIndex.computeIfAbsent(tagId, k -> new CopyOnWriteArrayList()).add(new QuestRequirementRef(q, r));
                    continue;
                }
                if (!(r instanceof StatisticRequirement)) continue;
                StatisticRequirement sr = (StatisticRequirement)r;
                String statKey = QuestManager.normalizeStatId(sr.getStatistic());
                this.statisticReqIndex.computeIfAbsent(statKey, k -> new CopyOnWriteArrayList()).add(new QuestRequirementRef(q, r));
            }
        }
        this.observationReqs = obs;
        boolean bl = this.hasObservationRequirements = !obs.isEmpty();
        if (QuestoryConfig.getInstance().debugMode) {
            Questory.LOGGER.info("[Index] Rebuilt requirement indices: {} item reqs, {} crafting reqs, {} quests total", (Object)this.itemReqIndex.size(), (Object)this.craftingReqIndex.size(), (Object)this.quests.size());
        }
    }

    public List<QuestRequirementRef> getObservationRequirements() {
        return this.observationReqs;
    }

    public boolean hasObservationRequirements() {
        return this.hasObservationRequirements;
    }

    public QuestProgress getProgress(UUID playerId) {
        return this.progressStorage.getProgress(playerId);
    }

    private void invalidatePlayerCache(UUID playerId) {
        this.playerFilterCache.remove(playerId);
    }

    public List<Quest> getVisibleQuests(UUID playerId) {
        CachedQuestFilters cache = this.playerFilterCache.computeIfAbsent(playerId, k -> new CachedQuestFilters());
        if (cache.visibleQuests == null || cache.isStale()) {
            QuestProgress progress = this.getProgress(playerId);
            cache.visibleQuests = this.quests.values().stream().filter(q -> q.isVisible(progress)).collect(Collectors.toList());
            cache.markUpdated();
        }
        return new ArrayList<Quest>(cache.visibleQuests);
    }

    public List<Quest> getCompletableQuests(UUID playerId) {
        CachedQuestFilters cache = this.playerFilterCache.computeIfAbsent(playerId, k -> new CachedQuestFilters());
        if (cache.completableQuests == null || cache.isStale()) {
            QuestProgress progress = this.getProgress(playerId);
            cache.completableQuests = this.quests.values().stream().filter(q -> q.canComplete(progress) && !progress.isQuestCompleted(q.getId())).collect(Collectors.toList());
            cache.markUpdated();
        }
        return new ArrayList<Quest>(cache.completableQuests);
    }

    public boolean completeQuest(class_3222 player, String questId) {
        Quest quest = this.getQuest(questId);
        if (quest == null) {
            return false;
        }
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled()) {
                return TeamQuestHelper.completeTeamQuest(player, quest);
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Team completion error, falling back to solo: " + t.getMessage());
        }
        QuestProgress progress = this.getProgress(player.method_5667());
        if (progress.isQuestCompleted(questId)) {
            return false;
        }
        if (!quest.canComplete(progress)) {
            return false;
        }
        try {
            QuestPreCompleteEvent pre = new QuestPreCompleteEvent(player, quest, quest.getRewards());
            QuestEventBus.post(pre);
            if (pre.isCanceled()) {
                return false;
            }
        }
        catch (Throwable pre) {
            // empty catch block
        }
        progress.completeQuest(questId);
        boolean anyUnclaimed = false;
        for (Reward reward : quest.getRewards()) {
            if (progress.isRewardClaimed(questId, reward.getId())) continue;
            anyUnclaimed = true;
            break;
        }
        if (anyUnclaimed) {
            for (Reward reward : quest.getRewards()) {
                if (progress.isRewardClaimed(questId, reward.getId())) continue;
                boolean skip = false;
                try {
                    RewardPreGrantEvent preRw = new RewardPreGrantEvent(player, quest, reward);
                    QuestEventBus.post(preRw);
                    skip = preRw.isCanceled();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (skip) continue;
                reward.grant(player);
                progress.claimReward(questId, reward.getId());
            }
            QuestEventBus.post(new RewardClaimedEvent(player, quest));
        }
        this.clearQuestNotification(player.method_5667(), questId);
        QuestNotifications.notifyQuestClaimed(player, quest);
        QuestEventBus.post(new QuestCompletedEvent(player, quest, progress.getCompletionTime(questId)));
        try {
            long completionTime = progress.getCompletionTime(questId);
            NetworkManager.sendToClient(player, new QuestTelemetryPacket(questId, completionTime, QuestTelemetryPacket.TelemetryEventType.QUEST_COMPLETED));
        }
        catch (Throwable completionTime) {
            // empty catch block
        }
        this.progressStorage.saveProgress(progress);
        NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        this.checkForNewlyUnlockedQuests(player, progress);
        this.invalidatePlayerCache(player.method_5667());
        try {
            DailyQuestManager.getInstance().onQuestCompleted(player, quest);
        }
        catch (Throwable t) {
            System.err.println("[Questory] DailyQuestManager onQuestCompleted error: " + t.getMessage());
        }
        return true;
    }

    private void checkForNewlyUnlockedQuests(class_3222 player, QuestProgress progress) {
        this.checkForNewlyUnlockedQuests(player, progress, false);
    }

    private void checkForNewlyUnlockedQuests(class_3222 player, QuestProgress progress, boolean batch) {
        ArrayList<Quest> newlyUnlocked = new ArrayList<Quest>();
        HashSet<String> candidateQuestIds = new HashSet<String>();
        for (String completedQuestId : progress.getCompletedQuests()) {
            Set<String> dependents = this.questDependents.get(completedQuestId);
            if (dependents == null) continue;
            candidateQuestIds.addAll(dependents);
        }
        for (Quest quest : this.quests.values()) {
            if (!quest.getDependencies().isEmpty()) continue;
            candidateQuestIds.add(quest.getId());
        }
        for (String questId : candidateQuestIds) {
            Set<String> notified;
            Quest quest = this.quests.get(questId);
            if (quest == null || progress.isQuestCompleted(questId) || !quest.isVisible(progress) || (notified = this.notifiedCompletableQuests.get(player.method_5667())) != null && notified.contains("unlocked_" + questId)) continue;
            newlyUnlocked.add(quest);
            QuestEventBus.post(new QuestUnlockedEvent(player, quest));
            if (notified == null) {
                notified = new HashSet<String>();
                this.notifiedCompletableQuests.put(player.method_5667(), notified);
            }
            notified.add("unlocked_" + questId);
        }
        if (!newlyUnlocked.isEmpty()) {
            if (batch) {
                QuestNotifications.notifyQuestsUnlockedBatch(player, newlyUnlocked);
            } else {
                for (Quest quest : newlyUnlocked) {
                    QuestNotifications.notifyQuestUnlocked(player, quest);
                }
            }
        }
    }

    public void trackItemProgress(UUID playerId, String itemId, int amount) {
        this.trackItemProgress(playerId, itemId, amount, null);
    }

    public void trackItemProgress(UUID playerId, String itemId, int amount, class_3222 player) {
        if (QuestoryConfig.getInstance().debugMode) {
            Questory.LOGGER.debug("trackItemProgress: playerId={}, itemId={}, normalized={}, amount={}, quests={}", (Object)playerId, (Object)itemId, (Object)QuestManager.normalizeId(itemId), (Object)amount, (Object)this.quests.size());
        }
        HashSet<String> updatedQuests = new HashSet<String>();
        String normalizedItemId = QuestManager.normalizeId(itemId);
        List<QuestRequirementRef> refs = this.itemReqIndex.get(normalizedItemId);
        if (refs == null) {
            if (QuestoryConfig.getInstance().debugMode) {
                Questory.LOGGER.debug("[Lookup] No requirements found for item: {} (normalized: {}). Index has {} items.", (Object)itemId, (Object)normalizedItemId, (Object)this.itemReqIndex.size());
            }
            return;
        }
        if (QuestoryConfig.getInstance().debugMode) {
            Questory.LOGGER.debug("[Lookup] Found {} requirement(s) for item: {} (normalized: {})", (Object)refs.size(), (Object)itemId, (Object)normalizedItemId);
        }
        for (QuestRequirementRef ref : refs) {
            QuestProgress progress;
            Quest quest = ref.quest;
            Requirement req = ref.requirement;
            if (!(req instanceof ItemRequirement)) continue;
            ItemRequirement itemReq = (ItemRequirement)req;
            if (QuestoryConfig.getInstance().debugMode) {
                Questory.LOGGER.debug("Checking quest: {}", (Object)quest.getId());
            }
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            int old = progress.getRequirementProgress(quest.getId(), req);
            boolean anyBefore = this.hasAnyProgress(progress, quest);
            long cap = Math.min(Integer.MAX_VALUE, Math.max(0L, (long)itemReq.getCount()));
            long proposed = Math.min(cap, (long)old + Math.max(1L, (long)amount));
            int delta = (int)Math.max(0L, proposed - (long)old);
            if (player != null && delta > 0) {
                QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, delta);
                QuestEventBus.post(pre);
                if (pre.isCanceled()) continue;
                delta = Math.max(0, pre.getDelta());
                proposed = Math.min(cap, (long)old + (long)delta);
            }
            progress.setRequirementProgress(quest.getId(), req, (int)proposed);
            int now = progress.getRequirementProgress(quest.getId(), req);
            updatedQuests.add(quest.getId());
            this.checkAndSyncProgress(player, progress, quest.getId(), isTeamQuest);
            if (player == null || now == old) continue;
            QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
            if (anyBefore || now <= 0) continue;
            QuestEventBus.post(new QuestStartedEvent(player, quest));
        }
    }

    public void trackRequirementProgress(UUID playerId, String questId, Requirement requirement, int amount) {
        this.trackRequirementProgress(playerId, questId, requirement, amount, null);
    }

    public void trackRequirementProgress(UUID playerId, String questId, Requirement requirement, int amount, class_3222 player) {
        QuestProgress progress;
        Quest quest = this.getQuest(questId);
        if (quest == null) {
            return;
        }
        boolean isTeamQuest = false;
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
        }
        catch (Throwable cfg) {
            // empty catch block
        }
        QuestProgress questProgress = progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId);
        if (progress == null || progress.isQuestCompleted(questId)) {
            return;
        }
        int old = progress.getRequirementProgress(questId, requirement);
        boolean anyBefore = this.hasAnyProgress(progress, quest);
        int now = old + amount;
        if (player != null && amount > 0) {
            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, requirement, amount);
            QuestEventBus.post(pre);
            if (pre.isCanceled()) {
                return;
            }
            now = old + pre.getDelta();
        }
        progress.setRequirementProgress(questId, requirement, now);
        if (isTeamQuest && player != null) {
            try {
                UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                if (teamId != null) {
                    TeamManager.getInstance().saveTeamProgress(teamId);
                }
            }
            catch (Throwable teamId) {}
        } else {
            this.progressStorage.saveProgress(progress);
        }
        if (player != null && now != old) {
            QuestProgress toSync;
            QuestEventBus.post(new QuestProgressEvent(player, quest, requirement, old, now));
            if (!anyBefore && now > 0) {
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
            QuestProgress questProgress2 = toSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), quest) : this.getProgress(player.method_5667());
            if (toSync != null) {
                NetworkManager.sendToClient(player, new ProgressSyncPacket(toSync));
            }
            if (quest.canComplete(progress)) {
                try {
                    this.notifyQuestReadyOnce(player, progress, quest);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                if (cfg.autoCompleteWhenRequirementsMet) {
                    this.completeQuest(player, questId);
                }
            }
        }
    }

    public void trackItemTagProgress(UUID playerId, String itemId, int amount, class_3222 player) {
        block17: {
            try {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemId));
                if (item == null) {
                    return;
                }
                HashSet<String> updatedQuests = new HashSet<String>();
                for (Map.Entry<String, List<QuestRequirementRef>> entry : this.itemTagReqIndex.entrySet()) {
                    String tagId = entry.getKey();
                    class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(tagId));
                    if (!item.method_40131().method_40220(tagKey)) continue;
                    for (QuestRequirementRef ref : entry.getValue()) {
                        QuestProgress progress;
                        ItemTagRequirement tagReq;
                        Quest quest = ref.quest;
                        Requirement req = ref.requirement;
                        if (!(req instanceof ItemTagRequirement) || !(tagReq = (ItemTagRequirement)req).shouldConsume()) continue;
                        boolean isTeamQuest = false;
                        try {
                            QuestoryConfig cfg = QuestoryConfig.getInstance();
                            isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
                        }
                        catch (Throwable cfg) {
                            // empty catch block
                        }
                        if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
                        int old = progress.getRequirementProgress(quest.getId(), req);
                        boolean anyBefore = this.hasAnyProgress(progress, quest);
                        int delta = amount;
                        if (player != null && delta > 0) {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, delta);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            delta = Math.max(0, pre.getDelta());
                        }
                        if (player != null && !anyBefore && delta > 0) {
                            QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                            QuestEventBus.post(preStart);
                            if (preStart.isCanceled()) continue;
                        }
                        if (delta <= 0) continue;
                        progress.addRequirementProgress(quest.getId(), req, delta);
                        int now = progress.getRequirementProgress(quest.getId(), req);
                        updatedQuests.add(quest.getId());
                        if (isTeamQuest && player != null) {
                            try {
                                UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                                if (teamId != null) {
                                    TeamManager.getInstance().saveTeamProgress(teamId);
                                }
                            }
                            catch (Throwable throwable) {}
                        } else {
                            this.progressStorage.saveProgress(progress);
                        }
                        if (player == null || now == old) continue;
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                }
                if (player == null || updatedQuests.isEmpty()) break block17;
                for (String qid : updatedQuests) {
                    QuestProgress progressToSync;
                    Quest q = this.getQuest(qid);
                    if (q == null) continue;
                    boolean isTeamQuest = false;
                    try {
                        QuestoryConfig cfg = QuestoryConfig.getInstance();
                        isTeamQuest = cfg.teamSystemEnabled && q.getTeamSettings() != null && q.getTeamSettings().isTeamEnabled();
                    }
                    catch (Throwable cfg) {
                        // empty catch block
                    }
                    if ((progressToSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), q) : this.getProgress(player.method_5667())) == null) continue;
                    NetworkManager.sendToClient(player, new ProgressSyncPacket(progressToSync));
                }
                QuestProgress checkProgress = this.getProgress(player.method_5667());
                this.checkAndNotifyCompletableQuests(player, checkProgress, updatedQuests);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trackCustomProgress(UUID playerId, String taskId, int amount) {
        this.trackCustomProgress(playerId, taskId, amount, null);
    }

    public void trackCustomProgress(UUID playerId, String taskId, int amount, class_3222 player) {
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            QuestProgress progress;
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                CustomRequirement cr;
                if (!(req instanceof CustomRequirement) || !(cr = (CustomRequirement)req).getTaskId().equals(taskId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                long cap = Math.max(1L, cr.getMaxProgress());
                long next = Math.min(cap, (long)old + (long)Math.max(1, amount));
                progress.setRequirementProgress(quest.getId(), req, (int)next);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (isTeamQuest && player != null) {
                    try {
                        UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                        if (teamId != null) {
                            TeamManager.getInstance().saveTeamProgress(teamId);
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.progressStorage.saveProgress(progress);
                }
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        if (player != null && !updatedQuests.isEmpty()) {
            for (String questId : updatedQuests) {
                QuestProgress progressToSync;
                Quest quest = this.getQuest(questId);
                if (quest == null) continue;
                boolean isTeamQuest = false;
                try {
                    QuestoryConfig cfg = QuestoryConfig.getInstance();
                    isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
                if ((progressToSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), quest) : this.getProgress(player.method_5667())) == null) continue;
                NetworkManager.sendToClient(player, new ProgressSyncPacket(progressToSync));
            }
            QuestProgress check = this.getProgress(player.method_5667());
            this.checkAndNotifyCompletableQuests(player, check, updatedQuests);
        }
    }

    public void trackCustomProgress(UUID playerId, String questId, String taskId, int amount) {
        this.trackCustomProgress(playerId, questId, taskId, amount, null);
    }

    public void trackCustomProgress(UUID playerId, String questId, String taskId, int amount, class_3222 player) {
        QuestProgress progress;
        if (questId == null || taskId == null || amount <= 0) {
            return;
        }
        Quest quest = this.getQuest(questId);
        if (quest == null) {
            return;
        }
        boolean isTeamQuest = false;
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
        }
        catch (Throwable cfg) {
            // empty catch block
        }
        QuestProgress questProgress = progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId);
        if (progress == null || progress.isQuestCompleted(questId)) {
            return;
        }
        boolean changed = false;
        for (Requirement req : quest.getRequirements()) {
            CustomRequirement cr;
            if (!(req instanceof CustomRequirement) || !Objects.equals((cr = (CustomRequirement)req).getTaskId(), taskId)) continue;
            int old = progress.getRequirementProgress(quest.getId(), req);
            boolean anyBefore = this.hasAnyProgress(progress, quest);
            long cap = Math.max(1L, cr.getMaxProgress());
            long next = Math.min(cap, (long)old + (long)Math.max(1, amount));
            progress.setRequirementProgress(quest.getId(), req, (int)next);
            int now = progress.getRequirementProgress(quest.getId(), req);
            boolean bl = changed = changed || now != old;
            if (isTeamQuest && player != null) {
                try {
                    UUID teamId = TeamManager.getInstance().getPlayerTeamId(playerId);
                    if (teamId != null) {
                        TeamManager.getInstance().saveTeamProgress(teamId);
                    }
                }
                catch (Throwable throwable) {}
            } else {
                this.progressStorage.saveProgress(progress);
            }
            if (player == null || now == old) continue;
            QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
            if (anyBefore || now <= 0) continue;
            QuestEventBus.post(new QuestStartedEvent(player, quest));
        }
        if (player != null && changed) {
            QuestProgress toSync;
            QuestProgress questProgress2 = toSync = isTeamQuest ? TeamQuestHelper.getQuestProgress(player.method_5667(), quest) : this.getProgress(player.method_5667());
            if (toSync != null) {
                NetworkManager.sendToClient(player, new ProgressSyncPacket(toSync));
            }
            Set<String> updated = Collections.singleton(questId);
            this.checkAndNotifyCompletableQuests(player, progress, updated);
        }
    }

    public void trackCraftingProgress(UUID playerId, String itemId, int amount) {
        this.trackCraftingProgress(playerId, itemId, amount, null);
    }

    public void trackCraftingProgress(UUID playerId, String itemId, int amount, class_3222 player) {
        HashSet<String> updatedQuests = new HashSet<String>();
        String normalized = QuestManager.normalizeId(itemId);
        Questory.LOGGER.info("[Questory Debug] trackCraftingProgress: Player={}, Item={}, Normalized={}, Amount={}", player != null ? player.method_5477().getString() : playerId, (Object)itemId, (Object)normalized, (Object)amount);
        List<QuestRequirementRef> refs = this.craftingReqIndex.get(normalized);
        if (refs == null || refs.isEmpty()) {
            if (QuestoryConfig.getInstance().debugMode) {
                Questory.LOGGER.debug("[Questory Debug] No index match for {}, scanning all quests...", (Object)normalized);
            }
            for (Quest q : this.quests.values()) {
                if (this.getProgress(playerId).isQuestCompleted(q.getId())) continue;
                for (Requirement r : q.getRequirements()) {
                    CraftingRequirement cr;
                    String crNorm;
                    if (!(r instanceof CraftingRequirement) || !(crNorm = QuestManager.normalizeId((cr = (CraftingRequirement)r).getItem())).equals(normalized)) continue;
                    Questory.LOGGER.warn("[Questory Critical] Index DESYNC! Found matching crafting requirement in quest {} but index was empty for key {}. Rebuilding indices...", (Object)q.getId(), (Object)normalized);
                    this.rebuildRequirementIndices();
                    refs = this.craftingReqIndex.get(normalized);
                    break;
                }
                if (refs == null || refs.isEmpty()) continue;
                break;
            }
        }
        if (refs == null) {
            if (QuestoryConfig.getInstance().debugMode) {
                Questory.LOGGER.debug("[Questory Debug] Still no match found for {}", (Object)normalized);
            }
            return;
        }
        for (QuestRequirementRef ref : refs) {
            QuestProgress progress;
            Quest quest = ref.quest;
            Requirement req = ref.requirement;
            if (!(req instanceof CraftingRequirement)) continue;
            CraftingRequirement craftReq = (CraftingRequirement)req;
            boolean isTeamQuest = false;
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                isTeamQuest = cfg.teamSystemEnabled && quest.getTeamSettings() != null && quest.getTeamSettings().isTeamEnabled();
            }
            catch (Throwable cfg) {
                // empty catch block
            }
            if ((progress = isTeamQuest && player != null ? TeamQuestHelper.getQuestProgress(playerId, quest) : this.getProgress(playerId)) == null || progress.isQuestCompleted(quest.getId())) continue;
            int old = progress.getRequirementProgress(quest.getId(), req);
            boolean anyBefore = this.hasAnyProgress(progress, quest);
            int delta = amount;
            if (player != null && delta > 0) {
                QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, delta);
                QuestEventBus.post(pre);
                if (pre.isCanceled()) continue;
                delta = Math.max(0, pre.getDelta());
            }
            if (player != null && !anyBefore && delta > 0) {
                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                QuestEventBus.post(preStart);
                if (preStart.isCanceled()) continue;
            }
            if (delta <= 0) continue;
            progress.addRequirementProgress(quest.getId(), req, delta);
            int now = progress.getRequirementProgress(quest.getId(), req);
            updatedQuests.add(quest.getId());
            if (QuestoryConfig.getInstance().debugMode) {
                Questory.LOGGER.debug("[Questory Debug] Updated crafting progress: Quest={}, Old={}, Now={}", (Object)quest.getId(), (Object)old, (Object)now);
            }
            this.checkAndSyncProgress(player, progress, quest.getId(), isTeamQuest);
            if (player == null || now == old) continue;
            QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
            if (anyBefore || now <= 0) continue;
            QuestEventBus.post(new QuestStartedEvent(player, quest));
        }
    }

    private static String normalizeId(String id) {
        if (id == null) {
            return "";
        }
        Object s = id.trim().toLowerCase(Locale.ROOT);
        if (((String)s).isEmpty()) {
            return s;
        }
        if (!((String)s).contains(":")) {
            if (((String)s).startsWith("minecraft")) {
                String path = ((String)s).substring("minecraft".length());
                if (path.startsWith("_") || path.startsWith("/")) {
                    path = path.substring(1);
                }
                s = "minecraft:" + path;
            } else {
                s = "minecraft:" + (String)s;
            }
        }
        return s;
    }

    public void trackEntityKillProgress(UUID playerId, String entityId, int amount) {
        this.trackEntityKillProgress(playerId, entityId, amount, null);
    }

    public void trackEntityKillProgress(UUID playerId, String entityId, int amount, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                EntityKillRequirement killReq;
                if (!(req instanceof EntityKillRequirement) || !(killReq = (EntityKillRequirement)req).getEntity().equals(entityId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                progress.addRequirementProgress(quest.getId(), req, amount);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                this.checkAndSyncProgress(player, progress, quest.getId(), false);
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
    }

    public void trackAdvancementProgress(UUID playerId, String advancementId) {
        this.trackAdvancementProgress(playerId, advancementId, null);
    }

    public void trackAdvancementProgress(UUID playerId, String advancementId, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                AdvancementRequirement advReq;
                if (!(req instanceof AdvancementRequirement) || !(advReq = (AdvancementRequirement)req).getAdvancement().equals(advancementId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                progress.setRequirementProgress(quest.getId(), req, 1);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public void trackCommandProgress(UUID playerId, String commandId) {
        QuestProgress progress = this.getProgress(playerId);
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                CommandRequirement cmdReq;
                if (!(req instanceof CommandRequirement) || !(cmdReq = (CommandRequirement)req).getRequirementId().equals(commandId)) continue;
                progress.setRequirementProgress(quest.getId(), req, 1);
            }
        }
        this.progressStorage.saveProgress(progress);
    }

    public void trackStatisticProgress(UUID playerId, String statistic, int value) {
        this.trackStatisticProgress(playerId, statistic, value, null);
    }

    public void trackStatisticProgress(UUID playerId, String statistic, int value, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        String statNorm = QuestManager.normalizeStatId(statistic);
        Questory.LOGGER.info("[Questory Debug] trackStatisticProgress: Player={}, Stat={}, Normalized={}, Value={}", player != null ? player.method_5477().getString() : playerId, (Object)statistic, (Object)statNorm, (Object)value);
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                if (!(req instanceof StatisticRequirement)) continue;
                StatisticRequirement statReq = (StatisticRequirement)req;
                String reqStatNorm = QuestManager.normalizeStatId(statReq.getStatistic());
                if (reqStatNorm.equals(statNorm)) {
                    int old = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore = this.hasAnyProgress(progress, quest);
                    int newVal = value;
                    if (player != null && value > old) {
                        int delta = value - old;
                        QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, delta);
                        QuestEventBus.post(pre);
                        if (pre.isCanceled()) continue;
                        delta = Math.max(0, pre.getDelta());
                        newVal = old + delta;
                        if (!anyBefore && delta > 0) {
                            QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                            QuestEventBus.post(preStart);
                            if (preStart.isCanceled()) continue;
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, newVal);
                    int now = progress.getRequirementProgress(quest.getId(), req);
                    updatedQuests.add(quest.getId());
                    this.checkAndSyncProgress(player, progress, quest.getId(), false);
                    if (player != null && QuestoryConfig.getInstance().debugMode) {
                        Questory.LOGGER.debug("[Questory Debug] Updated statistic progress: stat={}, quest={}, old={}, now={}", (Object)statNorm, (Object)quest.getId(), (Object)old, (Object)now);
                    }
                    if (player == null || now == old) continue;
                    QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                    if (anyBefore || now <= 0) continue;
                    QuestEventBus.post(new QuestStartedEvent(player, quest));
                    continue;
                }
                if (!QuestoryConfig.getInstance().debugMode) continue;
                Questory.LOGGER.debug("[Questory Debug] Stat mismatch: Req={}, Event={}", (Object)reqStatNorm, (Object)statNorm);
            }
        }
    }

    private void checkAndSyncProgress(class_3222 player, QuestProgress progress, String questId, boolean isTeamQuest) {
        Quest quest;
        if (isTeamQuest) {
            try {
                UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.method_5667());
                if (teamId != null) {
                    TeamManager.getInstance().saveTeamProgress(teamId);
                }
            }
            catch (Throwable teamId) {}
        } else {
            this.progressStorage.saveProgress(progress);
        }
        if (player != null) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null && (quest = this.getQuest(questId)) != null && !progress.isQuestCompleted(questId) && quest.canComplete(progress)) {
            try {
                this.notifyQuestReadyOnce(player, progress, quest);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void checkAndNotifyCompletableQuests(class_3222 player, QuestProgress progress, Set<String> updatedQuests) {
        this.checkAndNotifyCompletableQuests(player, progress, updatedQuests, false);
    }

    private void checkAndNotifyCompletableQuests(class_3222 player, QuestProgress progress, Set<String> updatedQuests, boolean batch) {
        Set notified = this.notifiedCompletableQuests.computeIfAbsent(player.method_5667(), k -> new HashSet());
        ArrayList<Quest> readyQuests = new ArrayList<Quest>();
        for (String questId : updatedQuests) {
            Quest quest = this.getQuest(questId);
            if (quest == null || !quest.canComplete(progress) || notified.contains(questId)) continue;
            readyQuests.add(quest);
            notified.add(questId);
        }
        if (!readyQuests.isEmpty()) {
            if (batch) {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                if (cfg.shouldNotify("ready") && cfg.shouldPlaySound()) {
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15195, class_3419.field_15248, 0.5f, 1.0f);
                }
            } else {
                for (Quest quest : readyQuests) {
                    QuestNotifications.notifyQuestReady(player, quest);
                }
            }
        }
    }

    public void notifyQuestReadyOnce(class_3222 player, QuestProgress progress, Quest quest) {
        if (player == null || quest == null || progress == null) {
            return;
        }
        Set notified = this.notifiedCompletableQuests.computeIfAbsent(player.method_5667(), k -> new HashSet());
        if (quest.canComplete(progress) && !notified.contains(quest.getId())) {
            QuestNotifications.notifyQuestReady(player, quest);
            notified.add(quest.getId());
        }
    }

    private void clearQuestNotification(UUID playerId, String questId) {
        Set<String> notified = this.notifiedCompletableQuests.get(playerId);
        if (notified != null) {
            notified.remove(questId);
        }
    }

    public void onPlayerDisconnect(UUID playerId) {
        this.progressStorage.unloadPlayer(playerId);
        this.notifiedCompletableQuests.remove(playerId);
        this.initialSyncCompleted.remove(playerId);
    }

    public void onPlayerJoin(class_3222 player) {
        QuestoryConfig cfg;
        NetworkManager.sendToClient(player, new QuestSyncPacket(new ArrayList<Quest>(this.quests.values())));
        QuestProgress progress = this.getProgress(player.method_5667());
        NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        if (this.chaptersByGroup != null && !this.chaptersByGroup.isEmpty()) {
            NetworkManager.sendToClient(player, new ChapterDataSyncPacket(new ArrayList<ChapterData>(this.chaptersByGroup.values())));
        }
        try {
            cfg = QuestoryConfig.getInstance();
            if (cfg.dailyEnable) {
                DailyQuestManager dm = DailyQuestManager.getInstance();
                NetworkManager.sendToClient(player, new DailyDataSyncPacket(dm.getCurrentDailyId(), dm.getCurrentTitle(), dm.getCurrentValidFrom(), dm.getCurrentValidUntil(), dm.getCurrentRolloverTz()));
            }
            boolean permitted = !cfg.advancedEditorRequiresOp || player.method_5687(cfg.adminPermissionLevel);
            NetworkManager.sendToClient(player, new ConfigSyncPacket(cfg.enableAdvancedEditor, cfg.advancedEditorRequiresOp, permitted));
        }
        catch (Throwable t) {
            Questory.LOGGER.error("Failed to sync daily meta: {}", (Object)t.getMessage());
        }
        try {
            if (this.groupTree != null) {
                NetworkManager.sendToClient(player, new GroupTreeSyncPacket(this.groupTree));
            }
        }
        catch (Throwable t) {
            Questory.LOGGER.error("Failed to sync group tree: {}", (Object)t.getMessage());
        }
        try {
            cfg = QuestoryConfig.getInstance();
            if (cfg.teamSystemEnabled) {
                int count;
                PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
                if (pendingMgr.hasPendingRewards(player.method_5667()) && (count = pendingMgr.grantPendingRewards(player)) > 0) {
                    player.method_43496((class_2561)class_2561.method_43470((String)("\u00a76[Questory] \u00a7eYou received \u00a7f" + count + " \u00a7epending team rewards!")));
                }
                this.syncTeamDataToPlayer(player);
            }
        }
        catch (Throwable t) {
            Questory.LOGGER.error("Failed to grant pending rewards: {}", (Object)t.getMessage());
        }
        if (!this.initialSyncCompleted.contains(player.method_5667())) {
            this.checkForNewlyUnlockedQuests(player, progress, true);
            Set<String> allQuestIds = this.quests.keySet();
            this.checkAndNotifyCompletableQuests(player, progress, allQuestIds, true);
            this.initialSyncCompleted.add(player.method_5667());
        }
        Questory.LOGGER.info("Synced quest data to player: {}", (Object)player.method_5477().getString());
    }

    private void syncTeamDataToPlayer(class_3222 player) {
        try {
            TeamManager teamMgr = TeamManager.getInstance();
            PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
            UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
            QuestTeam team = teamId != null ? teamMgr.getTeam(teamId) : null;
            Set<UUID> inviteIds = teamMgr.getPendingInvites(player.method_5667());
            ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
            for (UUID inviteTeamId : inviteIds) {
                QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
                if (inviteTeam == null) continue;
                String ownerName = this.getPlayerName(player.method_5682(), inviteTeam.getOwner());
                TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
                inviteInfos.add(info);
            }
            int rewardCount = pendingMgr.getPendingRewardCount(player.method_5667());
            TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.method_5667(), inviteInfos, rewardCount);
            NetworkManager.sendToClient(player, syncPacket);
            System.out.println("[Questory] Synced team data to player: " + player.method_5477().getString() + " (Team: " + (team != null ? team.getTeamName() : "none") + ")");
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to sync team data: " + t.getMessage());
        }
    }

    private String getPlayerName(MinecraftServer server, UUID playerId) {
        class_3222 player = server.method_3760().method_14602(playerId);
        if (player != null) {
            return player.method_5477().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    public void trackCurrencyProgress(UUID playerId, String currencyId, long value) {
        this.trackCurrencyProgress(playerId, currencyId, value, null);
    }

    public void trackCurrencyProgress(UUID playerId, String currencyId, long value, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                CurrencyRequirement curReq;
                if (!(req instanceof CurrencyRequirement) || !(curReq = (CurrencyRequirement)req).getCurrencyId().equals(currencyId)) continue;
                int old = progress.getRequirementProgress(quest.getId(), req);
                boolean anyBefore = this.hasAnyProgress(progress, quest);
                int clamped = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, value));
                progress.setRequirementProgress(quest.getId(), req, clamped);
                int now = progress.getRequirementProgress(quest.getId(), req);
                updatedQuests.add(quest.getId());
                if (player == null || now == old) continue;
                QuestEventBus.post(new QuestProgressEvent(player, quest, req, old, now));
                if (anyBefore || now <= 0) continue;
                QuestEventBus.post(new QuestStartedEvent(player, quest));
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public static class QuestRequirementRef {
        public final Quest quest;
        public final Requirement requirement;

        public QuestRequirementRef(Quest quest, Requirement requirement) {
            this.quest = quest;
            this.requirement = requirement;
        }
    }

    private static class CachedQuestFilters {
        List<Quest> visibleQuests;
        List<Quest> completableQuests;
        long lastUpdate;

        private CachedQuestFilters() {
        }

        boolean isStale() {
            return System.currentTimeMillis() - this.lastUpdate > 1000L;
        }

        void markUpdated() {
            this.lastUpdate = System.currentTimeMillis();
        }
    }
}

