/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.manager;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_174;
import net.minecraft.class_179;
import net.minecraft.class_184;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_5257;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.quest.GenericTriggerRequirement;

public class TriggerListenerManager {
    private static final TriggerListenerManager INSTANCE = new TriggerListenerManager();
    private final Map<UUID, Map<GenericTriggerRequirement, Object>> activeListeners = new ConcurrentHashMap<UUID, Map<GenericTriggerRequirement, Object>>();

    public static TriggerListenerManager getInstance() {
        return INSTANCE;
    }

    public void registerListener(class_3222 player, String questId, GenericTriggerRequirement requirement) {
        try {
            class_2960 triggerId = new class_2960(requirement.getTriggerId());
            class_179<?> trigger = this.getTriggerByName(triggerId);
            if (trigger == null) {
                Questory.LOGGER.warn("Unknown trigger type: {}", (Object)triggerId);
                return;
            }
            this.registerListenerTyped(trigger, player, questId, requirement);
        }
        catch (Exception e) {
            Questory.LOGGER.error("Failed to register trigger listener for {}", (Object)requirement.getTriggerId(), (Object)e);
        }
    }

    public List<class_2960> getKnownTriggerIds() {
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        try {
            for (Field field : class_174.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Map.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Map map = (Map)field.get(null);
                if (map.isEmpty() || !(map.values().iterator().next() instanceof class_179)) continue;
                for (Object key : map.keySet()) {
                    if (key instanceof class_2960) {
                        class_2960 rl = (class_2960)key;
                        ids.add(rl);
                        continue;
                    }
                    if (!(key instanceof String)) continue;
                    String s = (String)key;
                    ids.add(new class_2960(s));
                }
                return ids;
            }
            for (Field field : class_174.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !class_179.class.isAssignableFrom(field.getType())) continue;
                ids.add(new class_2960("minecraft", field.getName().toLowerCase(Locale.ROOT)));
            }
        }
        catch (Exception e) {
            Questory.LOGGER.error("Error getting known triggers: {}", (Object)e.getMessage());
        }
        return ids;
    }

    private class_179<?> getTriggerByName(class_2960 triggerId) {
        try {
            for (Field field : class_174.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Map.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Map map = (Map)field.get(null);
                if (map.isEmpty() || !(map.values().iterator().next() instanceof class_179)) continue;
                Object trigger = map.get(triggerId);
                if (trigger == null) {
                    trigger = map.get(triggerId.toString());
                }
                if (!(trigger instanceof class_179)) continue;
                return (class_179)trigger;
            }
            String path = triggerId.method_12832().toUpperCase(Locale.ROOT);
            for (Field field : class_174.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !class_179.class.isAssignableFrom(field.getType()) || !field.getName().equals(path)) continue;
                field.setAccessible(true);
                return (class_179)field.get(null);
            }
        }
        catch (Exception e) {
            Questory.LOGGER.error("Error accessing CriteriaTriggers: {}", (Object)e.getMessage());
        }
        return null;
    }

    private <T extends class_184> void registerListenerTyped(class_179<T> trigger, class_3222 player, String questId, GenericTriggerRequirement requirement) {
        try {
            class_5257 context = new class_5257(new class_2960("questory", "generic_trigger"), player.field_13995.method_3857());
            class_184 instance = trigger.method_795(requirement.getConditions(), context);
            Listener<class_184> listener = new Listener<class_184>(trigger, instance, requirement, player, questId);
            trigger.method_792(player.method_14236(), listener);
            this.activeListeners.computeIfAbsent(player.method_5667(), k -> new ConcurrentHashMap()).put(requirement, listener);
        }
        catch (Exception e) {
            Questory.LOGGER.error("Error creating listener for {}: {}", (Object)requirement.getTriggerId(), (Object)e.getMessage());
        }
    }

    public void unregisterListener(class_3222 player, GenericTriggerRequirement requirement) {
        Object listenerObj;
        Map<GenericTriggerRequirement, Object> playerListeners = this.activeListeners.get(player.method_5667());
        if (playerListeners != null && (listenerObj = playerListeners.remove(requirement)) instanceof Listener) {
            Listener listener = (Listener)((Object)listenerObj);
            this.unregisterListenerTyped(listener, player);
        }
    }

    private <T extends class_184> void unregisterListenerTyped(Listener<T> listener, class_3222 player) {
        listener.trigger.method_793(player.method_14236(), listener);
    }

    public void onPlayerDisconnect(UUID playerId) {
        this.activeListeners.remove(playerId);
    }

    public static class Listener<T extends class_184>
    extends class_179.class_180<T> {
        public final class_179<T> trigger;
        private final GenericTriggerRequirement requirement;
        private final class_3222 player;
        private final String questId;

        public Listener(class_179<T> trigger, T triggerInstance, GenericTriggerRequirement requirement, class_3222 player, String questId) {
            super(triggerInstance, null, "questory_generic");
            this.trigger = trigger;
            this.requirement = requirement;
            this.player = player;
            this.questId = questId;
        }

        public void method_796(class_2985 playerAdvancements) {
            if (this.player.method_14236() == playerAdvancements) {
                QuestManager.getInstance().trackRequirementProgress(this.player.method_5667(), this.questId, this.requirement, 1, this.player);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Listener other = (Listener)((Object)obj);
            return Objects.equals(this.requirement, other.requirement) && Objects.equals(this.player.method_5667(), other.player.method_5667());
        }

        public int hashCode() {
            return Objects.hash(this.requirement, this.player.method_5667());
        }
    }
}

