/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.modpack;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.modpack.ModpackInfo;

public class ModpackDetector {
    private static ModpackInfo cachedInfo = null;

    public static ModpackInfo detect() {
        if (cachedInfo != null) {
            return cachedInfo;
        }
        ModpackInfo info = null;
        info = ModpackDetector.detectFromCustom();
        if (info != null) {
            Questory.LOGGER.info("Detected modpack from custom config: {}", (Object)info);
            cachedInfo = info;
            return info;
        }
        info = ModpackDetector.detectFromCurseForge();
        if (info != null) {
            Questory.LOGGER.info("Detected CurseForge modpack: {}", (Object)info);
            cachedInfo = info;
            return info;
        }
        info = ModpackDetector.detectFromModrinth();
        if (info != null) {
            Questory.LOGGER.info("Detected Modrinth modpack: {}", (Object)info);
            cachedInfo = info;
            return info;
        }
        Questory.LOGGER.info("No modpack detected, using 'unknown'");
        cachedInfo = info = new ModpackInfo("unknown", "Custom Modpack", "1.0.0", "unknown");
        return info;
    }

    public static void clearCache() {
        cachedInfo = null;
    }

    private static ModpackInfo detectFromCustom() {
        try {
            String version;
            Path customPath = Paths.get("questory_modpack.json", new String[0]);
            Path absolutePath = customPath.toAbsolutePath();
            Questory.LOGGER.info("Looking for custom modpack config at: {}", (Object)absolutePath);
            if (!Files.exists(customPath, new LinkOption[0])) {
                Questory.LOGGER.debug("Custom modpack config not found at: {}", (Object)absolutePath);
                return null;
            }
            Questory.LOGGER.info("Found custom modpack config at: {}", (Object)absolutePath);
            JsonObject json = JsonParser.parseReader((Reader)new FileReader(customPath.toFile())).getAsJsonObject();
            String id = json.has("id") ? json.get("id").getAsString() : null;
            String name = json.has("name") ? json.get("name").getAsString() : null;
            String string = version = json.has("version") ? json.get("version").getAsString() : null;
            if (id != null && name != null && version != null) {
                Questory.LOGGER.info("Successfully parsed custom modpack config: id={}, name={}, version={}", (Object)id, (Object)name, (Object)version);
                return new ModpackInfo(id, name, version, "custom");
            }
            Questory.LOGGER.warn("Custom modpack config is missing required fields. id={}, name={}, version={}", (Object)id, (Object)name, (Object)version);
        }
        catch (Exception e) {
            Questory.LOGGER.warn("Failed to read custom modpack config", (Throwable)e);
        }
        return null;
    }

    private static ModpackInfo detectFromCurseForge() {
        try {
            Path[] possiblePaths;
            for (Path path : possiblePaths = new Path[]{Paths.get("manifest.json", new String[0]), Paths.get("curseforge", "manifest.json"), Paths.get("..", "manifest.json")}) {
                JsonObject json;
                if (!Files.exists(path, new LinkOption[0]) || !(json = JsonParser.parseReader((Reader)new FileReader(path.toFile())).getAsJsonObject()).has("manifestType") || !"minecraftModpack".equals(json.get("manifestType").getAsString())) continue;
                String name = json.has("name") ? json.get("name").getAsString() : "Unknown CurseForge Pack";
                String version = json.has("version") ? json.get("version").getAsString() : "1.0.0";
                String id = "cf_" + name.toLowerCase().replaceAll("[^a-z0-9_]", "_");
                if (json.has("projectID")) {
                    id = "cf_" + json.get("projectID").getAsString();
                }
                return new ModpackInfo(id, name, version, "curseforge");
            }
        }
        catch (Exception e) {
            Questory.LOGGER.debug("Failed to detect CurseForge modpack", (Throwable)e);
        }
        return null;
    }

    private static ModpackInfo detectFromModrinth() {
        try {
            Path[] possiblePaths;
            for (Path path : possiblePaths = new Path[]{Paths.get("modrinth.index.json", new String[0]), Paths.get("modrinth", "modrinth.index.json"), Paths.get("..", "modrinth.index.json")}) {
                JsonObject json;
                if (!Files.exists(path, new LinkOption[0]) || !(json = JsonParser.parseReader((Reader)new FileReader(path.toFile())).getAsJsonObject()).has("formatVersion")) continue;
                String name = json.has("name") ? json.get("name").getAsString() : "Unknown Modrinth Pack";
                String version = json.has("versionId") ? json.get("versionId").getAsString() : "1.0.0";
                String id = "mr_" + name.toLowerCase().replaceAll("[^a-z0-9_]", "_");
                return new ModpackInfo(id, name, version, "modrinth");
            }
        }
        catch (Exception e) {
            Questory.LOGGER.debug("Failed to detect Modrinth modpack", (Throwable)e);
        }
        return null;
    }
}

